/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.dataGather.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.dataGather.entity.DataGatherGLMember;
import kd.epm.eb.business.dataGather.entity.DataGatherGLTypeRange;
import kd.epm.eb.business.dataGather.service.DataGatherGLTypeRangeUtils;

public class DataGatherGLTypeRangeService {
    private static final Integer initSize = 16;

    public static DataGatherGLTypeRangeService getInstance() {
        return InnerClass.instance;
    }

    private DataGatherGLTypeRangeService() {
    }

    public Map<String, DataGatherGLTypeRange> getDataGatherGLTypeRange(String formId, Long fid) {
        return this.queryGLRangeTypeByIds(formId, fid);
    }

    private Map<String, DataGatherGLTypeRange> queryGLRangeTypeByIds(String formId, Long fid) {
        if ("bd_asstacttype".equalsIgnoreCase(formId)) {
            return this.queryAssValuesByAss(formId, fid);
        }
        return this.queryAssValuesByBase(formId, fid);
    }

    private Map<String, DataGatherGLTypeRange> queryAssValuesByBase(String formId, Long fid) {
        DataSet assValuesBase = this.queryAssValueInfoByBase(formId, fid == null ? null : Collections.singletonList(fid));
        HashMap<String, DataGatherGLTypeRange> objs = new HashMap<String, DataGatherGLTypeRange>(initSize);
        DataGatherGLTypeRange obj = new DataGatherGLTypeRange();
        obj.setSubMembers(DataGatherGLTypeRangeUtils.getInstance().getAssValuesFromMap(assValuesBase));
        obj.setTypeFormId(DataGatherGLTypeRangeUtils.getInstance().getAccountFormId(formId));
        obj.setTypeId(fid == null ? Long.valueOf(0L) : fid);
        String glTypeKey = DataGatherGLTypeRangeUtils.getInstance().getGLTypeKey(obj);
        objs.put(glTypeKey, obj);
        return objs;
    }

    private Map<String, DataGatherGLTypeRange> queryAssValuesByAss(String formId, Long fid) {
        DynamicObject[] assTypeDataDys = this.getAssTypeAndSourceInfo(fid);
        if (assTypeDataDys == null || assTypeDataDys.length == 0) {
            return null;
        }
        HashMap<String, DataGatherGLTypeRange> objs = new HashMap<String, DataGatherGLTypeRange>(initSize);
        for (DynamicObject assTypeDataDy : assTypeDataDys) {
            DataGatherGLTypeRange obj = new DataGatherGLTypeRange();
            obj.setSubMembers(this.queryAssValuesByAssSingle(assTypeDataDy, obj));
            obj.setTypeFormId(DataGatherGLTypeRangeUtils.getInstance().getAccountFormId(formId));
            obj.setTypeId(fid == null ? Long.valueOf(0L) : fid);
            String glTypeKey = DataGatherGLTypeRangeUtils.getInstance().getGLTypeKey(obj);
            objs.put(glTypeKey, obj);
        }
        return objs;
    }

    private void setAssGroupObj(DataGatherGLTypeRange obj, DynamicObject groupDy) {
        obj.setParentId(groupDy.getLong("parent.id"));
        obj.setTypeId(groupDy.getLong("id"));
        obj.setTypeNumber(groupDy.getString("number"));
        obj.setTypeName(groupDy.getString("name"));
    }

    private List<DataGatherGLMember> queryAssValuesByAssSingle(DynamicObject assTypeDataDy, DataGatherGLTypeRange obj) {
        if (assTypeDataDy == null) {
            return null;
        }
        obj.setFlexField(assTypeDataDy.getString("flexfield"));
        obj.setValueType(assTypeDataDy.getInt("valuetype"));
        obj.setTypeNumber(assTypeDataDy.getString("valuesource.number"));
        obj.setTypeName(assTypeDataDy.getString("valuesource.name"));
        List<DataGatherGLMember> members = new ArrayList<DataGatherGLMember>(initSize);
        switch (assTypeDataDy.getString("valuetype")) {
            case "1": {
                DataSet assValuesBase = this.queryAssValueInfoByBase(assTypeDataDy.getString("valuesource.number"), null);
                members = DataGatherGLTypeRangeUtils.getInstance().getAssValuesFromMap(assValuesBase);
                break;
            }
            case "2": {
                DataSet assValuesAss = this.queryAssValueInfoByAss(assTypeDataDy, obj);
                members = DataGatherGLTypeRangeUtils.getInstance().getAssValuesFromMap(assValuesAss);
                break;
            }
            case "3": {
                DataGatherGLMember glMember = new DataGatherGLMember();
                glMember.setNumber(assTypeDataDy.getString("number"));
                members.add(glMember);
            }
        }
        return members;
    }

    private DynamicObject[] getAssTypeAndSourceInfo(Long fid) {
        String selectFields = "number,valuetype,flexfield,valuesource,assistanttype ";
        QFilter qFilter = new QFilter("1", "=", (Object)1);
        if (fid != null) {
            qFilter = qFilter.and(new QFilter("id", "=", (Object)fid));
        }
        return BusinessDataServiceHelper.load((String)"bd_asstacttype", (String)selectFields, (QFilter[])qFilter.toArray());
    }

    private String getSelectFields(String formId) {
        if (formId.equalsIgnoreCase("gl_org")) {
            return "";
        }
        DynamicObjectType objType = BusinessDataServiceHelper.newDynamicObject((String)formId).getDynamicObjectType();
        DataEntityPropertyCollection propertys = objType.getProperties();
        StringBuilder str = new StringBuilder();
        str.append(" id,number,name ");
        if (propertys.containsKey((Object)"parent")) {
            str.append(",parent");
        }
        if (propertys.containsKey((Object)"level")) {
            str.append(",level");
        }
        if (propertys.containsKey((Object)"longnumber")) {
            str.append(",longnumber");
        }
        if (propertys.containsKey((Object)"isleaf")) {
            str.append(",isleaf ");
        }
        return str.toString();
    }

    private DataSet queryAssValueInfoByBase(String formId, Collection<Long> fids) {
        String selectFields = this.getSelectFields(formId);
        String filterField = "id";
        QFilter qFilter = new QFilter("1", "=", (Object)1);
        if (formId.equalsIgnoreCase("gl_org")) {
            return this.queryValueInfoByGlOrg("bos_org");
        }
        if (formId.equalsIgnoreCase("bd_accounttable")) {
            formId = "bd_accountview";
            filterField = "accounttable";
        }
        if ("bos_org".equals(formId)) {
            formId = "bos_org_structure";
            filterField = "org";
            selectFields = "org.id as id,org.number as number,org.name as name,parent,level,longnumber ,isleaf";
            qFilter = qFilter.and(new QFilter("view.number", "=", (Object)"15"));
        }
        if ("bos_adminorg".equals(formId)) {
            formId = "bos_adminorg_structure";
            filterField = "org";
            selectFields = "org.id as id,org.number as number,org.name as name,parent,level,longnumber ,isleaf ";
            qFilter = qFilter.and(new QFilter("view.number", "=", (Object)"01"));
        }
        if (fids != null) {
            qFilter = qFilter.and(new QFilter(filterField, "in", fids));
        }
        return QueryServiceHelper.queryDataSet((String)"queryAssValueInfoByBase", (String)formId, (String)selectFields, (QFilter[])qFilter.toArray(), null);
    }

    private DataSet queryValueInfoByGlOrg(String formId) {
        String selectFields = "id";
        QFilter qFilter = new QFilter("fisaccounting", "=", (Object)"1");
        Map orgs = BusinessDataServiceHelper.loadFromCache((String)formId, (String)selectFields, (QFilter[])qFilter.toArray());
        if (orgs == null || orgs.size() == 0) {
            return null;
        }
        ArrayList<Long> fids = new ArrayList<Long>(orgs.size());
        for (Map.Entry entry : orgs.entrySet()) {
            DynamicObject org = (DynamicObject)entry.getValue();
            if (org == null) continue;
            fids.add(org.getLong("id"));
        }
        return this.queryAssValueInfoByBase(formId, fids);
    }

    private DataSet queryAssValueInfoByAss(DynamicObject assTypeDataRow, DataGatherGLTypeRange obj) {
        if (assTypeDataRow.getString("assistanttype") == null) {
            return null;
        }
        String selectFields = "id,number,name,parent ";
        QFilter qFilter = new QFilter("id", "=", (Object)assTypeDataRow.getLong("assistanttype.id"));
        DynamicObject groupDy = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_assistantdatagroup", (String)selectFields, (QFilter[])qFilter.toArray());
        if (groupDy == null) {
            return null;
        }
        this.setAssGroupObj(obj, groupDy);
        selectFields = StringUtils.join((Object[])new String[]{selectFields, " ,isleaf,level"});
        qFilter = new QFilter("group.id", "=", (Object)groupDy.getLong("id"));
        return QueryServiceHelper.queryDataSet((String)"queryAssValueInfoByBase", (String)"bos_assistantdata_detail", (String)selectFields, (QFilter[])qFilter.toArray(), null);
    }

    private static class InnerClass {
        private static DataGatherGLTypeRangeService instance = new DataGatherGLTypeRangeService();

        private InnerClass() {
        }
    }
}

