/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.dataGather.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.dataGather.entity.DataGatherGLMember;
import kd.epm.eb.business.dataGather.entity.DataGatherGLTypeRange;
import kd.epm.eb.business.dataGather.entity.DataGatherMappingDimEntry;
import kd.epm.eb.business.dataGather.service.DataGatherCommon;
import kd.epm.eb.business.dataGather.service.DataGatherGLTypeRangeService;
import kd.epm.eb.common.utils.IDUtils;

public class DataGatherGLTypeRangeUtils {
    private static final Log LOG = LogFactory.getLog(DataGatherGLTypeRangeUtils.class);
    private static final Integer initSize = 16;

    public static DataGatherGLTypeRangeUtils getInstance() {
        return InnerClass.instance;
    }

    private DataGatherGLTypeRangeUtils() {
    }

    public void getGLTypeRange(String glTypeKey, String formId, Long fid, Map<String, DataGatherGLTypeRange> acctTypeValues_out) {
        Map<String, DataGatherGLTypeRange> dataGatherGLTypeRange;
        DataGatherGLTypeRange GLRange = this.findGLTypeRange(glTypeKey, acctTypeValues_out);
        if (GLRange == null && (dataGatherGLTypeRange = DataGatherGLTypeRangeService.getInstance().getDataGatherGLTypeRange(formId, fid)) != null && dataGatherGLTypeRange.size() > 0) {
            GLRange = dataGatherGLTypeRange.entrySet().iterator().next().getValue();
            acctTypeValues_out.put(glTypeKey, GLRange);
        }
    }

    public String getAccountFormId(String accountFormId) {
        return accountFormId.equalsIgnoreCase("bd_accounttable") ? "bd_accountview" : accountFormId;
    }

    public DataGatherGLTypeRange findGLTypeRange(String glTypeKey, Map<String, DataGatherGLTypeRange> acctTypeValues_out) {
        if (acctTypeValues_out == null) {
            return null;
        }
        return acctTypeValues_out.get(glTypeKey);
    }

    public String getGLTypeKey(DataGatherGLTypeRange glTypeRange) {
        return this.getGLTypeKey(glTypeRange.getTypeFormId(), glTypeRange.getTypeId());
    }

    public String getGLTypeKey(DataGatherMappingDimEntry dimMapping) {
        return this.getGLTypeKey(dimMapping.getSourceFieldTable(), dimMapping.getSourceFieldID());
    }

    public String getGLTypeKey(String formId, Long typeId) {
        return StringUtils.join((Object[])new Serializable[]{DataGatherGLTypeRangeUtils.getInstance().getAccountFormId(formId), "_", typeId == null ? "" : typeId});
    }

    public Set<String> getGLMembersFromGLRangeObj(Collection<DataGatherGLMember> glMembers) {
        HashSet<String> returns = new HashSet<String>(initSize);
        if (glMembers == null || glMembers.size() == 0) {
            return returns;
        }
        glMembers.forEach(e -> returns.add(e.getNumber()));
        return returns;
    }

    public void setParentMembers(Collection<DataGatherGLMember> glMembers, Collection<DataGatherGLMember> allMembers) {
        if (glMembers == null || glMembers.size() == 0) {
            return;
        }
        if (allMembers == null || allMembers.size() == 0) {
            return;
        }
        for (DataGatherGLMember glMember : glMembers) {
            if (glMember.getParentMembers() != null && glMember.getParentMembers().size() > 0) {
                return;
            }
            glMember.setParentMembers(this.getParentMembers(this.getParentIds(glMember.getId(), allMembers), allMembers));
        }
    }

    private Collection<Long> getParentIds(Long glMemberId, Collection<DataGatherGLMember> allMembers) {
        if (allMembers == null || allMembers.size() == 0) {
            return null;
        }
        ArrayList<Long> returns = new ArrayList<Long>(initSize);
        for (DataGatherGLMember allMember : allMembers) {
            Long parentId;
            if (glMemberId.compareTo(allMember.getId()) != 0 || IDUtils.isNull((Long)(parentId = allMember.getParentId()))) continue;
            returns.add(parentId);
        }
        return returns;
    }

    private Collection<DataGatherGLMember> getParentMembers(Collection<Long> glMemberIds, Collection<DataGatherGLMember> allMembers) {
        if (allMembers == null || allMembers.size() == 0) {
            return null;
        }
        if (glMemberIds == null || glMemberIds.size() == 0) {
            return null;
        }
        ArrayList<DataGatherGLMember> returns = new ArrayList<DataGatherGLMember>(initSize);
        for (Long glMemberId : glMemberIds) {
            if (IDUtils.isNull((Long)glMemberId)) continue;
            for (DataGatherGLMember allMember : allMembers) {
                if (allMember == null || glMemberId.compareTo(allMember.getId()) != 0) continue;
                returns.add(allMember);
            }
        }
        return returns;
    }

    public List<DataGatherGLMember> getAssValuesFromMap(DataSet assValues) {
        if (assValues == null) {
            return null;
        }
        List<Long> memberIdList = DataGatherCommon.MEMBER_ID_LIST.get();
        HashMap<Long, String> longNumbers = new HashMap<Long, String>(initSize);
        String glTypeKey = DataGatherCommon.GL_TYPE_KEY.get();
        if (glTypeKey == null) {
            LOG.error((Throwable)new KDBizException("Thread variable read failed."));
        }
        ArrayList<DataGatherGLMember> members = new ArrayList<DataGatherGLMember>(initSize);
        String[] fieldNames = assValues.getRowMeta().getFieldNames();
        while (assValues.hasNext()) {
            Row assValueRow = assValues.next();
            DataGatherGLMember member = new DataGatherGLMember();
            member.setId(assValueRow.getLong("id"));
            member.setName(assValueRow.getString("name"));
            member.setNumber(assValueRow.getString("number"));
            member.setLeaf(this.isValiadField(fieldNames, "isleaf") ? assValueRow.getBoolean("isleaf") : false);
            member.setLevel(this.isValiadField(fieldNames, "level") ? assValueRow.getInteger("level") : 0);
            member.setParentId(this.isValiadField(fieldNames, "parent") ? assValueRow.getLong("parent") : null);
            member.setLongNumber(this.isValiadField(fieldNames, "longnumber") ? assValueRow.getString("longnumber") : null);
            if (memberIdList != null && memberIdList.contains(member.getId()) && IDUtils.isNotNull((Long)member.getId()) && StringUtils.isNotBlank((CharSequence)member.getLongNumber())) {
                longNumbers.put(member.getId(), member.getLongNumber());
            }
            members.add(member);
        }
        assValues.close();
        this.loadAllSubMemberIndex(longNumbers, glTypeKey, members);
        return members;
    }

    private void loadAllSubMemberIndex(Map<Long, String> longNumbers, String glTypeKey, List<DataGatherGLMember> members) {
        if (longNumbers.size() > 0) {
            for (Map.Entry<Long, String> next : longNumbers.entrySet()) {
                Long id = next.getKey();
                String longNumber = next.getValue();
                for (int i = 0; i < members.size(); ++i) {
                    String glMemberLongNumber;
                    DataGatherGLMember glMember = members.get(i);
                    if (glMember == null || (glMemberLongNumber = glMember.getLongNumber()) == null || !glMemberLongNumber.startsWith(longNumber)) continue;
                    this.loadIndex(glTypeKey, id, i);
                }
            }
        }
    }

    private void loadIndex(String glTypeKey, Long parentId, int index) {
        List<Integer> indexList;
        String join = String.join((CharSequence)"_", glTypeKey, String.valueOf(parentId));
        Map<String, List<Integer>> listMap = DataGatherCommon.INDEX_LIST.get();
        if (listMap == null) {
            DataGatherCommon.INDEX_LIST.set(new HashMap(16));
            listMap = DataGatherCommon.INDEX_LIST.get();
        }
        if ((indexList = listMap.get(join)) == null) {
            indexList = new ArrayList<Integer>(initSize);
        }
        indexList.add(index);
        listMap.put(join, indexList);
    }

    private boolean isValiadField(String[] fieldNames, String fieldName) {
        if (fieldNames == null || fieldNames.length == 0) {
            return false;
        }
        for (String field : fieldNames) {
            if (!field.equalsIgnoreCase(fieldName)) continue;
            return true;
        }
        return false;
    }

    private static class InnerClass {
        private static DataGatherGLTypeRangeUtils instance = new DataGatherGLTypeRangeUtils();

        private InnerClass() {
        }
    }
}

