/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.dataGather.service;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.dataGather.entity.DataGatherHandCallParam;
import kd.epm.eb.business.dataGather.entity.DataGatherMappingDim;
import kd.epm.eb.business.dataGather.entity.DataGatherMappingDimEntry;
import kd.epm.eb.business.dataGather.service.DataGatherCommon;
import kd.epm.eb.business.dataGather.service.DataGatherMappingDimEntryService;
import kd.epm.eb.business.dataGather.service.DataGatherPeriodsBGM;
import kd.epm.eb.business.dataGather.service.DataGatherPeriodsEB;
import kd.epm.eb.common.ebcommon.common.enums.ApplicationTypeEnum;

public class DataGatherMappingDimService {
    private static final Log log = LogFactory.getLog(DataGatherMappingDimService.class);

    public static DataGatherMappingDimService getInstance() {
        return InnerClass.instance;
    }

    private DataGatherMappingDimService() {
    }

    public void getDataGatherMappingDim(DataGatherMappingDim dimMpping, DynamicObject dataRow, DataGatherHandCallParam param) {
        DataGatherCommon.doLogWithTime(0L, "begin setPeriodMapping and setDimEntryMapping: ", log);
        this.setPeriodMapping(dimMpping, dataRow, param);
        this.setDimEntryMapping(dimMpping, dataRow);
    }

    private void setPeriodMapping(DataGatherMappingDim dimMpping, DynamicObject dataRow, DataGatherHandCallParam param) {
        if (dataRow == null) {
            return;
        }
        if (param.getAppNum().equalsIgnoreCase(ApplicationTypeEnum.EB.getAppnum())) {
            DataGatherPeriodsEB.getInstance().setPeriodMapping(dimMpping, dataRow, param);
        }
        if (param.getAppNum().equalsIgnoreCase(ApplicationTypeEnum.BGM.getAppnum())) {
            DataGatherPeriodsBGM.getInstance().setPeriodMapping(dimMpping, dataRow, param);
        }
    }

    private void setDimEntryMapping(DataGatherMappingDim dimMpping, DynamicObject dataRow) {
        if (dataRow == null) {
            return;
        }
        ArrayList<DataGatherMappingDimEntry> memberMapping = new ArrayList<DataGatherMappingDimEntry>(DataGatherCommon.initSize);
        DynamicObjectCollection dt = (DynamicObjectCollection)dataRow.get("entitydimmap");
        if (dt == null) {
            DataGatherCommon.doLogWithTime(0L, "setDimEntryMapping.dt = null ", log);
            return;
        }
        DataGatherCommon.doLogWithTime(0L, "setDimEntryMapping.dt.count: " + dt.size(), log);
        for (int i = 0; i < dt.size(); ++i) {
            DataGatherMappingDimEntry dimEntryMapping = DataGatherMappingDimEntryService.getInstance().getDataGatherMappingDimEntry((DynamicObject)dt.get(i));
            memberMapping.add(dimEntryMapping);
        }
        dimMpping.setDimMemberMapping(memberMapping);
    }

    private static class InnerClass {
        private static DataGatherMappingDimService instance = new DataGatherMappingDimService();

        private InnerClass() {
        }
    }
}

