/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.dataGather.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.dataGather.entity.DataGatherMappingMember;
import kd.epm.eb.business.dataGather.entity.DataGatherMappingMemberEntry;
import kd.epm.eb.business.dataGather.service.DataGatherCommon;
import kd.epm.eb.business.dataGather.service.DataGatherMappingMemberEntryService;
import kd.epm.eb.common.enums.RangeEnum;

public class DataGatherMappingMemberService {
    private static final Log log = LogFactory.getLog(DataGatherMappingMemberService.class);

    public static DataGatherMappingMemberService getInstance() {
        return InnerClass.instance;
    }

    private DataGatherMappingMemberService() {
    }

    public List<DataGatherMappingMember> getDataGatherMappingMember(Set<Long> memberMappingIDs) {
        if (memberMappingIDs == null || memberMappingIDs.size() == 0) {
            DataGatherCommon.doLogWithTime(0L, "memberMappingIDs is null or 0 ", log);
            return null;
        }
        DataGatherCommon.doLogWithTime(0L, "begin queryMemberMapping: ", log);
        List<DataGatherMappingMember> dimMppings = this.queryMemberMapping(memberMappingIDs);
        return dimMppings;
    }

    private List<DataGatherMappingMember> queryMemberMapping(Set<Long> memberMappingIDs) {
        if (memberMappingIDs == null || memberMappingIDs.size() == 0) {
            return null;
        }
        String selectFields = "id,number,name,model,businessbasedata,businessbasedataname,dimnumber,dimname,enable,useassistdata,businessbasedataext,businessbasedatanameext,entryentity.entrystatus,entryentity.bizmember,entryentity.biznumber,entryentity.showbizmember,entryentity.bizmemberext,entryentity.biznumberext,entryentity.showbizmemberext,entryentity.dimmember,entryentity.showdimmember,entryentity.dimmemnumber,entryentity.range,usemorebussdata,entryentity.morebussdata ";
        QFilter qFilter = new QFilter("id", "in", memberMappingIDs);
        String formID = "eb_ebdimmembermap";
        ArrayList<DataGatherMappingMember> returns = new ArrayList<DataGatherMappingMember>(DataGatherCommon.initSize);
        DynamicObject[] dataRows = BusinessDataServiceHelper.load((String)formID, (String)selectFields, (QFilter[])qFilter.toArray());
        if (dataRows == null || dataRows.length == 0) {
            return null;
        }
        for (DynamicObject dataRow : dataRows) {
            if (!dataRow.getBoolean("enable")) continue;
            DataGatherMappingMember memberMapping = new DataGatherMappingMember();
            memberMapping.setEnable(dataRow.getBoolean("enable"));
            memberMapping.setUseMoreBussData(dataRow.getBoolean("usemorebussdata"));
            memberMapping.setFID(dataRow.getLong("id"));
            memberMapping.setName(dataRow.getString("name"));
            memberMapping.setNumber(dataRow.getString("number"));
            memberMapping.setBusinessBaseData(dataRow.getString("businessbasedata"));
            memberMapping.setBusinessBaseDataName(dataRow.getString("businessbasedataname"));
            memberMapping.setUseAssistData(dataRow.getBoolean("useassistdata"));
            memberMapping.setBusinessBaseDataExt(dataRow.getString("businessbasedataext"));
            memberMapping.setBusinessBaseDataExtName(dataRow.getString("businessbasedatanameext"));
            memberMapping.setDimKey(dataRow.getString("dimnumber"));
            memberMapping.setDimKeyName(dataRow.getString("dimname"));
            memberMapping.setModelID(dataRow.getLong("model.id"));
            memberMapping.setModelName(dataRow.getString("model.name"));
            memberMapping.setModelNumber(dataRow.getString("model.shownumber"));
            this.setMemberMappingEntrys(memberMapping, dataRow);
            returns.add(memberMapping);
        }
        return returns;
    }

    private void setMemberMappingEntrys(DataGatherMappingMember memberMapping, DynamicObject dataRow) {
        if (dataRow == null) {
            return;
        }
        ArrayList<DataGatherMappingMemberEntry> first = new ArrayList<DataGatherMappingMemberEntry>(DataGatherCommon.initSize);
        ArrayList<DataGatherMappingMemberEntry> secont = new ArrayList<DataGatherMappingMemberEntry>(DataGatherCommon.initSize);
        ArrayList<DataGatherMappingMemberEntry> last = new ArrayList<DataGatherMappingMemberEntry>(DataGatherCommon.initSize);
        DynamicObjectCollection dt = (DynamicObjectCollection)dataRow.get("entryentity");
        if (dt == null) {
            return;
        }
        for (int i = 0; i < dt.size(); ++i) {
            DataGatherMappingMemberEntry memberEntryMapping = DataGatherMappingMemberEntryService.getInstance().getDataGatherMappingMemberEntry((DynamicObject)dt.get(i));
            if (memberEntryMapping == null) continue;
            int range = ((DynamicObject)dt.get(i)).getInt("range");
            String baseType = ((DynamicObject)dt.get(i)).getString("morebussdata");
            if (!memberMapping.getUseMoreBussData().booleanValue()) {
                baseType = memberMapping.getBusinessBaseData();
            }
            if (!"gl_org".equals(baseType) && range == RangeEnum.ONLY.getIndex()) {
                first.add(memberEntryMapping);
                continue;
            }
            if ("gl_org".equals(baseType)) {
                last.add(memberEntryMapping);
                continue;
            }
            secont.add(memberEntryMapping);
        }
        memberMapping.setMemberMappingEntryFirst(first);
        memberMapping.setMemberMappingEntry(secont);
        memberMapping.setMemberMappingEntryLast(last);
    }

    private static class InnerClass {
        private static DataGatherMappingMemberService instance = new DataGatherMappingMemberService();

        private InnerClass() {
        }
    }
}

