/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.dataGather.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.dataGather.entity.DataGatherCollectScheme;
import kd.epm.eb.business.dataGather.entity.DataGatherDataSetEntity;
import kd.epm.eb.business.dataGather.entity.DataGatherExecuteScheme;
import kd.epm.eb.business.dataGather.entity.DataGatherHandCallParam;
import kd.epm.eb.business.dataGather.entity.DataGatherMappingDim;
import kd.epm.eb.business.dataGather.service.DataGatherCommon;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.common.elasticsearch.OlapDataAuditEventEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.olapdao.OlapContext;
import kd.epm.eb.common.olapdao.SaveDataContext;
import kd.epm.eb.common.shrek.controller.IShrekSave;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.util.ShrekIdCodeUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.impl.metadata.KDCell;
import kd.epm.epbs.business.log.trace.OlapTraceServiceHelper;

public class DataGatherPeriodsBGM {
    private static final Log LOG = LogFactory.getLog(DataGatherPeriodsBGM.class);
    private static final String PERIOD_FIX = "M";

    public static DataGatherPeriodsBGM getInstance() {
        return InnerClass.instance;
    }

    private DataGatherPeriodsBGM() {
    }

    public void setGlGatherPeriods(DataGatherExecuteScheme excuteSchemeInfo, DataGatherCollectScheme collectionScheme, DataGatherHandCallParam param) {
        Map<Long, String> glYearPeriodMap = collectionScheme.getGlGather().getEbGLYearPeriodMap();
        if (glYearPeriodMap == null) {
            glYearPeriodMap = new HashMap<Long, String>(DataGatherCommon.initSize);
        }
        Set<String> yearPeriods = excuteSchemeInfo.getHandCallParam() == null ? this.getBgmYearPeriodFromPeriodCount(excuteSchemeInfo.getFetchPeriod(), this.getEbYearPeriodByCurDate()) : this.getYearPeriodFromHandParams(excuteSchemeInfo.getFetchPeriod(), excuteSchemeInfo.getHandCallParam());
        List<Long> glPeriods = this.getGlPeriods(yearPeriods, collectionScheme, glYearPeriodMap);
        collectionScheme.getGlGather().setPeriodIds(glPeriods);
        collectionScheme.getGlGather().setEbGLYearPeriodMap(glYearPeriodMap);
    }

    private List<Long> getGlPeriods(Set<String> yearPeriods, DataGatherCollectScheme collectionScheme, Map<Long, String> yearPeriodMap) {
        ArrayList<Long> glPeriods = new ArrayList<Long>(DataGatherCommon.initSize);
        if (yearPeriods == null || yearPeriods.size() == 0) {
            return glPeriods;
        }
        for (String ebYearPeriod : yearPeriods) {
            Long glPeriodId = this.getGlPeriodByYearPeriod(ebYearPeriod, collectionScheme);
            glPeriods.add(glPeriodId);
            yearPeriodMap.put(glPeriodId, ebYearPeriod);
        }
        return glPeriods;
    }

    private Long getGlPeriodByYearPeriod(String yearPeriod, DataGatherCollectScheme collectionScheme) {
        Long returns = 0L;
        if (collectionScheme == null || collectionScheme.getDimMpping() == null) {
            return returns;
        }
        Map<Long, String> periodMapping = collectionScheme.getDimMpping().getPeriodMapping();
        if (collectionScheme == null || periodMapping.size() == 0) {
            return returns;
        }
        for (Map.Entry<Long, String> entry : periodMapping.entrySet()) {
            if (!entry.getValue().equalsIgnoreCase(yearPeriod)) continue;
            return entry.getKey();
        }
        return returns;
    }

    private String getEbYearPeriodByCurDate() {
        Calendar localTime = Calendar.getInstance();
        int y = localTime.get(1);
        int m = localTime.get(2) + 1;
        return this.joinYearPeriod(y, m);
    }

    private Set<String> getYearPeriodFromHandParams(Integer periodCount, DataGatherHandCallParam handParam) {
        if (handParam == null || handParam.getPeriodNum() == null) {
            return null;
        }
        String ebYearPeriod = handParam.getPeriodNum();
        Set<String> returns = this.getBgmYearPeriodFromPeriodCount(periodCount, ebYearPeriod);
        return returns;
    }

    private Set<String> getBgmYearPeriodFromPeriodCount(Integer periodCount, String periodNumber) {
        HashSet<String> returns = new HashSet<String>(periodCount);
        if (periodNumber == null || periodNumber.isEmpty()) {
            return returns;
        }
        Integer year = Integer.valueOf(periodNumber.split("\\.")[0].substring("FY".length()));
        Integer period = Integer.valueOf(periodNumber.split("\\.")[1].substring(PERIOD_FIX.length()));
        double yearPeriod = (double)year.intValue() + (double)period.intValue() * 0.01;
        for (int i = 0; i < periodCount; ++i) {
            returns.add(this.joinYearPeriod((int)yearPeriod, (int)Math.round((yearPeriod - (double)((int)yearPeriod)) * 100.0)));
            if ((yearPeriod -= 0.01) - (double)((int)yearPeriod) == 0.0) break;
        }
        return returns;
    }

    private String joinYearPeriod(int y, int m) {
        return String.format("%s.%s", "FY" + y, PERIOD_FIX + (m >= 10 ? String.valueOf(m) : "0" + m));
    }

    public String getDimNumberFromSchema(String dimKey, DataGatherCollectScheme collectSchemeInfo, Long period) {
        String returns = "";
        switch (dimKey) {
            case "BudgetPeriod": {
                returns = collectSchemeInfo.getGlGather().getEbGLYearPeriodMap().get(period);
                break;
            }
            case "Currency": {
                returns = collectSchemeInfo.getTargetCurrencyNumber();
            }
        }
        return returns;
    }

    public void setPeriodMapping(DataGatherMappingDim dimMpping, DynamicObject dataRow, DataGatherHandCallParam param) {
        if (dataRow == null) {
            return;
        }
        DynamicObject model = dataRow.getDynamicObject("model");
        if (model == null) {
            return;
        }
        Long modelId = model.getLong("id");
        if (IDUtils.isNull((Long)modelId)) {
            return;
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        HashMap<Long, String> periodMapping = new HashMap<Long, String>(DataGatherCommon.initSize);
        DynamicObjectCollection dt = (DynamicObjectCollection)dataRow.get("entityperiodmap");
        if (dt == null) {
            DataGatherCommon.doLogWithTime(0L, "bgm-setPeriodMapping.dt = null ", LOG);
            return;
        }
        DataGatherCommon.doLogWithTime(0L, "bgm-setPeriodMapping.dt.count: " + dt.size(), LOG);
        for (int i = 0; i < dt.size(); ++i) {
            String periodNumber;
            Member member;
            Long acctperiodID = ((DynamicObject)dt.get(i)).getLong("accperiod.id");
            Long budgetPeriodId = ((DynamicObject)dt.get(i)).getLong("budgetperiod_id");
            if (IDUtils.isNull((Long)budgetPeriodId) || (member = modelCacheHelper.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), Long.valueOf(0L), budgetPeriodId)) == null || StringUtils.isEmpty((String)(periodNumber = member.getNumber()))) continue;
            periodMapping.put(acctperiodID, periodNumber);
        }
        dimMpping.setPeriodMapping(periodMapping);
    }

    protected void saveOlapBgm(IModelCacheHelper modelcache, Long datasetId, List<DataGatherDataSetEntity> datatotals, String schemeNumber) {
        if (datatotals == null || datatotals.size() == 0) {
            return;
        }
        ArrayList<IKDCell> cells = new ArrayList<IKDCell>(16);
        String[] dimensionNums = modelcache.getDimensionNums(datasetId);
        for (DataGatherDataSetEntity row : datatotals) {
            String ebDimStr = row.getEbdim();
            LinkedHashMap ebDimMapSort = (LinkedHashMap)ObjectSerialUtil.parseObject((String)ebDimStr, LinkedHashMap.class);
            BigDecimal fvalue = row.getValue();
            BigDecimal writeValue = BigDecimal.ZERO;
            if (fvalue instanceof BigDecimal) {
                writeValue = fvalue;
            }
            String[] memberArr = this.getDimValueByDimOrd(dimensionNums, ebDimMapSort);
            IKDCell c = KDCell.of((String[])memberArr, (BigDecimal)writeValue);
            cells.add(c);
        }
        Dataset dataSet = DatasetServiceHelper.getInstance().getDataSet(datasetId);
        LogStats stats = new LogStats("budget-shrek-log : ");
        stats.addInfo("DataGatherPeriodsBGM.saveOlapBgm");
        OlapTraceServiceHelper.setTraceOpInfo((String)schemeNumber);
        OlapContext.setSaveDataContext((SaveDataContext)new SaveDataContext(OlapDataAuditEventEnum.DataGather));
        try (IShrekSave shrekOlapSave = ShrekOlapServiceHelper.saveData((Model)modelcache.getModelobj(), (Dataset)dataSet, (String[])dimensionNums, (Map)ShrekIdCodeUtils.getDefaultIdCodes((LogStats)stats));){
            for (IKDCell cell : cells) {
                shrekOlapSave.add(cell.getMeta().getNumber(), (Object)cell.getValue().getDecimal());
            }
        }
    }

    private String[] getDimValueByDimOrd(String[] allDimKey, Map<String, String> ebDimMap) {
        if (ebDimMap == null || ebDimMap.size() == 0) {
            return null;
        }
        String[] returns = new String[allDimKey.length];
        for (int i = 0; i < allDimKey.length; ++i) {
            returns[i] = ebDimMap.get(allDimKey[i]);
        }
        return returns;
    }

    private static class InnerClass {
        private static DataGatherPeriodsBGM instance = new DataGatherPeriodsBGM();

        private InnerClass() {
        }
    }
}

