/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.dataGather.service;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.dataGather.entity.DataGatherCollectScheme;
import kd.epm.eb.business.dataGather.entity.DataGatherExecuteScheme;
import kd.epm.eb.business.dataGather.entity.DataGatherHandCallParam;
import kd.epm.eb.business.dataGather.entity.DataGatherMappingDim;
import kd.epm.eb.business.dataGather.service.DataGatherCommon;

public class DataGatherPeriodsEB {
    private static final Log log = LogFactory.getLog(DataGatherPeriodsEB.class);

    public static DataGatherPeriodsEB getInstance() {
        return InnerClass.instance;
    }

    private DataGatherPeriodsEB() {
    }

    public void setGlGatherPeriods(DataGatherExecuteScheme excuteSchemeInfo, DataGatherCollectScheme collectionScheme, DataGatherHandCallParam param) {
        Map<Long, String> ebGLYearPeriodMap = collectionScheme.getGlGather().getEbGLYearPeriodMap();
        if (ebGLYearPeriodMap == null) {
            ebGLYearPeriodMap = new HashMap<Long, String>(DataGatherCommon.initSize);
        }
        Set<Object> EBYearPeriods = new HashSet(DataGatherCommon.initSize);
        EBYearPeriods = excuteSchemeInfo.getHandCallParam() == null ? this.getEBYearPeriodFromPeriodCount(excuteSchemeInfo.getFetchPeriod(), this.getEbYearPeriodByCurDate()) : this.getEBYearPeriodFromHandParams(excuteSchemeInfo.getFetchPeriod(), excuteSchemeInfo.getHandCallParam());
        List<Long> glPeriods = this.getGLPeriods(EBYearPeriods, collectionScheme, ebGLYearPeriodMap);
        collectionScheme.getGlGather().setPeriodIds(glPeriods);
        collectionScheme.getGlGather().setEbGLYearPeriodMap(ebGLYearPeriodMap);
    }

    public String getDimNumberFromSchema(String dimKey, DataGatherCollectScheme collectSchemeInfo, Long GLPeriod) {
        String returns = "";
        String ebYearPeriod = collectSchemeInfo.getGlGather().getEbGLYearPeriodMap().get(GLPeriod);
        switch (dimKey) {
            case "Year": {
                returns = ebYearPeriod == null ? "" : ebYearPeriod.split("!")[0];
                break;
            }
            case "Period": {
                returns = ebYearPeriod == null ? "" : ebYearPeriod.split("!")[1];
                break;
            }
            case "Currency": {
                returns = collectSchemeInfo.getTargetCurrencyNumber();
            }
        }
        return returns;
    }

    public void setPeriodMapping(DataGatherMappingDim dimMpping, DynamicObject dataRow, DataGatherHandCallParam param) {
        if (dataRow == null) {
            return;
        }
        HashMap<Long, String> periodMapping = new HashMap<Long, String>(DataGatherCommon.initSize);
        DynamicObjectCollection dt = (DynamicObjectCollection)dataRow.get("entityperiodmap");
        if (dt == null) {
            DataGatherCommon.doLogWithTime(0L, "setPeriodMapping.dt = null ", log);
            return;
        }
        DataGatherCommon.doLogWithTime(0L, "setPeriodMapping.dt.count: " + dt.size(), log);
        for (int i = 0; i < dt.size(); ++i) {
            Long acctperiodID = ((DynamicObject)dt.get(i)).getLong("accperiod.id");
            String ebYearNumber = ((DynamicObject)dt.get(i)).getString("fiscalyear.number");
            String ebPeriodNumber = ((DynamicObject)dt.get(i)).getString("budgetperiod.number");
            periodMapping.put(acctperiodID, ebYearNumber + "!" + ebPeriodNumber);
        }
        dimMpping.setPeriodMapping(periodMapping);
    }

    private Set<String> getEBYearPeriodFromPeriodCount(Integer periodCount, String ebYearPeriod) {
        HashSet<String> returns = new HashSet<String>(periodCount);
        if (ebYearPeriod == null || ebYearPeriod.isEmpty()) {
            return returns;
        }
        Integer year = Integer.valueOf(ebYearPeriod.split("!")[0].substring("FY".length()));
        Integer period = Integer.valueOf(ebYearPeriod.split("!")[1].substring("M_M".length()));
        double yearPeriod = (double)year.intValue() + (double)period.intValue() * 0.01;
        for (int i = 0; i < periodCount; ++i) {
            returns.add(this.joinYearPeriod((int)yearPeriod, (int)Math.round((yearPeriod - (double)((int)yearPeriod)) * 100.0)));
            if ((yearPeriod -= 0.01) - (double)((int)yearPeriod) != 0.0) continue;
            yearPeriod = (double)((int)yearPeriod - 1) + 0.12;
        }
        return returns;
    }

    private String getEbYearPeriodByCurDate() {
        Calendar localTime = Calendar.getInstance();
        int y = localTime.get(1);
        int m = localTime.get(2) + 1;
        return this.joinYearPeriod(y, m);
    }

    private String joinYearPeriod(int y, int m) {
        return String.format("%s!%s", "FY" + y, "M_M" + (m >= 10 ? String.valueOf(m) : "0" + m));
    }

    private Set<String> getEBYearPeriodFromHandParams(Integer periodCount, DataGatherHandCallParam handParam) {
        if (handParam == null || handParam.getPeriodNum() == null) {
            return null;
        }
        String ebYearPeriod = handParam.getYearNum() + "!" + handParam.getPeriodNum();
        Set<String> returns = this.getEBYearPeriodFromPeriodCount(periodCount, ebYearPeriod);
        return returns;
    }

    private List<Long> getGLPeriods(Set<String> EBYearPeriods, DataGatherCollectScheme collectionScheme, Map<Long, String> ebGLYearPeriodMap) {
        ArrayList<Long> glPeriods = new ArrayList<Long>(DataGatherCommon.initSize);
        if (EBYearPeriods == null || EBYearPeriods.size() == 0) {
            return glPeriods;
        }
        for (String ebYearPeriod : EBYearPeriods) {
            Set<Long> glPeriodIds = this.getGLPeriodByEbYearPeriod(ebYearPeriod, collectionScheme);
            glPeriods.addAll(glPeriodIds);
            for (Long glPeriodId : glPeriodIds) {
                ebGLYearPeriodMap.put(glPeriodId, ebYearPeriod);
            }
        }
        return glPeriods;
    }

    private Set<Long> getGLPeriodByEbYearPeriod(String EBYearPeirod, DataGatherCollectScheme collectionScheme) {
        HashSet<Long> returns = new HashSet<Long>(16);
        if (collectionScheme == null || collectionScheme.getDimMpping() == null) {
            return returns;
        }
        Map<Long, String> periodMapping = collectionScheme.getDimMpping().getPeriodMapping();
        if (collectionScheme == null || periodMapping.size() == 0) {
            return returns;
        }
        for (Map.Entry<Long, String> entry : periodMapping.entrySet()) {
            if (!entry.getValue().equalsIgnoreCase(EBYearPeirod)) continue;
            returns.add(entry.getKey());
        }
        return returns;
    }

    private static class InnerClass {
        private static DataGatherPeriodsEB instance = new DataGatherPeriodsEB();

        private InnerClass() {
        }
    }
}

