/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.dataGather.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.common.CellSet;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.business.dataGather.db.DataGatherSum;
import kd.epm.eb.business.dataGather.entity.DataGatherCollectScheme;
import kd.epm.eb.business.dataGather.entity.DataGatherDataSetEntity;
import kd.epm.eb.business.dataGather.entity.DataGatherExecuteScheme;
import kd.epm.eb.business.dataGather.entity.DataGatherHandCallParam;
import kd.epm.eb.business.dataGather.entity.DataGatherMiddleTable;
import kd.epm.eb.business.dataGather.service.DataGatherCommon;
import kd.epm.eb.business.dataGather.service.DataGatherDoMapping;
import kd.epm.eb.business.dataGather.service.DataGatherExecuteSchemeService;
import kd.epm.eb.business.dataGather.service.DataGatherGLDATAQueryService;
import kd.epm.eb.business.dataGather.service.DataGatherGLMiddleTableService;
import kd.epm.eb.business.dataGather.service.DataGatherPeriodsBGM;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.ebcommon.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.ebcommon.common.enums.FacTabFieldDefEnum;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.common.ebcommon.common.util.QFBuilder;
import kd.epm.eb.common.olapdao.OlapContext;
import kd.epm.eb.common.shrek.util.ShrekIdCodeUtils;
import kd.epm.eb.common.utils.datagather.GlobalVar;
import kd.epm.eb.ebBusiness.serviceHelper.DimensionServiceHelper;
import kd.epm.eb.ebBusiness.serviceHelper.OlapServiceHelper;

public class DataGatherRunService {
    private static final Log log = LogFactory.getLog(DataGatherRunService.class);
    private Map<Long, Map<Long, String>> acctTableAccounts_out;
    private List<String> allDimKey;
    private IModelCacheHelper modelcache;

    public static DataGatherRunService getInstance() {
        return InnerClass.instance;
    }

    private DataGatherRunService() {
    }

    public void doDataGatherRun(Long modelID, List<Long> excuteSchemeIds, DataGatherHandCallParam param) {
        DataGatherCommon.doLogWithTime(0L, "begin dataGatherRun_begin:" + excuteSchemeIds.toString(), log);
        List<DataGatherExecuteScheme> excuteSchemeInfos = this.getExecuteScheme(modelID, excuteSchemeIds, param);
        if (excuteSchemeInfos == null || excuteSchemeInfos.size() == 0) {
            DataGatherCommon.doLogWithTime(0L, "excuteSchemeInfos:null or 0", log);
            throw new KDBizException(ResManager.loadKDString((String)"\u6267\u884c\u65b9\u6848\u4e3a\u7a7a\uff01", (String)"DataGatherRunService_1", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        DataGatherCommon.doLogWithTime(0L, "excuteSchemeInfos.size:" + excuteSchemeInfos.size(), log);
        this.iniGlobleVar(modelID);
        DataGatherCommon.doLogWithTime(0L, "begin doDataGather: " + excuteSchemeIds.toString(), log);
        try {
            this.doDataGather(excuteSchemeInfos, param);
        }
        catch (KDBizException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            DataGatherCommon.doLogWithTime(0L, e.getMessage() + Arrays.toString(e.getStackTrace()), log);
            throw new KDBizException(ResManager.loadResFormat((String)"\u6267\u884c\u8fc7\u7a0b\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7[tranceId:%1]\u3002", (String)"DataGatherRunService_0", (String)"epm-eb-business", (Object[])new Object[]{RequestContext.get().getTraceId()}));
        }
        finally {
            DataGatherCommon.INDEX_LIST.remove();
            DataGatherCommon.MEMBER_ID_LIST.remove();
            DataGatherCommon.GL_TYPE_KEY.remove();
            DataGatherCommon.GL_SUB_MEMBERS.remove();
        }
        DataGatherCommon.doLogWithTime(0L, "after dataGatherRun_End. " + excuteSchemeIds.toString(), log);
    }

    private List<DataGatherExecuteScheme> getExecuteScheme(Long modelID, List<Long> excuteSchemeIds, DataGatherHandCallParam param) {
        if (GlobalVar.fetch.get() == null) {
            DataGatherGLMiddleTableService.getInstance().deleteDataFromMiddleTable(excuteSchemeIds);
        }
        DataGatherCommon.doLogWithTime(0L, "begin getDataTransExcuteScheme:" + excuteSchemeIds.toString(), log);
        List<DataGatherExecuteScheme> excuteSchemeInfos = DataGatherExecuteSchemeService.getInstance().getDataTransExcuteScheme(modelID, excuteSchemeIds, param);
        return excuteSchemeInfos;
    }

    private void iniGlobleVar(Long modelID) {
        this.acctTableAccounts_out = new ConcurrentHashMap<Long, Map<Long, String>>(DataGatherCommon.initSize);
        this.modelcache = ModelCacheContext.getOrCreate((Long)modelID);
        this.allDimKey = DimensionServiceHelper.getAllDim((Long)modelID);
    }

    private void setGlGatherParams(DataGatherExecuteScheme excuteSchemeInfo, DataGatherCollectScheme collectSchemeInfo) {
        Map<Long, String> tableAccounts = this.acctTableAccounts_out.get(collectSchemeInfo.getGlGather().getAccountTableID());
        if (tableAccounts == null) {
            tableAccounts = this.getAcctTableAccounts(collectSchemeInfo.getGlGather().getAccountTableID());
            this.acctTableAccounts_out.putIfAbsent(collectSchemeInfo.getGlGather().getAccountTableID(), tableAccounts);
        }
        DataGatherGLDATAQueryService.getInstance().setGlGatherAccountParams(collectSchemeInfo.getGlGather(), tableAccounts.keySet());
    }

    private Map<Long, String> getAcctTableAccounts(Long acctTableID) {
        DynamicObjectCollection dims = QueryServiceHelper.query((String)"bd_accountview", (String)"id, number,dc", (QFilter[])new QFBuilder().add("accounttable", "=", (Object)acctTableID).and(new QFilter("isleaf", "=", (Object)"1")).toArray(), (String)"number");
        HashMap<Long, String> allAccounts = new HashMap<Long, String>(DataGatherCommon.initSize);
        dims.forEach(e -> allAccounts.put(e.getLong("id"), e.getString("number") + "!" + e.getString("dc")));
        return allAccounts;
    }

    private boolean checkValid(DataGatherCollectScheme collectSchemeInfo) {
        Set<String> mixOrgs = collectSchemeInfo.getMixOrgs();
        return mixOrgs != null && mixOrgs.size() != 0;
    }

    private void doDataGatherRunSingleCollectScheme(DataGatherExecuteScheme excuteSchemeInfo, DataGatherCollectScheme collectSchemeInfo, DataGatherHandCallParam param) {
        String logHead = this.getLogExcuteSchemeInfo(excuteSchemeInfo, collectSchemeInfo);
        if (!this.checkValid(collectSchemeInfo)) {
            DataGatherCommon.doLogWithTime(0L, "collectSchemeInfo mixOrg is null or 0:" + logHead, log);
            return;
        }
        DataGatherCommon.doLogWithTime(0L, "begin setGlGatherParams:" + logHead, log);
        this.setGlGatherParams(excuteSchemeInfo, collectSchemeInfo);
        DataGatherCommon.doLogWithTime(0L, "begin getGLDatas:" + logHead, log);
        Map<Long, String> tableAccounts = this.acctTableAccounts_out.get(collectSchemeInfo.getGlGather().getAccountTableID());
        List<DataGatherMiddleTable> GlDataTableDatas = DataGatherGLDATAQueryService.getInstance().getGLDatasAndAssembly(excuteSchemeInfo, collectSchemeInfo, tableAccounts, param);
        DataGatherCommon.doLogWithTime(0L, "begin getOlapCellsByDatas: " + (GlDataTableDatas == null ? 0 : GlDataTableDatas.size()), log);
        boolean hasValiadData = DataGatherDoMapping.getInstance().getMappingDims(this.modelcache, collectSchemeInfo, GlDataTableDatas, this.allDimKey, param);
        DataGatherCommon.doLogWithTime(0L, "begin saveDataToMiddleTable: " + (GlDataTableDatas == null ? 0 : GlDataTableDatas.size()), log);
        DataGatherGLMiddleTableService.getInstance().saveDataToMiddleTable(excuteSchemeInfo, GlDataTableDatas, hasValiadData ? "1" : "2");
        DataGatherCommon.doLogWithTime(0L, "begin doSaveData: " + logHead, log);
        this.doSaveData(logHead, excuteSchemeInfo, collectSchemeInfo);
    }

    private void doSaveData(String logHead, DataGatherExecuteScheme excuteSchemeInfo, DataGatherCollectScheme collectSchemeInfo) {
        DataGatherCommon.doLogWithTime(0L, "begin queryTotals: " + logHead, log);
        List<DataGatherDataSetEntity> entities = this.queryTotals(excuteSchemeInfo);
        DataGatherCommon.doLogWithTime(0L, "begin cellsTotal: " + (entities == null ? 0 : entities.size()), log);
        String modelNumber = excuteSchemeInfo.getModelNumber();
        this.saveToOlap(excuteSchemeInfo, collectSchemeInfo, logHead, entities, modelNumber);
    }

    private void saveToOlap(DataGatherExecuteScheme excuteSchemeInfo, DataGatherCollectScheme collectSchemeInfo, String logHead, List<DataGatherDataSetEntity> entities, String modelNumber) {
        if (DataGatherRunService.checkAppNum(excuteSchemeInfo.getHandCallParam(), ApplicationTypeEnum.BGM)) {
            DataGatherCommon.doLogWithTime(0L, "begin saveToOlap BGM: " + logHead, log);
            DataGatherPeriodsBGM.getInstance().saveOlapBgm(this.modelcache, collectSchemeInfo.getDatasetId(), entities, excuteSchemeInfo.getNumber());
        }
        if (DataGatherRunService.checkAppNum(excuteSchemeInfo.getHandCallParam(), ApplicationTypeEnum.EB)) {
            CellSet cellTotals = this.cellsTotal(modelNumber, entities);
            DataGatherCommon.doLogWithTime(0L, "begin save2olap EB" + (cellTotals == null ? 0 : cellTotals.getCount()), log);
            this.save2olap(modelNumber, cellTotals);
        }
    }

    private List<DataGatherDataSetEntity> queryTotals(DataGatherExecuteScheme excuteSchemeInfo) {
        ArrayList<DataGatherDataSetEntity> list = new ArrayList<DataGatherDataSetEntity>(16);
        DataGatherSum.getInstance().loadSumData(excuteSchemeInfo, list, DBRoute.of((String)"epm"));
        return list;
    }

    private CellSet cellsTotal(String modelNumber, List<DataGatherDataSetEntity> entities) {
        if (entities == null || entities.size() == 0) {
            DataGatherCommon.doLogWithTime(0L, "cellsTotal.dts ==null", log);
            return null;
        }
        DataGatherCommon.doLogWithTime(0L, "cellsTotal entities.count:" + (entities == null ? 0 : entities.size()), log);
        String measure = FacTabFieldDefEnum.FIELD_MONEY.getField();
        CellSet cellTotals = new CellSet(this.allDimKey.toArray(new String[0]), new String[]{measure});
        cellTotals.setFromQuery(false);
        LinkedHashMap ebDimMapSort = null;
        for (DataGatherDataSetEntity row : entities) {
            String ebDimStr = row.getEbdim();
            ebDimMapSort = (LinkedHashMap)ObjectSerialUtil.parseObject((String)ebDimStr, LinkedHashMap.class);
            cellTotals.set(DataGatherCommon.getDimValueByDimOrd(this.allDimKey, ebDimMapSort), measure, (Object)row.getValue());
        }
        entities.clear();
        DataGatherCommon.doLogWithTime(0L, "cellsTotal cells.count:" + cellTotals.getCount(), log);
        return cellTotals;
    }

    private void doDataGather(List<DataGatherExecuteScheme> excuteSchemeInfos, DataGatherHandCallParam param) {
        if (excuteSchemeInfos == null || excuteSchemeInfos.size() == 0) {
            return;
        }
        for (DataGatherExecuteScheme excuteSchemeInfo : excuteSchemeInfos) {
            if (!this.checkExcuteSchemeOk(excuteSchemeInfo)) {
                DataGatherCommon.doLogWithTime(0L, "excuteSchemeInfo is not in valiadData:" + excuteSchemeInfo.getNumber(), log);
                continue;
            }
            List<DataGatherCollectScheme> collectSchemeInfos = excuteSchemeInfo.getCollectSchemeInfos();
            if (collectSchemeInfos == null || collectSchemeInfos.size() == 0) continue;
            for (DataGatherCollectScheme collectSchemeInfo : collectSchemeInfos) {
                if (DataGatherRunService.checkAppNum(excuteSchemeInfo.getHandCallParam(), ApplicationTypeEnum.BGM)) {
                    this.allDimKey = Arrays.asList(this.modelcache.getDimensionNums(collectSchemeInfo.getDatasetId()));
                }
                DataGatherCommon.doLogWithTime(0L, "begin doDataGatherRunSingleCollectScheme:" + collectSchemeInfo.getNumber(), log);
                this.doDataGatherRunSingleCollectScheme(excuteSchemeInfo, collectSchemeInfo, param);
            }
        }
    }

    private String getLogExcuteSchemeInfo(DataGatherExecuteScheme excuteScheme, DataGatherCollectScheme collectSchemeInfo) {
        return excuteScheme.getID().toString() + "--" + excuteScheme.getName() + "--" + collectSchemeInfo.getName();
    }

    private boolean checkExcuteSchemeOk(DataGatherExecuteScheme excuteSchemeInfo) {
        Date now = TimeServiceHelper.now();
        return this.getDate(excuteSchemeInfo.getEndDate(), 1).after(now) && this.getDate(excuteSchemeInfo.getStartDate(), -1).before(now);
    }

    private Date getDate(Date dt, int diff) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dt);
        calendar.add(5, diff);
        return calendar.getTime();
    }

    private SaveCommandInfo getSaveCommandInfo() {
        SaveCommandInfo olapInfo = new SaveCommandInfo();
        ShrekIdCodeUtils.setTraceInfo((CommandInfo)olapInfo, (Map)ShrekIdCodeUtils.getDefaultIdCodes(null));
        olapInfo.setMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        olapInfo.setDimensions(this.allDimKey.toArray(new String[0]));
        return olapInfo;
    }

    private void save2olap(String modelNumber, CellSet cells) {
        if (cells == null || cells.getCount() == 0) {
            DataGatherCommon.doLogWithTime(0L, "save2olap cells.count=0", log);
            return;
        }
        DataGatherCommon.doLogWithTime(0L, "save2olap cells.count:" + cells.getCount(), log);
        SaveCommandInfo olapInfo = this.getSaveCommandInfo();
        try {
            DataGatherCommon.doLogWithTime(0L, "begin saveOlapData", log);
            OlapServiceHelper.saveData((SaveCommandInfo)olapInfo, (CellSet)cells, (String)modelNumber, (boolean)true, (boolean)false);
        }
        catch (Exception e) {
            OlapContext.clearSaveDataContext();
            DataGatherCommon.doLogWithTime(0L, "save2olap err: ", log);
            throw new KDBizException(ResManager.loadResFormat((String)"olap\u4fdd\u5b58\u5931\u8d25\uff01%1", (String)"DataGatherRunService_2", (String)"epm-eb-business", (Object[])new Object[]{e.getMessage()}));
        }
    }

    public static boolean checkAppNum(DataGatherHandCallParam param, ApplicationTypeEnum applicationTypeEnum) {
        return param != null && applicationTypeEnum != null && applicationTypeEnum.getAppnum().equalsIgnoreCase(param.getAppNum());
    }

    private static class InnerClass {
        private static DataGatherRunService instance = new DataGatherRunService();

        private InnerClass() {
        }
    }
}

