/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.dataGather.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.util.JSONUtils;
import kd.epm.eb.business.dataGather.entity.DataGatherCollectScheme;
import kd.epm.eb.business.dataGather.entity.DataGatherExecuteScheme;
import kd.epm.eb.business.dataGather.entity.DataGatherHandCallParam;
import kd.epm.eb.business.dataGather.entity.DataGatherMiddleTable;
import kd.epm.eb.business.dataGather.service.DataGatherCommon;
import kd.epm.eb.business.dataGather.service.DataGatherGLDATAQueryService;
import kd.epm.eb.business.dataGather.service.DataGatherGLMiddleTableService;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.datagather.GlobalVar;
import kd.epm.eb.ebBusiness.model.BalanceQueryParam;

public final class SyncLoadDataForGlService {
    private static final Log LOG = LogFactory.getLog(DataGatherGLDATAQueryService.class);
    private Integer splitSize = (Integer)GlobalVar.splitSize.get();

    public static SyncLoadDataForGlService getInstance() {
        InnerClass.instance.splitSize = (Integer)GlobalVar.splitSize.get();
        return InnerClass.instance;
    }

    private SyncLoadDataForGlService() {
    }

    private ThreadPoolExecutor createThread() {
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        return new ThreadPoolExecutor(availableProcessors + 1, availableProcessors * 2, 30L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>());
    }

    protected List<DataGatherMiddleTable> doQueryGLDataAndAssembly(DataGatherExecuteScheme excuteSchemeInfo, DataGatherCollectScheme collectSchemeInfo, List<BalanceQueryParam> balanceQueryParams, Map<Long, String> tableAccounts, DataGatherHandCallParam param) {
        if (balanceQueryParams == null || balanceQueryParams.size() == 0) {
            return null;
        }
        LinkedHashMap<Long, List<long[]>> loopData = new LinkedHashMap<Long, List<long[]>>(balanceQueryParams.size() * 2);
        int threadSize = this.getThreadSizeAndSplitOrgs(balanceQueryParams, loopData);
        ThreadPoolExecutor poolExecutor = this.createThread();
        poolExecutor.allowCoreThreadTimeOut(true);
        ExecutorService es = ThreadLifeCycleManager.wrapExecutorService((ExecutorService)poolExecutor);
        CountDownLatch countDownLatch = new CountDownLatch(threadSize);
        Vector<DataGatherMiddleTable> GlDataTableDatas = new Vector<DataGatherMiddleTable>(DataGatherCommon.initSize);
        HashSet errInfos = new HashSet(DataGatherCommon.initSize);
        for (BalanceQueryParam balanceQueryParam : balanceQueryParams) {
            long periodId = balanceQueryParam.getPeriodId();
            List longs = (List)loopData.get(periodId);
            for (long[] aLong : longs) {
                BalanceQueryParam deepCopyParam = (BalanceQueryParam)ObjectSerialUtil.deepCopy((Object)balanceQueryParam);
                deepCopyParam.setOrgIds(aLong);
                es.execute(() -> {
                    try {
                        List<DataGatherMiddleTable> middleTables = this.invokeGLService(excuteSchemeInfo, collectSchemeInfo, tableAccounts, param, deepCopyParam);
                        if (middleTables != null && middleTables.size() > 0) {
                            GlDataTableDatas.addAll(middleTables);
                        }
                    }
                    catch (Exception e) {
                        LOG.info("DataGather: doQueryGLDataAndAssembly_error!", (Object)e);
                        errInfos.add(e.getMessage() + e.getCause() + e.getStackTrace());
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                });
            }
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            LOG.info("DataGather: doQueryGLDataAndAssembly_interrupted!", (Object)e);
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
        if (errInfos.size() > 0) {
            throw new KDBizException((String)errInfos.iterator().next());
        }
        return GlDataTableDatas;
    }

    private int getThreadSizeAndSplitOrgs(List<BalanceQueryParam> balanceQueryParams, Map<Long, List<long[]>> loopData) {
        int threadSize = 0;
        for (BalanceQueryParam balanceQueryParam : balanceQueryParams) {
            long[] orgIds;
            Long periodId = balanceQueryParam.getPeriodId();
            if (IDUtils.isNull((Long)periodId) || (orgIds = balanceQueryParam.getOrgIds()) == null || orgIds.length == 0) continue;
            List<long[]> splitArr = this.splitArr(orgIds);
            loopData.put(periodId, splitArr);
            threadSize += splitArr.size();
        }
        return threadSize;
    }

    private List<DataGatherMiddleTable> invokeGLService(DataGatherExecuteScheme excuteSchemeInfo, DataGatherCollectScheme collectSchemeInfo, Map<Long, String> tableAccounts, DataGatherHandCallParam param, BalanceQueryParam deepCopyParam) {
        long periodId = deepCopyParam.getPeriodId();
        String logEbPeriod = collectSchemeInfo.getGlGather().getEbGLYearPeriodMap().get(periodId);
        DataGatherCommon.doLogWithTime(0L, "invokeGLService: " + logEbPeriod, LOG);
        List gldatas = null;
        try {
            String result = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"gl", (String)"BalanceService", (String)"getBalance", (Object[])new Object[]{deepCopyParam.toString()});
            if (result != null) {
                gldatas = (List)JSONUtils.cast((String)result, List.class);
            }
        }
        catch (IOException | KDBizException e) {
            DataGatherCommon.doLogWithTime(0L, String.join((CharSequence)"invokeGLService err: ", e.getMessage()), LOG);
            throw new KDBizException(StringUtils.join((Object[])new String[]{ResManager.loadKDString((String)"\u540c\u6b65\u603b\u8d26\u79d1\u76ee\u4f59\u989d\u8868\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"DataGatherGLDATAQueryService_1", (String)"epm-eb-business", (Object[])new Object[0]), e.getMessage()}));
        }
        DataGatherCommon.doLogWithTime(0L, "invokeGLService: " + logEbPeriod + " GlDataCounts:" + (gldatas == null ? "null" : gldatas.size() + ""), LOG);
        return DataGatherGLMiddleTableService.getInstance().assemblyData(excuteSchemeInfo, collectSchemeInfo, gldatas, tableAccounts, deepCopyParam, param);
    }

    private List<long[]> splitArr(long[] orgIds) {
        if (orgIds == null || orgIds.length == 0) {
            return new ArrayList<long[]>(0);
        }
        int length = orgIds.length;
        int size = length / this.splitSize;
        size = length % this.splitSize == 0 ? size : size + 1;
        ArrayList<long[]> results = new ArrayList<long[]>(size * 2 + 1);
        int subArrInitLen = this.splitSize * 2 + 1;
        ArrayList<Long> tmpList = new ArrayList<Long>(subArrInitLen);
        int index = 0;
        while (index < length) {
            Long next = orgIds[index++];
            tmpList.add(next);
            if (tmpList.size() != this.splitSize.intValue() && index < length) continue;
            long[] longs = new long[tmpList.size()];
            int idx = 0;
            Iterator iterator = tmpList.iterator();
            while (iterator.hasNext()) {
                long tmpTransId = (Long)iterator.next();
                longs[idx++] = tmpTransId;
            }
            results.add(longs);
            tmpList.clear();
        }
        return results;
    }

    private static class InnerClass {
        private static SyncLoadDataForGlService instance = new SyncLoadDataForGlService();

        private InnerClass() {
        }
    }
}

