/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.dataintegration;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.epm.eb.business.dataintegration.DataIntegrationStart;
import kd.epm.eb.business.dataintegration.entity.ExecuteCondition;
import kd.epm.eb.business.dataintegration.entity.IntegrationExecStatus;
import kd.epm.eb.business.dataintegration.entity.context.IntegrationContext;
import kd.epm.eb.business.dataintegration.service.DataIntegrationDataService;
import kd.epm.eb.business.easupgrade.utils.IntegrationLogHelper;
import kd.epm.eb.common.orm.EbIntegrationLog;
import kd.epm.eb.common.utils.base.DistributeSessionlessCacheUtils;
import org.apache.commons.collections4.MapUtils;

public class CallBackDataIntegrationStart
extends DataIntegrationStart {
    private Map<String, Object> callbackMap;
    private Long currentSchemeId;

    private CallBackDataIntegrationStart(ExecuteCondition executeCondition) {
        super(executeCondition);
    }

    public static CallBackDataIntegrationStart getInstance(Map<String, Object> callbackMap) {
        Long triggerId = MapUtils.getLong(callbackMap, (Object)"trigger_id");
        Long schemeId = DataIntegrationDataService.getInstance().getDataIntegrationId(triggerId);
        EbIntegrationLog ebIntegrationLog = IntegrationLogHelper.getFirstLogPj(schemeId, IntegrationExecStatus.ING, "factionid", "fid");
        if (ebIntegrationLog == null) {
            throw new KDBizException(String.format("get log fail-scheme:%s,trigger:%s", schemeId, triggerId));
        }
        ExecuteCondition executeCondition = CallBackDataIntegrationStart.getExecConditionFromCache(ebIntegrationLog.getActionIdLong());
        HashSet schemeIds = Sets.newHashSet((Object[])new Long[]{schemeId});
        executeCondition.setTargetSchemeIds(schemeIds);
        executeCondition.setActionId(ebIntegrationLog.getActionIdLong());
        CallBackDataIntegrationStart start = new CallBackDataIntegrationStart(executeCondition);
        start.setCallbackMap(callbackMap);
        start.currentSchemeId = schemeId;
        start.getLogIdMap().put(schemeId, ebIntegrationLog.getIdLong());
        return start;
    }

    @Override
    protected IntegrationContext buildContext() {
        IntegrationContext context = super.buildContext();
        context.getFiSysIntegrations().clear();
        context.getFiSysIntegrations().addAll(context.getIscSysIntegrations());
        context.getIscSysIntegrations().clear();
        context.setTotalDataCount(MapUtils.getInteger(this.getCallbackMap(), (Object)"total_count"));
        return context;
    }

    @Override
    public void run(boolean async) {
        super.run(async);
        this.checkAndDelContext();
    }

    @Override
    protected void insertMainLog(IntegrationContext context) {
    }

    private void checkAndDelContext() {
        Long actionId = this.getActionId();
        if (this.currentSchemeId != null && IntegrationLogHelper.allInsDone(actionId)) {
            DistributeSessionlessCacheUtils.remove((String)("DATA_INTEGRATION_QUERY_LIST" + actionId));
        }
    }

    public void setCallbackMap(Map<String, Object> callbackMap) {
        this.callbackMap = callbackMap;
    }

    public Map<String, Object> getCallbackMap() {
        if (this.callbackMap == null) {
            this.callbackMap = new HashMap<String, Object>();
        }
        return this.callbackMap;
    }

    @Override
    protected DLock getSchemeLock(Long integrationSchemeId) {
        return null;
    }
}

