/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.dataintegration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.epm.eb.business.dataintegration.entity.AbstractDataIntegration;
import kd.epm.eb.business.dataintegration.entity.DataIntegration;
import kd.epm.eb.business.dataintegration.entity.DataIntegrationMemberPojo;
import kd.epm.eb.business.dataintegration.entity.DataIntegrationQuery;
import kd.epm.eb.business.dataintegration.entity.ExecuteCondition;
import kd.epm.eb.business.dataintegration.entity.IntegrationExecStatus;
import kd.epm.eb.business.dataintegration.entity.IntegrationRange;
import kd.epm.eb.business.dataintegration.entity.context.IntegrationContext;
import kd.epm.eb.business.dataintegration.entity.context.IntegrationCusContext;
import kd.epm.eb.business.dataintegration.service.DataIntegrationInService;
import kd.epm.eb.business.dataintegration.service.DataIntegrationQueryService;
import kd.epm.eb.business.dataintegration.service.IntegrationHandlerFactory;
import kd.epm.eb.business.dataintegration.service.handler.DataIntegrationHandler;
import kd.epm.eb.business.easupgrade.utils.EASDataIntegrationUtil;
import kd.epm.eb.business.easupgrade.utils.IntegrationLogHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dataintegration.DataIntegrationGetValType;
import kd.epm.eb.common.dataintegration.DataIntegrationType;
import kd.epm.eb.common.dataintegration.IntegrationSchemeType;
import kd.epm.eb.common.spread.util.GZIPUtils;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.base.DistributeSessionlessCacheUtils;

public class DataIntegrationStart {
    private ExecuteCondition executeCondition;
    private static final Log log = LogFactory.getLog(DataIntegrationStart.class);
    private boolean async = true;
    private Map<Long, Long> logIdMap = new HashMap<Long, Long>(16);
    private IModelCacheHelper modelCacheHelper;

    public static DataIntegrationStart getInstance(ExecuteCondition executeCondition) {
        DataIntegrationStart start = new DataIntegrationStart(executeCondition);
        start.setExecuteCondition(executeCondition);
        return start;
    }

    protected DataIntegrationStart(ExecuteCondition executeCondition) {
        this.executeCondition = executeCondition;
    }

    public void run(boolean async) {
        this.setAsync(async);
        IntegrationContext context = this.buildContext();
        this.insertMainLog(context);
        this.runCallBackIntegration(context);
        this.runDirectIntegration(context);
    }

    protected void runCallBackIntegration(IntegrationContext context) {
        if (context.getIscSysIntegrations().size() > 0) {
            DataIntegrationStart.addExecConditionToCache(context.getExecuteCondition(), this.getActionId());
            IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
            String loginIP = RequestContext.getOrCreate().getLoginIP();
            String traceId = RequestContext.getOrCreate().getTraceId();
            Runnable runner = () -> {
                RequestContext.getOrCreate().setLoginIP(loginIP);
                RequestContext.getOrCreate().setTraceId(traceId);
                context.getIscSysIntegrations().forEach(insideIntegration -> {
                    DLock schemeLock = this.getSchemeLock(insideIntegration.getId());
                    try {
                        IntegrationLogHelper.markLogStatus(this.logIdMap.get(insideIntegration.getId()), IntegrationExecStatus.ING);
                        Map<String, List<Member>> memberFilters = EASDataIntegrationUtil.parserMemberFilter(insideIntegration, modelCacheHelper, context);
                        DataIntegrationInService.getInstance().syncData((DataIntegration)insideIntegration, memberFilters);
                    }
                    catch (Exception e) {
                        IntegrationLogHelper.markLogStatus(this.logIdMap.get(insideIntegration.getId()), e.getMessage(), IntegrationExecStatus.FAIL);
                        log.error("runOutSignIntegration:" + insideIntegration.getId(), (Throwable)e);
                    }
                    finally {
                        if (schemeLock != null) {
                            schemeLock.unlock();
                        }
                    }
                });
            };
            if (this.async) {
                ThreadPools.executeOnce((String)"execute_outsideIntegrations", (Runnable)runner);
            } else {
                runner.run();
            }
        }
    }

    protected void runDirectIntegration(IntegrationContext context) {
        if (context.getFiSysIntegrations().size() > 0) {
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)context.getExecuteCondition().getModelId());
            String loginIP = RequestContext.getOrCreate().getLoginIP();
            String traceId = RequestContext.getOrCreate().getTraceId();
            Runnable runner = () -> {
                RequestContext.getOrCreate().setLoginIP(loginIP);
                RequestContext.getOrCreate().setTraceId(traceId);
                for (AbstractDataIntegration integration : context.getFiSysIntegrations()) {
                    Long mainLogId = this.logIdMap.get(integration.getId());
                    DLock schemeLock = null;
                    DataIntegrationHandler handler = null;
                    IntegrationCusContext cusContext = null;
                    try {
                        schemeLock = this.getSchemeLock(integration.getId());
                        handler = IntegrationHandlerFactory.getHandler(context, integration);
                        handler.setModelCacheHelper(modelCacheHelper);
                        handler.setMainLogId(mainLogId);
                        cusContext = handler.init(context);
                        boolean isEnd = false;
                        while (cusContext != null && !isEnd) {
                            isEnd = handler.readData(context, cusContext);
                            handler.convertData(context, cusContext);
                            handler.selDataCountInfo(cusContext);
                            cusContext.setSourceRowData(null);
                            handler.saveData(context, cusContext, integration.getNumber());
                            cusContext.setTargetRowData(null);
                            handler.afterSaveData(context, cusContext);
                        }
                        handler.finish(context, cusContext);
                    }
                    catch (Throwable e) {
                        IntegrationLogHelper.markLogStatus(mainLogId, e.getMessage(), IntegrationExecStatus.FAIL);
                        log.error("runInSignIntegration:" + integration.getId(), e);
                        try {
                            if (handler == null) continue;
                            handler.handleLog(context, cusContext);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    finally {
                        if (schemeLock == null) continue;
                        schemeLock.unlock();
                    }
                }
            };
            if (this.async) {
                ThreadPools.executeOnce((String)"execute_insideIntegrations", (Runnable)runner);
            } else {
                runner.run();
            }
        }
    }

    protected DLock getSchemeLock(Long integrationSchemeId) {
        DLock lock = DLock.create((String)("fi/epm/eb/dataintegrationin/" + integrationSchemeId));
        lock.lock();
        return lock;
    }

    protected IntegrationContext buildContext() {
        IntegrationContext context = new IntegrationContext();
        ExecuteCondition executeCondition = this.getExecuteCondition();
        context.setExecuteCondition(executeCondition);
        executeCondition.setFilterMemberPerm(CommonUtils.integraitonFilterswitch((Long)executeCondition.getModelId()));
        Set<Long> targetSchemeIds = executeCondition.getTargetSchemeIds();
        DataIntegrationType type = executeCondition.isOut() ? DataIntegrationType.OUTPUT : DataIntegrationType.INPUT;
        List<AbstractDataIntegration> allDataIntegration = DataIntegrationQueryService.getInstance().getDataIntegrationObjects(type, targetSchemeIds, true);
        for (AbstractDataIntegration integrationPJ : allDataIntegration) {
            if (!integrationPJ.getStatus()) continue;
            if (DataIntegrationType.INPUT == integrationPJ.getIntegrationType() && integrationPJ.getScheme() == IntegrationSchemeType.CUSTOM) {
                context.getIscSysIntegrations().add(integrationPJ);
                continue;
            }
            context.getFiSysIntegrations().add(integrationPJ);
        }
        Map<String, List<Member>> memberFilter = EASDataIntegrationUtil.parserMemberFilter(executeCondition);
        context.setMemberFilters(memberFilter);
        return context;
    }

    protected void insertMainLog(IntegrationContext context) {
        ArrayList<DynamicObject> logObjs = new ArrayList<DynamicObject>(16);
        for (AbstractDataIntegration integration : context.getFiSysIntegrations()) {
            logObjs.add(this.buildLogObj(integration, context));
        }
        for (AbstractDataIntegration integration : context.getIscSysIntegrations()) {
            logObjs.add(this.buildLogObj(integration, context));
        }
        SaveServiceHelper.save((DynamicObject[])logObjs.toArray(new DynamicObject[1]));
    }

    private DynamicObject buildLogObj(AbstractDataIntegration integration, IntegrationContext context) {
        DynamicObject logObj = BusinessDataServiceHelper.newDynamicObject((String)"eb_integration_log");
        Long id = GlobalIdUtil.genGlobalLongId();
        logObj.set("createrfield", (Object)UserUtils.getUserId());
        logObj.set("createdatefield", (Object)TimeServiceHelper.now());
        logObj.set("actionid", (Object)this.getActionId());
        logObj.set("status", (Object)IntegrationExecStatus.WAIT.getVal());
        logObj.set("integration", (Object)integration.getId());
        logObj.set("id", (Object)id);
        logObj.set("scope", (Object)this.selRange2Str(integration, context));
        this.logIdMap.put(integration.getId(), id);
        return logObj;
    }

    private String selRange2Str(AbstractDataIntegration integration, IntegrationContext context) {
        String result = null;
        IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
        if (integration != null) {
            boolean filterPerm = context.getExecuteCondition().isFilterMemberPerm();
            boolean isOut = context.getExecuteCondition().isOut();
            Long bizModelId = context.getExecuteCondition().getBizModelId();
            Map<String, DataIntegrationQuery> filters = context.getFilters().stream().collect(Collectors.toMap(DataIntegrationQuery::getDimNumber, q2 -> q2));
            ArrayList<DataIntegrationQuery> queryList = new ArrayList<DataIntegrationQuery>(16);
            for (IntegrationRange range : integration.getIntegrationRanges()) {
                if (range.getGetValType() == DataIntegrationGetValType.CONDITION) {
                    DataIntegrationQuery query = filters.get(range.getDimNumber());
                    if (query == null) continue;
                    queryList.add(query);
                    continue;
                }
                List<DataIntegrationMemberPojo> memberPojos = range.getRangeMembers().stream().map(member -> new DataIntegrationMemberPojo(member.getNumber(), member.getRange())).collect(Collectors.toList());
                DataIntegrationQuery query = new DataIntegrationQuery();
                query.setDimNumber(range.getDimNumber());
                query.setDataIntegrationMemberPojoList(memberPojos);
                queryList.add(query);
            }
            result = EASDataIntegrationUtil.parserRange2Show(queryList, modelCacheHelper, isOut, filterPerm, bizModelId);
        }
        return result;
    }

    public void setExecuteCondition(ExecuteCondition executeCondition) {
        this.executeCondition = executeCondition;
    }

    public ExecuteCondition getExecuteCondition() {
        return this.executeCondition;
    }

    public static void addExecConditionToCache(ExecuteCondition executeCondition, Long actionId) {
        String str = GZIPUtils.zipAndBase64((String)SerializationUtils.toJsonString((Object)executeCondition));
        DistributeSessionlessCacheUtils.put((String)("DATA_INTEGRATION_QUERY_LIST" + actionId), (Object)str);
    }

    public static ExecuteCondition getExecConditionFromCache(Long actionId) {
        String str = DistributeSessionlessCacheUtils.get((String)("DATA_INTEGRATION_QUERY_LIST" + actionId));
        str = GZIPUtils.unZipAndBase64((String)str);
        return (ExecuteCondition)SerializationUtils.fromJsonString((String)str, ExecuteCondition.class);
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public Long getActionId() {
        return this.getExecuteCondition().getActionId();
    }

    protected Map<Long, Long> getLogIdMap() {
        return this.logIdMap;
    }

    public IModelCacheHelper getModelCacheHelper() {
        if (this.modelCacheHelper == null) {
            this.modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.executeCondition.getModelId());
        }
        return this.modelCacheHelper;
    }
}

