/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.dataintegration.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.epm.eb.business.dataintegration.entity.AbstractDataIntegration;
import kd.epm.eb.business.dataintegration.entity.BcmDataIntegration;
import kd.epm.eb.business.dataintegration.entity.DataIntegrationDimMap;
import kd.epm.eb.business.dataintegration.entity.DataIntegrationMetricMap;
import kd.epm.eb.business.dataintegration.entity.GLDataIntegration;
import kd.epm.eb.business.dataintegration.entity.IntegrationDimMapGroup;
import kd.epm.eb.business.dataintegration.entity.IntegrationRange;
import kd.epm.eb.common.dataintegration.DataIntegrationType;
import kd.epm.eb.common.dataintegration.IntegrationSchemeType;

public class DataIntegration
extends AbstractDataIntegration {
    private String srcMetricType;
    private String srcSingleMetric;
    private Long taskId;
    private Long sourceObjId;
    private Long targetObjId;
    private Long targetSysId;
    private Long sourceSysId;
    private String tableName;
    private Long triggerId;
    private List<DataIntegrationMetricMap> metMapList;

    public static AbstractDataIntegration of(DynamicObject dy) {
        String schemeType = dy.getString("schemetype");
        AbstractDataIntegration dataset = schemeType.equals("3") ? new BcmDataIntegration() : (schemeType.equals("2") ? new GLDataIntegration() : new DataIntegration());
        dataset.setObject(dy);
        dataset.setId(dy.getLong("id"));
        dataset.setNumber(dy.getString("number"));
        dataset.setName(dy.getString("name"));
        dataset.setIntegrationType(DataIntegrationType.getTypeByVal((String)dy.getString("type")));
        dataset.setStatus(dy.getBoolean("status"));
        dataset.setDatasetid(dy.getLong("datasetid.id"));
        dataset.setModelid(dy.getLong("modelid.id"));
        ArrayList<DataIntegrationDimMap> memberMaps = new ArrayList<DataIntegrationDimMap>(9);
        dataset.setDimMapGroups(Collections.singletonList(new IntegrationDimMapGroup(null, 2, null, memberMaps)));
        ArrayList<IntegrationRange> integrationRanges = new ArrayList<IntegrationRange>(9);
        dataset.setIntegrationRanges(integrationRanges);
        return dataset;
    }

    public static List<AbstractDataIntegration> of(DynamicObject[] list) {
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<AbstractDataIntegration> objs = new ArrayList<AbstractDataIntegration>(list.length);
        for (DynamicObject dy : list) {
            AbstractDataIntegration obj = DataIntegration.of(dy);
            objs.add(obj);
        }
        return objs;
    }

    public static List<AbstractDataIntegration> of(DynamicObjectCollection list) {
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<AbstractDataIntegration> objs = new ArrayList<AbstractDataIntegration>(list.size());
        for (DynamicObject dy : list) {
            AbstractDataIntegration obj = DataIntegration.of(dy);
            objs.add(obj);
        }
        return objs;
    }

    @Override
    public IntegrationSchemeType getScheme() {
        return IntegrationSchemeType.CUSTOM;
    }

    public String getSrcmetrictype() {
        return this.srcMetricType;
    }

    public void setSrcmetrictype(String srcmetrictype) {
        this.srcMetricType = srcmetrictype;
    }

    public String getSrcsinglemetric() {
        return this.srcSingleMetric;
    }

    public void setSrcsinglemetric(String srcsinglemetric) {
        this.srcSingleMetric = srcsinglemetric;
    }

    public Long getTaskid() {
        return this.taskId;
    }

    public void setTaskid(Long taskid) {
        this.taskId = taskid;
    }

    public Long getSourceobjId() {
        return this.sourceObjId;
    }

    public void setSourceobjId(Long sourceobjId) {
        this.sourceObjId = sourceobjId;
    }

    public Long getTargetobjId() {
        return this.targetObjId;
    }

    public void setTargetobjId(Long targetobjId) {
        this.targetObjId = targetobjId;
    }

    public Long getSourcesysId() {
        return this.sourceSysId;
    }

    public void setSourcesysId(Long sourcesysId) {
        this.sourceSysId = sourcesysId;
    }

    public Long getTargetsysId() {
        return this.targetSysId;
    }

    public void setTargetsysId(Long targetsysId) {
        this.targetSysId = targetsysId;
    }

    public List<DataIntegrationMetricMap> getMetMapList() {
        if (this.metMapList == null) {
            this.metMapList = new ArrayList<DataIntegrationMetricMap>(10);
        }
        return this.metMapList;
    }

    public void setMetMapList(List<DataIntegrationMetricMap> metMapList) {
        this.metMapList = metMapList;
    }

    public void addMetMapList(DataIntegrationMetricMap metricMap) {
        this.getMetMapList().add(metricMap);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public Long getTriggerid() {
        return this.triggerId;
    }

    public void setTriggerid(Long triggerId) {
        this.triggerId = triggerId;
    }
}

