/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.dataintegration.entity;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.epm.eb.business.dataintegration.entity.syssetting.EasSysSetting;
import kd.epm.eb.business.dataintegration.entity.syssetting.SysSettingInfo;
import kd.epm.eb.business.easupgrade.utils.EASDataIntegrationUtil;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.dataintegration.DataIntegrationType;
import kd.epm.eb.common.dataintegration.IntegrationSchemeType;
import kd.epm.eb.common.utils.StringUtils;

public class MemberMapPPO {
    private boolean checkSourceField;
    private String refField;
    private Map<String, Map<String, Pair<String, String>>> alMemberMap;
    private Map<String, Set<String>> targetValSet = new HashMap<String, Set<String>>();

    public String getRefField() {
        return this.refField;
    }

    public void setRefField(String refField) {
        this.refField = refField;
    }

    public Map<String, Map<String, Pair<String, String>>> getAlMemberMap() {
        if (this.alMemberMap == null) {
            this.alMemberMap = new HashMap<String, Map<String, Pair<String, String>>>(16);
        }
        return this.alMemberMap;
    }

    public void setAlMemberMap(Map<String, Map<String, Pair<String, String>>> alMemberMap) {
        this.alMemberMap = alMemberMap;
    }

    public String getMemberMapVal(String sourceVal, boolean useName) {
        Pair<String, String> targetInfo = this.getMemberMap().get(sourceVal);
        if (targetInfo == null) {
            return null;
        }
        return useName ? (String)targetInfo.p2 : (String)targetInfo.p1;
    }

    public Map<String, Pair<String, String>> getMemberMap() {
        return this.getMemberMapBySField("");
    }

    public Map<String, Pair<String, String>> getMemberMapBySField(String field) {
        Map<String, Pair<String, String>> row = this.getAlMemberMap().get(field);
        if (row == null) {
            row = new HashMap<String, Pair<String, String>>(16);
        }
        return row;
    }

    public boolean isCheckSourceField() {
        return this.checkSourceField;
    }

    public void setCheckSourceField(boolean checkSourceField) {
        this.checkSourceField = checkSourceField;
    }

    public Set<String> getTargetVal(String sourceField) {
        Set<String> targetVals;
        if (!this.isCheckSourceField()) {
            sourceField = "";
        }
        if ((targetVals = this.targetValSet.get(sourceField)) == null) {
            targetVals = new HashSet<String>(16);
            Map<String, Pair<String, String>> memberMap = this.getAlMemberMap().get(sourceField);
            if (memberMap != null) {
                for (Map.Entry<String, Pair<String, String>> entry : memberMap.entrySet()) {
                    targetVals.add((String)entry.getValue().p1);
                }
            }
            this.targetValSet.put(sourceField, targetVals);
        }
        return targetVals;
    }

    public static MemberMapPPO of(DynamicObject obj) {
        MemberMapPPO po = new MemberMapPPO();
        if (obj != null) {
            EasSysSetting easSysSetting;
            IntegrationSchemeType scheme = IntegrationSchemeType.getTypeByVal((String)obj.getString("schemetype"));
            DataIntegrationType type = DataIntegrationType.getTypeByVal((String)obj.getString("type"));
            SysSettingInfo sourceSetting = EASDataIntegrationUtil.desSysSetting(obj.getString("sourcesysinfo"), DataIntegrationType.INPUT == type ? scheme : IntegrationSchemeType.EB);
            if (sourceSetting instanceof EasSysSetting && ((easSysSetting = (EasSysSetting)sourceSetting).isUseMulBizField() || StringUtils.isNotEmpty((String)((EasSysSetting)sourceSetting).getBizField()))) {
                po.setCheckSourceField(true);
            }
            po.setRefField(sourceSetting.findRefFieldVal());
            po.setAlMemberMap(EASDataIntegrationUtil.parserMemberMap(obj, type, scheme, sourceSetting));
        }
        return po;
    }
}

