/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.dataintegration.executor;

import java.util.HashSet;
import java.util.Set;
import kd.epm.eb.business.analyzeReport.context.ConditionContext;
import kd.epm.eb.business.analyzeReport.execute.ConditionExecutor;
import kd.epm.eb.business.dataintegration.entity.context.ConditionExecContext;
import kd.epm.eb.business.easupgrade.utils.EASDataIntegrationUtil;
import kd.epm.eb.common.analysereport.pojo.condition.ConditionResult;

public abstract class DimMapConditionExecutor
extends ConditionExecutor {
    private String fieldKey;
    private Set<String> fieldNumberSet;
    private boolean rollback;

    public DimMapConditionExecutor(String fieldKey, Set<String> fieldNumberSet) {
        if (fieldNumberSet == null) {
            fieldNumberSet = new HashSet<String>(1);
        }
        this.fieldKey = fieldKey;
        this.fieldNumberSet = fieldNumberSet;
    }

    private boolean checkVal(ConditionExecContext context) {
        boolean result = false;
        if (this.fieldKey != null) {
            String fieldVal = EASDataIntegrationUtil.getGlValOnRow(context.getRowData(), this.fieldKey, context.getFieldKeyMap());
            result = this.checkVal(fieldVal);
            if (this.rollback) {
                result = !result;
            }
        }
        return result;
    }

    protected abstract boolean checkVal(String var1);

    public String getFieldKey() {
        return this.fieldKey;
    }

    public void setFieldKey(String fieldKey) {
        this.fieldKey = fieldKey;
    }

    public Set<String> getFieldNumberSet() {
        return this.fieldNumberSet;
    }

    public void setFieldNumberSet(Set<String> fieldNumberSet) {
        this.fieldNumberSet = fieldNumberSet;
    }

    @Override
    public ConditionResult getResult(ConditionContext context) {
        ConditionResult result = new ConditionResult();
        if (context instanceof ConditionExecContext) {
            ConditionExecContext execContext = (ConditionExecContext)context;
            result.setSucceed(this.checkVal(execContext));
        }
        return result;
    }

    public boolean isRollback() {
        return this.rollback;
    }

    public void setRollback(boolean rollback) {
        this.rollback = rollback;
    }

    @Override
    public String toString() {
        return this.getSign() + ":{key:" + this.fieldKey + ",numSet:" + this.fieldNumberSet + ",rb:" + this.rollback + "}";
    }
}

