/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.dataintegration.service;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.dataintegration.CallBackDataIntegrationStart;
import kd.epm.eb.business.dataintegration.entity.DataIntegration;
import kd.epm.eb.business.dataintegration.entity.DataIntegrationMetricMap;
import kd.epm.eb.business.dataintegration.entity.DataIntegrationMetricType;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.DataTypeEnum;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.impl.base.KDValue;
import kd.epm.eb.olap.impl.metadata.KDCell;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

public class DataIntegrationDataService {
    private static final Log log = LogFactory.getLog(DataIntegrationDataService.class);
    private static final String[] FORMATS = new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM", "yyyy-MM-dd'T'HH:mm:ss.SSS Z"};
    Map<Long, Map<String, String>> metricEnumMap = new HashMap<Long, Map<String, String>>(16);

    public static DataIntegrationDataService getInstance() {
        return InnerClass.instance;
    }

    private DataIntegrationDataService() {
    }

    public void handleInputData(Map<String, Object> callbackMap) {
        log.info("\u96c6\u6210\u4efb\u52a1\u6210\u529f\u56de\u8c03\uff1a" + JSON.toJSONString(callbackMap));
        CallBackDataIntegrationStart.getInstance(callbackMap).run(false);
    }

    public Long getDataIntegrationId(Long triggerId) {
        if (triggerId == null || triggerId == 0L) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u542f\u52a8\u65b9\u6848\u4e3a\u7a7a\uff0c\u4e0d\u5904\u7406\u8f6c\u6362:%1", (String)"DataIntegrationDataService_2", (String)"epm-eb-business", (Object[])new Object[]{triggerId}));
        }
        QFBuilder qbDi = new QFBuilder();
        qbDi.add(new QFilter("triggerid", "=", (Object)triggerId));
        qbDi.add(new QFilter("status", "=", (Object)"1"));
        DynamicObject diCol = QueryServiceHelper.queryOne((String)"eb_integration", (String)"id", (QFilter[])qbDi.toArrays());
        if (diCol == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u5339\u914d\u4e0d\u5230\u5bf9\u5e94\u7684\u9884\u7b97\u7cfb\u7edf\u96c6\u6210\u6620\u5c04\u65b9\u6848 %1", (String)"DataIntegrationDataService_3", (String)"epm-eb-business", (Object[])new Object[]{triggerId}));
        }
        return diCol.getLong("id");
    }

    private String getFieldValue(Map<String, String> row, String fieldStr) {
        String[] fieldArr;
        for (String field : fieldArr = StringUtils.split((String)fieldStr, (String)",")) {
            field = "f" + field;
            String value = row.get(field);
            if (StringUtils.isBlank((CharSequence)value)) {
                value = row.get(field.toLowerCase());
                String string = value = StringUtils.isNotBlank((CharSequence)value) ? value : row.get(field.toUpperCase());
            }
            if (StringUtils.isBlank((CharSequence)value)) continue;
            return value;
        }
        return "";
    }

    public List<IKDCell> metricMapper(DataIntegration di, int metricPos, Map<String, String> row, String[] members, Dimension metricDim) {
        List<DataIntegrationMetricMap> metMapList = di.getMetMapList();
        ArrayList<IKDCell> cells = new ArrayList<IKDCell>(10);
        if (DataIntegrationMetricType.SINGLE.getCode().equals(di.getSrcmetrictype())) {
            String valueField = di.getSrcsinglemetric();
            String value = this.getFieldValue(row, valueField);
            this.metricSingleMapper(cells, value, members, metricPos, metricDim);
        } else {
            List<IKDCell> metricCells = this.mutipleMetricConvert(metMapList, metricPos, metricDim, row, members);
            cells.addAll(metricCells);
        }
        return cells;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void metricSingleMapper(List<IKDCell> cells, Object value, String[] members, int metricIndex, Dimension metricDim) {
        if (value == null) {
            throw new KDBizException(ResManager.loadKDString((String)"value\u503c\u4e3a\u7a7a", (String)"DataIntegrationDataService_10", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        IKDCell cell = KDCell.of((String[])members);
        Member metricMember = metricDim.getMember(null, members[metricIndex]);
        DataTypeEnum typeEnum = DataTypeEnum.getDataTypeEnumByIndex((String)metricMember.getDatatype());
        if (DataTypeEnum.DATETP == typeEnum) {
            try {
                Date date;
                if (value instanceof Date) {
                    date = (Date)value;
                } else {
                    String dataStr = value.toString();
                    if (dataStr.endsWith("Z")) {
                        dataStr = dataStr.replace("Z", " UTC");
                    }
                    date = DateUtils.parseDate((String)dataStr, (String[])FORMATS);
                }
                cell.setValue(KDValue.valueOf((String)ConvertUtils.convertToOADate((Date)date)));
            }
            catch (ParseException e) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u65e5\u671f\u8f6c\u6362\u51fa\u9519\uff1a%1\u3002", (String)"DataIntegrationDataService_9", (String)"epm-eb-business", (Object[])new Object[]{value}));
            }
        }
        if (DataTypeEnum.TXT == typeEnum) {
            cell.setValue(KDValue.valueOf((String)value.toString()));
        } else if (DataTypeEnum.ENUMTP == typeEnum) {
            String strVal;
            String enumname;
            Long metricMemberId = metricMember.getId();
            Map<String, String> enumMap = this.metricEnumMap.get(metricMemberId);
            if (enumMap == null) {
                DynamicObject metricObj = BusinessDataServiceHelper.loadSingleFromCache((Object)metricMemberId, (String)"epm_metricmembertree");
                DynamicObjectCollection enumentryentity = metricObj.getDynamicObjectCollection("enumentryentity");
                enumMap = enumentryentity.stream().collect(Collectors.toMap(o -> o.getString("enumnumber"), o -> o.getString("enumname")));
                this.metricEnumMap.put(metricMemberId, enumMap);
            }
            if ((enumname = enumMap.get(strVal = value.toString())) != null) {
                cell.setValue(KDValue.valueOf((String)enumMap.get(strVal)));
            } else {
                if (!enumMap.containsValue(strVal)) throw new KDBizException(ResManager.loadResFormat((String)"%1\u4e0d\u5728\u5ea6\u91cf\u679a\u4e3e\u8303\u56f4\u5185", (String)"DataIntegrationDataService_11", (String)"epm-eb-business", (Object[])new Object[]{strVal}));
                cell.setValue(KDValue.valueOf((String)strVal));
            }
        } else {
            try {
                BigDecimal decimal = value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal(value.toString());
                cell.setValue(KDValue.valueOf((BigDecimal)decimal));
            }
            catch (NumberFormatException e) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u6570\u503c\u8f6c\u6362\u51fa\u9519\uff1a%1\u3002", (String)"DataIntegrationDataService_8", (String)"epm-eb-business", (Object[])new Object[]{value}));
            }
        }
        cells.add(cell);
    }

    private List<IKDCell> mutipleMetricConvert(List<DataIntegrationMetricMap> metMapList, int metricPos, Dimension metricDim, Map<String, String> row, String[] members) {
        ArrayList<IKDCell> metricCells = new ArrayList<IKDCell>(metMapList.size());
        for (DataIntegrationMetricMap metricMap : metMapList) {
            String[] mems = (String[])ArrayUtils.clone((Object[])members);
            mems[metricPos] = metricMap.getMetrictarget();
            String valueField = metricMap.getMetricsource();
            String value = this.getFieldValue(row, valueField);
            this.metricSingleMapper(metricCells, value, mems, metricPos, metricDim);
        }
        return metricCells;
    }

    private static class InnerClass {
        private static DataIntegrationDataService instance = new DataIntegrationDataService();

        private InnerClass() {
        }
    }
}

