/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.dataintegration.service;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.dataintegration.entity.DataIntegrationExeScheme;
import kd.epm.eb.common.dataintegration.DataIntegrationType;
import kd.epm.eb.common.dataintegration.ExecuteSchemeNodeType;
import kd.epm.eb.common.utils.CollectionUtils;

public class DataIntegrationExeSchemeService {
    public static DataIntegrationExeSchemeService getInstance() {
        return InnerClass.instance;
    }

    private DataIntegrationExeSchemeService() {
    }

    public void saveExecuteSchemes(List<DataIntegrationExeScheme> exeSchemes) {
        if (CollectionUtils.isEmpty(exeSchemes)) {
            return;
        }
        ArrayList<DynamicObject> bizModelDefaultSchemes = new ArrayList<DynamicObject>(exeSchemes.size());
        for (DataIntegrationExeScheme exeScheme : exeSchemes) {
            DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"eb_integraexecutescheme");
            object.set("id", (Object)exeScheme.getId());
            object.set("number", (Object)exeScheme.getNumber());
            object.set("name", (Object)new LocaleString(exeScheme.getName()));
            object.set("type", (Object)exeScheme.getType().getVal());
            object.set("nodetype", (Object)exeScheme.getNodeType().getVal());
            object.set("parent", (Object)exeScheme.getParentId());
            object.set("bizmodel", (Object)exeScheme.getBizModelId());
            object.set("model", (Object)exeScheme.getModelId());
            bizModelDefaultSchemes.add(object);
        }
        SaveServiceHelper.save((DynamicObject[])bizModelDefaultSchemes.toArray(new DynamicObject[0]));
    }

    public List<DataIntegrationExeScheme> getExeScheme(Long modelId, DataIntegrationType type) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("type", "=", (Object)type.getVal());
        return this.getExeScheme(qFilter);
    }

    public List<DataIntegrationExeScheme> getExeScheme(Long modelId, DataIntegrationType type, ExecuteSchemeNodeType nodeType) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("type", "=", (Object)type.getVal());
        qFilter.and("nodetype", "=", (Object)nodeType.getVal());
        return this.getExeScheme(qFilter);
    }

    public DataIntegrationExeScheme getExeScheme(Long id) {
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        List<DataIntegrationExeScheme> exeSchemes = this.getExeScheme(qFilter);
        if (CollectionUtils.isEmpty(exeSchemes)) {
            return null;
        }
        return exeSchemes.get(0);
    }

    public List<DataIntegrationExeScheme> getExeScheme(QFilter qFilter) {
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"eb_integraexecutescheme", (String)"id,name,number,nodetype,parent,bizmodel,type,model", (QFilter[])qFilter.toArray(), (String)"createdate");
        if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            return new ArrayList<DataIntegrationExeScheme>(0);
        }
        ArrayList<DataIntegrationExeScheme> exeSchemes = new ArrayList<DataIntegrationExeScheme>(dynamicObjects.size());
        for (DynamicObject dynamicObject : dynamicObjects) {
            exeSchemes.add(this.translateObject(dynamicObject));
        }
        return exeSchemes;
    }

    public boolean existExecuteScheme(Long modelId, DataIntegrationType type, String numberOrName, boolean isName, Long selfId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId).and("type", "=", (Object)type.getVal());
        qFilter.and(isName ? "name" : "number", "=", (Object)numberOrName);
        qFilter.and("id", "!=", (Object)selfId);
        return QueryServiceHelper.exists((String)"eb_integraexecutescheme", (QFilter[])qFilter.toArray());
    }

    public Set<Long> getCurExecuteSchemeCatLogAll(Long modelId, DataIntegrationType type, Long executeSchemeId) {
        List<DataIntegrationExeScheme> exeSchemes = this.getExeScheme(modelId, type);
        HashMap<Long, Set> parentToChildMap = new HashMap<Long, Set>(16);
        for (DataIntegrationExeScheme exeScheme : exeSchemes) {
            Set childIds = parentToChildMap.computeIfAbsent(exeScheme.getParentId(), e -> new HashSet(16));
            childIds.add(exeScheme.getId());
        }
        HashSet<Long> allIds = new HashSet<Long>(16);
        allIds.add(executeSchemeId);
        ArrayDeque<Long> stack = new ArrayDeque<Long>(16);
        stack.push(executeSchemeId);
        while (!stack.isEmpty()) {
            Long currentId = (Long)stack.pop();
            Set ids = (Set)parentToChildMap.get(currentId);
            if (!CollectionUtils.isNotEmpty((Collection)ids)) continue;
            allIds.addAll(ids);
            for (Long id : ids) {
                stack.push(id);
            }
        }
        return allIds;
    }

    public Long getCurBizModelDefaultFirstLeafExecuteScheme(Long bizModelId, DataIntegrationType dataIntegrationType) {
        QFilter qFilter = new QFilter("bizmodel", "=", (Object)bizModelId);
        qFilter.and("type", "=", (Object)dataIntegrationType.getVal());
        List<DataIntegrationExeScheme> exeSchemes = this.getExeScheme(qFilter);
        if (CollectionUtils.isEmpty(exeSchemes)) {
            return 0L;
        }
        HashMap<Long, List> parentToChildMap = new HashMap<Long, List>(16);
        for (DataIntegrationExeScheme exeScheme : exeSchemes) {
            List childIds = parentToChildMap.computeIfAbsent(exeScheme.getParentId(), e -> new ArrayList(10));
            childIds.add(exeScheme.getId());
        }
        Optional<DataIntegrationExeScheme> first = exeSchemes.stream().filter(e -> ExecuteSchemeNodeType.DEFAULT == e.getNodeType()).findFirst();
        if (first.isPresent()) {
            Long firstLeafId = exeSchemes.get(0).getId();
            while (parentToChildMap.get(firstLeafId) != null) {
                firstLeafId = (Long)((List)parentToChildMap.get(firstLeafId)).get(0);
            }
            return firstLeafId;
        }
        return 0L;
    }

    private DataIntegrationExeScheme translateObject(DynamicObject dynamicObject) {
        Long id = dynamicObject.getLong("id");
        String number = dynamicObject.getString("number");
        String name = dynamicObject.getString("name");
        ExecuteSchemeNodeType nodeType = ExecuteSchemeNodeType.getTypeByVal((String)dynamicObject.getString("nodetype"));
        Long parent = dynamicObject.getLong("parent");
        Long bizModel = dynamicObject.getLong("bizmodel");
        Long modelId = dynamicObject.getLong("model");
        DataIntegrationType type = DataIntegrationType.getTypeByVal((String)dynamicObject.getString("type"));
        return new DataIntegrationExeScheme(id, number, name, type, nodeType, parent, modelId, bizModel);
    }

    private static class InnerClass {
        private static final DataIntegrationExeSchemeService instance = new DataIntegrationExeSchemeService();

        private InnerClass() {
        }
    }
}

