/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.dataintegration.service;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.bailorg.entity.SimpleObject;
import kd.epm.eb.business.dataintegration.entity.BcmDataIntegration;
import kd.epm.eb.business.dataintegration.entity.BcmDataQParam;
import kd.epm.eb.business.dataintegration.entity.DataIntegration;
import kd.epm.eb.business.dataintegration.entity.DataIntegrationDimMap;
import kd.epm.eb.business.dataintegration.entity.GLDataIntegration;
import kd.epm.eb.business.dataintegration.entity.GlBizFieldType;
import kd.epm.eb.business.dataintegration.entity.IntegrationDimMapGroup;
import kd.epm.eb.business.dataintegration.entity.MembMapParam;
import kd.epm.eb.business.dataintegration.entity.MemberMapPPO;
import kd.epm.eb.business.easupgrade.utils.EASDataIntegrationUtil;
import kd.epm.eb.business.easupgrade.utils.EASUpgradeUtils;
import kd.epm.eb.business.servicehelper.DimensionServiceHelper;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dataintegration.DataIntegrationGetDataType;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogSignHelper;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class DataIntegrationInService {
    private static final Log log = LogFactory.getLog(DataIntegrationInService.class);

    public static DataIntegrationInService getInstance() {
        return InnerClass.instance;
    }

    private DataIntegrationInService() {
    }

    public void syncData(DataIntegration integration, Map<String, List<Member>> paramMap) {
        Map resMap;
        long triggerid;
        DynamicObject tr;
        DynamicObject diDy = integration.getObject();
        Map<Long, MemberMapPPO> memberMapPPOMap = EASDataIntegrationUtil.loadRefMemberMap(integration);
        Map<String, List<String>> filterParamMap = this.getCusFilterParamMap(integration, paramMap, memberMapPPOMap);
        Long easdbid = diDy.getLong("easdb_id");
        if (IDUtils.isNotNull((Long)easdbid)) {
            String dataCenter = EASUpgradeUtils.getDataCenter(easdbid);
            if (!StringUtils.equals((CharSequence)dataCenter, (CharSequence)diDy.getString("easdatacenter"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u4e2d\u5fc3\u914d\u7f6e\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u68c0\u67e5\u96c6\u6210\u4e91\u8fde\u63a5\u914d\u7f6e\u3002", (String)"DataIntegrationInService_3", (String)"epm-eb-business", (Object[])new Object[0]));
            }
            EASDataIntegrationUtil.convertFilterParamMap(filterParamMap, easdbid);
        }
        if ((tr = BusinessDataServiceHelper.loadSingle((Object)(triggerid = diDy.getLong("triggerid.id")), (String)"isc_data_copy_trigger")) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u96c6\u6210\u4e91\u542f\u52a8\u65b9\u6848\u5df2\u5220\u9664\u3002", (String)"DataIntegrationInService_1", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        String tableName = diDy.getString("tablename");
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)("truncate table " + tableName));
        log.info("\u6e05\u7a7a\u4e34\u65f6\u8868:" + tableName);
        long dataCopyId = tr.getLong("data_copy.id");
        DynamicObject dataCopy = BusinessDataServiceHelper.loadSingle((Object)dataCopyId, (String)"isc_data_copy");
        DynamicObject dataCopyBak = BusinessDataServiceHelper.loadSingle((Object)tr.getLong("data_copy.id"), (String)"isc_data_copy");
        MainEntityType mainEntity = (MainEntityType)dataCopy.getDataEntityType();
        DynamicObjectCollection params = dataCopy.getDynamicObjectCollection("param_entries");
        DynamicObjectCollection filters = dataCopy.getDynamicObjectCollection("filter_entries");
        DynamicObjectCollection paramsBak = dataCopyBak.getDynamicObjectCollection("param_entries");
        DynamicObjectCollection filtersBak = dataCopyBak.getDynamicObjectCollection("filter_entries");
        params.clear();
        filters.clear();
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataCopy});
        OperationServiceHelper.executeOperate((String)"save", (String)"isc_data_copy", (DynamicObject[])new DynamicObject[]{dataCopy}, (OperateOption)OperateOption.create());
        HashMap filterMap = Maps.newHashMapWithExpectedSize((int)20);
        EntityType paramType = (EntityType)mainEntity.getAllEntities().get("param_entries");
        EntityType filterType = (EntityType)mainEntity.getAllEntities().get("filter_entries");
        for (Map.Entry<String, List<String>> entry : filterParamMap.entrySet()) {
            if (entry.getValue().contains("")) continue;
            String varName = "var_" + entry.getKey();
            DynamicObject param = new DynamicObject((DynamicObjectType)paramType);
            param.set("params_name", (Object)varName);
            param.set("params_data_type", (Object)"string");
            params.add((Object)param);
            DynamicObject filter = new DynamicObject((DynamicObjectType)filterType);
            filter.set("filter_column", (Object)entry.getKey());
            filter.set("filter_compare", (Object)"in");
            filter.set("filter_value_var", (Object)varName);
            filters.add((Object)filter);
            String valStr = entry.getValue().stream().map(e -> "\"" + e + "\"").collect(Collectors.joining(","));
            filterMap.put(varName, "[" + valStr + "]");
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataCopy});
        dataCopy = BusinessDataServiceHelper.loadSingle((Object)tr.getLong("data_copy.id"), (String)"isc_data_copy");
        log.info("syncExecute_filterMap:" + JSON.toJSONString((Object)filterMap));
        String trNumber = tr.getString("number");
        try {
            resMap = (Map)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"ISCDataCopyService", (String)"syncExecute", (Object[])new Object[]{trNumber, filterMap});
            log.info("\u6267\u884c\u542f\u52a8\u65b9\u6848\u8fd4\u56de\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)resMap));
        }
        catch (Exception e2) {
            try {
                throw e2;
            }
            catch (Throwable throwable) {
                DynamicObjectCollection param_entries = dataCopy.getDynamicObjectCollection("param_entries");
                for (DynamicObject doj : paramsBak) {
                    DataEntityPropertyCollection properties = doj.getDataEntityType().getProperties();
                    DynamicObject dynamicObject = param_entries.addNew();
                    for (IDataEntityProperty prop : properties) {
                        dynamicObject.set(prop, doj.get(prop));
                    }
                }
                DynamicObjectCollection filter_entries = dataCopy.getDynamicObjectCollection("filter_entries");
                for (DynamicObject doj : filtersBak) {
                    DataEntityPropertyCollection properties = doj.getDataEntityType().getProperties();
                    DynamicObject dynamicObject = filter_entries.addNew();
                    for (IDataEntityProperty prop : properties) {
                        dynamicObject.set(prop, doj.get(prop));
                    }
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataCopy});
                throw throwable;
            }
        }
        DynamicObjectCollection param_entries = dataCopy.getDynamicObjectCollection("param_entries");
        for (Object doj : paramsBak) {
            DataEntityPropertyCollection properties = doj.getDataEntityType().getProperties();
            DynamicObject dynamicObject = param_entries.addNew();
            for (IDataEntityProperty prop : properties) {
                dynamicObject.set(prop, doj.get(prop));
            }
        }
        DynamicObjectCollection filter_entries = dataCopy.getDynamicObjectCollection("filter_entries");
        for (DynamicObject doj : filtersBak) {
            DataEntityPropertyCollection properties = doj.getDataEntityType().getProperties();
            DynamicObject dynamicObject = filter_entries.addNew();
            for (IDataEntityProperty prop : properties) {
                dynamicObject.set(prop, doj.get(prop));
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataCopy});
        Boolean success = MapUtils.getBoolean((Map)resMap, (Object)"success");
        if (success == null || !success.booleanValue()) {
            int _index;
            String errorMsg = MapUtils.getString((Map)resMap, (Object)"msg");
            if (errorMsg != null && (_index = errorMsg.indexOf("http")) >= 0) {
                errorMsg = errorMsg.substring(0, _index);
            }
            log.error("\u6267\u884c\u91c7\u96c6\u65b9\u6848\u5931\u8d25:" + errorMsg);
            throw new KDBizException(ResManager.loadResFormat((String)"\u6267\u884c\u91c7\u96c6\u65b9\u6848\u5931\u8d25:%1", (String)"DataIntegrationInService_0", (String)"epm-eb-business", (Object[])new Object[]{errorMsg}));
        }
    }

    public void parserFilterByDimMap(Map<String, List<Member>> ebMemberFilter, List<DataIntegrationDimMap> dimMapList, Map<Long, MemberMapPPO> memberMapPPOMap, boolean checkSpecialPeriod, Consumer<MembMapParam> membMapConsumer) {
        Map<String, DataIntegrationDimMap> dimMapMap = dimMapList.stream().filter(map -> StringUtils.isNotEmpty((CharSequence)map.getDimtarget())).collect(Collectors.toMap(DataIntegrationDimMap::getDimtarget, m2 -> m2));
        dimMapMap.forEach((dimNumber, dimMap) -> {
            block8: {
                String fixSourceVal;
                String sourceField;
                List memberList;
                block11: {
                    block12: {
                        Map<String, Pair<String, String>> memberMap;
                        block10: {
                            block9: {
                                memberList = (List)ebMemberFilter.get(dimNumber);
                                if (memberList != null) break block9;
                                String fixSourceVal2 = dimMap.getSourceFixVal();
                                String sourceField2 = dimMap.getDimsource();
                                if (!StringUtils.isNotEmpty((CharSequence)fixSourceVal2) || !StringUtils.isNotEmpty((CharSequence)sourceField2)) break block8;
                                membMapConsumer.accept(new MembMapParam(sourceField2, fixSourceVal2, null, null));
                                break block8;
                            }
                            sourceField = dimMap.getDimsource();
                            if (!StringUtils.isNotEmpty((CharSequence)sourceField) || sourceField.contains(",")) break block8;
                            if (!memberList.isEmpty()) break block10;
                            membMapConsumer.accept(new MembMapParam(sourceField, true));
                            break block8;
                        }
                        fixSourceVal = dimMap.getSourceFixVal();
                        if (!StringUtils.isEmpty((CharSequence)fixSourceVal)) break block11;
                        MemberMapPPO memberMapPPO = (MemberMapPPO)memberMapPPOMap.get(dimMap.getDimmembmapid());
                        if (memberMapPPO == null) break block12;
                        String refField = memberMapPPO.getRefField();
                        Map<String, Pair<String, String>> map = memberMap = memberMapPPO.isCheckSourceField() ? memberMapPPO.getMemberMapBySField(sourceField) : memberMapPPO.getMemberMap();
                        if (memberMap.isEmpty()) break block8;
                        HashMap memberSourceMap = new HashMap(memberMap.size());
                        memberMap.forEach((sourceVal, targetVal) -> memberSourceMap.computeIfAbsent(targetVal.p1, key -> new LinkedList()).add(sourceVal));
                        for (Member member : memberList) {
                            List sourcesVal = (List)memberSourceMap.get(member.getNumber());
                            if (sourcesVal != null) {
                                sourcesVal.forEach(sourceVal -> {
                                    String refVal = null;
                                    if (refField != null) {
                                        String[] vals = sourceVal.split("\u3002.&.\u3002");
                                        sourceVal = vals[0];
                                        if (vals.length > 1) {
                                            refVal = vals[1];
                                        }
                                    }
                                    membMapConsumer.accept(new MembMapParam(sourceField, (String)sourceVal, refField, refVal));
                                });
                                continue;
                            }
                            membMapConsumer.accept(new MembMapParam(sourceField, member.getNumber(), null, null));
                        }
                        break block8;
                    }
                    if (checkSpecialPeriod && SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber)) {
                        for (Member member : memberList) {
                            Pair<String, String> period2YP = DimensionServiceHelper.parserPeriod2YP(member.getNumber());
                            if (period2YP == null) continue;
                            membMapConsumer.accept(new MembMapParam(sourceField, (String)period2YP.p1, sourceField, (String)period2YP.p2, true));
                        }
                    } else {
                        for (Member member : memberList) {
                            membMapConsumer.accept(new MembMapParam(sourceField, member.getNumber(), null, null));
                        }
                    }
                    break block8;
                }
                String fixTargetVal = dimMap.getDimmembnum();
                if (fixTargetVal != null) {
                    for (Member member : memberList) {
                        if (!member.getNumber().equals(fixTargetVal)) continue;
                        membMapConsumer.accept(new MembMapParam(sourceField, fixSourceVal, null, null));
                        break;
                    }
                }
            }
        });
    }

    public Map<String, List<Long>> getGlFilterParamMap(GLDataIntegration dataIntegration, Map<String, List<Member>> ebMemberFilter, Map<Long, MemberMapPPO> memberMapPPOMap, Map<String, String> accountOrgMap) {
        List<IntegrationDimMapGroup> dimMapList = dataIntegration.getDimMapGroups();
        HashMap<String, Set> result_number = new HashMap<String, Set>(16);
        HashMap<String, List<Long>> result_id = new HashMap<String, List<Long>>(16);
        HashSet specialPeriodNums = new HashSet(16);
        DataIntegrationGetDataType getDataType = dataIntegration.getGetDataType();
        dimMapList.forEach(group -> this.parserFilterByDimMap(ebMemberFilter, group.getMemberMaps(), memberMapPPOMap, true, param -> {
            if (param.isEmptyFilter()) {
                result_number.put(param.getSourceField(), new HashSet(16));
            } else if (param.isSpecialPeriod()) {
                String yearNum = param.getSourceVal();
                String periodNum = param.getRefVal();
                String glPeriodNum = yearNum + periodNum;
                specialPeriodNums.add(glPeriodNum);
                result_number.computeIfAbsent(param.getSourceField(), key -> new HashSet(16)).add(glPeriodNum);
            } else {
                result_number.computeIfAbsent(param.getSourceField(), key -> new HashSet(16)).add(param.getSourceVal());
            }
        }));
        if (result_number.size() > 0) {
            Set getGlFilterParamMap = LogSignHelper.getLogSignByGropNum((String)"getGlFilterParamMap");
            result_number.forEach((key, nums) -> {
                if (getGlFilterParamMap.contains(key)) {
                    CommonServiceHelper.handleLog((Log)log, (String)("GlParamSNumb-" + key), (String)SerializationUtils.toJsonString((Object)nums));
                }
                if (nums.size() > 0) {
                    GlBizFieldType fieldType = GlBizFieldType.getTypeByNumber(key);
                    Long glObj = null;
                    Long costView = null;
                    if (fieldType == GlBizFieldType.ORG) {
                        glObj = dataIntegration.getCalculateModel();
                        costView = dataIntegration.getCalculateView();
                    } else {
                        if (fieldType == GlBizFieldType.ACCOUNT) {
                            int splitIndex = 0;
                            for (String number2 : nums) {
                                if (number2 == null || (splitIndex = number2.lastIndexOf(",")) <= 0) continue;
                                accountOrgMap.put(number2, number2.substring(0, splitIndex));
                            }
                            return;
                        }
                        if (fieldType == GlBizFieldType.PERIOD) {
                            glObj = dataIntegration.getCalculatePeriodType();
                        } else {
                            return;
                        }
                    }
                    Map<Long, String> idNumberMap = EASDataIntegrationUtil.queryGlDataIdNumberMap(fieldType, glObj, costView, true);
                    boolean isPeriod = fieldType == GlBizFieldType.PERIOD;
                    boolean checkTPeriod = specialPeriodNums.size() > 0 && isPeriod;
                    HashSet removeNumbers = new HashSet(16);
                    HashMap maxAdjustPeriod = new HashMap(16);
                    idNumberMap.forEach((id, number) -> {
                        if (nums.contains(number)) {
                            result_id.computeIfAbsent((String)key, k -> new LinkedList()).add(id);
                        } else if (checkTPeriod && number.endsWith("T") && !getDataType.onlyCurrentPeriod()) {
                            String periodNumStr;
                            String yearNumber = null;
                            number = number.substring(0, number.length() - 1);
                            int periodNumb = 0;
                            if (number.length() > 2 && (periodNumb = Integer.parseInt(periodNumStr = number.substring(number.length() - 2))) > 12) {
                                yearNumber = number.substring(0, number.length() - 2);
                                number = yearNumber + "12";
                            }
                            if (specialPeriodNums.contains(number)) {
                                if (getDataType.onlyAdjustPeriod()) {
                                    if (periodNumb > 12) {
                                        Integer preMaxNumber = (Integer)maxAdjustPeriod.get(number);
                                        if (preMaxNumber == null) {
                                            maxAdjustPeriod.put(number, periodNumb);
                                        } else if (preMaxNumber < periodNumb) {
                                            maxAdjustPeriod.put(number, periodNumb);
                                            removeNumbers.add(yearNumber + preMaxNumber + "T");
                                        } else {
                                            return;
                                        }
                                    }
                                    removeNumbers.add(number);
                                }
                                result_id.computeIfAbsent((String)key, k -> new LinkedList()).add(id);
                            }
                        }
                    });
                    if (removeNumbers.size() > 0) {
                        ((List)result_id.get(key)).removeIf(id -> removeNumbers.contains(idNumberMap.get(id)));
                    }
                    if (!result_id.containsKey(key)) {
                        result_id.put((String)key, new LinkedList());
                    }
                    if (getGlFilterParamMap.contains(key)) {
                        CommonServiceHelper.handleLog((Log)log, (String)("GlParamAllData-" + key), (String)SerializationUtils.toJsonString(idNumberMap));
                        CommonServiceHelper.handleLog((Log)log, (String)("GlFilterParam-" + key), (String)SerializationUtils.toJsonString(result_id.get(key)));
                    }
                } else {
                    result_id.put((String)key, new LinkedList());
                }
            });
        }
        return result_id;
    }

    public Map<String, List<BcmDataQParam.MemberRange>> getBcmFilterParamMap(Map<String, List<Member>> ebMemberFilter, BcmDataIntegration bcmDataIntegration, Map<Long, MemberMapPPO> memberMapPPOMap) {
        List<DataIntegrationDimMap> dimMapList = bcmDataIntegration.getFirstDimMap();
        HashMap<String, List<BcmDataQParam.MemberRange>> result = new HashMap<String, List<BcmDataQParam.MemberRange>>(ebMemberFilter.size());
        HashMap<String, Set> allMemberNums = new HashMap<String, Set>();
        this.parserFilterByDimMap(ebMemberFilter, dimMapList, memberMapPPOMap, true, param -> {
            String bcmDimNumber = param.getSourceField();
            String bcmMember = param.getSourceVal();
            if (param.isEmptyFilter()) {
                allMemberNums.put(bcmDimNumber, new HashSet(16));
            } else if (param.isSpecialPeriod()) {
                allMemberNums.computeIfAbsent(SysDimensionEnum.Period.getNumber(), key -> new HashSet()).add("M_M" + param.getRefVal());
                allMemberNums.computeIfAbsent(SysDimensionEnum.Year.getNumber(), key -> new HashSet()).add("FY" + bcmMember);
            } else {
                allMemberNums.computeIfAbsent(bcmDimNumber, key -> new HashSet(16)).add(bcmMember);
                if (param.getRefField() != null && param.getRefVal() != null && SysDimensionEnum.Period.getNumber().equals(param.getRefField())) {
                    allMemberNums.computeIfAbsent(param.getRefField(), key -> new HashSet(16)).add(param.getRefVal());
                }
            }
        });
        dimMapList.forEach(map -> {
            String bcmDim = map.getDimsource();
            String bcmFixMember = map.getSourceFixVal();
            String ebDim = map.getDimtarget();
            if (StringUtils.isEmpty((CharSequence)ebDim) && StringUtils.isNotEmpty((CharSequence)bcmFixMember)) {
                allMemberNums.computeIfAbsent(bcmDim, key -> new HashSet()).add(bcmFixMember);
            }
        });
        Set orgNumbers = (Set)allMemberNums.get(SysDimensionEnum.Entity.getNumber());
        Set filterOrgNumbers = bcmDataIntegration.getSrcRangeMembers().stream().map(SimpleObject::getNumber).collect(Collectors.toSet());
        if (orgNumbers != null) {
            orgNumbers.removeIf(org -> !filterOrgNumbers.contains(org));
        } else {
            allMemberNums.put(SysDimensionEnum.Entity.getNumber(), new HashSet(filterOrgNumbers));
        }
        Set bcmFilterParamMap = LogSignHelper.getLogSignByGropNum((String)"getBcmFilterParamMap");
        allMemberNums.forEach((dimNum, memberNums) -> {
            if (bcmFilterParamMap.contains(dimNum)) {
                CommonServiceHelper.handleLog((Log)log, (String)("BcmParamAllData-" + dimNum), (String)SerializationUtils.toJsonString((Object)memberNums));
            }
            ArrayList members = new ArrayList(memberNums.size());
            this.loadBcmMemberObj(bcmDataIntegration, (String)dimNum, (Set<String>)memberNums).forEach(obj -> members.add(new BcmDataQParam.MemberRange((String)dimNum, null, Collections.singletonList(obj.getString("number")))));
            result.put((String)dimNum, members);
        });
        return result;
    }

    public DynamicObjectCollection loadBcmMemberObj(BcmDataIntegration integration, String dimNumber, Set<String> numbers) {
        QFilter modelQ = new QFilter("model", "=", (Object)integration.getSrcModelId());
        QFilter numberQ = new QFilter("number", "=", (Object)dimNumber);
        DynamicObject dimObj = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"memberform,id", (QFilter[])new QFilter[]{modelQ, numberQ});
        if (dimObj != null) {
            String formKey = dimObj.getString("memberform");
            Long dimId = dimObj.getLong("id");
            QFilter dimIdQ = new QFilter("dimension", "=", (Object)dimId);
            if (SysDimensionEnum.Entity.getNumber().equals(dimNumber)) {
                dimIdQ.and("cslscheme", "=", (Object)integration.getSrcOrgViewId());
            }
            QFilter numbersQ = null;
            if (numbers != null) {
                numbersQ = new QFilter("number", "in", numbers);
            }
            return QueryServiceHelper.query((String)formKey, (String)"number", (QFilter[])new QFilter[]{modelQ, dimIdQ, numbersQ});
        }
        return new DynamicObjectCollection();
    }

    private Map<String, List<String>> getCusFilterParamMap(DataIntegration dataIntegration, Map<String, List<Member>> ebMemberFilter, Map<Long, MemberMapPPO> memberMapPPOMap) {
        HashMap filterParamMap = Maps.newHashMapWithExpectedSize((int)20);
        this.parserFilterByDimMap(ebMemberFilter, dataIntegration.getFirstDimMap(), memberMapPPOMap, false, param -> {
            if (param.isEmptyFilter()) {
                filterParamMap.put(param.getSourceField(), new ArrayList(16));
            } else {
                filterParamMap.computeIfAbsent(param.getSourceField(), key -> new ArrayList(16)).add(param.getSourceVal());
            }
        });
        return filterParamMap;
    }

    private static class InnerClass {
        private static DataIntegrationInService instance = new DataIntegrationInService();

        private InnerClass() {
        }
    }
}

