/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.dataintegration.service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.dataintegration.entity.DataIntegrationMapCat;
import kd.epm.eb.common.utils.QFBuilder;

public class DataIntegrationMapService {
    public static DataIntegrationMapService getInstance() {
        return InnerClass.instance;
    }

    private DataIntegrationMapService() {
    }

    public TreeNode getMapCatTree(Long modelId) {
        QFBuilder qb = new QFBuilder();
        qb.add(new QFilter("modelid", "=", (Object)modelId));
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"eb_integration_mapcat", (String)"id,number,name,modelid,parentid,createtime", (QFilter[])qb.toArrays(), (String)"createtime asc");
        List<DataIntegrationMapCat> mapCatList = DataIntegrationMapCat.of(dys);
        TreeNode root = new TreeNode();
        root.setId("0");
        root.setText(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6620\u5c04\u5206\u7c7b", (String)"DataIntegrationMapService_0", (String)"epm-eb-business", (Object[])new Object[0]));
        root.setParentid("");
        if (mapCatList.isEmpty()) {
            return root;
        }
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(10);
        mapCatList.forEach(e -> {
            TreeNode node = new TreeNode(e.getParentid() + "", e.getId() + "", e.getName());
            treeNodes.add(node);
        });
        List rootNode = treeNodes.stream().filter(e -> "0".equals(e.getParentid())).collect(Collectors.toList());
        if (rootNode.isEmpty()) {
            return null;
        }
        ArrayList<TreeNode> rootNodeList = new ArrayList<TreeNode>(10);
        for (TreeNode rn : rootNode) {
            this.recursiveTree(rn, treeNodes);
            rootNodeList.add(rn);
        }
        root.setChildren(rootNodeList);
        return root;
    }

    public void recursiveTree(TreeNode parent, List<TreeNode> list) {
        List children = list.stream().filter(e -> e.getParentid().equals(parent.getId())).collect(Collectors.toList());
        if (children.isEmpty()) {
            return;
        }
        parent.setChildren(children);
        for (TreeNode child : children) {
            this.recursiveTree(child, list);
        }
    }

    private static class InnerClass {
        private static DataIntegrationMapService instance = new DataIntegrationMapService();

        private InnerClass() {
        }
    }
}

