/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.dataintegration.service;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.Dimension;
import kd.epm.eb.common.utils.DatasetServiceHelper;

public class DataIntegrationOutService {
    private static final Log log = LogFactory.getLog(DataIntegrationOutService.class);

    public static DataIntegrationOutService getInstance() {
        return InnerClass.instance;
    }

    private DataIntegrationOutService() {
    }

    public SelectCommandInfo getSciInfo(Long datasetid, Set<String> dimsourceSet, Map<String, List<Member>> paramMap, IModelCacheHelper modelCache) {
        List dimensions = DatasetServiceHelper.getInstance().listDimensionByDatasetId(datasetid);
        Map<String, Long> viewMap = dimensions.stream().collect(Collectors.toMap(Dimension::getNumber, Dimension::getViewId));
        SelectCommandInfo queryInfo = new SelectCommandInfo();
        String accDimNumber = SysDimensionEnum.Account.getNumber();
        if (paramMap.containsKey(accDimNumber)) {
            List<Member> members = paramMap.get(accDimNumber);
            List<String> memberNumbers = members.stream().map(BaseCache::getNumber).collect(Collectors.toList());
            queryInfo.addFilter(accDimNumber, memberNumbers.toArray(new String[memberNumbers.size()]));
        }
        for (Dimension dim : dimensions) {
            List<String> memberNumbers;
            List members;
            String dimNumber = dim.getNumber();
            queryInfo.addDims(new String[]{dimNumber});
            if (paramMap.containsKey(dimNumber)) {
                members = paramMap.get(dimNumber);
                memberNumbers = members.stream().map(BaseCache::getNumber).collect(Collectors.toList());
                queryInfo.addFilter(dimNumber, memberNumbers.toArray(new String[memberNumbers.size()]));
                continue;
            }
            members = modelCache.getMembers(viewMap.get(dimNumber), dimNumber);
            if (!dimsourceSet.contains(dimNumber)) {
                if (SysDimensionEnum.ChangeType.getNumber().equals(dimNumber)) {
                    queryInfo.addFilter(dimNumber, new String[]{"CurrentPeriod"});
                    continue;
                }
                if (SysDimensionEnum.AuditTrail.getNumber().equals(dimNumber)) {
                    queryInfo.addFilter(dimNumber, new String[]{"EntityInput"});
                    continue;
                }
                if (SysDimensionEnum.InternalCompany.getNumber().equals(dimNumber)) {
                    queryInfo.addFilter(dimNumber, new String[]{"ICTotal"});
                    continue;
                }
                if (SysDimensionEnum.Metric.getNumber().equals(dimNumber)) {
                    queryInfo.addFilter(dimNumber, new String[]{"Money"});
                    continue;
                }
                Member rootMember = members.stream().filter(e -> e.getParentId().equals(0L)).findFirst().get();
                queryInfo.addFilter(dimNumber, new String[]{rootMember.getNumber()});
                continue;
            }
            memberNumbers = members.stream().filter(Member::isLeaf).map(BaseCache::getNumber).collect(Collectors.toList());
            queryInfo.addFilter(dimNumber, memberNumbers.toArray(new String[memberNumbers.size()]));
        }
        String accountNumber = SysDimensionEnum.Account.getNumber();
        if (!paramMap.containsKey(accountNumber)) {
            List members = modelCache.getMembers(viewMap.get(accountNumber), accountNumber);
            List<String> leafMembers = members.stream().filter(member -> member.isLeaf() && datasetid.equals(member.getDatasetId())).map(BaseCache::getNumber).collect(Collectors.toList());
            queryInfo.addFilter(accountNumber, leafMembers.toArray(new String[leafMembers.size()]));
        }
        return queryInfo;
    }

    private static class InnerClass {
        private static DataIntegrationOutService instance = new DataIntegrationOutService();

        private InnerClass() {
        }
    }
}

