/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.dataintegration.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.form.FormShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.bailorg.entity.SimpleObject;
import kd.epm.eb.business.dataintegration.DataIntegrationOut;
import kd.epm.eb.business.dataintegration.entity.AbstractDataIntegration;
import kd.epm.eb.business.dataintegration.entity.BcmDataIntegration;
import kd.epm.eb.business.dataintegration.entity.DataIntegration;
import kd.epm.eb.business.dataintegration.entity.DataIntegrationDimMap;
import kd.epm.eb.business.dataintegration.entity.DataIntegrationMetricMap;
import kd.epm.eb.business.dataintegration.entity.GLDataIntegration;
import kd.epm.eb.business.dataintegration.entity.GLMapCondition;
import kd.epm.eb.business.dataintegration.entity.GlBizFieldType;
import kd.epm.eb.business.dataintegration.entity.IntegrationDimMapGroup;
import kd.epm.eb.business.dataintegration.entity.IntegrationRange;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.dataintegration.DataIntegrationGetDataType;
import kd.epm.eb.common.dataintegration.DataIntegrationGetValType;
import kd.epm.eb.common.dataintegration.DataIntegrationType;
import kd.epm.eb.common.dataintegration.IntegrationSchemeType;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import org.apache.commons.lang3.StringUtils;

public class DataIntegrationQueryService {
    public static DataIntegrationQueryService getInstance() {
        return InnerClass.instance;
    }

    private DataIntegrationQueryService() {
    }

    public Map<Long, Set<Long>> getDimMappingRelInterScheme(Long modelId, Collection<Long> dimMappingIds) {
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue() || CollectionUtils.isEmpty(dimMappingIds)) {
            return new HashMap<Long, Set<Long>>(0);
        }
        HashMap<Long, Set<Long>> dimMappingRelSchemeIds = new HashMap<Long, Set<Long>>(16);
        QFilter qFilter = new QFilter("modelid", "=", (Object)modelId);
        qFilter.and(new QFilter("dimmapentity.dimmembmap", "in", dimMappingIds).or("bcmdimmapentity.bcmdimmemmap", "in", dimMappingIds));
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_integration", (String)"id,dimmapentity.dimmembmap,bcmdimmapentity.bcmdimmemmap", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            for (DynamicObject object : query) {
                Set schemeIds;
                long id = object.getLong("id");
                long cusDimMapId = object.getLong("dimmapentity.dimmembmap");
                long bcmDimMapId = object.getLong("bcmdimmapentity.bcmdimmemmap");
                if (IDUtils.isNotEmptyLong((Long)cusDimMapId).booleanValue()) {
                    schemeIds = dimMappingRelSchemeIds.computeIfAbsent(cusDimMapId, e -> new HashSet(16));
                    schemeIds.add(id);
                    continue;
                }
                if (!IDUtils.isNotEmptyLong((Long)bcmDimMapId).booleanValue()) continue;
                schemeIds = dimMappingRelSchemeIds.computeIfAbsent(bcmDimMapId, e -> new HashSet(16));
                schemeIds.add(id);
            }
        }
        QFilter glQFilter = new QFilter("modelid", "=", (Object)modelId);
        glQFilter.and("schemetype", "=", (Object)IntegrationSchemeType.GL.getVal());
        DynamicObjectCollection glQuery = QueryServiceHelper.query((String)"eb_integration", (String)"id,dimmapscheme_entry.dimmemmapjson", (QFilter[])glQFilter.toArray());
        if (CollectionUtils.isNotEmpty((Collection)glQuery)) {
            for (DynamicObject object : glQuery) {
                long interSchemeId = object.getLong("id");
                String dimMemMapJson = object.getString("dimmapscheme_entry.dimmemmapjson");
                if (StringUtils.isEmpty((CharSequence)dimMemMapJson)) continue;
                List dimMapList = (List)ObjectSerialUtil.parseObject((String)dimMemMapJson, (TypeReference)new TypeReference<List<DataIntegrationDimMap>>(){}, (Feature[])new Feature[0]);
                for (DataIntegrationDimMap dataIntegrationDimMap : dimMapList) {
                    Long dimMapId = dataIntegrationDimMap.getDimmembmapid();
                    if (!IDUtils.isNotEmptyLong((Long)dimMapId).booleanValue() || !dimMappingIds.contains(dimMapId)) continue;
                    Set schemeIds = dimMappingRelSchemeIds.computeIfAbsent(dimMapId, e -> new HashSet(16));
                    schemeIds.add(interSchemeId);
                }
            }
        }
        return dimMappingRelSchemeIds;
    }

    public Map<Long, Set<String>> getCusDimMappingRelInterSchemeSourceField(Long modelId, Long dimMappingId) {
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue() || IDUtils.isEmptyLong((Long)dimMappingId).booleanValue()) {
            return new HashMap<Long, Set<String>>(0);
        }
        QFilter qFilter = new QFilter("modelid", "=", (Object)modelId);
        qFilter.and("dimmapentity.dimmembmap", "=", (Object)dimMappingId);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_integration", (String)"id, dimmapentity.dimsource", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            HashMap<Long, Set<String>> schemeToSourceFiled = new HashMap<Long, Set<String>>(query.size());
            for (DynamicObject object : query) {
                String sourceFiled = object.getString("dimmapentity.dimsource");
                if (StringUtils.isEmpty((CharSequence)sourceFiled)) continue;
                String[] split = sourceFiled.split(",");
                HashSet<String> fields = new HashSet<String>(split.length);
                for (String s : split) {
                    if (StringUtils.isEmpty((CharSequence)s) || ",".equals(s)) continue;
                    fields.add(s);
                }
                if (fields.size() <= 0) continue;
                schemeToSourceFiled.put(object.getLong("id"), fields);
            }
            return schemeToSourceFiled;
        }
        return new HashMap<Long, Set<String>>(0);
    }

    public List<AbstractDataIntegration> getDataIntegrationObjects(DataIntegrationType type, Collection<Long> schemeIds, boolean isUseOfExecute) {
        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])schemeIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)type.getEntityName()));
        if (load != null && load.length != 0) {
            ArrayList<AbstractDataIntegration> dataIntegrations = new ArrayList<AbstractDataIntegration>(load.length);
            for (DynamicObject object : load) {
                AbstractDataIntegration dataIntegration = this.tranDataIntegrationObject(object, isUseOfExecute);
                if (dataIntegration == null) continue;
                dataIntegrations.add(dataIntegration);
            }
            return dataIntegrations;
        }
        return new ArrayList<AbstractDataIntegration>(0);
    }

    public AbstractDataIntegration tranDataIntegrationObject(DynamicObject object, boolean isUseOfExecute) {
        AbstractDataIntegration dataIntegration = this.newDataIntegrationByObject(object);
        if (dataIntegration == null) {
            return null;
        }
        dataIntegration.setObject(object);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)object.getLong("modelid.id"));
        this.setDataIntegrationSchemeBaseInfo(object, dataIntegration, modelCacheHelper);
        if (dataIntegration instanceof DataIntegrationOut) {
            this.setCusDataIntegrationObjectInfo((DataIntegrationOut)dataIntegration, object, modelCacheHelper, isUseOfExecute);
        } else if (dataIntegration instanceof DataIntegration) {
            this.setCusDataIntegrationObjectInfo((DataIntegration)dataIntegration, object, modelCacheHelper, isUseOfExecute);
        } else if (dataIntegration instanceof GLDataIntegration) {
            this.setGLDataIntegrationObjectInfo((GLDataIntegration)dataIntegration, object, modelCacheHelper);
        } else if (dataIntegration instanceof BcmDataIntegration) {
            this.setBCMDataIntegrationObjectInfo((BcmDataIntegration)dataIntegration, object, modelCacheHelper, isUseOfExecute);
        }
        DynamicObjectCollection interRangeEntry = object.getDynamicObjectCollection("interangeentry");
        for (DynamicObject range : interRangeEntry) {
            DataIntegrationGetValType getValType = DataIntegrationGetValType.getTypeByVal((String)range.getString("rangegetvalway"));
            String memRangeJson = range.getString("rangememrangejson");
            IntegrationRange integrationRange = new IntegrationRange();
            String rangeDimNum = range.getString("rangedimnum");
            integrationRange.setDimNumber(rangeDimNum);
            integrationRange.setGetValType(getValType);
            if (getValType == DataIntegrationGetValType.SCHEME && StringUtils.isNotEmpty((CharSequence)memRangeJson)) {
                List memberConditions = (List)ObjectSerialUtil.parseObject((String)memRangeJson, (TypeReference)new TypeReference<List<MemberCondition>>(){}, (Feature[])new Feature[0]);
                integrationRange.setRangeMembers(memberConditions);
            }
            dataIntegration.addIntegrationRanges(integrationRange);
        }
        this.dealDataSetChangeDim(dataIntegration, modelCacheHelper);
        return dataIntegration;
    }

    protected void dealDataSetChangeDim(AbstractDataIntegration dataIntegration, IModelCacheHelper modelCacheHelper) {
        Set existInterRangeDims = dataIntegration.getIntegrationRanges().stream().map(IntegrationRange::getDimNumber).collect(Collectors.toSet());
        if (dataIntegration instanceof DataIntegrationOut) {
            String[] dimensionNums;
            for (String dimNum : dimensionNums = modelCacheHelper.getDimensionNums(dataIntegration.getDatasetid())) {
                if (existInterRangeDims.contains(dimNum)) continue;
                IntegrationRange integrationRange = new IntegrationRange();
                integrationRange.setDimNumber(dimNum);
                integrationRange.setGetValType(DataIntegrationGetValType.CONDITION);
                dataIntegration.addIntegrationRanges(integrationRange);
            }
        }
    }

    private void setDataIntegrationSchemeBaseInfo(DynamicObject object, AbstractDataIntegration dataIntegration, IModelCacheHelper modelCacheHelper) {
        long dataSetId = object.getLong("datasetid.id");
        long bizModelId = object.getLong("bizmodel.id");
        if (IDUtils.isEmptyLong((Long)bizModelId).booleanValue()) {
            bizModelId = modelCacheHelper.getBusModelByDataSet(Long.valueOf(dataSetId));
        }
        dataIntegration.setIntegrationType(DataIntegrationType.getTypeByVal((String)object.getString("type")));
        dataIntegration.setId(object.getLong("id"));
        dataIntegration.setNumber(object.getString("number"));
        dataIntegration.setName(object.getString("name"));
        dataIntegration.setStatus(object.getBoolean("status"));
        dataIntegration.setModelid(object.getLong("modelid.id"));
        dataIntegration.setDatasetid(dataSetId);
        dataIntegration.setBizModelId(bizModelId);
        dataIntegration.setExecuteSchemeId(object.getLong("executescheme.id"));
    }

    private void setBCMDataIntegrationObjectInfo(BcmDataIntegration dataIntegration, DynamicObject object, IModelCacheHelper modelCacheHelper, boolean isUseOfExecute) {
        DynamicObjectCollection sourceOrgMembers = object.getDynamicObjectCollection("srcrangememrecord");
        DynamicObjectCollection dimMapEntry = object.getDynamicObjectCollection("bcmdimmapentity");
        dataIntegration.setSrcModelId(object.getLong("srcmodel.id"));
        dataIntegration.setSrcOrgViewId(object.getLong("srcorgview.id"));
        for (DynamicObject sourceOrgMember : sourceOrgMembers) {
            DynamicObject orgMem = sourceOrgMember.getDynamicObject("fbasedataid");
            if (orgMem == null) continue;
            dataIntegration.addSrcRangeMember(new SimpleObject(orgMem.getLong("id"), null, orgMem.getString("number")));
        }
        IntegrationDimMapGroup dimMapGroup = new IntegrationDimMapGroup();
        dataIntegration.addDimMapGroup(dimMapGroup);
        for (DynamicObject dynamicObject : dimMapEntry) {
            DataIntegrationDimMap dataIntegrationDimMap = new DataIntegrationDimMap();
            dimMapGroup.addMemberMap(dataIntegrationDimMap);
            String sourceNumber = dynamicObject.getString("bcmdimsourcenumber");
            if (isUseOfExecute && "Year-Period".equals(sourceNumber)) {
                sourceNumber = "Year";
            }
            dataIntegrationDimMap.setDimsource(sourceNumber);
            dataIntegrationDimMap.setSourceFixVal(dynamicObject.getString("bcmpointsourcemem"));
            dataIntegrationDimMap.setDimtarget(dynamicObject.getString("bcmdimtarnumber"));
            dataIntegrationDimMap.setDimmembmapid(dynamicObject.getLong("bcmdimmemmap.id"));
            dataIntegrationDimMap.setDimmembnum(dynamicObject.getString("bcmpointtarmem"));
        }
        this.dealDataSetChangDim(modelCacheHelper, dataIntegration, dimMapGroup);
    }

    private void setGLDataIntegrationObjectInfo(GLDataIntegration dataIntegration, DynamicObject object, IModelCacheHelper modelCacheHelper) {
        DataIntegrationGetDataType getDataType = DataIntegrationGetDataType.getEnum((String)object.getString("getdatatype"));
        long calModelId = object.getLong("calculatemodel.id");
        long calViewId = object.getLong("calculateview.id");
        DynamicObjectCollection calOrgs = object.getDynamicObjectCollection("calculateorgmem");
        long accountTable = object.getLong("accounttable.id");
        long accountBookType = object.getLong("accountbooktype.id");
        long calPeriodType = object.getLong("calculateperiodtype.id");
        String currencyIdStr = object.getString("currency");
        DynamicObjectCollection dimMapSchemes = object.getDynamicObjectCollection("dimmapscheme_entry");
        dataIntegration.setGetDataType(getDataType);
        dataIntegration.setCalculateModel(calModelId);
        dataIntegration.setCalculateView(calViewId);
        dataIntegration.setIncludeCEPL(object.getBoolean("includecepl"));
        for (DynamicObject calOrg : calOrgs) {
            DynamicObject calMember = calOrg.getDynamicObject("fbasedataid");
            dataIntegration.addCalculateOrgMembers(new SimpleObject(calMember.getLong("id"), null, calMember.getString("number")));
        }
        dataIntegration.setAccountTable(accountTable);
        dataIntegration.setAccountBookType(accountBookType);
        dataIntegration.setCalculatePeriodType(calPeriodType);
        dataIntegration.setCurrencyIdStr(currencyIdStr);
        for (DynamicObject dimMapScheme : dimMapSchemes) {
            String dimMapJson;
            IntegrationDimMapGroup dimMapGroup = new IntegrationDimMapGroup();
            dimMapGroup.setTitle(dimMapScheme.getString("mapschemetitle"));
            dimMapGroup.setLevel(dimMapScheme.getInt("mapschemelevel"));
            String conditionJson = dimMapScheme.getString("dimmapconditionjson");
            if (StringUtils.isNotEmpty((CharSequence)conditionJson)) {
                List mapConditions = (List)ObjectSerialUtil.parseObject((String)conditionJson, (TypeReference)new TypeReference<List<GLMapCondition>>(){}, (Feature[])new Feature[0]);
                dimMapGroup.setCondition(mapConditions);
            }
            if (StringUtils.isNotEmpty((CharSequence)(dimMapJson = dimMapScheme.getString("dimmemmapjson")))) {
                List dimMapList = (List)ObjectSerialUtil.parseObject((String)dimMapJson, (TypeReference)new TypeReference<List<DataIntegrationDimMap>>(){}, (Feature[])new Feature[0]);
                dimMapGroup.setMemberMaps(dimMapList);
                this.dealDataSetChangDim(modelCacheHelper, dataIntegration, dimMapGroup);
            }
            dataIntegration.addDimMapGroup(dimMapGroup);
        }
    }

    private void setCusDataIntegrationObjectInfo(DataIntegration dataIntegration, DynamicObject object, IModelCacheHelper modelCacheHelper, boolean isUseOfExecute) {
        dataIntegration.setSrcsinglemetric(object.getString("srcsinglemetric"));
        dataIntegration.setSourceobjId(object.getLong("sourceobj.id"));
        dataIntegration.setTargetobjId(object.getLong("targetobj.id"));
        dataIntegration.setTargetsysId(object.getLong("targetsys.id"));
        dataIntegration.setSourcesysId(object.getLong("sourcesys.id"));
        dataIntegration.setTableName(object.getString("tablename"));
        dataIntegration.setTriggerid(object.getLong("triggerid.id"));
        DynamicObjectCollection dimMapEntry = object.getDynamicObjectCollection("dimmapentity");
        IntegrationDimMapGroup group = new IntegrationDimMapGroup();
        dataIntegration.addDimMapGroup(group);
        for (DynamicObject dynamicObject : dimMapEntry) {
            DataIntegrationDimMap integrationDimMap = new DataIntegrationDimMap();
            group.addMemberMap(integrationDimMap);
            if (dataIntegration instanceof DataIntegrationOut) {
                integrationDimMap.setDimsource(dynamicObject.getString("dimsource"));
                integrationDimMap.setDimsourcename(dynamicObject.getString("dimsourcename"));
                integrationDimMap.setDimmember(dynamicObject.getString("fixedmember"));
                integrationDimMap.setUseSourceFieldName("name".equals(dynamicObject.getString("dimattr")));
            } else {
                String dimSource = dynamicObject.getString("dimsource");
                if (isUseOfExecute && StringUtils.isNotEmpty((CharSequence)dimSource)) {
                    dimSource = dimSource.startsWith(",") ? dimSource.substring(1) : dimSource;
                    dimSource = dimSource.endsWith(",") ? dimSource.substring(0, dimSource.length() - 1) : dimSource;
                }
                integrationDimMap.setDimsource(dimSource);
                integrationDimMap.setDimmember(dynamicObject.getString("dimmember"));
            }
            integrationDimMap.setDimtarget(dynamicObject.getString("dimtarget"));
            integrationDimMap.setDimtargetname(dynamicObject.getString("dimtargetname"));
            integrationDimMap.setDimmembmapid(dynamicObject.getLong("dimmembmap.id"));
            integrationDimMap.setDimmembnum(dynamicObject.getString("dimmembnum"));
        }
        if (dataIntegration instanceof DataIntegrationOut) {
            DataIntegrationOut outObject = (DataIntegrationOut)dataIntegration;
            outObject.setMainPkField(object.getString("pkfield"));
            outObject.setEasModelNumber(object.getString("easmodel"));
            outObject.setEasEditStatus(object.getString("easeditstatus"));
        } else {
            dataIntegration.setSrcmetrictype(object.getString("srcmetrictype"));
            DynamicObjectCollection metricEntity = object.getDynamicObjectCollection("metricmapentity");
            for (DynamicObject dynamicObject : metricEntity) {
                DataIntegrationMetricMap metricMap = DataIntegrationMetricMap.of(dynamicObject);
                dataIntegration.addMetMapList(metricMap);
            }
            this.dealDataSetChangDim(modelCacheHelper, dataIntegration, group);
        }
    }

    private void dealDataSetChangDim(IModelCacheHelper modelCacheHelper, AbstractDataIntegration dataIntegration, IntegrationDimMapGroup group) {
        List<DataIntegrationDimMap> memberMapList = group.getMemberMaps();
        if (CollectionUtils.isEmpty(memberMapList)) {
            return;
        }
        Long dataSetId = dataIntegration.getDatasetid();
        DataIntegrationType type = dataIntegration.getIntegrationType();
        Set existDimNums = memberMapList.stream().map(DataIntegrationDimMap::getDimtarget).collect(Collectors.toSet());
        List dimensionList = modelCacheHelper.getDimensionList(dataSetId);
        for (Dimension dimension : dimensionList) {
            String metricType;
            if (existDimNums.contains(dimension.getNumber()) || type == DataIntegrationType.INPUT && dataIntegration instanceof DataIntegration && "mutiple".equals(metricType = ((DataIntegration)dataIntegration).getSrcmetrictype()) && "Metric".equals(dimension.getNumber())) continue;
            DataIntegrationDimMap integrationDimMap = new DataIntegrationDimMap();
            group.addMemberMap(integrationDimMap);
            integrationDimMap.setDimtarget(dimension.getNumber());
            integrationDimMap.setDimtargetname(dimension.getName());
            Member member = dimension.getMember(Long.valueOf(0L), dimension.getNoneNumber());
            if (member == null) continue;
            integrationDimMap.setDimmember(member.getName());
            integrationDimMap.setDimmembnum(member.getNumber());
        }
    }

    public AbstractDataIntegration newDataIntegrationByObject(DynamicObject object) {
        DataIntegrationType type = DataIntegrationType.getTypeByVal((String)object.getString("type"));
        if (type == DataIntegrationType.INPUT) {
            IntegrationSchemeType schemeType = IntegrationSchemeType.getTypeByVal((String)object.getString("schemetype"));
            if (schemeType == IntegrationSchemeType.CUSTOM) {
                return new DataIntegration();
            }
            if (schemeType == IntegrationSchemeType.GL) {
                return new GLDataIntegration();
            }
            if (schemeType == IntegrationSchemeType.BCM) {
                return new BcmDataIntegration();
            }
        } else if (type == DataIntegrationType.OUTPUT) {
            return new DataIntegrationOut();
        }
        return null;
    }

    public void getExistSchemeNamesOrNumbers(Long modelId, Set<String> names, Set<String> numbers) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_integration", (String)"number,name", (QFilter[])new QFilter("modelid", "=", (Object)modelId).toArray());
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            for (DynamicObject object : query) {
                numbers.add(object.getString("number"));
                names.add(object.getString("name"));
            }
        }
    }

    public List<SimpleObject> getCalDimensions() {
        QFilter qFilter = new QFilter("valuetype", "!=", (Object)"3");
        qFilter.and("name", "is not null", (Object)"");
        DynamicObjectCollection calDimensions = QueryServiceHelper.query((String)GlBizFieldType.DIMENSION.getFieldFormKey(), (String)"id, number,name", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isNotEmpty((Collection)calDimensions)) {
            ArrayList<SimpleObject> simpleObjectList = new ArrayList<SimpleObject>(calDimensions.size());
            for (DynamicObject calDimension : calDimensions) {
                simpleObjectList.add(new SimpleObject(calDimension.getLong("id"), calDimension.getString("name"), calDimension.getString("number")));
            }
            return simpleObjectList;
        }
        return new ArrayList<SimpleObject>(0);
    }

    public void setViewNumberParamBeforeSelCalOrg(FormShowParameter showParameter, Long calViewId) {
        if (IDUtils.isEmptyLong((Long)calViewId).booleanValue()) {
            return;
        }
        DynamicObject query = QueryServiceHelper.queryOne((String)"bos_org_viewschema", (String)"number", (QFilter[])new QFilter("id", "=", (Object)calViewId).toArray());
        if (query != null) {
            showParameter.setCustomParam("orgFuncId", (Object)"10");
            showParameter.setCustomParam("orgViewSchemeNumber", (Object)query.getString("number"));
        }
    }

    public Map<String, Set<Long>> getDimMappingView(Map<String, Set<Long>> dimToDimMappingIdMap, IModelCacheHelper modelCacheHelper) {
        HashSet dimMappingIds = new HashSet(16);
        dimToDimMappingIdMap.values().forEach(dimMappingIds::addAll);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_integration_map", (String)"targetsysinfo", (QFilter[])new QFilter[]{new QFilter("id", "in", dimMappingIds)});
        if (query == null) {
            return new HashMap<String, Set<Long>>(0);
        }
        HashMap<String, Set<Long>> dimMappingViewMap = new HashMap<String, Set<Long>>(16);
        for (DynamicObject object : query) {
            String info = object.getString("targetsysinfo");
            if (!StringUtils.isNotEmpty((CharSequence)info)) continue;
            Map map = (Map)JSON.parseObject((String)info, Map.class);
            Long dimId = IDUtils.toLong(map.get("dim"));
            Long viewId = IDUtils.toLong(map.get("view"));
            if (!IDUtils.isNotEmptyLong((Long)dimId).booleanValue() || !IDUtils.isNotEmptyLong((Long)viewId).booleanValue()) continue;
            Set viewIds = dimMappingViewMap.computeIfAbsent(modelCacheHelper.getDimension(dimId).getNumber(), e -> new HashSet(16));
            viewIds.add(viewId);
        }
        return dimMappingViewMap;
    }

    public Long getDimMappingViewId(Long dimMappingId) {
        Map map;
        Long viewId;
        String info;
        DynamicObject query = QueryServiceHelper.queryOne((String)"eb_integration_map", (String)"targetsysinfo", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dimMappingId)});
        if (query != null && StringUtils.isNotEmpty((CharSequence)(info = query.getString("targetsysinfo"))) && IDUtils.isNotEmptyLong((Long)(viewId = IDUtils.toLong((map = (Map)JSON.parseObject((String)info, Map.class)).get("view")))).booleanValue()) {
            return viewId;
        }
        return 0L;
    }

    private static class InnerClass {
        private static DataIntegrationQueryService instance = new DataIntegrationQueryService();

        private InnerClass() {
        }
    }
}

