/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.dataintegration.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.dataintegration.entity.DataIntegrationDimMap;
import kd.epm.eb.business.dataintegration.entity.DataIntegrationMemberPojo;
import kd.epm.eb.business.dataintegration.entity.DataIntegrationPlan;
import kd.epm.eb.business.dataintegration.entity.DataIntegrationQCondition;
import kd.epm.eb.business.dataintegration.entity.DataIntegrationQuery;
import kd.epm.eb.business.dataintegration.service.DataIntegrationQueryService;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.dataintegration.DataIntegrationGetValType;
import kd.epm.eb.common.dataintegration.DataIntegrationType;
import kd.epm.eb.common.dataintegration.IntegrationSchemeType;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.base.ObjUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class DataIntegrationService {
    private static final Log log = LogFactory.getLog(DataIntegrationService.class);

    public static DataIntegrationService getInstance() {
        return InnerClass.instance;
    }

    private DataIntegrationService() {
    }

    public DataIntegrationPlan createOutPlan(Long schemeId, Long modelId, Long datasetId, Long srcDsId, Long tarId, DynamicObjectCollection dimMaperList, String metricField, String pkField) {
        DynamicObject tarObj = BusinessDataServiceHelper.loadSingle((Object)tarId, (String)"isc_metadata_schema");
        String tarType = tarObj.getString("type");
        if ("SERVICE".equalsIgnoreCase(tarType)) {
            return new DataIntegrationPlan();
        }
        String tableName = this.createTableByTarobj(modelId, datasetId, schemeId, tarObj);
        DynamicObject iscDs = BusinessDataServiceHelper.loadSingle((Object)srcDsId, (String)"isc_data_source");
        Long srcId = (Long)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"ISCDataCopyService", (String)"syncMetaData", (Object[])new Object[]{iscDs.getString("number"), "TABLE", tableName + "@epm"});
        DynamicObject srcObj = BusinessDataServiceHelper.loadSingle((Object)srcId, (String)"isc_metadata_schema");
        DynamicObject dataCopy = this.createOutDataCopy(srcObj, tarObj, schemeId, tableName, dimMaperList, metricField, pkField);
        DynamicObject trigger = this.createOutTrigger(dataCopy);
        return new DataIntegrationPlan(srcObj.getLong("id"), tarObj.getLong("id"), trigger.getLong("id"), tableName);
    }

    private String createTableByTarobj(long modelId, Long datasetId, Long schemeId, DynamicObject tarObj) {
        DBRoute epm;
        boolean exitsTable;
        String tableName = "";
        String routeSource = tarObj.get("id") + "";
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("scheme", "=", (Object)schemeId);
        DynamicObject dyRouter = QueryServiceHelper.queryOne((String)"eb_integration_router", (String)"id,modelid,datasetid,source,table", (QFilter[])qfBuilder.toArrays());
        if (dyRouter != null) {
            tableName = dyRouter.getString("table");
        }
        if (StringUtils.isBlank((CharSequence)tableName)) {
            tableName = "t_eb_tmp_" + System.currentTimeMillis();
        }
        if (exitsTable = DB.exitsTable((DBRoute)(epm = DBRoute.of((String)"epm")), (String)tableName)) {
            DynamicObjectCollection properties = tarObj.getDynamicObjectCollection("prop_entryentity");
            List columnNames = DB.getColumnNames((DBRoute)epm, (String)tableName);
            boolean match = true;
            for (DynamicObject prop : properties) {
                String propName = "f" + prop.getString("prop_name");
                match = columnNames.stream().anyMatch(e -> e.equalsIgnoreCase(propName));
                if (match) continue;
                match = false;
                break;
            }
            if (match) {
                return tableName;
            }
            DB.execute((DBRoute)epm, (String)("drop table " + tableName));
            log.warn("createDatasetTable-drop table" + tableName);
        }
        this.createTableByTarobj(tableName, tarObj);
        if (!exitsTable) {
            DynamicObject newrouter = BusinessDataServiceHelper.newDynamicObject((String)"eb_integration_router");
            newrouter.set("modelid", (Object)modelId);
            newrouter.set("datasetid", (Object)datasetId);
            newrouter.set("source", (Object)routeSource);
            newrouter.set("table", (Object)tableName);
            newrouter.set("scheme", (Object)schemeId);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newrouter});
        }
        return tableName;
    }

    public DataIntegrationPlan createPlan(long diId, long modelId, long datasetId, Long srcId, Long tarDsId) {
        DynamicObject src = BusinessDataServiceHelper.loadSingle((Object)srcId, (String)"isc_metadata_schema");
        String tableName = this.creatTargetTable(modelId, datasetId, diId, src);
        DynamicObject iscDs = BusinessDataServiceHelper.loadSingle((Object)tarDsId, (String)"isc_data_source");
        Long tarId = (Long)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"ISCDataCopyService", (String)"syncMetaData", (Object[])new Object[]{iscDs.getString("number"), "TABLE", tableName + "@epm"});
        DynamicObject tar = BusinessDataServiceHelper.loadSingle((Object)tarId, (String)"isc_metadata_schema");
        DynamicObject dataCopy = this.createDataCopy(diId, src, tar);
        DynamicObject trigger = this.createTrigger(diId, dataCopy);
        return new DataIntegrationPlan(src.getLong("id"), tar.getLong("id"), trigger.getLong("id"), tableName);
    }

    private DynamicObject createTrigger(long diId, DynamicObject dataCopy) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("id", "=", (Object)diId);
        DeleteServiceHelper.delete((String)"isc_data_copy_trigger", (QFilter[])qfBuilder.toArrays());
        DynamicObject tr = BusinessDataServiceHelper.newDynamicObject((String)"isc_data_copy_trigger");
        tr.set("id", (Object)diId);
        tr.set("trigger_type", (Object)"manual");
        tr.set("data_copy", (Object)dataCopy);
        tr.set("number", (Object)(diId + "@epm"));
        tr.set("name", (Object)ResManager.loadResFormat((String)"\u82cd\u7a79\u9884\u7b97-%1", (String)"DataIntegrationService_1", (String)"epm-eb-business", (Object[])new Object[]{diId}));
        tr.set("trace_all", (Object)Boolean.FALSE);
        tr.set("enable", (Object)1);
        tr.set("creator", (Object)UserUtils.getUserId());
        tr.set("createtime", (Object)new Timestamp(System.currentTimeMillis()));
        tr.set("status", (Object)"C");
        MainEntityType mainEntity = (MainEntityType)tr.getDataEntityType();
        EntityType entryType = (EntityType)mainEntity.getAllEntities().get("event_handlers");
        DynamicObjectCollection items = tr.getDynamicObjectCollection("event_handlers");
        DynamicObject item = new DynamicObject((DynamicObjectType)entryType);
        item.set("datacopy_event", (Object)"OnTaskSuccess");
        item.set("target_consumer", (Object)"TargetSystem");
        item.set("event_handler", (Object)"msvc://epm.eb.IntegrationStartupCallbackService.successCallback");
        items.add((Object)item);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tr});
        return tr;
    }

    private DynamicObject createOutTrigger(DynamicObject dataCopy) {
        String dataCopyNumber = dataCopy.getString("number");
        int id = dataCopyNumber.hashCode();
        if (QueryServiceHelper.exists((String)"isc_data_copy_trigger", (Object)id)) {
            return BusinessDataServiceHelper.loadSingle((Object)id, (String)"isc_data_copy_trigger");
        }
        DynamicObject tr = BusinessDataServiceHelper.newDynamicObject((String)"isc_data_copy_trigger");
        tr.set("id", (Object)id);
        tr.set("trigger_type", (Object)"manual");
        tr.set("data_copy", (Object)dataCopy);
        tr.set("number", (Object)dataCopy.getString("number"));
        tr.set("name", (Object)dataCopy.getString("number"));
        tr.set("trace_all", (Object)Boolean.FALSE);
        tr.set("enable", (Object)1);
        tr.set("creator", (Object)UserUtils.getUserId());
        tr.set("createtime", (Object)new Timestamp(System.currentTimeMillis()));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tr});
        return tr;
    }

    private DynamicObject createDataCopy(long diId, DynamicObject src, DynamicObject tar) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("id", "=", (Object)diId);
        DeleteServiceHelper.delete((String)"isc_data_copy", (QFilter[])qfBuilder.toArrays());
        DynamicObject dc = BusinessDataServiceHelper.newDynamicObject((String)"isc_data_copy");
        dc.set("id", (Object)diId);
        dc.set("status", (Object)"C");
        dc.set("source_schema", (Object)src);
        dc.set("data_source", src.get("group"));
        dc.set("target_schema", (Object)tar);
        dc.set("data_target", tar.get("group"));
        dc.set("mode", (Object)"BreakOnError");
        dc.set("number", (Object)(diId + "@epm"));
        dc.set("name", (Object)ResManager.loadResFormat((String)"\u82cd\u7a79\u9884\u7b97-%1", (String)"DataIntegrationService_1", (String)"epm-eb-business", (Object[])new Object[]{diId}));
        dc.set("proxy_user", (Object)"#{creator}");
        dc.set("creator", (Object)UserUtils.getUserId());
        dc.set("createtime", (Object)new Timestamp(System.currentTimeMillis()));
        dc.set("modifier", (Object)UserUtils.getUserId());
        dc.set("modifytime", (Object)new Timestamp(System.currentTimeMillis()));
        MainEntityType mainEntity = (MainEntityType)dc.getDataEntityType();
        EntityType entryType = (EntityType)mainEntity.getAllEntities().get("mapping_entries");
        DynamicObjectCollection items = dc.getDynamicObjectCollection("mapping_entries");
        DynamicObjectCollection properties = src.getDynamicObjectCollection("prop_entryentity");
        for (DynamicObject prop : properties) {
            DynamicObject item = new DynamicObject((DynamicObjectType)entryType);
            item.set("mapping_tar_column", (Object)("f" + prop.getString("prop_name")));
            boolean isPrimaryKey = prop.getBoolean("is_primary_key");
            item.set("candidate_key", (Object)isPrimaryKey);
            item.set("mapping_src_column", (Object)prop.getString("prop_name"));
            items.add((Object)item);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dc});
        return dc;
    }

    private DynamicObject createOutDataCopy(DynamicObject src, DynamicObject tar, Long schemeId, String tableName, DynamicObjectCollection dimMaperList, String metricField, String pkField) {
        String tarNumber = tar.getString("number");
        boolean exists = QueryServiceHelper.exists((String)"isc_data_copy", (Object)schemeId);
        DynamicObject dc = null;
        if (exists) {
            dc = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"isc_data_copy");
            dc.set("source_schema", (Object)src);
            dc.set("data_source", src.get("group"));
            dc.set("target_schema", (Object)tar);
            dc.set("data_target", tar.get("group"));
        } else {
            dc = BusinessDataServiceHelper.newDynamicObject((String)"isc_data_copy");
            dc.set("id", (Object)schemeId);
            dc.set("status", (Object)"C");
            dc.set("source_schema", (Object)src);
            dc.set("data_source", src.get("group"));
            dc.set("target_schema", (Object)tar);
            dc.set("data_target", tar.get("group"));
            dc.set("mode", (Object)"BreakOnError");
            dc.set("number", (Object)(tableName + "_" + tarNumber));
            dc.set("name", (Object)ResManager.loadResFormat((String)"\u82cd\u7a79\u9884\u7b97-%1", (String)"DataIntegrationService_1", (String)"epm-eb-business", (Object[])new Object[]{tableName + "_" + tarNumber}));
            dc.set("proxy_user", (Object)"#{creator}");
            dc.set("creator", (Object)UserUtils.getUserId());
            dc.set("createtime", (Object)new Timestamp(System.currentTimeMillis()));
            dc.set("modifier", (Object)UserUtils.getUserId());
            dc.set("modifytime", (Object)new Timestamp(System.currentTimeMillis()));
        }
        MainEntityType mainEntity = (MainEntityType)dc.getDataEntityType();
        EntityType entryType = (EntityType)mainEntity.getAllEntities().get("mapping_entries");
        DynamicObjectCollection items = dc.getDynamicObjectCollection("mapping_entries");
        items.clear();
        for (DynamicObject dimMaper : dimMaperList) {
            DynamicObject item = new DynamicObject((DynamicObjectType)entryType);
            item.set("mapping_tar_column", (Object)dimMaper.getString("dimtarget"));
            item.set("mapping_src_column", (Object)("f" + dimMaper.getString("dimtarget").toLowerCase()));
            items.add((Object)item);
        }
        DynamicObject metricItem = new DynamicObject((DynamicObjectType)entryType);
        metricItem.set("mapping_tar_column", (Object)metricField);
        metricItem.set("mapping_src_column", (Object)("f" + metricField.toLowerCase()));
        items.add((Object)metricItem);
        String tarType = tar.getString("type");
        if ("TABLE".equalsIgnoreCase(tarType) || "ENTITY".equalsIgnoreCase(tarType)) {
            DynamicObjectCollection properties = tar.getDynamicObjectCollection("prop_entryentity");
            Optional<DynamicObject> pkObj = properties.stream().filter(e -> e.getBoolean("is_primary_key")).findFirst();
            if (pkObj.isPresent()) {
                DynamicObject item = new DynamicObject((DynamicObjectType)entryType);
                item.set("mapping_tar_column", (Object)pkField);
                item.set("candidate_key", (Object)Boolean.TRUE);
                item.set("mapping_src_column", (Object)("f" + pkField.toLowerCase()));
                items.add((Object)item);
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u76ee\u6807\u96c6\u6210\u5bf9\u8c61\u672a\u8bbe\u7f6e\u4e3b\u952e\u3002", (String)"DataIntegrationService_2", (String)"epm-eb-business", (Object[])new Object[0]));
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dc});
        return dc;
    }

    private String creatTargetTable(long modelId, long datasetId, long schemeId, DynamicObject src) {
        String tableName = "";
        String number = src.getString("number");
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("scheme", "=", (Object)schemeId);
        DynamicObject dyRouter = QueryServiceHelper.queryOne((String)"eb_integration_router", (String)"id,modelid,datasetid,source,table", (QFilter[])qfBuilder.toArrays());
        if (dyRouter != null) {
            tableName = dyRouter.getString("table");
        }
        DBRoute epm = DBRoute.of((String)"epm");
        if (StringUtils.isNotBlank((CharSequence)tableName)) {
            List columnNames = DB.getColumnNames((DBRoute)epm, (String)tableName);
            DynamicObjectCollection properties = src.getDynamicObjectCollection("prop_entryentity");
            Boolean isChange = Boolean.FALSE;
            for (DynamicObject prop : properties) {
                String fieldName = "f" + prop.getString("prop_name");
                if (columnNames.stream().anyMatch(e -> e.equalsIgnoreCase(fieldName))) continue;
                isChange = Boolean.TRUE;
            }
            if (!isChange.booleanValue()) {
                return tableName;
            }
            if (DB.exitsTable((DBRoute)epm, (String)tableName)) {
                DB.execute((DBRoute)epm, (String)("drop table " + tableName));
                log.warn("creatTargetTable-drop table" + tableName);
            }
        } else {
            tableName = "t_eb_tmp_" + System.currentTimeMillis();
        }
        this.createTable(src, tableName);
        DynamicObject newrouter = BusinessDataServiceHelper.newDynamicObject((String)"eb_integration_router");
        newrouter.set("modelid", (Object)modelId);
        newrouter.set("datasetid", (Object)datasetId);
        newrouter.set("source", (Object)number);
        newrouter.set("table", (Object)tableName);
        newrouter.set("scheme", (Object)schemeId);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newrouter});
        return tableName;
    }

    private void createTable(DynamicObject src, String tableName) {
        DBRoute epm = DBRoute.of((String)"epm");
        DynamicObjectCollection properties = src.getDynamicObjectCollection("prop_entryentity");
        if (properties == null || properties.size() < 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6e90\u5bf9\u8c61\u5c5e\u6027\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u5176\u5b83\u96c6\u6210\u5bf9\u8c61", (String)"DataIntegrationService_3", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        String pk = "";
        StringBuilder sb = new StringBuilder();
        sb.append(" create table ").append(tableName).append(" (");
        for (DynamicObject prop : properties) {
            String propName = "f" + prop.getString("prop_name");
            String propLabel = prop.getString("prop_label");
            String dataType = prop.getString("data_type");
            boolean isPrimaryKey = prop.getBoolean("is_primary_key");
            if (isPrimaryKey) {
                pk = " constraint pk_" + tableName + " primary key(" + propName + ") ";
            }
            sb.append(" ").append(propName).append(" ").append(this.transformFileType(dataType));
            sb.append(" ,");
        }
        String ddl = sb.toString();
        ddl = StringUtils.isNotBlank((CharSequence)pk) ? ddl + pk : StringUtils.substring((String)ddl, (int)0, (int)ddl.lastIndexOf(","));
        ddl = ddl + ")";
        DB.execute((DBRoute)epm, (String)ddl);
    }

    private void createTableByTarobj(String tableName, DynamicObject tarObj) {
        StringBuilder sb = new StringBuilder();
        sb.append(" create table ").append(tableName).append(" (");
        String pk = "";
        DynamicObjectCollection properties = tarObj.getDynamicObjectCollection("prop_entryentity");
        for (DynamicObject prop : properties) {
            String propName = "f" + prop.getString("prop_name");
            String dataType = prop.getString("data_type");
            boolean isPrimaryKey = prop.getBoolean("is_primary_key");
            if (isPrimaryKey) {
                pk = " constraint pk_" + tableName + " primary key(" + propName + ") ";
            }
            sb.append(" ").append(propName).append(" ").append(this.transformFileType(dataType));
            sb.append(" ,");
        }
        String ddl = sb.toString();
        ddl = StringUtils.isNotBlank((CharSequence)pk) ? ddl + pk : StringUtils.substring((String)ddl, (int)0, (int)ddl.lastIndexOf(","));
        ddl = ddl + ")";
        DBRoute epm = DBRoute.of((String)"epm");
        DB.execute((DBRoute)epm, (String)ddl);
    }

    private String transformFileType(String dataType) {
        if (StringUtils.containsIgnoreCase((CharSequence)dataType, (CharSequence)"decimal(19,0)")) {
            dataType = "bigint";
        } else if (StringUtils.containsIgnoreCase((CharSequence)dataType, (CharSequence)"decimal(10,0)")) {
            dataType = "int";
        } else if (StringUtils.equalsIgnoreCase((CharSequence)dataType, (CharSequence)"date")) {
            dataType = "datetime";
        }
        return dataType;
    }

    public static List<DataIntegrationQCondition> getDataIntegrationQueryMap(Collection<Long> queryIds, boolean filterSchedule) {
        return DataIntegrationService.getDataIntegrationQueryMap(queryIds, filterSchedule, false);
    }

    public static List<DataIntegrationQCondition> getDataIntegrationQueryMap(Collection<Long> queryIds, boolean filterSchedule, boolean filterDefault) {
        QFilter qFilter = new QFilter("id", "in", queryIds);
        if (filterSchedule) {
            qFilter.and("schedulestatus", "=", (Object)"1");
        }
        if (filterDefault) {
            qFilter.and("defaultshowstatus", "=", (Object)true);
        }
        ArrayList<DataIntegrationQCondition> result = new ArrayList<DataIntegrationQCondition>(queryIds.size());
        DynamicObjectCollection objs = QueryServiceHelper.query((String)"eb_integration_query", (String)"number,queryjson,isdeletedata,schedulestatus,defaultshowstatus,datasetid,bizmodelid,bizmodelid.model as modelid", (QFilter[])qFilter.toArray());
        objs.forEach(obj -> {
            DataIntegrationQCondition condition = DataIntegrationQCondition.of(obj);
            condition.setQueryList(DataIntegrationService.getDataIntegrationQueryList(obj, ModelCacheContext.getOrCreate((Long)obj.getLong("modelid")), null));
            result.add(condition);
        });
        return result;
    }

    public static List<DataIntegrationQuery> getDataIntegrationQueryList(DynamicObject queryObj, IModelCacheHelper modelCacheHelper, Map<String, Long> viewMap) {
        List<Object> result = null;
        if (queryObj != null) {
            if (viewMap == null) {
                viewMap = modelCacheHelper.getViewsByBusModel(Long.valueOf(queryObj.getLong("bizmodelid")));
            }
            String queryJsonString = queryObj.getString("queryjson");
            result = JSON.parseArray((String)queryJsonString, DataIntegrationQuery.class);
            result = DataIntegrationService.getDataIntegrationQueryList(result, modelCacheHelper, (Map<String, Long>)viewMap);
        }
        if (result == null) {
            result = new ArrayList(16);
        }
        return result;
    }

    public static List<DataIntegrationQuery> getDataIntegrationQueryList(List<DataIntegrationQuery> dataIntegrationQueryList, IModelCacheHelper imodelCacheHelper, Map<String, Long> viewMap) {
        ArrayList<DataIntegrationQuery> newDataIntegrationQueryList = new ArrayList<DataIntegrationQuery>(16);
        for (DataIntegrationQuery dataIntegrationQuery : dataIntegrationQueryList) {
            List<Long> memberIdLongList;
            newDataIntegrationQueryList.add(dataIntegrationQuery);
            List<DataIntegrationMemberPojo> dataIntegrationMemberPojoList = dataIntegrationQuery.getDataIntegrationMemberPojoList();
            if (CollectionUtils.isNotEmpty(dataIntegrationMemberPojoList) || CollectionUtils.isEmpty(memberIdLongList = dataIntegrationQuery.getMemberIds())) continue;
            if (dataIntegrationMemberPojoList == null) {
                dataIntegrationMemberPojoList = new ArrayList<DataIntegrationMemberPojo>(16);
            }
            for (Long memberIdLong : memberIdLongList) {
                DataIntegrationMemberPojo dataIntegrationMemberPojo = new DataIntegrationMemberPojo();
                dataIntegrationMemberPojo.setMemberIdLong(memberIdLong);
                dataIntegrationMemberPojo.setDimensionNumberString(dataIntegrationQuery.getDimNumber());
                dataIntegrationMemberPojo.setScopeString(ObjUtils.getString((Object)RangeEnum.ONLY.getIndex()));
                Member member = imodelCacheHelper.getMember(dataIntegrationMemberPojo.getDimensionNumberString(), viewMap.get(dataIntegrationMemberPojo.getDimensionNumberString()), memberIdLong);
                dataIntegrationMemberPojo.setMemberNumberString(member.getNumber());
                dataIntegrationMemberPojoList.add(dataIntegrationMemberPojo);
            }
            dataIntegrationQuery.setMemberIds(null);
            dataIntegrationQuery.setDataIntegrationMemberPojoList(dataIntegrationMemberPojoList);
        }
        return newDataIntegrationQueryList;
    }

    public static Map<Long, Map<String, Long>> getDataIntegrationSchemeViewMap(Set<Long> schemeIds, Map<Long, Map<String, Long>> mapCache) {
        HashMap<Long, Map<String, Long>> result = new HashMap<Long, Map<String, Long>>(16);
        if (CollectionUtils.isEmpty(schemeIds)) {
            return result;
        }
        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])schemeIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"eb_integration"));
        if (load != null) {
            for (DynamicObject dynamicObject : load) {
                Map<String, Long> viewMap;
                long id = dynamicObject.getLong("id");
                Map<String, Long> cache = mapCache.get(id);
                if (cache != null && !cache.isEmpty()) {
                    result.put(id, cache);
                    continue;
                }
                String type = dynamicObject.getString("type");
                if ("output".equals(type)) {
                    Map<String, Long> viewMap2 = DataIntegrationService.readOutPutSchemeView(dynamicObject);
                    if (viewMap2.isEmpty()) continue;
                    result.put(dynamicObject.getLong("id"), viewMap2);
                    continue;
                }
                Object schemetype = dynamicObject.get("schemetype");
                if ("1".equals(schemetype)) {
                    viewMap = DataIntegrationService.readCusSchemeViewMap(dynamicObject);
                    if (viewMap.isEmpty()) continue;
                    result.put(dynamicObject.getLong("id"), viewMap);
                    continue;
                }
                if ("2".equals(schemetype)) {
                    viewMap = DataIntegrationService.readGlSchemeViewMap(dynamicObject);
                    if (viewMap.isEmpty()) continue;
                    result.put(dynamicObject.getLong("id"), viewMap);
                    continue;
                }
                if (!"3".equals(schemetype) || (viewMap = DataIntegrationService.readBcmSchemeViewMap(dynamicObject)).isEmpty()) continue;
                result.put(dynamicObject.getLong("id"), viewMap);
            }
        }
        return result;
    }

    public static Map<String, Long> readOutPutSchemeView(DynamicObject dynamicObject) {
        DynamicObjectCollection interangeentry = dynamicObject.getDynamicObjectCollection("dimmapentity");
        HashMap<String, Long> result = new HashMap<String, Long>(16);
        if (CollectionUtils.isNotEmpty((Collection)interangeentry)) {
            String name = dynamicObject.getString("name");
            Set<String> userSchemeDim = DataIntegrationService.getRangeDimNum(dynamicObject);
            for (DynamicObject object : interangeentry) {
                Map map;
                String info;
                String bcmdimtarnumber;
                DynamicObject bcmdimmemmap = object.getDynamicObject("dimmembmap");
                if (bcmdimmemmap == null || !userSchemeDim.contains(bcmdimtarnumber = object.getString("dimsource")) || !StringUtils.isNotEmpty((CharSequence)(info = bcmdimmemmap.getString("sourcesysinfo"))) || !(map = (Map)JSON.parseObject((String)info, Map.class)).containsKey("view") || !IDUtils.isNotNull((Long)IDUtils.toLong(map.get("view")))) continue;
                result.put(bcmdimtarnumber, IDUtils.toLong(map.get("view")));
            }
        }
        return result;
    }

    public static Map<String, Long> readCusSchemeViewMap(DynamicObject dynamicObject) {
        DynamicObjectCollection interangeentry = dynamicObject.getDynamicObjectCollection("dimmapentity");
        HashMap<String, Long> result = new HashMap<String, Long>(16);
        if (CollectionUtils.isNotEmpty((Collection)interangeentry)) {
            Set<String> userSchemeDim = DataIntegrationService.getRangeDimNum(dynamicObject);
            for (DynamicObject object : interangeentry) {
                Map map;
                String info;
                String bcmdimtarnumber;
                DynamicObject bcmdimmemmap = object.getDynamicObject("dimmembmap");
                if (bcmdimmemmap == null || !userSchemeDim.contains(bcmdimtarnumber = object.getString("dimtarget")) || !StringUtils.isNotEmpty((CharSequence)(info = bcmdimmemmap.getString("targetsysinfo"))) || !(map = (Map)JSON.parseObject((String)info, Map.class)).containsKey("view") || !IDUtils.isNotNull((Long)IDUtils.toLong(map.get("view")))) continue;
                result.put(bcmdimtarnumber, IDUtils.toLong(map.get("view")));
            }
        }
        return result;
    }

    public static Map<String, Long> readGlSchemeViewMap(DynamicObject dynamicObject) {
        DynamicObjectCollection dynamicObjects = dynamicObject.getDynamicObjectCollection("dimmapscheme_entry");
        HashMap<String, Long> result = new HashMap<String, Long>(16);
        if (CollectionUtils.isNotEmpty((Collection)dynamicObjects)) {
            Set<String> userSchemeDim = DataIntegrationService.getRangeDimNum(dynamicObject);
            for (DynamicObject object : dynamicObjects) {
                String dimMemMapJson = object.getString("dimmemmapjson");
                if (dimMemMapJson == null) continue;
                List dimMapList = (List)ObjectSerialUtil.parseObject((String)dimMemMapJson, (TypeReference)new TypeReference<List<DataIntegrationDimMap>>(){}, (Feature[])new Feature[0]);
                for (DataIntegrationDimMap dataIntegrationDimMap : dimMapList) {
                    Map map;
                    String info;
                    DynamicObject dynamicObject1;
                    if (!userSchemeDim.contains(dataIntegrationDimMap.getDimtarget()) || View.NoViewDimNums.contains(dataIntegrationDimMap.getDimtarget()) || (dynamicObject1 = BusinessDataServiceHelper.loadSingle((String)"eb_integration_map", (String)"targetsysinfo", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dataIntegrationDimMap.getDimmembmapid())})) == null || !StringUtils.isNotEmpty((CharSequence)(info = dynamicObject1.getString("targetsysinfo"))) || !(map = (Map)JSON.parseObject((String)info, Map.class)).containsKey("view") || !IDUtils.isNotNull((Long)IDUtils.toLong(map.get("view"))) || !IDUtils.isNotNull((Long)IDUtils.toLong(map.get("view")))) continue;
                    result.put(dataIntegrationDimMap.getDimtarget(), IDUtils.toLong(map.get("view")));
                }
            }
        }
        return result;
    }

    public static Map<String, Long> readBcmSchemeViewMap(DynamicObject dynamicObject) {
        DynamicObjectCollection interangeentry = dynamicObject.getDynamicObjectCollection("bcmdimmapentity");
        HashMap<String, Long> result = new HashMap<String, Long>(16);
        if (CollectionUtils.isNotEmpty((Collection)interangeentry)) {
            Set<String> userSchemeDim = DataIntegrationService.getRangeDimNum(dynamicObject);
            for (DynamicObject object : interangeentry) {
                Map map;
                String info;
                String bcmdimtarnumber;
                DynamicObject bcmdimmemmap = object.getDynamicObject("bcmdimmemmap");
                if (bcmdimmemmap == null || !userSchemeDim.contains(bcmdimtarnumber = object.getString("bcmdimtarnumber")) || !StringUtils.isNotEmpty((CharSequence)(info = bcmdimmemmap.getString("targetsysinfo"))) || !(map = (Map)JSON.parseObject((String)info, Map.class)).containsKey("view") || !IDUtils.isNotNull((Long)IDUtils.toLong(map.get("view")))) continue;
                result.put(bcmdimtarnumber, IDUtils.toLong(map.get("view")));
            }
        }
        return result;
    }

    public static Map<String, Long> resolveFilterViewInfo(List<DataIntegrationQuery> queryList) {
        HashMap<String, Long> result = new HashMap<String, Long>(16);
        if (CollectionUtils.isEmpty(queryList)) {
            return result;
        }
        for (DataIntegrationQuery dataIntegrationQuery : queryList) {
            if (!IDUtils.isNotNull((Long)dataIntegrationQuery.getViewId())) continue;
            result.put(dataIntegrationQuery.getDimNumber(), dataIntegrationQuery.getViewId());
        }
        return result;
    }

    public static Set<String> getRangeDimNum(DynamicObject dynamicObject) {
        DynamicObjectCollection range = dynamicObject.getDynamicObjectCollection("interangeentry");
        HashSet<String> userSchemeDim = new HashSet<String>(16);
        for (DynamicObject object : range) {
            if (!DataIntegrationGetValType.CONDITION.getVal().equals(object.getString("rangegetvalway"))) continue;
            userSchemeDim.add(object.getString("rangedimnum"));
        }
        return userSchemeDim;
    }

    public static Set<Long> getViewErrorScheme(Set<Long> schemeIds, Map<Long, Map<String, Long>> schemViewMap, List<DataIntegrationQuery> queryList) {
        HashSet<Long> viewErrorScheme = new HashSet<Long>(16);
        Map<String, Long> filterViewInfo = DataIntegrationService.resolveFilterViewInfo(queryList);
        if (schemViewMap != null && !schemViewMap.isEmpty() && !filterViewInfo.isEmpty()) {
            for (Long schemeId : schemeIds) {
                Map<String, Long> schemeView;
                if (!schemViewMap.containsKey(schemeId) || (schemeView = schemViewMap.get(schemeId)).isEmpty()) continue;
                log.info("filterViewInfo:{} ,schemeView:{} ", filterViewInfo, schemeView);
                for (Map.Entry<String, Long> dimView : schemeView.entrySet()) {
                    Long filterView = filterViewInfo.get(dimView.getKey());
                    if (!IDUtils.isNotNull((Long)filterView) || !IDUtils.isNotNull((Long)dimView.getValue()) || IDUtils.equals((Object)dimView.getValue(), (Object)filterView)) continue;
                    viewErrorScheme.add(schemeId);
                }
            }
        }
        log.info("viewErrorScheme:{}", viewErrorScheme);
        return viewErrorScheme;
    }

    public static Map<String, Object> checkAccountAndPeriod(Set<Long> schemeIds, List<DataIntegrationQuery> queryList) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        if (CollectionUtils.isNotEmpty(schemeIds)) {
            HashSet dimNumberSet = new HashSet(16);
            DataIntegrationQueryService.getInstance().getDataIntegrationObjects(DataIntegrationType.INPUT, schemeIds, true).forEach(dataIntegration -> dataIntegration.getIntegrationRanges().forEach(range -> {
                String dimNumber;
                if (range.getGetValType() == DataIntegrationGetValType.CONDITION && StringUtils.isNotEmpty((CharSequence)(dimNumber = range.getDimNumber()))) {
                    dimNumberSet.add(dimNumber.toLowerCase());
                }
            }));
            boolean accountEmpty = false;
            boolean periodEmpty = false;
            if (CollectionUtils.isEmpty(queryList)) {
                accountEmpty = dimNumberSet.contains(SysDimensionEnum.Account.getNumber().toLowerCase());
                periodEmpty = dimNumberSet.contains(SysDimensionEnum.BudgetPeriod.getNumber().toLowerCase());
            } else {
                DataIntegrationQuery accountQuery = queryList.stream().filter(x -> SysDimensionEnum.Account.getNumber().equalsIgnoreCase(x.getDimNumber())).findFirst().orElse(null);
                DataIntegrationQuery periodQuery = queryList.stream().filter(x -> SysDimensionEnum.BudgetPeriod.getNumber().equalsIgnoreCase(x.getDimNumber())).findFirst().orElse(null);
                accountEmpty = dimNumberSet.contains(SysDimensionEnum.Account.getNumber().toLowerCase()) && (accountQuery == null || CollectionUtils.isEmpty(accountQuery.getDataIntegrationMemberPojoList()));
                boolean bl = periodEmpty = dimNumberSet.contains(SysDimensionEnum.BudgetPeriod.getNumber().toLowerCase()) && (periodQuery == null || CollectionUtils.isEmpty(periodQuery.getDataIntegrationMemberPojoList()));
            }
            if (accountEmpty || periodEmpty) {
                DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"eb_integration", (String)"id,schemetype", (QFilter[])new QFilter("id", "in", schemeIds).toArray());
                HashSet<Long> hasBcm = new HashSet<Long>(16);
                HashSet<Long> hasGl = new HashSet<Long>(16);
                for (DynamicObject obj : dynamicObjects) {
                    String type = obj.getString("schemetype");
                    if (IntegrationSchemeType.BCM.getVal().equals(type)) {
                        hasBcm.add(obj.getLong("id"));
                        continue;
                    }
                    if (!IntegrationSchemeType.GL.getVal().equals(type)) continue;
                    hasGl.add(obj.getLong("id"));
                }
                HashSet<String> schemeName = new HashSet<String>(2);
                HashSet<String> dimName = new HashSet<String>(2);
                HashSet<Long> needRemoveSchme = new HashSet<Long>(16);
                if (accountEmpty && CollectionUtils.isNotEmpty(hasGl)) {
                    schemeName.add(ResManager.loadKDString((String)"\u8d22\u52a1\u4e91-\u603b\u8d26", (String)"DataIntegrationDataService_22", (String)"epm-eb-business", (Object[])new Object[0]));
                    dimName.add(SysDimensionEnum.Account.getChineseName());
                    needRemoveSchme.addAll(hasGl);
                }
                if (periodEmpty) {
                    if (CollectionUtils.isNotEmpty(hasBcm)) {
                        schemeName.add(ResManager.loadKDString((String)"\u4f01\u4e1a\u7ee9\u6548\u4e91-\u5408\u5e76\u62a5\u8868", (String)"DataIntegrationDataService_21", (String)"epm-eb-business", (Object[])new Object[0]));
                        dimName.add(SysDimensionEnum.BudgetPeriod.getChineseName());
                        needRemoveSchme.addAll(hasBcm);
                    }
                    if (CollectionUtils.isNotEmpty(hasGl)) {
                        schemeName.add(ResManager.loadKDString((String)"\u8d22\u52a1\u4e91-\u603b\u8d26", (String)"DataIntegrationDataService_22", (String)"epm-eb-business", (Object[])new Object[0]));
                        dimName.add(SysDimensionEnum.BudgetPeriod.getChineseName());
                        needRemoveSchme.addAll(hasGl);
                    }
                }
                if (CollectionUtils.isNotEmpty(schemeName) && CollectionUtils.isNotEmpty(dimName)) {
                    String errmsg = ResManager.loadResFormat((String)"\u5b58\u5728%1\u7c7b\u578b\u7684\u91c7\u96c6\u65b9\u6848\uff0c\u540c\u6b65\u65f6%2\u7ef4\u5ea6\u7684\u8303\u56f4\u5fc5\u9009\uff0c\u8bf7\u4fee\u6539\u914d\u7f6e\u6761\u4ef6\u540e\u518d\u8bd5\u3002", (String)"DataIntegrationDataService_24", (String)"epm-eb-business", (Object[])new Object[]{String.join((CharSequence)"\u3001", schemeName), String.join((CharSequence)"\u3001", dimName)});
                    result.put("errorMsg", errmsg);
                    result.put("errorScheme", needRemoveSchme);
                }
            }
        }
        return result;
    }

    private static class InnerClass {
        private static DataIntegrationService instance = new DataIntegrationService();

        private InnerClass() {
        }
    }
}

