/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.dataintegration.service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.bailorg.entity.SimpleObject;
import kd.epm.eb.business.dataintegration.DataIntegrationOut;
import kd.epm.eb.business.dataintegration.entity.AbstractDataIntegration;
import kd.epm.eb.business.dataintegration.entity.BcmDataIntegration;
import kd.epm.eb.business.dataintegration.entity.DataIntegration;
import kd.epm.eb.business.dataintegration.entity.DataIntegrationDimMap;
import kd.epm.eb.business.dataintegration.entity.DataIntegrationMetricMap;
import kd.epm.eb.business.dataintegration.entity.DataIntegrationPlan;
import kd.epm.eb.business.dataintegration.entity.GLDataIntegration;
import kd.epm.eb.business.dataintegration.entity.GLMapCondition;
import kd.epm.eb.business.dataintegration.entity.IntegrationDimMapGroup;
import kd.epm.eb.business.dataintegration.entity.IntegrationRange;
import kd.epm.eb.business.dataintegration.service.DataIntegrationQueryService;
import kd.epm.eb.business.dataintegration.service.DataIntegrationService;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.dataintegration.DataIntegrationGetValType;
import kd.epm.eb.common.dataintegration.DataIntegrationType;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import org.apache.commons.lang3.StringUtils;

public class DataIntegrationStoreService {
    public static DataIntegrationStoreService getInstance() {
        return InnerClass.instance;
    }

    private DataIntegrationStoreService() {
    }

    public int copyScheme(Long modelId, DataIntegrationType type, List<Long> schemeIds, StringBuilder msg) {
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue() || CollectionUtils.isEmpty(schemeIds)) {
            return 0;
        }
        DataIntegrationQueryService queryService = DataIntegrationQueryService.getInstance();
        List<AbstractDataIntegration> dataIntegrationObjects = queryService.getDataIntegrationObjects(type, schemeIds, false);
        if (CollectionUtils.isNotEmpty(dataIntegrationObjects)) {
            HashSet<String> existNames = new HashSet<String>(16);
            HashSet<String> existNumbers = new HashSet<String>(16);
            queryService.getExistSchemeNamesOrNumbers(modelId, existNames, existNumbers);
            long[] ids = GlobalIdUtil.genGlobalLongIds((int)dataIntegrationObjects.size());
            int i = 0;
            HashSet<String> overMaxLengthSchemeNames = new HashSet<String>(16);
            HashSet<String> overMaxLengthSchemeNumbers = new HashSet<String>(16);
            ArrayList<AbstractDataIntegration> copySchemes = new ArrayList<AbstractDataIntegration>(10);
            for (AbstractDataIntegration dataIntegrationObject : dataIntegrationObjects) {
                String number = dataIntegrationObject.getNumber();
                String name = dataIntegrationObject.getName();
                dataIntegrationObject.setId(ids[i++]);
                String copySchemeNumber = this.getCopySchemeName(existNumbers, number);
                if (copySchemeNumber == null) {
                    overMaxLengthSchemeNumbers.add(number);
                    continue;
                }
                String copySchemeName = this.getCopySchemeName(existNames, name);
                if (copySchemeName == null) {
                    overMaxLengthSchemeNames.add(name);
                    continue;
                }
                dataIntegrationObject.setNumber(copySchemeNumber);
                dataIntegrationObject.setName(copySchemeName);
                copySchemes.add(dataIntegrationObject);
            }
            if (overMaxLengthSchemeNumbers.size() > 0) {
                msg.append(ResManager.loadResFormat((String)"\u5df2\u8df3\u8fc7\u7f16\u7801\u8d85\u957f\u7684\u65b9\u6848\u201c%1\u201d\u3002", (String)"", (String)"epm-eb-formplugin", (Object[])new Object[]{StringUtils.join((Object[])overMaxLengthSchemeNumbers.toArray(), (String)",")}));
            }
            if (overMaxLengthSchemeNames.size() > 0) {
                msg.append(ResManager.loadResFormat((String)"\u5df2\u8df3\u8fc7\u540d\u79f0\u8d85\u957f\u7684\u65b9\u6848\u201c%1\u201d\u3002", (String)"", (String)"epm-eb-formplugin", (Object[])new Object[]{StringUtils.join((Object[])overMaxLengthSchemeNames.toArray(), (String)",")}));
            }
            return this.saveIntegrationScheme(copySchemes);
        }
        return 0;
    }

    public int saveIntegrationScheme(List<AbstractDataIntegration> dataIntegrationObjects) {
        int count = 0;
        if (CollectionUtils.isNotEmpty(dataIntegrationObjects)) {
            ArrayList<DynamicObject> objectList = new ArrayList<DynamicObject>(10);
            for (AbstractDataIntegration dataIntegration : dataIntegrationObjects) {
                DataIntegrationType integrationType = dataIntegration.getIntegrationType();
                DynamicObject newObject = BusinessDataServiceHelper.newDynamicObject((String)integrationType.getEntityName());
                newObject.set("id", (Object)dataIntegration.getId());
                newObject.set("number", (Object)dataIntegration.getNumber());
                newObject.set("name", (Object)dataIntegration.getName());
                newObject.set("status", (Object)false);
                newObject.set("type", (Object)integrationType.getVal());
                newObject.set("modelid", (Object)dataIntegration.getModelid());
                newObject.set("datasetid", (Object)dataIntegration.getDatasetid());
                newObject.set("bizmodel", (Object)dataIntegration.getBizModelId());
                newObject.set("executescheme", (Object)dataIntegration.getExecuteSchemeId());
                if (integrationType == DataIntegrationType.INPUT) {
                    newObject.set("schemetype", (Object)dataIntegration.getScheme().getVal());
                }
                if (dataIntegration instanceof DataIntegrationOut) {
                    this.saveCusSchemeSpecialInfo((DataIntegrationOut)dataIntegration, newObject);
                } else if (dataIntegration instanceof DataIntegration) {
                    this.saveCusSchemeSpecialInfo((DataIntegration)dataIntegration, newObject);
                } else if (dataIntegration instanceof GLDataIntegration) {
                    this.saveGLSchemeSpecialInfo((GLDataIntegration)dataIntegration, newObject);
                } else if (dataIntegration instanceof BcmDataIntegration) {
                    this.saveBCMSchemeSpecialInfo((BcmDataIntegration)dataIntegration, newObject);
                }
                DynamicObjectCollection interRange = newObject.getDynamicObjectCollection("interangeentry");
                interRange.clear();
                List<IntegrationRange> integrationRanges = dataIntegration.getIntegrationRanges();
                if (CollectionUtils.isNotEmpty(integrationRanges)) {
                    for (IntegrationRange integrationRange : integrationRanges) {
                        DynamicObject range = interRange.addNew();
                        DataIntegrationGetValType getValType = integrationRange.getGetValType();
                        List<MemberCondition> rangeMembers = integrationRange.getRangeMembers();
                        range.set("rangedimnum", (Object)integrationRange.getDimNumber());
                        range.set("rangegetvalway", (Object)getValType.getVal());
                        if (getValType != DataIntegrationGetValType.SCHEME || !CollectionUtils.isNotEmpty(rangeMembers)) continue;
                        range.set("rangememrangejson", (Object)SerializationUtils.toJsonString(rangeMembers));
                    }
                }
                objectList.add(newObject);
                ++count;
            }
            if (objectList.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])objectList.toArray(new DynamicObject[0]));
            }
        }
        return count;
    }

    private void saveBCMSchemeSpecialInfo(BcmDataIntegration dataIntegration, DynamicObject newObject) {
        newObject.set("srcmodel", (Object)dataIntegration.getSrcModelId());
        newObject.set("srcorgview", (Object)dataIntegration.getSrcOrgViewId());
        DynamicObjectCollection sourceOrgMembers = newObject.getDynamicObjectCollection("srcrangememrecord");
        sourceOrgMembers.clear();
        List<SimpleObject> srcRangeMembers = dataIntegration.getSrcRangeMembers();
        if (CollectionUtils.isNotEmpty(srcRangeMembers)) {
            for (SimpleObject srcRangeMember : srcRangeMembers) {
                DynamicObject srcMem = sourceOrgMembers.addNew();
                srcMem.set("fbasedataid", (Object)srcRangeMember.getId());
            }
        }
        DynamicObjectCollection dimMapEntry = newObject.getDynamicObjectCollection("bcmdimmapentity");
        dimMapEntry.clear();
        List<DataIntegrationDimMap> firstDimMap = dataIntegration.getFirstDimMap();
        if (CollectionUtils.isNotEmpty(firstDimMap)) {
            for (DataIntegrationDimMap dataIntegrationDimMap : firstDimMap) {
                DynamicObject dimEntry = dimMapEntry.addNew();
                dimEntry.set("bcmdimsourcenumber", (Object)dataIntegrationDimMap.getDimsource());
                dimEntry.set("bcmpointsourcemem", (Object)dataIntegrationDimMap.getSourceFixVal());
                dimEntry.set("bcmdimtarnumber", (Object)dataIntegrationDimMap.getDimtarget());
                dimEntry.set("bcmdimmemmap", (Object)dataIntegrationDimMap.getDimmembmapid());
                dimEntry.set("bcmpointtarmem", (Object)dataIntegrationDimMap.getDimmembnum());
            }
        }
    }

    private void saveGLSchemeSpecialInfo(GLDataIntegration dataIntegration, DynamicObject newObject) {
        newObject.set("getdatatype", (Object)dataIntegration.getGetDataType().getVal());
        newObject.set("calculatemodel", (Object)dataIntegration.getCalculateModel());
        newObject.set("calculateview", (Object)dataIntegration.getCalculateView());
        DynamicObjectCollection calOrgs = newObject.getDynamicObjectCollection("calculateorgmem");
        calOrgs.clear();
        List<SimpleObject> calculateOrgMembers = dataIntegration.getCalculateOrgMembers();
        if (CollectionUtils.isNotEmpty(calculateOrgMembers)) {
            for (SimpleObject calculateOrgMember : calculateOrgMembers) {
                DynamicObject mem = calOrgs.addNew();
                mem.set("fbasedataid", (Object)calculateOrgMember.getId());
            }
        }
        newObject.set("accounttable", (Object)dataIntegration.getAccountTable());
        newObject.set("accountbooktype", (Object)dataIntegration.getAccountBookType());
        newObject.set("calculateperiodtype", (Object)dataIntegration.getCalculatePeriodType());
        newObject.set("currency", (Object)dataIntegration.getCurrencyIdStr());
        newObject.set("includecepl", (Object)dataIntegration.isIncludeCEPL());
        DynamicObjectCollection dimMapSchemes = newObject.getDynamicObjectCollection("dimmapscheme_entry");
        dimMapSchemes.clear();
        List<IntegrationDimMapGroup> dimMapGroups = dataIntegration.getDimMapGroups();
        if (CollectionUtils.isNotEmpty(dimMapGroups)) {
            for (IntegrationDimMapGroup dimMapGroup : dimMapGroups) {
                List<DataIntegrationDimMap> memberMaps;
                DynamicObject mapScheme = dimMapSchemes.addNew();
                mapScheme.set("mapschemetitle", (Object)dimMapGroup.getTitle());
                mapScheme.set("mapschemelevel", (Object)dimMapGroup.getLevel());
                List<GLMapCondition> condition = dimMapGroup.getCondition();
                if (CollectionUtils.isNotEmpty(condition)) {
                    mapScheme.set("dimmapconditionjson", (Object)SerializationUtils.toJsonString(condition));
                }
                if (!CollectionUtils.isNotEmpty(memberMaps = dimMapGroup.getMemberMaps())) continue;
                mapScheme.set("dimmemmapjson", (Object)SerializationUtils.toJsonString(memberMaps));
            }
        }
    }

    private void saveCusSchemeSpecialInfo(DataIntegration dataIntegration, DynamicObject newObject) {
        newObject.set("srcsinglemetric", (Object)dataIntegration.getSrcsinglemetric());
        newObject.set("targetsys", (Object)dataIntegration.getTargetsysId());
        newObject.set("sourcesys", (Object)dataIntegration.getSourcesysId());
        DynamicObjectCollection dimMapEntry = newObject.getDynamicObjectCollection("dimmapentity");
        dimMapEntry.clear();
        List<DataIntegrationDimMap> dimMapGroups = dataIntegration.getFirstDimMap();
        if (CollectionUtils.isNotEmpty(dimMapGroups)) {
            for (DataIntegrationDimMap dimMapGroup : dimMapGroups) {
                DynamicObject mapInfo = dimMapEntry.addNew();
                mapInfo.set("dimsource", (Object)dimMapGroup.getDimsource());
                if (dataIntegration instanceof DataIntegrationOut) {
                    mapInfo.set("dimsourcename", (Object)dimMapGroup.getDimsourcename());
                    mapInfo.set("dimattr", (Object)(dimMapGroup.isUseSourceFieldName() ? "name" : "number"));
                    mapInfo.set("fixedmember", (Object)dimMapGroup.getDimmember());
                } else {
                    mapInfo.set("dimmember", (Object)dimMapGroup.getDimmember());
                }
                mapInfo.set("dimtarget", (Object)dimMapGroup.getDimtarget());
                mapInfo.set("dimtargetname", (Object)dimMapGroup.getDimtargetname());
                mapInfo.set("dimmembmap", (Object)dimMapGroup.getDimmembmapid());
                mapInfo.set("dimmembnum", (Object)dimMapGroup.getDimmembnum());
            }
        }
        if (dataIntegration instanceof DataIntegrationOut) {
            DataIntegrationOut dataIntegrationOut = (DataIntegrationOut)dataIntegration;
            newObject.set("pkfield", (Object)dataIntegrationOut.getMainPkField());
            newObject.set("easmodel", (Object)dataIntegrationOut.getEasModelNumber());
            newObject.set("easeditstatus", (Object)dataIntegrationOut.getEasEditStatus());
            newObject.set("targetobj", (Object)dataIntegrationOut.getTargetobjId());
            this.reBuildCusOutputSchemeTableRouter(newObject, dimMapEntry, dataIntegrationOut);
        } else {
            newObject.set("sourceobj", (Object)dataIntegration.getSourceobjId());
            this.reBuildCusInputSchemeTableRouter(dataIntegration, newObject);
            newObject.set("srcmetrictype", (Object)dataIntegration.getSrcmetrictype());
            List<DataIntegrationMetricMap> metMapList = dataIntegration.getMetMapList();
            if (CollectionUtils.isNotEmpty(metMapList)) {
                DynamicObjectCollection metricEntity = newObject.getDynamicObjectCollection("metricmapentity");
                metricEntity.clear();
                for (DataIntegrationMetricMap metricMap : metMapList) {
                    DynamicObject metricEntry = metricEntity.addNew();
                    metricEntry.set("metricsource", (Object)metricMap.getMetricsource());
                    metricEntry.set("metrictargetname", (Object)metricMap.getMetrictargetname());
                    metricEntry.set("metrictarget", (Object)metricMap.getMetrictarget());
                }
            }
        }
    }

    public void reBuildCusOutputSchemeTableRouter(DynamicObject newObject, DynamicObjectCollection dimMapEntry, DataIntegrationOut dataIntegrationOut) {
        DataIntegrationPlan plan = DataIntegrationService.getInstance().createOutPlan(dataIntegrationOut.getId(), dataIntegrationOut.getModelid(), dataIntegrationOut.getDatasetid(), dataIntegrationOut.getSourcesysId(), dataIntegrationOut.getTargetobjId(), dimMapEntry, dataIntegrationOut.getSrcsinglemetric(), dataIntegrationOut.getMainPkField());
        newObject.set("sourceobj", (Object)plan.getSrcObjId());
        newObject.set("tablename", (Object)plan.getTableName());
        newObject.set("triggerid", (Object)plan.getTriggerId());
    }

    public void reBuildCusInputSchemeTableRouter(DataIntegration dataIntegration, DynamicObject newObject) {
        DataIntegrationPlan plan = DataIntegrationService.getInstance().createPlan(dataIntegration.getId(), dataIntegration.getModelid(), dataIntegration.getDatasetid(), dataIntegration.getSourceobjId(), dataIntegration.getTargetsysId());
        newObject.set("targetobj", (Object)plan.getTargetObjId());
        newObject.set("tablename", (Object)plan.getTableName());
        newObject.set("triggerid", (Object)plan.getTriggerId());
    }

    public void deleteCusIntegrationSchemeTableRouter(List<Long> schemeIds) {
        DeleteServiceHelper.delete((String)"eb_integration_router", (QFilter[])new QFilter("scheme", "in", schemeIds).toArray());
    }

    private String getCopySchemeName(Set<String> existNames, String name) {
        String copyName = name + "copy";
        int i = 1;
        while (existNames.contains(copyName)) {
            copyName = name + "copy" + i++;
        }
        if (copyName.length() > 50) {
            return null;
        }
        return copyName;
    }

    private static class InnerClass {
        private static DataIntegrationStoreService instance = new DataIntegrationStoreService();

        private InnerClass() {
        }
    }
}

