/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.dataintegration.service;

import kd.epm.eb.business.dataintegration.entity.AbstractDataIntegration;
import kd.epm.eb.business.dataintegration.entity.context.IntegrationContext;
import kd.epm.eb.business.dataintegration.service.handler.BcmDataIntegrationHandler;
import kd.epm.eb.business.dataintegration.service.handler.CusDataIntegrationHandler;
import kd.epm.eb.business.dataintegration.service.handler.CusDataOutIntegrationHandler;
import kd.epm.eb.business.dataintegration.service.handler.DataIntegrationHandler;
import kd.epm.eb.business.dataintegration.service.handler.DefaultIntegrationHandler;
import kd.epm.eb.business.dataintegration.service.handler.GlDataIntegrationHandler;
import kd.epm.eb.common.dataintegration.DataIntegrationType;
import kd.epm.eb.common.dataintegration.IntegrationSchemeType;

public class IntegrationHandlerFactory {
    public static DataIntegrationHandler getHandler(IntegrationContext context, AbstractDataIntegration dataIntegration) {
        DataIntegrationHandler handler = null;
        if (context != null && dataIntegration != null) {
            IntegrationSchemeType scheme = dataIntegration.getScheme();
            DataIntegrationType integrationType = dataIntegration.getIntegrationType();
            if (scheme == IntegrationSchemeType.CUSTOM) {
                handler = integrationType == DataIntegrationType.INPUT ? new CusDataIntegrationHandler() : new CusDataOutIntegrationHandler();
            } else if (scheme == IntegrationSchemeType.BCM) {
                handler = new BcmDataIntegrationHandler();
            } else if (scheme == IntegrationSchemeType.GL) {
                handler = new GlDataIntegrationHandler();
            }
        }
        if (handler == null) {
            handler = new DefaultIntegrationHandler();
        }
        handler.setDataIntegration(dataIntegration);
        return handler;
    }
}

