/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.dataintegration.service.handler;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.epm.eb.business.dataintegration.entity.AbstractDataIntegration;
import kd.epm.eb.business.dataintegration.entity.BcmDataIntegration;
import kd.epm.eb.business.dataintegration.entity.BcmDataQParam;
import kd.epm.eb.business.dataintegration.entity.BcmPYParam;
import kd.epm.eb.business.dataintegration.entity.DataIntegrationDimMap;
import kd.epm.eb.business.dataintegration.entity.DataIntegrationQuery;
import kd.epm.eb.business.dataintegration.entity.context.BcmIntegrationCusContext;
import kd.epm.eb.business.dataintegration.entity.context.IntegrationContext;
import kd.epm.eb.business.dataintegration.entity.context.IntegrationCusContext;
import kd.epm.eb.business.dataintegration.service.DataIntegrationDataService;
import kd.epm.eb.business.dataintegration.service.DataIntegrationInService;
import kd.epm.eb.business.dataintegration.service.handler.DataInIntegrationHandler;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.common.utils.SqlBatchUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.olap.api.metadata.IKDCell;
import org.apache.commons.lang3.StringUtils;

public class BcmDataIntegrationHandler
extends DataInIntegrationHandler {
    private List<BcmPYParam> toReadPeriods;
    private BcmDataQParam qParam;
    private String fixScenarioNumber;
    private String modelNumber;
    private boolean emptyFilter = false;
    private Map<String, Set<String>> bcmMemberPerm;
    private String noPermDimMemberStr;

    @Override
    public IntegrationCusContext init(IntegrationContext globalContext) {
        IntegrationCusContext cusContext = super.init(globalContext);
        BcmDataIntegration bcmDataIntegration = this.getBcmDataIntegration();
        this.initScenarioNumber(bcmDataIntegration);
        this.modelNumber = (String)CommonServiceHelper.getValueFromDB((String)"bcm_model", (String)"number", (String)"id", (Object[])new Object[]{bcmDataIntegration.getSrcModelId()});
        this.qParam = new BcmDataQParam();
        this.qParam.setIgnorePermission(true);
        Map<String, List<BcmDataQParam.MemberRange>> bcmFilterParamMap = DataIntegrationInService.getInstance().getBcmFilterParamMap(this.getMemberFilters(), bcmDataIntegration, this.getMemberMap());
        bcmFilterParamMap.remove(SysDimensionEnum.Scenario.getNumber());
        ArrayList<BcmDataQParam.MemberRange> allFilterMembers = new ArrayList<BcmDataQParam.MemberRange>(16);
        bcmFilterParamMap.forEach((dimNum, members) -> {
            if (members.isEmpty()) {
                log.info("dim filter empty :" + dimNum);
                this.emptyFilter = true;
            } else {
                allFilterMembers.addAll((Collection<BcmDataQParam.MemberRange>)members);
            }
        });
        this.qParam.setFilters(allFilterMembers);
        this.initReadPeriods(allFilterMembers);
        HashMap<String, String> fixDim = new HashMap<String, String>(3);
        fixDim.put(SysDimensionEnum.Scenario.getNumber(), this.fixScenarioNumber);
        this.qParam.setFixDim(fixDim);
        this.qParam.setShowDims(this.selShowDimNumbers(bcmDataIntegration));
        this.loadBcmMemberPerm();
        return new BcmIntegrationCusContext(cusContext);
    }

    @Override
    public Map<String, Long> getSchemeDimviewMap(AbstractDataIntegration dataIntegration, List<DataIntegrationQuery> filters) {
        HashMap<String, Long> resultMap = this.getCommonView(dataIntegration, filters);
        DynamicObject object = dataIntegration.getObject();
        DynamicObjectCollection dimmapentity = object.getDynamicObjectCollection("bcmdimmapentity");
        if (CollectionUtils.isNotEmpty((Collection)dimmapentity)) {
            for (DynamicObject dynamicObject : dimmapentity) {
                DynamicObject viewObj = dynamicObject.getDynamicObject("bcmpointtarmemview");
                if (viewObj == null) continue;
                String dimmembnum = dynamicObject.getString("bcmdimtarnumber");
                resultMap.put(dimmembnum, viewObj.getLong("id"));
            }
        }
        return resultMap;
    }

    @Override
    public boolean readData(IntegrationContext globalContext, IntegrationCusContext cusContext) {
        if (this.emptyFilter) {
            return true;
        }
        BcmIntegrationCusContext bcmCusContext = this.getBcmCusContext(cusContext);
        BcmDataQParam qParam = this.getqParam();
        List<BcmPYParam> readPeriods = this.getToReadPeriods();
        int currentPeriodIndex = bcmCusContext.getCurrentPeriodIndex();
        if (currentPeriodIndex < readPeriods.size()) {
            BcmPYParam pyParam = readPeriods.get(currentPeriodIndex);
            qParam.getFixDim().put(SysDimensionEnum.Year.getNumber(), pyParam.getYearNumber());
            qParam.getFixDim().put(SysDimensionEnum.Period.getNumber(), pyParam.getPeriodNumber());
            Map result = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"bcm", (String)"OlapDataQueryMsService", (String)"queryData", (Object[])new Object[]{this.modelNumber, SerializationUtils.toJsonString((Object)qParam)});
            boolean success = (Boolean)result.get("success");
            Map data = (Map)result.get("data");
            if (!success || data == null) {
                throw new KDBizException(SerializationUtils.toJsonString((Object)result));
            }
            List rowsData = (List)data.get("datas");
            Set dimNumbers = (Set)data.get("dimension");
            HashMap<String, Integer> dimIndexMap = new HashMap<String, Integer>(dimNumbers.size());
            int index = 0;
            for (String dimNum : dimNumbers) {
                dimIndexMap.put(dimNum, index++);
            }
            bcmCusContext.setSourceRowData(rowsData);
            bcmCusContext.setDimIndex(dimIndexMap);
            ++currentPeriodIndex;
            bcmCusContext.setCurrentPY(pyParam);
        }
        bcmCusContext.setCurrentPeriodIndex(currentPeriodIndex);
        return currentPeriodIndex >= readPeriods.size();
    }

    private List<String> selShowDimNumbers(BcmDataIntegration bcmDataIntegration) {
        LinkedList<String> showDimNumbers = new LinkedList<String>();
        bcmDataIntegration.getFirstDimMap().forEach(map -> {
            if (StringUtils.isNotEmpty((CharSequence)map.getDimsource())) {
                showDimNumbers.add(map.getDimsource());
            }
        });
        return showDimNumbers;
    }

    private void initReadPeriods(List<BcmDataQParam.MemberRange> bcmFilterParamMap) {
        ArrayList<String> pNumbers = new ArrayList<String>(15);
        ArrayList<String> yNumbers = new ArrayList<String>(15);
        Iterator<BcmDataQParam.MemberRange> iterator = bcmFilterParamMap.iterator();
        while (iterator.hasNext()) {
            BcmDataQParam.MemberRange memberRange = iterator.next();
            if (memberRange.getDim().equals(SysDimensionEnum.Period.getNumber())) {
                pNumbers.addAll(memberRange.getVal());
                iterator.remove();
                continue;
            }
            if (!memberRange.getDim().equals(SysDimensionEnum.Year.getNumber())) continue;
            yNumbers.addAll(memberRange.getVal());
            iterator.remove();
        }
        this.toReadPeriods = new ArrayList<BcmPYParam>(16);
        if (pNumbers.size() > 0 && yNumbers.size() > 0) {
            for (String yNum : yNumbers) {
                for (String pNum : pNumbers) {
                    this.toReadPeriods.add(new BcmPYParam(pNum, yNum));
                }
            }
        }
    }

    private void initScenarioNumber(BcmDataIntegration bcmDataIntegration) {
        for (DataIntegrationDimMap dimMap : bcmDataIntegration.getFirstDimMap()) {
            if (!SysDimensionEnum.Scenario.getNumber().equals(dimMap.getDimsource())) continue;
            this.fixScenarioNumber = dimMap.getSourceFixVal();
            break;
        }
    }

    @Override
    public void convertData(IntegrationContext globalContext, IntegrationCusContext cusContext) {
        cusContext.setTargetRowData(this.coverToEbData(globalContext, cusContext));
    }

    @Override
    protected void selToKdCell(List<IKDCell> kdCells, String[] dimMemberNums, Object row, int metricIndex, Dimension metricDim, IntegrationCusContext cusContext) {
        List rowData = (List)row;
        Object val = rowData.get(rowData.size() - 1);
        DataIntegrationDataService.getInstance().metricSingleMapper(kdCells, val, dimMemberNums, metricIndex, metricDim);
    }

    @Override
    protected Pair<String, String> getFieldValue(Object row, IntegrationCusContext param, String fieldStr) {
        if (row != null) {
            BcmIntegrationCusContext bcmCusContext = this.getBcmCusContext(param);
            String val = null;
            if (SysDimensionEnum.Period.getNumber().equals(fieldStr)) {
                val = bcmCusContext.getCurrentPY().getPeriodNumber();
            } else if (SysDimensionEnum.Year.getNumber().equals(fieldStr)) {
                val = bcmCusContext.getCurrentPY().getYearNumber();
            } else if (SysDimensionEnum.Scenario.getNumber().equals(fieldStr)) {
                val = this.fixScenarioNumber;
            } else {
                List rowData = (List)row;
                Integer dimIndex = bcmCusContext.getDimIndex().get(fieldStr);
                if (dimIndex != null) {
                    val = (String)rowData.get(dimIndex);
                }
            }
            if (val != null) {
                return new Pair((Object)fieldStr, (Object)val);
            }
        }
        return null;
    }

    public BcmDataIntegration getBcmDataIntegration() {
        return (BcmDataIntegration)this.getDataIntegration();
    }

    private BcmIntegrationCusContext getBcmCusContext(IntegrationCusContext context) {
        return (BcmIntegrationCusContext)context;
    }

    public BcmDataQParam getqParam() {
        return this.qParam;
    }

    public List<BcmPYParam> getToReadPeriods() {
        if (this.toReadPeriods == null) {
            this.toReadPeriods = new ArrayList<BcmPYParam>(1);
        }
        return this.toReadPeriods;
    }

    @Override
    protected String getNumberByDefaultMap(Object rowData, IntegrationCusContext param, String sourceVal, String sourceField) {
        String result = null;
        if (SysDimensionEnum.Year.getNumber().equals(sourceField)) {
            result = this.getBcmCusContext(param).getCurrentPY().getEbPeriodStr();
        }
        return result;
    }

    @Override
    public void selDataToLog(String logKey, Map<String, Object> logData) {
        super.selDataToLog(logKey, logData);
        logData.put("toReadPeriods", this.toReadPeriods);
        logData.put("qParam", this.qParam);
        logData.put("fixScenarioNumber", this.fixScenarioNumber);
        logData.put("modelNumber", this.modelNumber);
    }

    private void loadBcmMemberPerm() {
        if (CommonUtils.checkBcmJCDataPerm((Long)this.getModelId(), (boolean)false)) {
            this.bcmMemberPerm = new HashMap<String, Set<String>>(16);
            HashSet noPermDimMemberSet = new HashSet(16);
            this.getBcmDataIntegration().getFirstDimMap().forEach(dimMap -> {
                Set<String> permMemberNumbers;
                String bcmDim = dimMap.getDimsource();
                if (StringUtils.isNotEmpty((CharSequence)bcmDim) && (permMemberNumbers = this.loadBcmMemberPerm(bcmDim)) != null) {
                    String fixBcmMember = dimMap.getSourceFixVal();
                    if (StringUtils.isNotEmpty((CharSequence)fixBcmMember) && !permMemberNumbers.contains(fixBcmMember)) {
                        noPermDimMemberSet.add(bcmDim + "-" + fixBcmMember);
                    } else {
                        this.bcmMemberPerm.put(bcmDim, permMemberNumbers);
                    }
                }
            });
            Set<String> permMemberNumbers = this.loadBcmMemberPerm(SysDimensionEnum.Period.getNumber());
            if (permMemberNumbers != null) {
                this.bcmMemberPerm.put(SysDimensionEnum.Period.getNumber(), permMemberNumbers);
            }
            if (noPermDimMemberSet.size() > 0) {
                this.noPermDimMemberStr = String.join((CharSequence)",", noPermDimMemberSet);
            }
        }
    }

    private Set<String> loadBcmMemberPerm(String dimNumber) {
        HashMap params = Maps.newHashMap();
        HashSet result = null;
        String memberTable = (String)CommonServiceHelper.getValueFromDB((String)"bcm_dimension", (String)"membertable", (String)"number,model", (Object[])new Object[]{dimNumber, this.getBcmDataIntegration().getSrcModelId()});
        if (memberTable != null) {
            params.put("modelNum", this.modelNumber);
            params.put("dimNum", dimNumber);
            params.put("permType", "R");
            params.put("userId", UserUtils.getUserId());
            Long viewId = this.getBcmDataIntegration().getSrcOrgViewId();
            String viewNumber = null;
            if (viewId != null) {
                viewNumber = (String)CommonServiceHelper.getValueFromDB((String)"bcm_cslscheme", (String)"number", (String)"id", (Object[])new Object[]{this.getBcmDataIntegration().getSrcOrgViewId()});
            }
            params.put("schemeNum", viewNumber);
            Set permMemberIds = (Set)DispatchServiceHelper.invokeBizService((String)"fi", (String)"bcm", (String)"MemberQueryMsService", (String)"queryMembers", (Object[])new Object[]{SerializationUtils.toJsonString((Object)params)});
            if (permMemberIds != null) {
                HashSet memberNumberSet = new HashSet(permMemberIds.size());
                String sql = "select fnumber from " + memberTable + " where fid in (" + SqlBatchUtils.getBatchParamsSql((int)1000) + ")";
                ArrayList idParams = new ArrayList(permMemberIds);
                SqlBatchUtils.batchQuery((String)sql, (DBRoute)BgBaseConstant.bcm, idParams, (int)0, (rowMeta, row) -> memberNumberSet.add(row.getString("fnumber")));
                result = memberNumberSet;
            }
        }
        return result;
    }

    @Override
    protected String validateRow(Object rowData, IntegrationCusContext cusContext) {
        String errorStr = null;
        if (this.bcmMemberPerm != null) {
            StringBuilder sb = new StringBuilder();
            if (this.noPermDimMemberStr != null) {
                sb.append(this.noPermDimMemberStr).append(',');
            }
            this.bcmMemberPerm.forEach((dimNum, permMemberNum) -> {
                Pair<String, String> fieldValue = this.getFieldValue(rowData, cusContext, (String)dimNum);
                if (fieldValue != null && !permMemberNum.contains(fieldValue.p2)) {
                    sb.append((String)dimNum).append('-').append((String)fieldValue.p2).append(',');
                }
            });
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 1);
                errorStr = ResManager.loadResFormat((String)"\u6ca1\u6709\u5408\u5e76\u7ef4\u5ea6\u6210\u5458\u7684\u6743\u9650[%1]", (String)"BcmDataIntegrationHandler_1", (String)"epm-eb-business", (Object[])new Object[]{sb.toString()});
            }
        }
        return errorStr;
    }
}

