/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.dataintegration.service.handler;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.epm.eb.business.dataintegration.entity.AbstractDataIntegration;
import kd.epm.eb.business.dataintegration.entity.DataIntegration;
import kd.epm.eb.business.dataintegration.entity.DataIntegrationDimMap;
import kd.epm.eb.business.dataintegration.entity.ExecuteCondition;
import kd.epm.eb.business.dataintegration.entity.MemberMapPPO;
import kd.epm.eb.business.dataintegration.entity.context.EasOutIntegrationCusContext;
import kd.epm.eb.business.dataintegration.entity.context.IntegrationContext;
import kd.epm.eb.business.dataintegration.entity.context.IntegrationCusContext;
import kd.epm.eb.business.dataintegration.service.DataIntegrationOutService;
import kd.epm.eb.business.dataintegration.service.handler.DataIntegrationHandler;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.DataTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.olapdao.BgmdOlapReader;
import kd.epm.eb.common.olapdao.OlapReadOption;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.permission.membPerm.DimMemberPermChecker;
import kd.epm.eb.common.permission.membPerm.MemberItem;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.impl.metadata.KDCell;
import kd.epm.eb.olap.service.OlapManager;
import kd.epm.eb.olap.service.request.QueryRequest;
import kd.epm.eb.olap.utils.PageUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class CusDataOutIntegrationHandler
extends DataIntegrationHandler {
    private Map<Long, String> allIdValMap = new HashMap<Long, String>(16);
    private List<QueryRequest> subList;
    private boolean isEas;
    private String insertSqlStr;
    private String upSqlStr;
    private boolean toEas;
    private String dsNumber;
    private String valueKey;
    private static final String service = "facade://com.kingdee.eas.ma.mbg.app.MbgDataSynFacade:synBgData";
    private Map<String, Integer> colLengthMap = new HashMap<String, Integer>(16);
    private Map<String, Object> easMethodParam = Maps.newHashMapWithExpectedSize((int)4);
    private DimMemberPermChecker permChecker;

    @Override
    public IntegrationCusContext init(IntegrationContext globalContext) {
        IntegrationCusContext cusContext = super.init(globalContext);
        DataIntegration dataIntegration = this.getEasDataIntegration();
        DynamicObject integrationObject = dataIntegration.getObject();
        DynamicObject tarObj = integrationObject.getDynamicObject("targetobj");
        String tarType = tarObj.getString("type");
        this.isEas = tarType.equalsIgnoreCase("SERVICE") ? Boolean.TRUE : Boolean.FALSE;
        String targetObjType = tarObj.getString("type");
        this.toEas = !"TABLE".equalsIgnoreCase(targetObjType) && !"ENTITY".equalsIgnoreCase(targetObjType);
        IModelCacheHelper modelCache = this.getModelCacheHelper();
        Set<String> sourceDimNums = dataIntegration.getFirstDimMap().stream().map(DataIntegrationDimMap::getDimsource).collect(Collectors.toSet());
        int orgPageSize = CommonUtils.integraitonOrgPageSize((Long)this.getModelId());
        if (this.toEas) {
            Boolean easeditstatus = integrationObject.getBoolean("easeditstatus");
            this.dsNumber = integrationObject.getDynamicObject("targetsys").getString("number");
            this.easMethodParam.put("bgSchemeNumber", integrationObject.getString("easmodel"));
            this.easMethodParam.put("bgFormId", null);
            this.easMethodParam.put("isAuditData", easeditstatus);
            this.valueKey = "value";
        } else {
            this.valueKey = integrationObject.getString("srcsinglemetric");
        }
        String tableName = integrationObject.getString("tablename");
        this.initSqlInfo(tableName, dataIntegration, tarObj);
        Map<String, List<Member>> memberFilters = this.getMemberFilters();
        boolean hasEmptyDimFilter = false;
        for (Map.Entry<String, List<Member>> entry : memberFilters.entrySet()) {
            if (entry.getValue() == null || !entry.getValue().isEmpty()) continue;
            hasEmptyDimFilter = true;
            log.info(this.getDataIntegration().getNumber() + "--empty dim filter:" + entry.getKey());
        }
        if (hasEmptyDimFilter) {
            this.subList = new ArrayList<QueryRequest>(1);
        } else {
            SelectCommandInfo queryInfo = DataIntegrationOutService.getInstance().getSciInfo(dataIntegration.getDatasetid(), sourceDimNums, memberFilters, modelCache);
            this.subList = PageUtil.getSelectCommandInfoPage((SelectCommandInfo)queryInfo, (int)orgPageSize);
        }
        log.info("\u6309\u7ec4\u7ec7\u5206\u9875pageSize:" + this.subList.size());
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)("truncate table " + tableName));
        return new EasOutIntegrationCusContext(cusContext);
    }

    private void initSqlInfo(String tableName, DataIntegration dataIntegration, DynamicObject tarObj) {
        StringBuilder sbField = new StringBuilder();
        String pkfield = "f" + dataIntegration.getObject().getString("pkfield");
        sbField.append("insert into ").append(tableName).append("(");
        StringBuilder sbVal = new StringBuilder().append(" values (");
        for (DataIntegrationDimMap dimMap : dataIntegration.getFirstDimMap()) {
            String tarDimNumber = dimMap.getDimtarget();
            sbField.append("f").append(tarDimNumber.toLowerCase()).append(",");
            sbVal.append("?,");
        }
        String fieldSql = sbField.append('f').append(this.valueKey).append(',').append(pkfield).append(")").toString();
        String valSql = sbVal.append("?,?)").toString();
        this.insertSqlStr = fieldSql + valSql;
        this.upSqlStr = "update " + tableName + " set f" + this.valueKey + " = ? where " + pkfield + " = ?";
        if (tarObj != null) {
            DynamicObjectCollection propEntryRows = tarObj.getDynamicObjectCollection("prop_entryentity");
            for (DynamicObject row : propEntryRows) {
                int index2;
                int index1;
                String fieldKey = row.getString("prop_name");
                String dataType = row.getString("data_type");
                if (!StringUtils.isNotEmpty((CharSequence)dataType) || (index1 = dataType.lastIndexOf("(")) >= (index2 = dataType.lastIndexOf(")")) - 1) continue;
                String numberStr = dataType.substring(index1 + 1, index2);
                try {
                    this.colLengthMap.put(fieldKey, Integer.valueOf(numberStr));
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public boolean readData(IntegrationContext globalContext, IntegrationCusContext cusContext) {
        EasOutIntegrationCusContext easCusContext = this.getEasCusContext(cusContext);
        int currentCmdIndex = easCusContext.getCurrentCmdIndex();
        if (currentCmdIndex < this.subList.size()) {
            AbstractDataIntegration dataIntegration = this.getDataIntegration();
            IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
            QueryRequest queryRequest = this.subList.get(currentCmdIndex);
            log.info("\u53d1\u8d77olap\u67e5\u8be2\uff1a" + JSON.toJSONString((Object)queryRequest));
            long datasetid = dataIntegration.getDatasetid();
            List<String> dimNumberList = modelCacheHelper.getDimensionList(Long.valueOf(datasetid)).stream().map(BaseCache::getNumber).collect(Collectors.toList());
            queryRequest.setModelId(modelCacheHelper.getModelobj().getId());
            queryRequest.setDatasetId(Long.valueOf(datasetid));
            queryRequest.setSelectDims(dimNumberList);
            ArrayList cells = Lists.newArrayListWithExpectedSize((int)10000);
            OlapReadOption olapReadOption = new OlapReadOption();
            olapReadOption.setExcludeNull(false);
            DimMemberPermChecker _permChecker = this.getPermChecker(globalContext, dimNumberList);
            try (BgmdOlapReader reader = OlapManager.getInstance().queryReader(queryRequest, olapReadOption);){
                while (reader.hasNext()) {
                    Object[] row = reader.next();
                    IKDCell cell = KDCell.of((Object[])row);
                    if (cell == null) {
                        row[0] = " ";
                        cell = KDCell.of((Object[])row, (boolean)true);
                    }
                    if (!this.hasPerm(cell, _permChecker, dimNumberList)) continue;
                    cells.add(cell);
                }
            }
            easCusContext.setCurrentCmdIndex(++currentCmdIndex);
            easCusContext.setSourceRowData(cells);
        }
        return currentCmdIndex >= this.subList.size();
    }

    @Override
    public void convertData(IntegrationContext globalContext, IntegrationCusContext cusContext) {
        List sourceRowData = cusContext.getSourceRowData();
        IModelCacheHelper modelCache = this.getModelCacheHelper();
        AbstractDataIntegration dataIntegration = this.getDataIntegration();
        List dimensionList = modelCache.getDimensionList(dataIntegration.getDatasetid());
        List<DataIntegrationDimMap> dimMap = dataIntegration.getFirstDimMap();
        HashMap<String, Integer> dimIndexMap = new HashMap<String, Integer>(dimensionList.size());
        int index = 0;
        int metricIndex = -1;
        for (Dimension dimension : dimensionList) {
            if (SysDimensionEnum.Metric.getNumber().equals(dimension.getNumber())) {
                metricIndex = index;
            }
            dimIndexMap.put(dimension.getNumber(), index++);
        }
        Map<Long, MemberMapPPO> allMemberMap = this.getMemberMap();
        LinkedList tarList = new LinkedList();
        HashSet<Integer> numberCellsIndex = new HashSet<Integer>(16);
        HashSet<String> tarNameFieldSet = new HashSet<String>();
        block1: for (IKDCell cell : sourceRowData) {
            String value;
            String[] numberArr = cell.getMeta().getNumber();
            LinkedHashMap<String, String> tarMap = new LinkedHashMap<String, String>(numberArr.length);
            for (DataIntegrationDimMap mapRow : dimMap) {
                String tarField = mapRow.getDimtarget();
                if (!this.isEas) {
                    tarField = tarField.toLowerCase();
                }
                String sourceDimNum = mapRow.getDimsource();
                String targetFixVal = mapRow.getDimmembnum();
                boolean useNameMap = mapRow.isUseSourceFieldName();
                String fieldVal = null;
                if (StringUtils.isBlank((CharSequence)sourceDimNum)) {
                    if (StringUtils.isBlank((CharSequence)targetFixVal)) {
                        String failMsg = ResManager.loadResFormat((String)"EAS\u6210\u5458\u6620\u5c04\u65e0\u6cd5\u5339\u914d\u4e14\u672a\u6307\u5b9a\u6210\u5458\u201c%1\u201d\u3002", (String)"DataIntegrationOutService_2", (String)"epm-eb-business", (Object[])new Object[]{tarField});
                        this.addDetailLog(failMsg, cell, cusContext);
                        continue block1;
                    }
                    fieldVal = targetFixVal;
                } else {
                    String srcMemberNumber = numberArr[(Integer)dimIndexMap.get(sourceDimNum)];
                    MemberMapPPO memberMapPPO = allMemberMap.get(mapRow.getDimmembmapid());
                    if (memberMapPPO != null) {
                        String toMapVal = srcMemberNumber;
                        if (memberMapPPO.getRefField() != null) {
                            toMapVal = toMapVal + "\u3002.&.\u3002" + numberArr[(Integer)dimIndexMap.get(memberMapPPO.getRefField())];
                        }
                        fieldVal = useNameMap ? memberMapPPO.getMemberMapVal(toMapVal, true) : memberMapPPO.getMemberMapVal(toMapVal, false);
                    }
                    if (useNameMap) {
                        tarNameFieldSet.add(tarField);
                    }
                    if (fieldVal == null) {
                        if (this.isEas) {
                            String failMsg = ResManager.loadResFormat((String)"EAS\u6210\u5458\u6620\u5c04\u65e0\u6cd5\u5339\u914d\u4e14\u672a\u6307\u5b9a\u6210\u5458\u201c%1\u201d\u3002", (String)"DataIntegrationOutService_2", (String)"epm-eb-business", (Object[])new Object[]{tarField});
                            this.addDetailLog(failMsg, cell, cusContext);
                            continue block1;
                        }
                        String tarVal = this.getTarValue(sourceDimNum, srcMemberNumber, useNameMap, modelCache);
                        if (tarVal == null) {
                            String failMsg = ResManager.loadResFormat((String)"\u7ef4\u5ea6\u6210\u5458\u4e0d\u5b58\u5728:%1-%2", (String)"CusDataOutIntegrationHandler_2", (String)"epm-eb-business", (Object[])new Object[]{sourceDimNum, srcMemberNumber});
                            this.addDetailLog(failMsg, cell, cusContext);
                            continue block1;
                        }
                        fieldVal = tarVal;
                    }
                }
                if (!this.checkValLength(this.valueKey, fieldVal, cell, cusContext)) continue block1;
                tarMap.put(tarField, fieldVal);
            }
            boolean isNumberRow = false;
            if (this.isEas) {
                value = cell.getValue().toString();
                tarMap.put(this.valueKey, value);
            } else {
                Date date;
                value = cell.getValue().toString();
                DataTypeEnum typeEnum = DataTypeEnum.UNCURRENCY;
                if (metricIndex != -1) {
                    String metricMemberNum = numberArr[metricIndex];
                    Member metricMember = modelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, metricMemberNum);
                    typeEnum = DataTypeEnum.getDataTypeEnumByIndex((String)metricMember.getDatatype());
                }
                if (DataTypeEnum.DATETP == typeEnum && (date = ConvertUtils.from((String)cell.getValue().toString())) != null) {
                    value = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
                }
                isNumberRow = typeEnum == DataTypeEnum.UNCURRENCY || typeEnum == DataTypeEnum.CURRENCY;
                tarMap.put(this.valueKey, value);
            }
            if (!this.checkValLength(this.valueKey, value, cell, cusContext)) continue;
            if (isNumberRow) {
                numberCellsIndex.add(tarList.size());
            }
            if (this.logAllMapData) {
                this.addDetailLog(null, cell, tarMap, cusContext);
            }
            tarList.add(tarMap);
        }
        cusContext.setTargetRowData(tarList);
        ((EasOutIntegrationCusContext)cusContext).setTarNameFieldSet(tarNameFieldSet);
        ((EasOutIntegrationCusContext)cusContext).setNumberCellsIndex(numberCellsIndex);
    }

    private boolean checkValLength(String fieldKey, String fieldVal, IKDCell rowData, IntegrationCusContext cusContext) {
        Integer maxLength = this.colLengthMap.get(fieldKey);
        if (maxLength != null && maxLength < fieldVal.length()) {
            String failMsg = ResManager.loadResFormat((String)"\u76ee\u6807\u503c\u957f\u5ea6\u8d85\u8fc7\u4e86\u76ee\u6807\u5b57\u6bb5\u7684\u6700\u5927\u957f\u5ea6\uff0c\u76ee\u6807\u5b57\u6bb5\uff1a%1(%2)\uff0c\u76ee\u6807\u503c\uff1a%3", (String)"CusDataOutIntegrationHandler_3", (String)"epm-eb-business", (Object[])new Object[]{fieldKey, maxLength, fieldVal});
            this.addDetailLog(failMsg, rowData, cusContext);
            return false;
        }
        return true;
    }

    @Override
    public void saveData(IntegrationContext globalContext, IntegrationCusContext cusContext, String schemeNumber) {
        EasOutIntegrationCusContext easCusContext = (EasOutIntegrationCusContext)cusContext;
        List tarList = cusContext.getTargetRowData();
        if (!this.toEas) {
            this.insertTable(tarList, easCusContext.getTarNameFieldSet(), easCusContext.getNumberCellsIndex());
        } else {
            this.toEas(tarList);
        }
    }

    private void insertTable(List<Map<String, String>> tarList, Set<String> tarNamefieldSet, Set<Integer> numberCellsIndex) {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(tarList.size());
        HashSet<Long> upIds = new HashSet<Long>(16);
        int index = -1;
        for (Map<String, String> tarMap : tarList) {
            ++index;
            ArrayList<String> memberNumberList = new ArrayList<String>(tarMap.size());
            for (Map.Entry<String, String> entry : tarMap.entrySet()) {
                String tarField = entry.getKey();
                if (tarNamefieldSet.contains(tarField) || this.valueKey.equals(tarField)) continue;
                memberNumberList.add(entry.getValue());
            }
            Long id2 = Hashing.sha256().hashString((CharSequence)StringUtils.join(memberNumberList, (String)";"), StandardCharsets.UTF_8).padToLong();
            String oldVal = this.allIdValMap.get(id2);
            String newValStr = tarMap.get(this.valueKey);
            boolean isNumberVal = numberCellsIndex.contains(index);
            if (oldVal != null) {
                if (!isNumberVal) continue;
                BigDecimal oldNumber = this.toNumber(oldVal);
                BigDecimal newNumber = this.toNumber(newValStr);
                BigDecimal newVal = oldNumber.add(newNumber);
                this.allIdValMap.put(id2, newVal.toPlainString());
                upIds.add(id2);
                continue;
            }
            this.allIdValMap.put(id2, isNumberVal ? newValStr : "");
            Object[] paramArr = new Object[]{};
            for (Map.Entry<String, String> entry : tarMap.entrySet()) {
                String tarDimNumber = entry.getKey().toLowerCase();
                paramArr = ArrayUtils.add((Object[])paramArr, (Object)tarMap.get(tarDimNumber));
            }
            paramArr = ArrayUtils.add((Object[])paramArr, (Object)id2);
            paramList.add(paramArr);
        }
        if (!paramList.isEmpty()) {
            log.info("executeBatch_size:" + paramList.size());
            DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)this.insertSqlStr, paramList);
        }
        if (upIds.size() > 0) {
            ArrayList toUpParamList = new ArrayList(upIds.size());
            upIds.forEach(id -> toUpParamList.add(new Object[]{this.allIdValMap.get(id), id}));
            log.info("executeBatch_up_size:" + toUpParamList.size());
            DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)this.upSqlStr, toUpParamList);
        }
    }

    private void toEas(List<Map<String, String>> tarList) {
        List<List<String>> bgDatas = this.getEasBgDatas(tarList);
        String example = CollectionUtils.isEmpty(bgDatas) ? "" : JSON.toJSONString(bgDatas.get(0));
        log.info("\u540c\u6b65\u5230EAS\u7684\u6570\u636e\u91cf\uff0cbgDatas size:" + bgDatas.size() + ",\u6570\u636e\u6837\u672c:" + example);
        this.easMethodParam.put("bgDatas", bgDatas);
        Map resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscMetaSchemaService", (String)"callService", (Object[])new Object[]{this.dsNumber, service, this.easMethodParam, null});
        log.info("\u6267\u884c\u96c6\u6210\u5bf9\u8c61\u8fd4\u56de\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)resultMap));
        if (!resultMap.containsKey("result")) {
            String errorMsg = JSON.toJSONString((Object)resultMap);
            log.error("\u6570\u636e\u96c6\u6210\u8f93\u51fa\u6267\u884c\u542f\u52a8\u65b9\u6848\u62a5\u9519:" + errorMsg);
            throw new KDBizException(errorMsg);
        }
    }

    private List<List<String>> getEasBgDatas(List<Map<String, String>> tarList) {
        ArrayList<List<String>> bgDatas = new ArrayList<List<String>>(tarList.size());
        for (Map<String, String> tarMap : tarList) {
            ArrayList<String> data = new ArrayList<String>(10);
            for (Map.Entry<String, String> entry : tarMap.entrySet()) {
                String dimNumber = entry.getKey();
                String memNumber = entry.getValue();
                if ("value".equals(dimNumber)) continue;
                data.add(dimNumber + ":" + memNumber);
            }
            data.add(tarMap.get("value"));
            bgDatas.add(data);
        }
        return bgDatas;
    }

    private String getTarValue(String dimNumber, String memberNumber, boolean useMemberName, IModelCacheHelper modelCache) {
        Member member = modelCache.getMemberByAnyView(dimNumber, memberNumber);
        if (member == null) {
            return null;
        }
        if (useMemberName) {
            return member.getName();
        }
        return member.getNumber();
    }

    private void toIscTrigger() {
        DynamicObject tr = BusinessDataServiceHelper.loadSingle((Object)this.getDataIntegration().getObject().getLong("triggerid.id"), (String)"isc_data_copy_trigger");
        String trNumber = tr.getString("number");
        Map resMap = (Map)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"ISCDataCopyService", (String)"syncExecute", (Object[])new Object[]{trNumber, new HashMap(1)});
        log.info("\u6267\u884c\u542f\u52a8\u65b9\u6848\u8fd4\u56de\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)resMap));
        Boolean success = MapUtils.getBoolean((Map)resMap, (Object)"success");
        if (!Objects.nonNull(success) || !success.booleanValue()) {
            String errorMsg = MapUtils.getString((Map)resMap, (Object)"msg");
            log.error("\u6570\u636e\u96c6\u6210\u8f93\u51fa\u6267\u884c\u542f\u52a8\u65b9\u6848\u62a5\u9519:" + errorMsg);
            throw new KDBizException(errorMsg);
        }
    }

    private EasOutIntegrationCusContext getEasCusContext(IntegrationCusContext cusContext) {
        return (EasOutIntegrationCusContext)cusContext;
    }

    private DataIntegration getEasDataIntegration() {
        return (DataIntegration)this.getDataIntegration();
    }

    @Override
    public void finish(IntegrationContext globalContext, IntegrationCusContext cusContext) {
        this.toIscTrigger();
        super.finish(globalContext, cusContext);
    }

    @Override
    Pair<String, String> getFieldValue(Object row, IntegrationCusContext param, String fieldStr) {
        return null;
    }

    @Override
    public void selDataToLog(String logKey, Map<String, Object> logData) {
        super.selDataToLog(logKey, logData);
        logData.put("isEas", this.isEas);
        logData.put("insertSqlStr", this.insertSqlStr);
        logData.put("upSqlStr", this.upSqlStr);
        logData.put("toEas", this.toEas);
        logData.put("dsNumber", this.dsNumber);
        logData.put("valueKey", this.valueKey);
    }

    private BigDecimal toNumber(String valStr) {
        BigDecimal result = null;
        try {
            result = new BigDecimal(valStr);
        }
        catch (Exception e) {
            result = BigDecimal.ZERO;
        }
        return result;
    }

    public DimMemberPermChecker getPermChecker(IntegrationContext globalContext, List<String> dimNumList) {
        ExecuteCondition executeCondition = globalContext.getExecuteCondition();
        if (this.permChecker == null && executeCondition.isFilterMemberPerm()) {
            this.permChecker = DimMembPermHelper.getPermChecker((Long)executeCondition.getModelId(), (Long)executeCondition.getBizModelId(), dimNumList, (Long)UserUtils.getUserId(), (DimMembPermType)DimMembPermType.READ);
        }
        return this.permChecker;
    }

    public boolean hasPerm(IKDCell cell, DimMemberPermChecker permChecker, List<String> dimNumList) {
        boolean result = false;
        if (permChecker == null || permChecker.hasAllPerm()) {
            result = true;
        } else {
            Map<String, MemberItem> memberGroup = this.toMemberItemMap(cell, dimNumList, null);
            result = permChecker.check(memberGroup);
        }
        return result;
    }
}

