/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.dataintegration.service.handler;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.eb.business.dataintegration.entity.AbstractDataIntegration;
import kd.epm.eb.business.dataintegration.entity.DataIntegration;
import kd.epm.eb.business.dataintegration.entity.DataIntegrationDimMap;
import kd.epm.eb.business.dataintegration.entity.DataIntegrationMetricMap;
import kd.epm.eb.business.dataintegration.entity.DataIntegrationQuery;
import kd.epm.eb.business.dataintegration.entity.ExecuteCondition;
import kd.epm.eb.business.dataintegration.entity.IntegrationDimMapGroup;
import kd.epm.eb.business.dataintegration.entity.IntegrationRange;
import kd.epm.eb.business.dataintegration.entity.MemberMapPPO;
import kd.epm.eb.business.dataintegration.entity.context.IntegrationContext;
import kd.epm.eb.business.dataintegration.entity.context.IntegrationCusContext;
import kd.epm.eb.business.dataintegration.service.handler.DataIntegrationHandler;
import kd.epm.eb.business.easupgrade.utils.IntegrationLogHelper;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.dataintegration.DataIntegrationGetValType;
import kd.epm.eb.common.elasticsearch.OlapDataAuditEventEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.olapdao.OlapContext;
import kd.epm.eb.common.olapdao.OlapWriteOption;
import kd.epm.eb.common.olapdao.SaveDataContext;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.permission.membPerm.DimMemberPermChecker;
import kd.epm.eb.common.permission.membPerm.MemberItem;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.olap.api.base.IKDValue;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.service.AlgoCalcUtils;
import kd.epm.eb.olap.service.OlapManager;
import kd.epm.eb.olap.service.request.SaveRequest;
import kd.epm.epbs.business.log.trace.OlapTraceServiceHelper;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

abstract class DataInIntegrationHandler
extends DataIntegrationHandler {
    private Set<String> incrSet = new HashSet<String>(16);
    private List<Dimension> ebDimList;
    private Map<String, Long> dimViewMap;
    private DimMemberPermChecker permChecker;

    DataInIntegrationHandler() {
    }

    @Override
    public IntegrationCusContext init(IntegrationContext globalContext) {
        super.init(globalContext);
        IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
        this.incrSet.clear();
        this.ebDimList = modelCacheHelper.getDimensionList(this.getDataIntegration().getDatasetid());
        this.dimViewMap = modelCacheHelper.getViewsByDataSet(this.getDataIntegration().getDatasetid());
        List<DataIntegrationQuery> filters = globalContext.getExecuteCondition().getFilters();
        Map<String, Long> schemeDimviewMap = this.getSchemeDimviewMap(this.getDataIntegration(), filters);
        if (!schemeDimviewMap.isEmpty()) {
            this.dimViewMap.putAll(schemeDimviewMap);
        }
        this.checkAndDelOldData(globalContext);
        return new IntegrationCusContext();
    }

    public Map<String, Long> getSchemeDimviewMap(AbstractDataIntegration dataIntegration, List<DataIntegrationQuery> filters) {
        return null;
    }

    @NotNull
    protected HashMap<String, Long> getCommonView(AbstractDataIntegration dataIntegration, List<DataIntegrationQuery> filters) {
        List<IntegrationRange> integrationRanges = dataIntegration.getIntegrationRanges();
        HashMap<String, Long> filterViewMap = new HashMap<String, Long>(16);
        if (CollectionUtils.isNotEmpty(filters)) {
            for (DataIntegrationQuery filter : filters) {
                if (!IDUtils.isNotNull((Long)filter.getViewId())) continue;
                filterViewMap.put(filter.getDimNumber(), filter.getViewId());
            }
        }
        HashMap<String, Long> resultMap = new HashMap<String, Long>(16);
        if (CollectionUtils.isNotEmpty(integrationRanges)) {
            for (IntegrationRange integrationRange : integrationRanges) {
                if (DataIntegrationGetValType.SCHEME == integrationRange.getGetValType() && StringUtils.isNotEmpty((CharSequence)integrationRange.getDimNumber())) {
                    MemberCondition memberCondition;
                    List<MemberCondition> rangeMembers = integrationRange.getRangeMembers();
                    if (!CollectionUtils.isNotEmpty(rangeMembers) || !IDUtils.isNotNull((Long)IDUtils.toLong((Object)(memberCondition = rangeMembers.get(0)).getViewId()))) continue;
                    resultMap.put(integrationRange.getDimNumber(), IDUtils.toLong((Object)memberCondition.getViewId()));
                    continue;
                }
                if (DataIntegrationGetValType.CONDITION != integrationRange.getGetValType() || !StringUtils.isNotEmpty((CharSequence)integrationRange.getDimNumber()) || !filterViewMap.containsKey(integrationRange.getDimNumber())) continue;
                resultMap.put(integrationRange.getDimNumber(), (Long)filterViewMap.get(integrationRange.getDimNumber()));
            }
        }
        return resultMap;
    }

    protected void checkAndDelOldData(IntegrationContext globalContext) {
        ExecuteCondition executeCondition = globalContext.getExecuteCondition();
        String delDataInfo = null;
        if (executeCondition.isDelOldData()) {
            try {
                List<DataIntegrationMetricMap> metMapList;
                AbstractDataIntegration dataIntegration = this.getDataIntegration();
                Set<Object> metricMembers = new HashSet(16);
                HashMap<String, Set> memberMap = new HashMap<String, Set>(16);
                List<IntegrationDimMapGroup> dimMapGroups = dataIntegration.getDimMapGroups();
                for (IntegrationDimMapGroup integrationDimMapGroup : dimMapGroups) {
                    for (DataIntegrationDimMap dataIntegrationDimMap : integrationDimMapGroup.getMemberMaps()) {
                        String dimNumber = dataIntegrationDimMap.getDimtarget();
                        String dimmember = dataIntegrationDimMap.getDimmembnum();
                        if (!StringUtils.isNotEmpty((CharSequence)dimmember)) continue;
                        if (StringUtils.equals((CharSequence)SysDimensionEnum.Metric.getNumber(), (CharSequence)dimNumber)) {
                            metricMembers.add(dimmember);
                            continue;
                        }
                        memberMap.computeIfAbsent(dimNumber, key -> new HashSet(16)).add(dimmember);
                    }
                }
                for (Map.Entry entry : this.getMemberFilters().entrySet()) {
                    String string = (String)entry.getKey();
                    HashSet memberSet = new HashSet(16);
                    ((List)entry.getValue()).forEach(member -> memberSet.add(member.getNumber()));
                    if (StringUtils.equals((CharSequence)SysDimensionEnum.Metric.getNumber(), (CharSequence)string)) {
                        metricMembers = memberSet;
                        continue;
                    }
                    memberMap.put(string, memberSet);
                }
                if (dataIntegration instanceof DataIntegration && !(metMapList = ((DataIntegration)dataIntegration).getMetMapList()).isEmpty()) {
                    metricMembers = metMapList.stream().map(DataIntegrationMetricMap::getMetrictarget).collect(Collectors.toSet());
                }
                String loginIp = RequestContext.getOrCreate().getLoginIP();
                RequestContext.getOrCreate().setLoginIP(loginIp);
                for (String string : metricMembers) {
                    ShrekOlapServiceHelper.deleteData((Long)this.getModelId(), (Long)dataIntegration.getDatasetid(), memberMap, (String)string);
                }
                HashMap<String, Set<Object>> hashMap = new HashMap<String, Set<Object>>(memberMap);
                hashMap.put(SysDimensionEnum.Metric.getNumber(), metricMembers);
                delDataInfo = ResManager.loadResFormat((String)"\u5220\u9664\u6761\u4ef6\uff1a%1\u3002", (String)"DataIntegrationDataService_12", (String)"epm-eb-business", (Object[])new Object[]{JSON.toJSONString(hashMap)});
            }
            catch (Exception e) {
                log.error("checkAndDelOldData", (Throwable)e);
                delDataInfo = ResManager.loadResFormat((String)"\u5220\u9664\u5931\u8d25\uff1a%1", (String)"DataIntegrationDataService_13", (String)"epm-eb-business", (Object[])new Object[]{e.getMessage()});
            }
        } else {
            delDataInfo = ResManager.loadKDString((String)"\u4e0d\u5220\u9664", (String)"DataIntegrationDataService_16", (String)"epm-eb-business", (Object[])new Object[0]);
        }
        IntegrationLogHelper.updateLogInfo(this.getMainLogId(), new String[]{"fdeletedatainfo"}, new Object[]{delDataInfo});
    }

    public List<IKDCell> coverToEbData(IntegrationContext globalContext, IntegrationCusContext param) {
        ArrayList<IKDCell> allCells = new ArrayList<IKDCell>(16);
        List sourceDataRows = param.getSourceRowData();
        if (sourceDataRows == null) {
            return allCells;
        }
        List<Dimension> ebDimList = this.getEbDimList();
        Map<String, Long> viewMap = this.getDimViewMap();
        int metricIndex = -1;
        Dimension metricDim = null;
        for (int index = 0; index < ebDimList.size(); ++index) {
            if (!SysDimensionEnum.Metric.getNumber().equals(ebDimList.get(index).getNumber())) continue;
            metricIndex = index;
            metricDim = ebDimList.get(index);
            break;
        }
        Map<Long, MemberMapPPO> srcDimMemberMapperMap = this.getMemberMap();
        ArrayList<IKDCell> cells = new ArrayList<IKDCell>(16);
        Long datasetId = this.getDataIntegration().getDatasetid();
        String[] dimMemberNums = null;
        for (Object row : sourceDataRows) {
            block20: {
                boolean match = true;
                String errMsg = this.validateRow(row, param);
                if (errMsg != null) {
                    match = Boolean.FALSE;
                } else {
                    cells.clear();
                    dimMemberNums = new String[ebDimList.size()];
                    int index = 0;
                    Map<String, DataIntegrationDimMap> dimMap4Target = this.getDimMaps(row, param);
                    if (dimMap4Target == null) {
                        errMsg = ResManager.loadKDString((String)"\u8be5\u884c\u6570\u636e\u672a\u5339\u914d\u4e0a\u7ef4\u5ea6\u6620\u5c04", (String)"DataInIntegrationHandler_1", (String)"epm-eb-business", (Object[])new Object[0]);
                        match = Boolean.FALSE;
                    } else {
                        for (Dimension dim : ebDimList) {
                            String ebDimNumber = dim.getNumber();
                            Long viewId = viewMap.get(ebDimNumber);
                            String targetDimMember = null;
                            DataIntegrationDimMap dimMap = dimMap4Target.get(ebDimNumber);
                            if (dimMap == null && !SysDimensionEnum.Metric.getNumber().equals(ebDimNumber)) {
                                throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u7ef4\u5ea6\u53d1\u751f\u53d8\u52a8\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u7ef4\u5ea6\u6620\u5c04\u3002", (String)"DataIntegrationDataService_4", (String)"epm-eb-business", (Object[])new Object[0]));
                            }
                            if (dimMap != null) {
                                String sourceField = dimMap.getDimsource();
                                Member member = null;
                                if (StringUtils.isBlank((CharSequence)sourceField)) {
                                    targetDimMember = dimMap.getDimmembnum();
                                    member = dim.getMember(viewId, targetDimMember);
                                    if (member == null || !member.isLeaf() || SysDimensionEnum.Account.getNumber().equals(ebDimNumber) && !datasetId.equals(member.getDatasetId())) {
                                        errMsg = ResManager.loadResFormat((String)"\u6307\u5b9a\u7684\u7ef4\u5ea6\u6210\u5458\u4e0d\u5b58\u5728\u6216\u975e\u660e\u7ec6,\u7ef4\u5ea6\uff1a%1,\u6210\u5458\uff1a%2", (String)"DataIntegrationDataService_19", (String)"epm-eb-business", (Object[])new Object[]{ebDimNumber, targetDimMember});
                                        match = Boolean.FALSE;
                                        break;
                                    }
                                } else {
                                    Pair<String, String> sourceValPair = this.getFieldValueNotNull(row, param, sourceField);
                                    MemberMapPPO memberMapPPO = srcDimMemberMapperMap.get(dimMap.getDimmembmapid());
                                    targetDimMember = this.getConfigNumber(dimMap, memberMapPPO, row, param, sourceValPair);
                                    String sourceVal = (String)sourceValPair.p2;
                                    String matchField = (String)sourceValPair.p1;
                                    if (StringUtils.isBlank((CharSequence)targetDimMember)) {
                                        if (this.canMapValByNumber(matchField, sourceVal, memberMapPPO)) {
                                            member = dim.getMember(viewId, sourceVal);
                                        }
                                    } else {
                                        member = dim.getMember(viewId, targetDimMember);
                                    }
                                    if (member == null || !member.isLeaf() || SysDimensionEnum.Account.getNumber().equals(ebDimNumber) && !datasetId.equals(member.getDatasetId())) {
                                        errMsg = ResManager.loadResFormat((String)"\u7ef4\u5ea6\u6210\u5458\u6ca1\u6709\u5339\u914d\u4e0a\u6216\u975e\u660e\u7ec6,\u76ee\u6807\u7ef4\u5ea6\uff1a%1,\u6e90\u5b57\u6bb5\u503c\uff1a%2", (String)"DataIntegrationDataService_5", (String)"epm-eb-business", (Object[])new Object[]{ebDimNumber, sourceVal});
                                        match = Boolean.FALSE;
                                        break;
                                    }
                                    targetDimMember = member.getNumber();
                                }
                            }
                            dimMemberNums[index++] = targetDimMember;
                        }
                    }
                }
                if (!match) {
                    this.addDetailLog(errMsg, row, param);
                    continue;
                }
                try {
                    this.selToKdCell(cells, dimMemberNums, row, metricIndex, metricDim, param);
                    this.checkStrValLength(cells);
                    this.checkCellDataPerm(globalContext, cells, ebDimList, viewMap);
                    if (!this.logAllMapData) break block20;
                    this.addDetailLog(null, row, cells, param);
                }
                catch (Exception e) {
                    this.addDetailLog(e.getMessage(), row, param);
                    continue;
                }
            }
            allCells.addAll(cells);
        }
        param.setTargetRowData(allCells);
        return allCells;
    }

    protected String validateRow(Object rowData, IntegrationCusContext cusContext) {
        return null;
    }

    private void checkCellDataPerm(IntegrationContext globalContext, List<IKDCell> cells, List<Dimension> ebDimList, Map<String, Long> viewMap) {
        ExecuteCondition executeCondition = globalContext.getExecuteCondition();
        if (executeCondition.isFilterMemberPerm()) {
            List<String> dimNumList = ebDimList.stream().map(BaseCache::getNumber).collect(Collectors.toList());
            if (this.permChecker == null) {
                this.permChecker = DimMembPermHelper.getPermChecker((Long)executeCondition.getModelId(), (Long)executeCondition.getBizModelId(), dimNumList, (Long)UserUtils.getUserId(), (DimMembPermType)DimMembPermType.WRITE);
            }
            if (!this.permChecker.hasAllPerm()) {
                LinkedList<String> errorList = new LinkedList<String>();
                for (IKDCell cell : cells) {
                    CharSequence[] dimNumbers = cell.getMeta().getNumber();
                    Map<String, MemberItem> memberGroup = this.toMemberItemMap(cell, dimNumList, viewMap);
                    if (this.permChecker.check(memberGroup)) continue;
                    errorList.add("[" + String.join((CharSequence)",", dimNumbers) + "]");
                }
                if (errorList.size() > 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u7ef4\u5ea6\u7ec4\u5408%s\u7684\u6743\u9650", (String)"DataIntegrationDataService_20", (String)"epm-eb-business", (Object[])new Object[]{String.join((CharSequence)",", errorList)}));
                }
            }
        }
    }

    private void checkStrValLength(List<IKDCell> cells) {
        for (IKDCell cell : cells) {
            IKDValue value = cell.getValue();
            if (value == null || !value.isString() || value.getString().length() <= 600) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u672c\u8d85\u8fc7600\u5b57\u7b26\uff0c\u8d85\u51fa\u5b58\u50a8\u9650\u5236\u3002", (String)"DataInIntegrationHandler_2", (String)"epm-eb-business", (Object[])new Object[0]));
        }
    }

    protected Map<String, DataIntegrationDimMap> getDimMaps(Object rowData, IntegrationCusContext cusContext) {
        return this.getDimMap();
    }

    abstract void selToKdCell(List<IKDCell> var1, String[] var2, Object var3, int var4, Dimension var5, IntegrationCusContext var6);

    @Override
    public void saveData(IntegrationContext globalContext, IntegrationCusContext cusContext, String schemeNumber) {
        IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
        this.saveToOlap(cusContext.getTargetRowData(), modelCacheHelper, schemeNumber);
    }

    protected void saveToOlap(List<IKDCell> cells, IModelCacheHelper modelCache, String schemeNumber) {
        if (cells == null || cells.isEmpty()) {
            return;
        }
        Long modelId = modelCache.getModelobj().getId();
        Long datasetId = this.getDataIntegration().getDatasetid();
        List dimensions = modelCache.getDimensionList(datasetId);
        ArrayList newCells = Lists.newArrayList();
        ArrayList incrCells = Lists.newArrayList();
        for (IKDCell kdCell : cells) {
            String key = kdCell.getKey();
            BGCell bgCell = AlgoCalcUtils.toBGCell((IKDCell)kdCell, (IModelCacheHelper)modelCache, (List)dimensions, this.getDimViewMap());
            String met = (String)bgCell.getMemberMap().get(SysDimensionEnum.Metric.getNumber());
            Member metMember = modelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, met);
            boolean isAgg = metMember.hasAgg();
            if (!isAgg) {
                newCells.add(bgCell);
                continue;
            }
            if (this.incrSet.contains(key)) {
                incrCells.add(bgCell);
                continue;
            }
            this.incrSet.add(key);
            newCells.add(bgCell);
        }
        OlapWriteOption olapWriteOption = new OlapWriteOption();
        olapWriteOption.setDataLockThrowErr(true);
        olapWriteOption.setIncrement(false);
        OlapTraceServiceHelper.setTraceOpInfo((String)schemeNumber);
        OlapContext.setSaveDataContext((SaveDataContext)new SaveDataContext(OlapDataAuditEventEnum.DataGather));
        OlapManager.getInstance().saveList(new SaveRequest(modelId, datasetId, (List)newCells), olapWriteOption);
        olapWriteOption.setIncrement(true);
        OlapTraceServiceHelper.setTraceOpInfo((String)schemeNumber);
        OlapContext.setSaveDataContext((SaveDataContext)new SaveDataContext(OlapDataAuditEventEnum.DataGather));
        OlapManager.getInstance().saveList(new SaveRequest(modelId, datasetId, (List)incrCells), olapWriteOption);
    }

    protected boolean canMapValByNumber(String sourceField, String sourceVal, MemberMapPPO memberMapPPO) {
        if (memberMapPPO != null) {
            Set<String> targetVal = memberMapPPO.getTargetVal(sourceField);
            return !targetVal.contains(sourceVal);
        }
        return true;
    }

    private String getConfigNumber(DataIntegrationDimMap dimMap, MemberMapPPO memberMap, Object rowData, IntegrationCusContext param, Pair<String, String> sourceValPair) {
        String targetNumber = null;
        String sourceVal = (String)sourceValPair.p2;
        String sourceField = (String)sourceValPair.p1;
        if (memberMap != null) {
            Pair<String, String> targetInfo;
            if (memberMap.getRefField() != null) {
                sourceVal = sourceVal + "\u3002.&.\u3002" + (String)this.getFieldValueNotNull((Object)rowData, (IntegrationCusContext)param, (String)memberMap.getRefField()).p2;
            }
            if ((targetInfo = memberMap.isCheckSourceField() ? memberMap.getMemberMapBySField(sourceField).get(sourceVal) : memberMap.getMemberMap().get(sourceVal)) != null) {
                targetNumber = (String)targetInfo.p1;
            }
        } else {
            String sourceFixVal = dimMap.getSourceFixVal();
            String targetFxiVal = dimMap.getDimmembnum();
            targetNumber = StringUtils.isEmpty((CharSequence)sourceFixVal) && StringUtils.isNotEmpty((CharSequence)targetFxiVal) ? targetFxiVal : (StringUtils.isNotEmpty((CharSequence)sourceFixVal) && StringUtils.isEmpty((CharSequence)targetFxiVal) ? (sourceFixVal.equals(sourceVal) ? sourceVal : null) : (StringUtils.isNotEmpty((CharSequence)sourceFixVal) && StringUtils.isNotEmpty((CharSequence)targetFxiVal) ? (sourceFixVal.equals(sourceVal) ? targetFxiVal : null) : this.getNumberByDefaultMap(rowData, param, sourceVal, sourceField)));
        }
        return targetNumber;
    }

    protected String getNumberByDefaultMap(Object rowData, IntegrationCusContext param, String sourceVal, String sourceField) {
        return null;
    }

    public List<Dimension> getEbDimList() {
        if (this.ebDimList == null) {
            this.ebDimList = new ArrayList<Dimension>(16);
        }
        return this.ebDimList;
    }

    public Map<String, Long> getDimViewMap() {
        if (this.dimViewMap == null) {
            this.dimViewMap = new HashMap<String, Long>(16);
        }
        return this.dimViewMap;
    }
}

