/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.dataintegration.service.handler;

import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.dataintegration.entity.AbstractDataIntegration;
import kd.epm.eb.business.dataintegration.entity.DataIntegrationDimMap;
import kd.epm.eb.business.dataintegration.entity.IntegrationExecStatus;
import kd.epm.eb.business.dataintegration.entity.MemberMapPPO;
import kd.epm.eb.business.dataintegration.entity.context.IntegrationContext;
import kd.epm.eb.business.dataintegration.entity.context.IntegrationCusContext;
import kd.epm.eb.business.easupgrade.utils.EASDataIntegrationUtil;
import kd.epm.eb.business.easupgrade.utils.IntegrationLogHelper;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.orm.EbIntegrationLog;
import kd.epm.eb.common.permission.membPerm.MemberItem;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.LogSignHelper;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.impl.metadata.KDCell;

public abstract class DataIntegrationHandler {
    protected static final Log log = LogFactory.getLog(DataIntegrationHandler.class);
    protected static final int maxDetailLogSize = 500;
    private AbstractDataIntegration dataIntegration;
    private IModelCacheHelper modelCacheHelper;
    private Map<Long, MemberMapPPO> memberMap;
    private Map<String, List<Member>> memberFilters;
    private Map<String, DataIntegrationDimMap> dimMap;
    private List<DynamicObject> detailLogObjs = new LinkedList<DynamicObject>();
    private Long actionId;
    private Long mainLogId;
    protected boolean logAllMapData = false;

    public IntegrationCusContext init(IntegrationContext globalContext) {
        this.actionId = globalContext.getExecuteCondition().getActionId();
        this.loadRefMemberMap();
        this.loadMembFilterByRange(globalContext);
        this.markLogStatus(IntegrationExecStatus.ING);
        IntegrationLogHelper.delDetailLogByIntegration(this.getDataIntegration().getId());
        this.logAllMapData = LogSignHelper.needLog((String)"DataIntegrationHandler", (String)"logAllMapData");
        return new IntegrationCusContext();
    }

    private void loadMembFilterByRange(IntegrationContext globalContext) {
        this.memberFilters = EASDataIntegrationUtil.parserMemberFilter(this.getDataIntegration(), this.getModelCacheHelper(), globalContext);
    }

    private void loadRefMemberMap() {
        this.memberMap = EASDataIntegrationUtil.loadRefMemberMap(this.dataIntegration);
    }

    public boolean readData(IntegrationContext globalContext, IntegrationCusContext cusContext) {
        return true;
    }

    public void convertData(IntegrationContext globalContext, IntegrationCusContext cusContext) {
    }

    public void saveData(IntegrationContext globalContext, IntegrationCusContext cusContext, String schemeNumber) {
    }

    public void afterSaveData(IntegrationContext globalContext, IntegrationCusContext cusContext) {
        Long mainLogId = this.getMainLogId();
        IntegrationLogHelper.updateLogInfo(mainLogId, new String[]{"fsuccesscount", "ffailcount", "fisynccount", "fmodifydatefield"}, new Object[]{cusContext.getSuccessCnt(), cusContext.getFailCnt(), cusContext.getSynCount(), TimeServiceHelper.now()});
    }

    public void finish(IntegrationContext globalContext, IntegrationCusContext cusContext) {
        this.checkAndSaveDetLog(true);
        this.markLogStatus(IntegrationExecStatus.SUSS);
        this.handleLog(globalContext, cusContext);
    }

    public void handleLog(IntegrationContext globalContext, IntegrationCusContext cusContext) {
        Set logSigns = LogSignHelper.getLogSignByGropNum((String)"DataIntegrationHandler");
        if (logSigns.contains("logAllParam")) {
            String sign = "logAllParam";
            HashMap<String, Object> logData = new HashMap<String, Object>();
            this.selDataToLog(sign, logData);
            logData.put("cusContext", cusContext);
            String logStr = SerializationUtils.toJsonString(logData);
            CommonServiceHelper.handleLog((Log)log, (String)("DataIntegrationHandler_" + sign), (String)logStr);
        }
    }

    public void setDataIntegration(AbstractDataIntegration dataIntegration) {
        this.dataIntegration = dataIntegration;
    }

    public AbstractDataIntegration getDataIntegration() {
        return this.dataIntegration;
    }

    public Long getModelId() {
        return this.getDataIntegration().getModelid();
    }

    public Pair<String, String> getFieldValueNotNull(Object row, IntegrationCusContext param, String fieldStr) {
        Pair fieldValue = this.getFieldValue(row, param, fieldStr);
        if (fieldValue == null) {
            fieldValue = new Pair((Object)fieldStr, (Object)"");
        }
        return fieldValue;
    }

    abstract Pair<String, String> getFieldValue(Object var1, IntegrationCusContext var2, String var3);

    public IModelCacheHelper getModelCacheHelper() {
        return this.modelCacheHelper;
    }

    public void setModelCacheHelper(IModelCacheHelper modelCacheHelper) {
        this.modelCacheHelper = modelCacheHelper;
    }

    public Map<Long, MemberMapPPO> getMemberMap() {
        if (this.memberMap == null) {
            this.memberMap = new HashMap<Long, MemberMapPPO>(16);
        }
        return this.memberMap;
    }

    public Map<String, List<Member>> getMemberFilters() {
        if (this.memberFilters == null) {
            this.memberFilters = new HashMap<String, List<Member>>(16);
        }
        return this.memberFilters;
    }

    public Map<String, DataIntegrationDimMap> getDimMap() {
        if (this.dimMap == null) {
            this.dimMap = new HashMap<String, DataIntegrationDimMap>(16);
            if (this.dataIntegration != null) {
                this.dataIntegration.getFirstDimMap().forEach(map -> this.dimMap.put(map.getDimtarget(), (DataIntegrationDimMap)map));
            }
        }
        return this.dimMap;
    }

    public Long getActionId() {
        return this.actionId;
    }

    protected void markLogStatus(IntegrationExecStatus execStatus) {
        IntegrationLogHelper.markLogStatus(this.getMainLogId(), execStatus);
    }

    protected void addDetailLog(String logInfo, Object rowData, IntegrationCusContext cusContext) {
        this.addDetailLog(logInfo, rowData, null, cusContext);
    }

    protected void addDetailLog(String logInfo, Object rowData, Object targetData, IntegrationCusContext cusContext) {
        Long mainLogId = this.getMainLogId();
        Long integrationId = this.getDataIntegration().getId();
        DynamicObject logDetail = BusinessDataServiceHelper.newDynamicObject((String)"eb_integration_logdet");
        logDetail.set("integration", (Object)integrationId);
        logDetail.set("logid", (Object)mainLogId);
        if (logInfo != null && logInfo.length() > 200) {
            logInfo = logInfo.substring(0, 200);
        }
        logDetail.set("failmsg", (Object)logInfo);
        if (targetData == null) {
            logDetail.set("datajson", (Object)this.rowData2Str(rowData));
        } else {
            logDetail.set("datajson", (Object)("source:" + this.rowData2Str(rowData) + ",target:" + this.rowData2Str(targetData)));
        }
        logDetail.set("createdatefield", (Object)new Date());
        logDetail.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        this.detailLogObjs.add(logDetail);
        this.checkAndSaveDetLog(false);
    }

    private String rowData2Str(Object rowData) {
        String result = null;
        if (rowData instanceof String) {
            result = (String)rowData;
        } else if (rowData instanceof KDCell) {
            result = ((KDCell)rowData).toShowStr();
        } else if (rowData instanceof List) {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            for (Object obj : (List)rowData) {
                sb.append(this.rowData2Str(obj)).append(',');
            }
            if (sb.length() > 1) {
                sb.setCharAt(sb.length() - 1, ']');
            } else {
                sb.append(']');
            }
            result = sb.toString();
        } else {
            result = SerializationUtils.toJsonString((Object)rowData);
        }
        return result;
    }

    protected void checkAndSaveDetLog(boolean isEnd) {
        if (isEnd || this.detailLogObjs.size() > 500) {
            SaveServiceHelper.save((DynamicObject[])this.detailLogObjs.toArray(new DynamicObject[0]));
            this.detailLogObjs.clear();
        }
    }

    protected Long getMainLogId() {
        if (this.mainLogId == null && this.actionId != null) {
            Long integrationSchemeId = this.getDataIntegration().getId();
            List<EbIntegrationLog> logPjByAction = IntegrationLogHelper.getLogPjByAction(this.actionId);
            for (EbIntegrationLog logObj : logPjByAction) {
                if (!logObj.getIntegrationidLong().equals(integrationSchemeId)) continue;
                this.mainLogId = logObj.getIdLong();
                break;
            }
            if (this.mainLogId == null) {
                this.mainLogId = 0L;
            }
        }
        return this.mainLogId;
    }

    public void setMainLogId(Long mainLogId) {
        this.mainLogId = mainLogId;
    }

    public void selDataCountInfo(IntegrationCusContext cusContext) {
        int failCnt = cusContext.getFailCnt();
        int successCnt = cusContext.getSuccessCnt();
        List sourceRowData = cusContext.getSourceRowData();
        List targetRowData = cusContext.getTargetRowData();
        int sourceDataCount = sourceRowData == null ? 0 : sourceRowData.size();
        int targetDataCount = targetRowData == null ? 0 : targetRowData.size();
        cusContext.setFailCnt(failCnt += sourceDataCount - targetDataCount);
        cusContext.setSuccessCnt(successCnt += (targetDataCount /= cusContext.getSourceDataCountDiv()));
        if (cusContext.isCalculateSynCount()) {
            cusContext.setSynCount(cusContext.getSynCount() + sourceDataCount);
        }
    }

    public void selDataToLog(String logKey, Map<String, Object> logData) {
        logData.put("membMap", this.memberMap);
        logData.put("actionId", this.actionId);
        logData.put("mainLogId", this.mainLogId);
    }

    protected Map<String, MemberItem> toMemberItemMap(IKDCell cell, List<String> dimNumbers, Map<String, Long> viewMap) {
        String[] dimMemberNumbers = cell.getMeta().getNumber();
        HashMap<String, MemberItem> memberGroup = new HashMap<String, MemberItem>(dimMemberNumbers.length);
        int index = 0;
        for (String dimNum : dimNumbers) {
            Long viewId = viewMap == null ? null : viewMap.get(dimNum);
            MemberItem memberItem = new MemberItem();
            memberItem.setNumberFirst(true);
            memberItem.setMember(true);
            memberItem.setMemberNum(dimMemberNumbers[index]);
            memberItem.setViewId(viewId);
            memberGroup.put(dimNum, memberItem);
            ++index;
        }
        return memberGroup;
    }
}

