/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.dataintegration.service.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.analyzeReport.execute.ConditionExecutor;
import kd.epm.eb.business.bailorg.entity.SimpleObject;
import kd.epm.eb.business.dataGather.entity.DataGatherGLMember;
import kd.epm.eb.business.dataGather.entity.DataGatherGLTypeRange;
import kd.epm.eb.business.dataGather.service.DataGatherGLAssInfoService;
import kd.epm.eb.business.dataintegration.entity.AbstractDataIntegration;
import kd.epm.eb.business.dataintegration.entity.DataIntegrationDimMap;
import kd.epm.eb.business.dataintegration.entity.DataIntegrationQuery;
import kd.epm.eb.business.dataintegration.entity.GLDataIntegration;
import kd.epm.eb.business.dataintegration.entity.GLMapCondition;
import kd.epm.eb.business.dataintegration.entity.GlBizFieldType;
import kd.epm.eb.business.dataintegration.entity.GlPeriod;
import kd.epm.eb.business.dataintegration.entity.IntegrationDimMapGroup;
import kd.epm.eb.business.dataintegration.entity.MemberMapPPO;
import kd.epm.eb.business.dataintegration.entity.context.ConditionExecContext;
import kd.epm.eb.business.dataintegration.entity.context.GlIntegrationCusContext;
import kd.epm.eb.business.dataintegration.entity.context.IntegrationContext;
import kd.epm.eb.business.dataintegration.entity.context.IntegrationCusContext;
import kd.epm.eb.business.dataintegration.service.DataIntegrationDataService;
import kd.epm.eb.business.dataintegration.service.DataIntegrationInService;
import kd.epm.eb.business.dataintegration.service.handler.DataInIntegrationHandler;
import kd.epm.eb.business.easupgrade.utils.EASDataIntegrationUtil;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.dataintegration.DataIntegrationGetDataType;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.common.formula.ExpressionContext;
import kd.epm.eb.common.formula.ExpressionParseHelper;
import kd.epm.eb.common.formula.GlDataExpContext;
import kd.epm.eb.common.formula.Iexpression;
import kd.epm.eb.common.formula.VariateExpression;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.ebBusiness.model.BalanceQueryParam;
import kd.epm.eb.ebBusiness.model.GlServiceHelper;
import kd.epm.eb.olap.api.metadata.IKDCell;
import org.apache.commons.lang3.StringUtils;

public class GlDataIntegrationHandler
extends DataInIntegrationHandler {
    private BalanceQueryParam queryParam;
    private Map<String, String> toReadAccountOrgMap = new HashMap<String, String>(16);
    private Map<Long, String> glOrgIdNumMap;
    private Iexpression glDataExp;
    private List<ConditionExecutor> conditionExecutors;
    private static final Map<String, String> fieldKeyMap = new HashMap<String, String>(3);

    @Override
    public IntegrationCusContext init(IntegrationContext globalContext) {
        IntegrationCusContext cusContext = super.init(globalContext);
        Map<String, List<Member>> memberFilters = this.getMemberFilters();
        GLDataIntegration glIntegration = this.getGlIntegration();
        Map<String, List<Long>> glFilterParamMap = DataIntegrationInService.getInstance().getGlFilterParamMap(glIntegration, memberFilters, this.getMemberMap(), this.toReadAccountOrgMap);
        this.initConditionAndSelFilter(glIntegration, glFilterParamMap);
        this.glOrgIdNumMap = EASDataIntegrationUtil.queryGlDataIdNumberMap(GlBizFieldType.ORG, glIntegration.getCalculateModel(), glIntegration.getCalculateView(), true);
        this.buildQParam(glFilterParamMap);
        GlIntegrationCusContext glIntegrationCusContext = new GlIntegrationCusContext(cusContext);
        List periodIds = glFilterParamMap.getOrDefault(GlBizFieldType.PERIOD.getNumber(), new ArrayList(1));
        List<GlPeriod> glPeriods = EASDataIntegrationUtil.loadGlPeriodObj(periodIds);
        glIntegrationCusContext.setToReadPeriods(glPeriods);
        return glIntegrationCusContext;
    }

    @Override
    public Map<String, Long> getSchemeDimviewMap(AbstractDataIntegration dataIntegration, List<DataIntegrationQuery> filters) {
        HashMap<String, Long> resultMap = this.getCommonView(dataIntegration, filters);
        DynamicObject object = dataIntegration.getObject();
        DynamicObjectCollection dimmapentity = object.getDynamicObjectCollection("dimmapscheme_entry");
        if (CollectionUtils.isNotEmpty((Collection)dimmapentity)) {
            for (DynamicObject dynamicObject : dimmapentity) {
                String dimMemMapJson = dynamicObject.getString("dimmemmapjson");
                if (dimMemMapJson == null) continue;
                List dimMapList = (List)ObjectSerialUtil.parseObject((String)dimMemMapJson, (TypeReference)new TypeReference<List<DataIntegrationDimMap>>(){}, (Feature[])new Feature[0]);
                for (DataIntegrationDimMap dataIntegrationDimMap : dimMapList) {
                    Map map;
                    String info;
                    DynamicObject dynamicObject1;
                    if (IDUtils.isNotNull((Long)dataIntegrationDimMap.getDimmembviewid())) {
                        resultMap.put(dataIntegrationDimMap.getDimtarget(), dataIntegrationDimMap.getDimmembviewid());
                        continue;
                    }
                    if (View.NoViewDimNums.contains(dataIntegrationDimMap.getDimtarget()) || (dynamicObject1 = BusinessDataServiceHelper.loadSingle((String)"eb_integration_map", (String)"targetsysinfo", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dataIntegrationDimMap.getDimmembmapid())})) == null || !StringUtils.isNotEmpty((CharSequence)(info = dynamicObject1.getString("targetsysinfo"))) || !(map = (Map)JSON.parseObject((String)info, Map.class)).containsKey("view")) continue;
                    resultMap.put(dataIntegrationDimMap.getDimtarget(), IDUtils.toLong(map.get("view")));
                }
            }
        }
        return resultMap;
    }

    private void initConditionAndSelFilter(GLDataIntegration glIntegration, Map<String, List<Long>> glFilterParamMap) {
        this.conditionExecutors = new ArrayList<ConditionExecutor>(glIntegration.getDimMapGroups().size());
        HashMap<Long, String> accountOrgInfo = new HashMap<Long, String>(16);
        glIntegration.getDimMapGroups().forEach(group -> {
            List<GLMapCondition> glMapConditionList = group.getCondition();
            if (glMapConditionList != null) {
                glMapConditionList.forEach(condition -> {
                    if (condition.getFieldType() == GlBizFieldType.ACCOUNT) {
                        condition.getMemValues().forEach(memb -> {
                            String cfr_ignored_0 = accountOrgInfo.put(memb.getId(), null);
                        });
                    }
                });
            }
        });
        if (accountOrgInfo.size() > 0) {
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"initAccountInfo", (String)GlBizFieldType.ACCOUNT.getFieldFormKey(), (String)"id,number,createorg.number as orgnumber", (QFilter[])new QFilter("id", "in", accountOrgInfo.keySet()).toArray(), null);){
                for (Row row : dataSet) {
                    accountOrgInfo.put(row.getLong("id"), row.getString("number") + "," + row.getString("orgnumber"));
                }
            }
        }
        glIntegration.getDimMapGroups().forEach(group -> {
            List<GLMapCondition> glMapConditionList = group.getCondition();
            this.conditionExecutors.add(EASDataIntegrationUtil.parserCondition(glMapConditionList, accountOrgInfo));
        });
    }

    @Override
    public boolean readData(IntegrationContext globalContext, IntegrationCusContext cusContext) {
        List allRowsData = null;
        GlIntegrationCusContext glCusContext = this.getGlCusContext(cusContext);
        List<GlPeriod> toReadPeriods = glCusContext.getToReadPeriods();
        int currPeriodIndex = glCusContext.getCurrPeriodIndex();
        BalanceQueryParam queryParam = this.getQueryParam();
        if (queryParam.getOrgIds().length == 0) {
            log.info(this.getGlIntegration().getNumber() + ":glOrg is empty");
            return true;
        }
        if (currPeriodIndex < toReadPeriods.size()) {
            GlPeriod periodId = toReadPeriods.get(currPeriodIndex);
            HashMap<String, Integer> accountType = new HashMap<String, Integer>(16);
            HashMap<Long, String> accountIdStrNumMap = new HashMap<Long, String>(16);
            this.getVAccount(periodId, queryParam.getAccountTableId(), accountType, accountIdStrNumMap);
            glCusContext.setAccountType(accountType);
            glCusContext.setAccountIdStrNumMap(accountIdStrNumMap);
            queryParam.setPeriodId(periodId.getId().longValue());
            queryParam.getAccountAssgrp().clear();
            accountIdStrNumMap.keySet().forEach(accountId -> queryParam.setAccountAssgrp(accountId, null));
            if (CollectionUtils.isNotEmpty((Map)queryParam.getAccountAssgrp())) {
                allRowsData = GlServiceHelper.getBalance((BalanceQueryParam)queryParam);
            } else {
                log.info(this.getGlIntegration().getNumber() + "--account empty--period:" + periodId.getNumber());
            }
            glCusContext.setCurrPeriodIndex(currPeriodIndex + 1);
            glCusContext.setCurrentPeriod(periodId);
        }
        cusContext.setSourceRowData(allRowsData);
        return currPeriodIndex == toReadPeriods.size();
    }

    private void buildQParam(Map<String, List<Long>> glFilterParamMap) {
        boolean emptyOrgFilter;
        List<Long> glOrgIds = glFilterParamMap.get(GlBizFieldType.ORG.getNumber());
        GLDataIntegration glIntegration = this.getGlIntegration();
        Set<String> orgNumbers = glIntegration.getCalculateOrgMembers().stream().map(SimpleObject::getNumber).collect(Collectors.toSet());
        Map<String, List<String>> allChildMap = EASDataIntegrationUtil.queryGlAllChildNumber(orgNumbers, Collections.emptySet(), GlBizFieldType.ORG, glIntegration.getCalculateModel(), glIntegration.getCalculateView());
        HashMap glNumberIdMap = new HashMap(this.glOrgIdNumMap.size());
        this.glOrgIdNumMap.forEach((id, number) -> glNumberIdMap.put(number, id));
        HashSet toQOrgIds = new HashSet(16);
        HashSet<Long> filterOrgIds = new HashSet<Long>(16);
        boolean bl = emptyOrgFilter = glOrgIds != null && glOrgIds.isEmpty();
        if (glOrgIds != null) {
            filterOrgIds.addAll(glOrgIds);
        }
        orgNumbers.forEach(orgNumber -> {
            Long orgId = (Long)glNumberIdMap.get(orgNumber);
            if (orgId != null && !emptyOrgFilter && (filterOrgIds.isEmpty() || filterOrgIds.contains(orgId))) {
                toQOrgIds.add(orgId);
            }
        });
        allChildMap.values().forEach(childNumbers -> {
            if (childNumbers != null) {
                childNumbers.forEach(orgNumber -> {
                    Long orgId = (Long)glNumberIdMap.get(orgNumber);
                    if (orgId != null && !emptyOrgFilter && (filterOrgIds.isEmpty() || filterOrgIds.contains(orgId))) {
                        toQOrgIds.add(orgId);
                    }
                });
            }
        });
        BalanceQueryParam param = new BalanceQueryParam();
        long[] orgIds = new long[toQOrgIds.size()];
        int index = 0;
        for (Long orgId : toQOrgIds) {
            orgIds[index++] = orgId;
        }
        param.setSubstractPL(!glIntegration.isIncludeCEPL());
        param.setOrgIds(orgIds);
        if (!"-1".equals(glIntegration.getCurrencyIdStr())) {
            param.setCurrencyId(IDUtils.toLong((Object)glIntegration.getCurrencyIdStr()).longValue());
        }
        param.setAccountTableId(glIntegration.getAccountTable().longValue());
        param.setBookTypeId(glIntegration.getAccountBookType().longValue());
        param.addSelector("org");
        param.addSelector("account");
        param.addSelector("assgrp");
        DataIntegrationGetDataType getDataType = glIntegration.getGetDataType();
        try {
            this.glDataExp = ExpressionParseHelper.parse((String)getDataType.getFormula());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.glDataExp == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u53d6\u503c\u65b9\u5f0f\u516c\u5f0f\u89e3\u6790\u9519\u8bef\uff1a%1", (String)"GlDataIntegrationHandler_1", (String)"epm-eb-business", (Object[])new Object[]{getDataType.getFormula()}));
        }
        LinkedList<Iexpression> deque = new LinkedList<Iexpression>();
        deque.add(this.glDataExp);
        while (!deque.isEmpty()) {
            Iexpression iexpression = (Iexpression)deque.pollFirst();
            if (iexpression instanceof VariateExpression) {
                String fieldKey = ((VariateExpression)iexpression).getIndexName();
                if ("att".equals(fieldKey)) continue;
                param.addSelector(fieldKey);
                continue;
            }
            if (iexpression == null) continue;
            deque.add(iexpression.getLeftExpr());
            deque.add(iexpression.getRightExpr());
        }
        this.setQueryParam(param);
    }

    private void getVAccount(GlPeriod period, Long accountTable, Map<String, Integer> accountType, Map<Long, String> accountIdNumMap) {
        long orgId = RequestContext.get().getOrgId();
        Date endDate = period.getEndDate();
        QFilter qAcctTableId = new QFilter("accounttable", "=", (Object)accountTable);
        QFilter qDate = new QFilter("startdate", "<=", (Object)endDate).and(new QFilter("enddate", ">=", (Object)endDate));
        QFilter qNumber = new QFilter("number", "in", this.toReadAccountOrgMap.values());
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"", (String)"bd_accountview", (String)"id,number,createorg.number as orgnumber,dc", (QFilter[])new QFilter[]{qAcctTableId, qDate, qNumber}, null);){
            for (Row row : dataSet) {
                String acctNumber = row.getString("number");
                String acctOrgNumberStr = acctNumber + "," + row.getString("orgnumber");
                Long id = row.getLong("id");
                if (!this.toReadAccountOrgMap.containsKey(acctOrgNumberStr)) continue;
                accountType.put(acctOrgNumberStr, row.getInteger("dc"));
                accountIdNumMap.put(id, acctOrgNumberStr);
            }
        }
    }

    @Override
    public void convertData(IntegrationContext globalContext, IntegrationCusContext cusContext) {
        List sourceRowData = cusContext.getSourceRowData();
        if (sourceRowData != null && sourceRowData.size() > 0) {
            LinkedList<Long> groupIds = new LinkedList<Long>();
            sourceRowData.forEach(row -> {
                Object assgrpVal = row.get("assgrp");
                if (assgrpVal instanceof Long) {
                    groupIds.add((Long)assgrpVal);
                }
            });
            HashMap<Long, Map<String, String>> glDimMemberInfo = new HashMap<Long, Map<String, String>>(16);
            Collection<DataGatherGLTypeRange> dataGatherGLTypeRanges = DataGatherGLAssInfoService.getInstance().queryAssInfos(0, groupIds);
            if (dataGatherGLTypeRanges != null) {
                dataGatherGLTypeRanges.forEach(row -> {
                    Collection<DataGatherGLMember> subMembers = row.getSubMembers();
                    if (subMembers != null && subMembers.size() > 0) {
                        glDimMemberInfo.computeIfAbsent(row.getTypeId(), key -> new HashMap()).put(row.getNumber(), subMembers.iterator().next().getNumber());
                    }
                });
            }
            GlIntegrationCusContext glCusContext = this.getGlCusContext(cusContext);
            this.replaceVal2Number(sourceRowData, glCusContext, this.glOrgIdNumMap, glDimMemberInfo);
            cusContext.setTargetRowData(this.coverToEbData(globalContext, cusContext));
        }
    }

    public void replaceVal2Number(List<Map<String, Object>> allRowData, GlIntegrationCusContext glCusContext, Map<Long, String> glOrgIdNumMap, Map<Long, Map<String, String>> glDimMemberInfo) {
        if (allRowData != null && allRowData.size() > 0) {
            String periodNumber = glCusContext.getCurrentPeriod().getNumber();
            Map<Long, String> accountIdStrNumMap = glCusContext.getAccountIdStrNumMap();
            for (Map<String, Object> rowData : allRowData) {
                Map<String, String> memberInfo;
                Long account = IDUtils.toLong((Object)rowData.get("account"));
                Long org = IDUtils.toLong((Object)rowData.get("org"));
                Long assgrp = IDUtils.toLong((Object)rowData.get("assgrp"));
                rowData.put("period", periodNumber);
                if (IDUtils.isNotNull((Long)account)) {
                    rowData.put("account", accountIdStrNumMap.get(account));
                }
                if (IDUtils.isNotNull((Long)org)) {
                    rowData.put("org", glOrgIdNumMap.get(org));
                }
                if (!IDUtils.isNotNull((Long)assgrp) || (memberInfo = glDimMemberInfo.get(assgrp)) == null) continue;
                rowData.put("assgrp", memberInfo);
            }
        }
    }

    @Override
    void selToKdCell(List<IKDCell> kdCells, String[] dimMemberNums, Object row, int metricIndex, Dimension metricDim, IntegrationCusContext cusContext) {
        if (row != null) {
            Map rowData = (Map)row;
            GlIntegrationCusContext glCusContext = this.getGlCusContext(cusContext);
            GlDataExpContext glDataExpContext = new GlDataExpContext();
            glDataExpContext.setRowData(rowData);
            glDataExpContext.setCurrentAccountInfo(glCusContext.getAccountType());
            this.glDataExp.setContext((ExpressionContext)glDataExpContext);
            BigDecimal calculate = this.glDataExp.calculate();
            DataIntegrationDataService.getInstance().metricSingleMapper(kdCells, calculate, dimMemberNums, metricIndex, metricDim);
        }
    }

    @Override
    Pair<String, String> getFieldValue(Object row, IntegrationCusContext param, String fieldStr) {
        String fieldVal = EASDataIntegrationUtil.getGlValOnRow((Map)row, fieldStr, fieldKeyMap);
        if (fieldVal != null) {
            return new Pair((Object)fieldStr, (Object)fieldVal);
        }
        return null;
    }

    @Override
    protected String getNumberByDefaultMap(Object rowData, IntegrationCusContext param, String sourceVal, String sourceField) {
        String result = null;
        String glFieldKey = fieldKeyMap.get(sourceField);
        if ("period".equals(glFieldKey)) {
            result = this.getGlCusContext(param).getCurrentPeriod().getEbPeriodStr();
        }
        return result;
    }

    @Override
    protected Map<String, DataIntegrationDimMap> getDimMaps(Object rowData, IntegrationCusContext cusContext) {
        GLDataIntegration glIntegration = this.getGlIntegration();
        List<IntegrationDimMapGroup> dimMapGroups = glIntegration.getDimMapGroups();
        ConditionExecContext context = new ConditionExecContext();
        context.setRowData((Map)rowData);
        context.setFieldKeyMap(fieldKeyMap);
        context.setGlOrgIdNumMap(this.glOrgIdNumMap);
        context.setGlCusContext(this.getGlCusContext(cusContext));
        for (int seq = 0; seq < this.conditionExecutors.size(); ++seq) {
            ConditionExecutor executor = this.conditionExecutors.get(seq);
            if (executor != null && !executor.getBoolean(context)) continue;
            return dimMapGroups.get(seq).getMemberMapsMap();
        }
        return null;
    }

    private GlIntegrationCusContext getGlCusContext(IntegrationCusContext cusContext) {
        return (GlIntegrationCusContext)cusContext;
    }

    private GLDataIntegration getGlIntegration() {
        return (GLDataIntegration)this.getDataIntegration();
    }

    public BalanceQueryParam getQueryParam() {
        return this.queryParam;
    }

    public void setQueryParam(BalanceQueryParam queryParam) {
        this.queryParam = queryParam;
    }

    @Override
    protected void addDetailLog(String logInfo, Object rowData, Object targetData, IntegrationCusContext cusContext) {
        super.addDetailLog(logInfo, rowData, targetData, cusContext);
    }

    @Override
    public void selDataToLog(String logKey, Map<String, Object> logData) {
        super.selDataToLog(logKey, logData);
        logData.put("queryParam", this.queryParam);
        logData.put("toReadAccountOrgMap", this.toReadAccountOrgMap);
        logData.put("glOrgIdNumMap", this.glOrgIdNumMap);
        logData.put("glDataExp", this.glDataExp == null ? null : this.glDataExp.toString());
        logData.put("condition", this.conditionExecutors == null ? null : this.conditionExecutors.toString());
    }

    @Override
    protected boolean canMapValByNumber(String sourceField, String sourceVal, MemberMapPPO memberMapPPO) {
        if ("account-preset".equals(sourceField)) {
            return false;
        }
        return super.canMapValByNumber(sourceField, sourceVal, memberMapPPO);
    }

    static {
        fieldKeyMap.put(GlBizFieldType.ORG.getNumber(), "org");
        fieldKeyMap.put(GlBizFieldType.ACCOUNT.getNumber(), "account");
        fieldKeyMap.put(GlBizFieldType.PERIOD.getNumber(), "period");
        fieldKeyMap.put(GlBizFieldType.ORG.getFieldKey(), "org");
        fieldKeyMap.put(GlBizFieldType.ACCOUNT.getFieldKey(), "account");
        fieldKeyMap.put(GlBizFieldType.PERIOD.getFieldKey(), "period");
    }
}

