/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.datalock;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.epm.eb.business.DimensionView.ViewMemberUpgradeService;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.Dimension;
import kd.epm.eb.common.utils.IDUtils;

public class DataLockUpViewService {
    public static void update(Map<Long, Map<Long, Map<String, Object>>> dimViewMapByBaseView, Map<Long, Map<Long, Dimension>> dimensionMapByModel, Long modelId) {
        if (dimViewMapByBaseView == null || dimensionMapByModel == null || IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
            return;
        }
        Map<Long, Dimension> dimensionMap = dimensionMapByModel.getOrDefault(modelId, Maps.newHashMapWithExpectedSize((int)16));
        if (dimensionMap.isEmpty()) {
            return;
        }
        Long entityDimId = 0L;
        String entityNumber = SysDimensionEnum.Entity.getNumber();
        for (Dimension dimension : dimensionMap.values()) {
            if (!entityNumber.equals(dimension.getNumber())) continue;
            entityDimId = dimension.getId();
            break;
        }
        if (IDUtils.isEmptyLong((Long)entityDimId).booleanValue()) {
            return;
        }
        HashMap notPresetViewMap = Maps.newHashMapWithExpectedSize((int)16);
        Long finalEntityDimId = entityDimId;
        dimViewMapByBaseView.forEach((baseViewId, viewMap) -> {
            for (Map.Entry entry : viewMap.entrySet()) {
                Long viewId = (Long)entry.getKey();
                Map view = (Map)entry.getValue();
                Long tempModelId = (Long)view.get("fmodelid");
                Long dimensionId = (Long)view.get("fdimensionid");
                String source = (String)view.get("fsource");
                if (!tempModelId.equals(modelId) || !dimensionId.equals(finalEntityDimId) || !"0".equals(source)) continue;
                notPresetViewMap.put(viewId, view);
            }
        });
        if (notPresetViewMap.isEmpty()) {
            return;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid id, a.fentity entity, b.fentityviewid entityview from t_bgmd_datalockcasedetail a inner join t_bgmd_datalockcase b on b.fid=a.fcaseid and b.fmodelid=?", new Object[]{modelId});
        ArrayList<Object[]> dataLockUpdateParams = new ArrayList<Object[]>(16);
        DataSet rows = ViewMemberUpgradeService.queryDatasetBySql(sqlBuilder, "queryDataLock");
        if (rows != null && !rows.isEmpty()) {
            while (rows.hasNext()) {
                String entity;
                Row row = rows.next();
                Long entityView = row.getLong("entityview");
                if (!notPresetViewMap.containsKey(entityView) || !entityNumber.equals(entity = row.getString("entity"))) continue;
                Map view = (Map)notPresetViewMap.get(entityView);
                String viewNumber = (String)view.get("fnumber");
                String newEntityNumber = entityNumber + "_" + viewNumber;
                Long id = row.getLong("id");
                dataLockUpdateParams.add(new Object[]{newEntityNumber, id});
            }
        }
        DataLockUpViewService.dataLockCaseDetailEntityUpdateRows("t_bgmd_datalockcasedetail", dataLockUpdateParams);
    }

    private static void dataLockCaseDetailEntityUpdateRows(String ebTableName, List<Object[]> paramsList) {
        if (paramsList == null || paramsList.isEmpty()) {
            return;
        }
        String sql = "update " + ebTableName + " set fentity = ? where fid = ?;";
        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql, paramsList);
    }
}

