/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.dataperm;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.entity.memberF7.BaseF7Parameter;
import kd.epm.eb.common.entity.memberF7.LeftTreeF7Parameter;
import kd.epm.eb.common.entity.memberF7.SingleTreeF7Parameter;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.f7.DimMemberF7SelInfo;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.CommonMethod;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;

public interface EbMembPerm {
    default public void switchF7(BeforeF7SelectEvent evt, long busModelId, BaseF7Parameter f7Parameter) {
        if (f7Parameter == null) {
            f7Parameter = new SingleTreeF7Parameter();
        }
        if (f7Parameter instanceof LeftTreeF7Parameter) {
            this.switchLeftTreeF7(evt, busModelId, (LeftTreeF7Parameter)f7Parameter);
        } else {
            this.switchSingleTreeF7(evt, busModelId, (SingleTreeF7Parameter)f7Parameter);
        }
    }

    default public void switchSingleTreeF7(BeforeF7SelectEvent evt, long busModelId, SingleTreeF7Parameter f7Parameter) {
        List qFilters;
        if (f7Parameter == null) {
            f7Parameter = new SingleTreeF7Parameter();
        }
        BasedataEdit basedataEdit = (BasedataEdit)evt.getSource();
        String dimNumber = this.getCurrentDimNumber(basedataEdit.getKey());
        MemberF7Parameter f7Param = NewF7Utils.singleF7(this.getModelId(), NewF7Utils.getDimension(this.getModelId(), dimNumber), ListSelectedRow.class.getName());
        f7Param.setBusModelId(Long.valueOf(busModelId));
        if (IDUtils.isNotNull((Long)f7Parameter.getViewId())) {
            f7Param.setViewId(f7Parameter.getViewId());
        }
        if (CollectionUtils.isNotEmpty((Collection)f7Parameter.getDataSetIds())) {
            f7Param.setDatasetIds(f7Parameter.getDataSetIds());
        }
        f7Param.setOnlySelLeaf(f7Parameter.isOnlyLeaf());
        f7Param.setShowVariable(f7Parameter.isNeedVar());
        f7Param.setVerifyPermission(f7Parameter.isCheckPerm());
        f7Param.setEnableView(f7Parameter.isForceDisableView());
        f7Param.setHideDecompose(!f7Parameter.isQueryDecompose());
        f7Param.setShowDebitAndCredit(f7Parameter.isShowDrcrdirect());
        if (f7Parameter.getOptionalNumber() != null && !f7Parameter.getOptionalNumber().isEmpty()) {
            List members = f7Param.getModelCacheHelper().getMembers(f7Param.getDimensionNumber(), f7Param.getViewId(), (Collection)f7Parameter.getOptionalNumber());
            f7Param.setSelectRangeIds(members.stream().filter(member -> member != null).map(BaseCache::getId).collect(Collectors.toSet()));
        }
        if (evt.getFormShowParameter() instanceof ListShowParameter && CollectionUtils.isNotEmpty((Collection)(qFilters = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters()))) {
            f7Param.addCustomCommFilter(qFilters);
        }
        NewF7Utils.openF7(evt, f7Param);
    }

    default public void switchLeftTreeF7(BeforeF7SelectEvent evt, long busModelId, LeftTreeF7Parameter f7Parameter) {
        this.switchLeftTreeF7(evt, busModelId, f7Parameter, null);
    }

    default public void switchLeftTreeF7(BeforeF7SelectEvent evt, long busModelId, LeftTreeF7Parameter f7Parameter, CloseCallBack closeCallBack) {
        List qFilters;
        if (f7Parameter == null) {
            f7Parameter = new LeftTreeF7Parameter();
        }
        BasedataEdit basedataEdit = (BasedataEdit)evt.getSource();
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        String dimNumber = this.getCurrentDimNumber(basedataEdit.getKey());
        MemberF7Parameter f7Param = showParameter.isMultiSelect() ? NewF7Utils.multipleF7(this.getModelId(), NewF7Utils.getDimension(this.getModelId(), dimNumber), ListSelectedRow.class.getName()) : NewF7Utils.singleF7(this.getModelId(), NewF7Utils.getDimension(this.getModelId(), dimNumber), ListSelectedRow.class.getName());
        f7Param.setBusModelId(Long.valueOf(busModelId));
        if (IDUtils.isNotNull((Long)f7Parameter.getViewId())) {
            f7Param.setViewId(f7Parameter.getViewId());
        }
        if (CollectionUtils.isNotEmpty((Collection)f7Parameter.getDataSetIds())) {
            f7Param.setDatasetIds(f7Parameter.getDataSetIds());
        }
        f7Param.setCanSelectRoot(f7Parameter.isCanSelectRoot());
        f7Param.setCanSelectBudgetPeriodRoot(f7Parameter.isCanSelectBudgetPeriodRoot());
        f7Param.setOnlySelLeaf(f7Parameter.isOnlyLeaf());
        f7Param.setShowVariable(f7Parameter.isNeedVar());
        f7Param.setVerifyPermission(f7Parameter.isCheckPerm());
        f7Param.setEnableView(f7Parameter.isForceDisableView());
        f7Param.setHideDecompose(!f7Parameter.isQueryDecompose());
        f7Param.setShowDebitAndCredit(f7Parameter.isShowDrcrdirect());
        f7Param.setCombPermMap(f7Parameter.getCombPermMap());
        if (f7Parameter.getOptionalNumber() != null) {
            List members = f7Param.getModelCacheHelper().getMembers(f7Param.getDimensionNumber(), f7Param.getViewId(), (Collection)f7Parameter.getOptionalNumber());
            f7Param.setSelectRangeIds(members.stream().filter(Objects::nonNull).map(BaseCache::getId).collect(Collectors.toSet()));
        }
        if (evt.getFormShowParameter() instanceof ListShowParameter && CollectionUtils.isNotEmpty((Collection)(qFilters = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters()))) {
            f7Param.addCustomCommFilter(qFilters);
        }
        NewF7Utils.openF7(evt, f7Param, closeCallBack);
    }

    default public void switchDimF7(BeforeF7SelectEvent beforeF7SelectEvent) {
        FormShowParameter showParameter = beforeF7SelectEvent.getFormShowParameter();
        if (showParameter instanceof ListShowParameter) {
            ListShowParameter listShowParameter = (ListShowParameter)showParameter;
            String billFormId = listShowParameter.getBillFormId();
            SysDimensionEnum EbDimensionEnum = null;
            EbDimensionEnum = SysDimensionEnum.getEnumByTreeNumber((String)billFormId);
            if (EbDimensionEnum != null) {
                String dimNumber = this.getCurrentDimNumber(beforeF7SelectEvent.getProperty().getName());
                if (dimNumber == null) {
                    return;
                }
                Long modelId = this.getModelId();
                if (modelId == null || modelId.equals(0L)) {
                    return;
                }
                MemberF7Parameter f7Param = NewF7Utils.multipleF7(modelId, NewF7Utils.getDimension(modelId, dimNumber), ListSelectedRow.class.getName());
                NewF7Utils.openF7(beforeF7SelectEvent, f7Param);
            }
        }
    }

    default public void switchDimNewF7(BeforeF7SelectEvent evt) {
        this.switchDimNewF7(evt, null);
    }

    default public void switchDimNewF7(BeforeF7SelectEvent evt, Long busModelId) {
        this.switchDimNewF7(evt, busModelId, null);
    }

    default public void switchDimNewF7(BeforeF7SelectEvent evt, Long busModelId, List<Long> datasetIds) {
        this.switchDimNewF7(evt, busModelId, datasetIds, true, null);
    }

    default public void switchDimNewF7(BeforeF7SelectEvent evt, Long busModelId, List<Long> datasetIds, boolean checkPerm, Consumer<MemberF7Parameter> f7ParameterConsumer) {
        ListShowParameter listShowParameter;
        String billFormId;
        SysDimensionEnum EbDimensionEnum;
        FormShowParameter showParameter = evt.getFormShowParameter();
        String f7Key = evt.getProperty().getName();
        if (showParameter instanceof ListShowParameter && (EbDimensionEnum = SysDimensionEnum.getEnumByTreeNumber((String)(billFormId = (listShowParameter = (ListShowParameter)showParameter).getBillFormId()))) != null) {
            BasedataEdit edit;
            Object source;
            boolean unifiedBackF7Val = this.getMemberF7KeySet().contains(f7Key);
            String dimNumber = this.getCurrentDimNumber(f7Key);
            if (dimNumber == null) {
                return;
            }
            Long modelId = this.getModelId();
            if (IDUtils.isNull((Long)modelId)) {
                return;
            }
            MemberF7Parameter f7Param = NewF7Utils.singleF7(modelId, NewF7Utils.getDimension(modelId, dimNumber), ListSelectedRow.class.getName());
            if (busModelId != null) {
                f7Param.setBusModelId(busModelId);
            }
            if (datasetIds != null) {
                f7Param.setDatasetIds(datasetIds);
            }
            if ((source = evt.getSource()) instanceof BasedataEdit && CollectionUtils.isNotEmpty((Collection)(edit = (BasedataEdit)source).getQFilters())) {
                f7Param.addCustomCommFilter(edit.getQFilters());
            }
            f7Param.setVerifyPermission(checkPerm);
            if (f7ParameterConsumer != null) {
                f7ParameterConsumer.accept(f7Param);
            }
            if (unifiedBackF7Val && SysDimensionEnum.dimHasView((String)dimNumber)) {
                Long bizModelId;
                Long viewId = f7Param.getViewId();
                if (IDUtils.isEmptyLong((Long)viewId).booleanValue() && IDUtils.isNotEmptyLong((Long)(bizModelId = f7Param.getBusModelId())).booleanValue()) {
                    viewId = ModelCacheContext.getOrCreate((Long)modelId).getViewByBusModelAndDimNumber(bizModelId, dimNumber);
                    f7Param.setViewId(viewId);
                }
                if (this instanceof AbstractFormPlugin) {
                    if (viewId == null) {
                        viewId = 0L;
                    }
                    ((AbstractFormPlugin)this).getPageCache().put("dimMembF7_" + dimNumber + "_viewId", viewId.toString());
                }
            }
            NewF7Utils.openF7(evt, f7Param);
        }
    }

    default public void dealMemberF7CloseCallback(AfterF7SelectEvent afterF7SelectEvent) {
        ListSelectedRow listSelectedRow = afterF7SelectEvent.getListSelectedRow();
        String f7Key = ((BasedataEdit)afterF7SelectEvent.getSource()).getKey();
        Set<String> memberF7KeySet = this.getMemberF7KeySet();
        if (memberF7KeySet.contains(f7Key)) {
            String dimNumber = this.getCurrentDimNumber(f7Key);
            Long viewId = 0L;
            Long memberId = 0L;
            if (listSelectedRow != null) {
                Map dataMap = listSelectedRow.getDataMap();
                if (dataMap != null) {
                    viewId = ConvertUtils.toLong(dataMap.get("viewid"));
                }
                memberId = IDUtils.toLong((Object)listSelectedRow.getPrimaryKeyValue());
            } else if (StringUtils.isNotEmpty((String)((String)afterF7SelectEvent.getInputValue())) && this instanceof AbstractFormPlugin) {
                AbstractFormPlugin formPlugin = (AbstractFormPlugin)this;
                viewId = IDUtils.toLong((Object)formPlugin.getPageCache().get("dimMembF7_" + dimNumber + "_viewId"));
                memberId = IDUtils.toLong((Object)afterF7SelectEvent.getInputValue());
            }
            DimMemberF7SelInfo f7SelInfo = new DimMemberF7SelInfo();
            f7SelInfo.setMemberId(memberId);
            f7SelInfo.setDimNumber(dimNumber);
            f7SelInfo.setF7Key(f7Key);
            f7SelInfo.setViewId(viewId);
            f7SelInfo.setRowIndex(afterF7SelectEvent.getCurrentRowIndex());
            this.dealSingleMemberF7Back(f7SelInfo);
        }
    }

    default public void dealSingleMemberF7Back(DimMemberF7SelInfo selMember) {
        if (this instanceof CommonMethod) {
            ((CommonMethod)this).cacheDimViewId(selMember.getViewId(), selMember.getF7Key());
        }
    }

    default public void addMemberF7AfterSelListener() {
        if (this instanceof AfterF7SelectListener && this instanceof AbstractFormPlugin) {
            Set<String> memberF7KeySet = this.getMemberF7KeySet();
            AfterF7SelectListener f7SelectListener = (AfterF7SelectListener)this;
            AbstractFormPlugin formPlugin = (AbstractFormPlugin)this;
            if (memberF7KeySet.size() > 0) {
                for (String f7Key : memberF7KeySet) {
                    BasedataEdit basedataEdit = (BasedataEdit)formPlugin.getControl(f7Key);
                    if (basedataEdit == null) continue;
                    basedataEdit.addAfterF7SelectListener(f7SelectListener);
                }
            }
        }
    }

    default public String getCurrentDimNumber(String controlKey) {
        return null;
    }

    default public Long getModelId() {
        return 0L;
    }

    default public Set<String> getMemberF7KeySet() {
        HashSet<String> f7Keys = new HashSet<String>(16);
        String memberF7KeyStr = this.getMemberF7KeyStr();
        if (memberF7KeyStr != null) {
            for (String key : memberF7KeyStr.split(",")) {
                if (!StringUtils.isNotEmpty((String)key)) continue;
                f7Keys.add(key);
            }
        }
        return f7Keys;
    }

    default public String getMemberF7KeyStr() {
        return null;
    }
}

