/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.dataperm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.ViewUpMember;
import kd.epm.eb.common.model.Dimension;
import kd.epm.eb.common.permission.DimMembPermUtil;
import kd.epm.eb.common.permission.MembPermRecordUtil;
import kd.epm.eb.common.permission.enums.PermGroupEnum;
import kd.epm.eb.common.permission.pojo.DimMembPermDetailRecord;
import kd.epm.eb.common.permission.pojo.DimMembPermRecord;
import kd.epm.eb.common.utils.Counter;
import kd.epm.eb.common.utils.IDUtils;

public class MemberPermUpViewService {
    public static void update(Map<Long, Map<Long, List<Map<String, Object>>>> dimPresetBaseViewsByModelMap, Map<Long, Map<Long, Dimension>> dimensionMapByModel, Map<Long, List<Member>> alreadyViewMemberHasChildMapByView, Map<Long, Map<Long, Long>> bizModelRefDimView, Map<Long, Map<Long, Long>> dimPresetViewByModelMap, Long currentModelId) {
        Map dimPresetBaseViews = dimPresetBaseViewsByModelMap.getOrDefault(currentModelId, new HashMap(1));
        Map dimensionMap = dimensionMapByModel.getOrDefault(currentModelId, new HashMap(1));
        Map dimBaseViewMap = dimPresetViewByModelMap.getOrDefault(currentModelId, new HashMap(1));
        HashMap<String, Long> dimShortNumIdMap = new HashMap<String, Long>(dimensionMap.size());
        dimensionMap.values().forEach(dim -> dimShortNumIdMap.put(DimMembPermUtil.getDimShortNumsStr((String)dim.getShortNumber()), dim.getId()));
        HashMap<Long, Pair<Long, Long>> rootMemberIdMap = new HashMap<Long, Pair<Long, Long>>(16);
        HashMap<Long, Long> vrMemberViewMap = new HashMap<Long, Long>(16);
        HashMap<Long, Set<Long>> viewMemberIdMap = new HashMap<Long, Set<Long>>(16);
        MemberPermUpViewService.selDimMemberInfo(dimPresetBaseViews, rootMemberIdMap, vrMemberViewMap, viewMemberIdMap, alreadyViewMemberHasChildMapByView, dimBaseViewMap);
        MemberPermUpViewService.updateManagerPerm(rootMemberIdMap, dimPresetBaseViews, dimShortNumIdMap, viewMemberIdMap, currentModelId);
        MemberPermUpViewService.updateDataPerm(rootMemberIdMap, vrMemberViewMap, dimShortNumIdMap, bizModelRefDimView, dimBaseViewMap, currentModelId);
    }

    private static void selDimMemberInfo(Map<Long, List<Map<String, Object>>> dimPresetBaseViews, Map<Long, Pair<Long, Long>> rootMemberIdMap, Map<Long, Long> vrMemberViewMap, Map<Long, Set<Long>> viewMemberIdMap, Map<Long, List<Member>> alreadyViewMemberHasChildMapByView, Map<Long, Long> dimBaseViewMap) {
        HashMap rootMemberViewMap = new HashMap(16);
        HashSet<Long> baseViewSet = new HashSet<Long>(dimBaseViewMap.values());
        alreadyViewMemberHasChildMapByView.forEach((viewId, members) -> {
            HashSet<Long> memberIdSet = new HashSet<Long>(members.size());
            boolean isNotBaseView = !baseViewSet.contains(viewId);
            for (Member member : members) {
                ViewUpMember _member = (ViewUpMember)member;
                if (IDUtils.isEmptyLong((Long)_member.getParentId()).booleanValue()) {
                    rootMemberViewMap.put(viewId, _member.getMemberId());
                }
                memberIdSet.add(_member.getId());
                if (!_member.isNewMember() || !isNotBaseView) continue;
                vrMemberViewMap.put(_member.getMemberId(), (Long)viewId);
            }
            viewMemberIdMap.put((Long)viewId, (Set<Long>)memberIdSet);
        });
        dimPresetBaseViews.values().forEach(viewList -> {
            Long oldRoot;
            Long baseView = null;
            ArrayList<Long> bizViews = new ArrayList<Long>(viewList.size());
            for (Map viewInfo : viewList) {
                Long viewId = (Long)viewInfo.get("fid");
                if ("1".equals(viewInfo.get("fsource"))) {
                    baseView = viewId;
                    continue;
                }
                bizViews.add(viewId);
            }
            if (baseView != null && bizViews.size() > 0 && (oldRoot = (Long)rootMemberViewMap.get(baseView)) != null) {
                for (Long _viewId : bizViews) {
                    Long newRoot = (Long)rootMemberViewMap.get(_viewId);
                    if (newRoot == null) continue;
                    rootMemberIdMap.put(_viewId, new Pair((Object)oldRoot, (Object)newRoot));
                }
            }
        });
    }

    private static void updateManagerPerm(Map<Long, Pair<Long, Long>> rootMemberIdMap, Map<Long, List<Map<String, Object>>> dimPresetBaseViews, Map<String, Long> dimShortNumIdMap, Map<Long, Set<Long>> viewMemberIdMap, Long currentModelId) {
        Map permRecordMap = MembPermRecordUtil.readMainRecordByModel((Long)currentModelId, (PermGroupEnum)PermGroupEnum.MANAGER);
        if (permRecordMap.isEmpty()) {
            return;
        }
        ArrayList toSaveMainRecord = new ArrayList(16);
        ArrayList toUpRecords = new ArrayList(16);
        permRecordMap.values().forEach(mainRecord -> {
            HashMap toSaveDetailRecord = new HashMap(16);
            String dimNumsStr = mainRecord.getDimNumsStr();
            Long dimId = (Long)dimShortNumIdMap.get(dimNumsStr);
            List baseViews = (List)dimPresetBaseViews.get(dimId);
            if (baseViews != null && mainRecord.getAllDetailRecords().size() > 0) {
                Counter rowCounter = new Counter();
                rowCounter.setSize(((Integer)mainRecord.getAllDetailRecords().keySet().stream().max(Integer::compareTo).get()).intValue());
                for (Map view : baseViews) {
                    Long viewId = (Long)view.get("fid");
                    boolean isBaseView = "1".equals(view.get("fsource"));
                    if (isBaseView) {
                        mainRecord.getAllDetailRecords().values().forEach(memberRecords -> {
                            if (memberRecords[0].isMember()) {
                                toUpRecords.add(new Object[]{viewId, memberRecords[0].getEntryId()});
                            }
                        });
                        continue;
                    }
                    Set memberIdMap = (Set)viewMemberIdMap.get(viewId);
                    if (memberIdMap == null) continue;
                    Pair rootMemberInfo = (Pair)rootMemberIdMap.get(viewId);
                    mainRecord.getAllDetailRecords().values().forEach(memberRecords -> {
                        DimMembPermDetailRecord memberRecord = memberRecords[0];
                        boolean contains = memberIdMap.contains(memberRecord.getMemberId());
                        if (contains || rootMemberInfo != null && IDUtils.equals((Object)memberRecord.getMemberId(), (Object)rootMemberInfo.p1)) {
                            DimMembPermDetailRecord _detailRecord = memberRecord.cloneObj();
                            _detailRecord.setViewId(viewId);
                            if (!contains) {
                                _detailRecord.setMemberId((Long)rootMemberInfo.p2);
                            }
                            rowCounter.addOne();
                            toSaveDetailRecord.put(rowCounter.getSize(), new DimMembPermDetailRecord[]{_detailRecord});
                        }
                    });
                }
                if (!toSaveDetailRecord.isEmpty()) {
                    mainRecord.getAllDetailRecords().clear();
                    mainRecord.getAllDetailRecords().putAll(toSaveDetailRecord);
                    toSaveMainRecord.add(mainRecord);
                }
            }
        });
        MembPermRecordUtil.updateDetailRecord4View(toUpRecords);
        MembPermRecordUtil.saveDetailRecord(toSaveMainRecord, (boolean)true);
    }

    private static void updateDataPerm(Map<Long, Pair<Long, Long>> rootMemberIdMap, Map<Long, Long> vrMemberViewMap, Map<String, Long> dimShortNumIdMap, Map<Long, Map<Long, Long>> bizModelDimViewMap, Map<Long, Long> dimBaseViewMap, Long currentModelId) {
        Map permRecordMap = MembPermRecordUtil.readMainRecordByModel((Long)currentModelId, (PermGroupEnum)PermGroupEnum.DATA);
        if (permRecordMap.isEmpty()) {
            return;
        }
        HashMap baseViewBizModelsMap = new HashMap(16);
        bizModelDimViewMap.forEach((bizModelId, dimViewMap) -> dimViewMap.forEach((dimId, viewId) -> {
            if (viewId.equals(dimBaseViewMap.get(dimId))) {
                baseViewBizModelsMap.computeIfAbsent(viewId, key -> new HashSet(16)).add(bizModelId);
            }
        }));
        ArrayList toSaveMainRecord = new ArrayList(16);
        ArrayList toUpRecords1 = new ArrayList(16);
        ArrayList toUpRecords2 = new ArrayList(16);
        permRecordMap.values().forEach(mainRecord -> {
            List shortNums = DimMembPermUtil.getDimShortNumsByStr((String)mainRecord.getDimNumsStr(), (boolean)true);
            Long bizModelId = mainRecord.getBizCtrlRangeId();
            if (IDUtils.isNotEmptyLong((Long)bizModelId).booleanValue()) {
                Map dimViewMap = (Map)bizModelDimViewMap.get(bizModelId);
                if (bizModelId != null) {
                    int index = 0;
                    for (String dimShortNum : shortNums) {
                        Long viewId;
                        Long dimId = (Long)dimShortNumIdMap.get(dimShortNum);
                        if (dimId != null && (viewId = (Long)dimViewMap.get(dimId)) != null) {
                            Set refBizModelIds;
                            Pair rootMemberInfo = (Pair)rootMemberIdMap.get(viewId);
                            for (DimMembPermDetailRecord[] memberRecord : mainRecord.getAllDetailRecords().values()) {
                                boolean upMember = false;
                                if (!memberRecord[index].isMember()) continue;
                                Long vrViewId = (Long)vrMemberViewMap.get(memberRecord[index].getMemberId());
                                if (vrViewId != null) {
                                    memberRecord[index].setViewId(vrViewId);
                                } else {
                                    if (rootMemberInfo != null && IDUtils.equals((Object)rootMemberInfo.p1, (Object)memberRecord[index].getMemberId())) {
                                        memberRecord[index].setMemberId((Long)rootMemberInfo.p2);
                                        upMember = true;
                                    }
                                    memberRecord[index].setViewId(viewId);
                                }
                                if (upMember) {
                                    toUpRecords2.add(new Object[]{memberRecord[index].getViewId(), memberRecord[index].getMemberId(), memberRecord[index].getEntryId()});
                                    continue;
                                }
                                toUpRecords1.add(new Object[]{memberRecord[index].getViewId(), memberRecord[index].getEntryId()});
                            }
                            if (shortNums.size() == 1 && (refBizModelIds = (Set)baseViewBizModelsMap.get(viewId)) != null && refBizModelIds.size() > 1) {
                                for (Long _bizModelId : refBizModelIds) {
                                    if (bizModelId.equals(_bizModelId)) continue;
                                    DimMembPermRecord newPermRecord = mainRecord.cloneObj();
                                    newPermRecord.setBizModelId(_bizModelId);
                                    toSaveMainRecord.add(newPermRecord);
                                }
                            }
                        }
                        ++index;
                    }
                }
            }
        });
        MembPermRecordUtil.updateDetailRecord4View(toUpRecords1);
        MembPermRecordUtil.upDetailRecord4ViewAndMember(toUpRecords2);
        MembPermRecordUtil.savePermRecord(toSaveMainRecord);
    }
}

