/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.dataset;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.enums.BizModelEnum;
import kd.epm.eb.common.enums.DataSetPresetDimEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.base.LanguageUtils;

public class BizModelPreset {
    public static void presetData(String modelId, List<Long> ids, Map<Long, Long> viewMap, Map<Long, Long> viewGroupMap, boolean isBgmdModelSave) {
        if (BizModelPreset.isExistPreset(modelId) || ids == null) {
            return;
        }
        BizModelEnum bizModelEnum = BizModelEnum.AUNNALBUDGET;
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"eb_businessmodel");
        dynamicObject.set("number", (Object)bizModelEnum.getNumber());
        dynamicObject.set("name", (Object)LanguageUtils.getLocaleValue((String)bizModelEnum.getName(), (String)bizModelEnum.getNameKey().getResourceID(), (String)"epm-eb-common"));
        dynamicObject.set("model", (Object)Long.parseLong(modelId));
        dynamicObject.set("creater", (Object)UserUtils.getUserId());
        dynamicObject.set("createdate", (Object)TimeServiceHelper.now());
        dynamicObject.set("modifier", (Object)UserUtils.getUserId());
        dynamicObject.set("modifydate", (Object)TimeServiceHelper.now());
        dynamicObject.set("issyspreset", (Object)bizModelEnum.getIsSysPreset());
        DynamicObjectCollection appscenarios = dynamicObject.getDynamicObjectCollection("scenarioentry");
        for (Long id : ids) {
            DynamicObject row = appscenarios.addNew();
            DynamicObject appscenario = BusinessDataServiceHelper.newDynamicObject((String)"eb_applicationscenario");
            appscenario.set("id", (Object)id);
            row.set("appscenario", (Object)appscenario);
        }
        DynamicObjectCollection viewEntry = dynamicObject.getDynamicObjectCollection("viewentry");
        HashMap<Long, String> dimNumberMap = new HashMap<Long, String>(16);
        List<Long> dimIds = BizModelPreset.getPresetDimensionIds(modelId, dimNumberMap);
        for (Long id : dimIds) {
            DynamicObject row = viewEntry.addNew();
            DynamicObject dimension = BusinessDataServiceHelper.newDynamicObject((String)"epm_dimension");
            dimension.set("id", (Object)id);
            row.set("dimension", (Object)dimension);
            if (isBgmdModelSave) {
                if (!viewGroupMap.containsKey(id) || dimNumberMap.get(id) == null || !SysDimensionEnum.dimHasView((String)((String)dimNumberMap.get(id)))) continue;
                DynamicObject viewGroup = BusinessDataServiceHelper.newDynamicObject((String)"eb_dimensionview_group");
                viewGroup.set("id", (Object)viewGroupMap.get(id));
                row.set("viewgroup", (Object)viewGroup);
                continue;
            }
            if (!viewMap.containsKey(id) || dimNumberMap.get(id) == null || !SysDimensionEnum.Entity.getNumber().equals(dimNumberMap.get(id))) continue;
            DynamicObject view = BusinessDataServiceHelper.newDynamicObject((String)"eb_dimensionview");
            view.set("id", (Object)viewMap.get(id));
            row.set("view", (Object)view);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    public static boolean isExistPreset(String modelId) {
        QFilter qFilter = new QFilter("model", "=", (Object)Long.parseLong(modelId));
        QFilter qFilter1 = new QFilter("number", "=", (Object)"AunnalBudget");
        boolean exists = QueryServiceHelper.exists((String)"eb_businessmodel", (QFilter[])new QFilter[]{qFilter, qFilter1});
        return exists;
    }

    public static DynamicObject queryByNumber(String modelId) {
        QFilter qFilter = new QFilter("model", "=", (Object)Long.parseLong(modelId));
        QFilter qFilter1 = new QFilter("number", "=", (Object)"AunnalBudget");
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_businessmodel", (String)"id,number,name,issyspreset", (QFilter[])new QFilter[]{qFilter, qFilter1});
        return dynamicObject;
    }

    public static List<Long> getPresetDimensionIds(String modelId, Map<Long, String> dimNumberMap) {
        ArrayList<Long> list = new ArrayList<Long>(16);
        ArrayList dimensionNumber = new ArrayList(16);
        dimensionNumber.addAll(DataSetPresetDimEnum.getAllNumber());
        QFilter modelQf = new QFilter("model", "=", (Object)Long.parseLong(modelId));
        QFilter qFilter = new QFilter("number", "in", dimensionNumber);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"epm_dimension", (String)"id,number", (QFilter[])new QFilter[]{modelQf, qFilter}, (String)"dseq asc");
        if (dynamicObjects != null && dynamicObjects.size() > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                list.add(dynamicObject.getLong("id"));
                dimNumberMap.put(dynamicObject.getLong("id"), dynamicObject.getString("number"));
            }
        }
        return list;
    }
}

