/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.dataupload;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.decompose.entity.AdjustDecomposeDetail;
import kd.epm.eb.common.decompose.entity.AdjustDecomposeRecord;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;
import org.apache.commons.lang3.StringUtils;

public class DataReleaseUtils {
    public static Map<Long, DynamicObject> getAllDataMapping(Long modelId, Long bizModelId) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Set dimensionIds = modelCacheHelper.getDimensionListByBusModel(bizModelId).stream().map(BaseCache::getId).collect(Collectors.toSet());
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"eb_datarelease_dimmap", (String)"id,srcdim,tardim,tarmember,maponly,membermap,tarmembertype,memberexclude", (QFilter[])new QFilter("srcdim", "in", dimensionIds).toArray());
        HashMap<Long, DynamicObject> mappingMap = new HashMap<Long, DynamicObject>(load.length);
        for (DynamicObject dynamicObject : load) {
            mappingMap.put(dynamicObject.getLong("id"), dynamicObject);
        }
        return mappingMap;
    }

    public static AdjustDecomposeRecord buildAdjustDecomposeRecord(IModelCacheHelper srcModelCache, Map<Long, DynamicObject> allDataMapping, Map<Long, DynamicObject> memberMapping, Map<String, String> srcDimensionMap, DynamicObject dynamicObject, DynamicObject decomposeAdjust) {
        AdjustDecomposeRecord record = new AdjustDecomposeRecord();
        HashMap<String, String> memberMap = new HashMap<String, String>(16);
        HashMap<String, String> viewJsonMap = new HashMap<String, String>(16);
        long tarModel = dynamicObject.getLong("tarmodel.id");
        DynamicObject tarBizModel = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.getLong("tarbizmodel.id"), (String)"eb_businessmodel");
        DynamicObjectCollection viewentry = tarBizModel.getDynamicObjectCollection("viewentry");
        HashMap<Long, Long> dimBaseViewMap = new HashMap<Long, Long>(16);
        for (DynamicObject dyObject : viewentry) {
            DynamicObject view = dyObject.getDynamicObject("view");
            if (view == null) continue;
            dimBaseViewMap.put(dyObject.getDynamicObject("dimension").getLong("id"), view.getLong("id"));
        }
        long tarOrgView = dynamicObject.getLong("tarorgview.id");
        IModelCacheHelper tarModelCache = ModelCacheContext.getOrCreate((Long)tarModel);
        DynamicObjectCollection dataReleaseMap = dynamicObject.getDynamicObjectCollection("datareleasemap");
        for (DynamicObject object : dataReleaseMap) {
            Optional<Member> first;
            DynamicObject mappingObj = allDataMapping.get(object.getLong("fbasedataid_id"));
            if (mappingObj == null) continue;
            long srcDimId = mappingObj.getLong("srcdim.id");
            long tarDimId = mappingObj.getLong("tardim.id");
            if (IDUtils.isNull((long)tarDimId)) continue;
            String tarDimNumber = mappingObj.getString("tardim.number");
            long tarDimViewId = 0L;
            if (SysDimensionEnum.Entity.getNumber().equals(tarDimNumber)) {
                tarDimViewId = tarOrgView;
            } else if (dimBaseViewMap.get(tarDimId) != null) {
                tarDimViewId = (Long)dimBaseViewMap.get(tarDimId);
            }
            List members = tarModelCache.getMembers(Long.valueOf(tarDimViewId), tarDimNumber);
            if (IDUtils.isNull((long)srcDimId) && (first = members.stream().filter(member -> member.getId().longValue() == mappingObj.getLong("tarmember.id")).findFirst()).isPresent()) {
                Member member2 = first.get();
                memberMap.put(tarDimNumber, member2.getNumber());
                if (member2.isLeaf() && IDUtils.isNotNull((long)tarDimViewId)) {
                    viewJsonMap.put(tarDimNumber, String.valueOf(tarDimViewId));
                }
            }
            String srcDimNumber = mappingObj.getString("srcdim.number");
            String memberExclude = mappingObj.getString("memberexclude");
            String srcMemberNumber = srcDimensionMap.get(srcDimNumber);
            if (StringUtils.isEmpty((CharSequence)srcMemberNumber)) {
                Dimension srcDimension = srcModelCache.getDimension(srcDimNumber);
                srcMemberNumber = srcDimension.getNoneNumber();
            }
            if (StringUtils.isNotEmpty((CharSequence)memberExclude)) {
                String[] split;
                for (String number : split = memberExclude.split(",")) {
                    if (!Objects.equals(srcMemberNumber, number)) continue;
                    return record;
                }
            }
            Long memberMappingId = mappingObj.getLong("membermap.id");
            DynamicObject membermap = memberMapping.get(memberMappingId);
            boolean mapOnly = mappingObj.getBoolean("maponly");
            String tarMemberNumber = "";
            if (membermap != null) {
                DynamicObjectCollection membermapentity = membermap.getDynamicObjectCollection("membermapentity");
                for (DynamicObject mapEntry : membermapentity) {
                    boolean status = mapEntry.getBoolean("state");
                    if (!status || !Objects.equals(mapEntry.getString("srcmembernumber"), srcMemberNumber)) continue;
                    String finalTarMemberNumber = tarMemberNumber = mapEntry.getString("tarmembernumber");
                    Optional<Member> first2 = members.stream().filter(member -> finalTarMemberNumber.equals(member.getNumber())).findFirst();
                    if (first2.isPresent()) {
                        Member member3 = first2.get();
                        if (member3.isLeaf() && IDUtils.isNotNull((long)tarDimViewId)) {
                            viewJsonMap.put(tarDimNumber, String.valueOf(tarDimViewId));
                        }
                        DataReleaseUtils.popularRecord(record, memberMap, member3, tarDimNumber);
                        continue;
                    }
                    return null;
                }
                if (StringUtils.isEmpty((CharSequence)tarMemberNumber) && mapOnly) {
                    return null;
                }
            }
            if (!StringUtils.isEmpty((CharSequence)tarMemberNumber)) continue;
            if (SysDimensionEnum.Entity.getNumber().equals(tarDimNumber)) {
                String finalSrcMemberNumber = srcMemberNumber;
                Optional<Member> first3 = members.stream().filter(member -> finalSrcMemberNumber.equals(member.getNumber())).findFirst();
                if (first3.isPresent()) {
                    Member member4 = first3.get();
                    if (member4.isLeaf() && IDUtils.isNotNull((long)tarDimViewId)) {
                        viewJsonMap.put(tarDimNumber, String.valueOf(tarDimViewId));
                    }
                    DataReleaseUtils.popularRecord(record, memberMap, member4, tarDimNumber);
                    continue;
                }
                return null;
            }
            Member member5 = tarModelCache.getMember(tarDimNumber, Long.valueOf(tarDimViewId), srcMemberNumber);
            if (member5 != null) {
                if (member5.isLeaf() && IDUtils.isNotNull((long)tarDimViewId)) {
                    viewJsonMap.put(tarDimNumber, String.valueOf(tarDimViewId));
                }
                DataReleaseUtils.popularRecord(record, memberMap, member5, tarDimNumber);
                continue;
            }
            return null;
        }
        record.setModelId(Long.valueOf(tarModel));
        record.setBusinessModelId(Long.valueOf(dynamicObject.getLong("tarbizmodel.id")));
        record.setVersionId(Long.valueOf(dynamicObject.getLong("receiveversion.id")));
        memberMap.put(SysDimensionEnum.Version.getNumber(), dynamicObject.getString("receiveversion.number"));
        record.setDataTypeId(Long.valueOf(dynamicObject.getLong("receivedatatype.id")));
        memberMap.put(SysDimensionEnum.DataType.getNumber(), dynamicObject.getString("receivedatatype.number"));
        Member budgetMember = tarModelCache.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, srcDimensionMap.get(SysDimensionEnum.BudgetPeriod.getNumber()));
        memberMap.put(SysDimensionEnum.BudgetPeriod.getNumber(), budgetMember.getNumber());
        record.setBudgetPeriodId(budgetMember.getId());
        Member auditTrailMember = tarModelCache.getMember(SysDimensionEnum.AuditTrail.getNumber(), null, srcDimensionMap.get(SysDimensionEnum.AuditTrail.getNumber()));
        memberMap.put(SysDimensionEnum.AuditTrail.getNumber(), auditTrailMember.getNumber());
        record.setAuditTrailId(auditTrailMember.getId());
        record.setMemberMap(memberMap);
        AdjustDecomposeDetail adjustDecomposeDetail = new AdjustDecomposeDetail();
        adjustDecomposeDetail.setType(Integer.valueOf(decomposeAdjust.getInt("type")));
        adjustDecomposeDetail.setPendingTrial(decomposeAdjust.get("pendingtrial"));
        adjustDecomposeDetail.setAdjustTrial((Object)decomposeAdjust.getBigDecimal("adjusttrial"));
        adjustDecomposeDetail.setFixTrial(decomposeAdjust.get("fixtrial"));
        adjustDecomposeDetail.setSourceAdjustId(Long.valueOf(decomposeAdjust.getLong("entryid")));
        adjustDecomposeDetail.setAdjustExplain(decomposeAdjust.getString("adjustexplain"));
        adjustDecomposeDetail.setStatus(Integer.valueOf(decomposeAdjust.getInt("status")));
        adjustDecomposeDetail.setViewMap(viewJsonMap);
        adjustDecomposeDetail.setSourceModelId(srcModelCache.getModelobj().getId());
        adjustDecomposeDetail.setEntityViewId(Long.valueOf(tarOrgView));
        adjustDecomposeDetail.setUploadStatus("0");
        record.setDetails(Collections.singletonList(adjustDecomposeDetail));
        return record;
    }

    public static void popularRecord(AdjustDecomposeRecord record, Map<String, String> memberMap, Member member, String tarDimNumber) {
        SysDimensionEnum enumByNumber = SysDimensionEnum.getEnumByNumber((String)tarDimNumber);
        if (enumByNumber == null) {
            memberMap.put(tarDimNumber, member.getNumber());
            return;
        }
        if (SysDimensionEnum.Entity.getNumber().equals(tarDimNumber)) {
            record.setEntityId(member.getId());
        } else if (SysDimensionEnum.Account.getNumber().equals(tarDimNumber)) {
            record.setDataSetId(member.getDatasetId());
            record.setAccountId(member.getId());
        } else if (SysDimensionEnum.BudgetPeriod.getNumber().equals(tarDimNumber)) {
            record.setBudgetPeriodId(member.getId());
        } else if (SysDimensionEnum.AuditTrail.getNumber().equals(tarDimNumber)) {
            record.setAuditTrailId(member.getId());
        } else if (SysDimensionEnum.Currency.getNumber().equals(tarDimNumber)) {
            record.setCurrencyId(member.getId());
        }
        memberMap.put(tarDimNumber, member.getNumber());
    }

    public static void sendMessage(String msgReceivers, String srcModelName, String tarModelName) {
        LocaleString title = new LocaleString();
        title.setLocaleValue(ResManager.loadKDString((String)"\u6570\u636e\u4e0b\u8fbe\u6d88\u606f\u63d0\u9192", (String)"BgTaskTransferSettingPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        LocaleString content = new LocaleString();
        content.setLocaleValue(ResManager.loadResFormat((String)"%1\u4f53\u7cfb\u63a5\u5230%2\u4f53\u7cfb\u4e0b\u8fbe\u7684\u8c03\u6574\u8bb0\u5f55\uff0c\u8bf7\u53ca\u65f6\u5206\u89e3\u3002", (String)"", (String)"epm-eb-formplugin", (Object[])new Object[]{tarModelName, srcModelName}));
        LocaleString tag = new LocaleString();
        tag.setLocaleValue(ResManager.loadKDString((String)"\u6570\u636e\u4e0b\u8fbe", (String)"DecomposeSchemeListPlugin_47", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        String[] split = msgReceivers.split(",");
        List userIds = Arrays.stream(split).map(Long::parseLong).collect(Collectors.toList());
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setMessageTitle((ILocaleString)title);
        messageInfo.setMessageContent((ILocaleString)content);
        messageInfo.setUserIds(userIds);
        messageInfo.setSenderId(UserUtils.getUserId());
        messageInfo.setSendTime(new Date(System.currentTimeMillis()));
        messageInfo.setMessageTag((ILocaleString)tag);
        MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
    }

    public static Map<String, Set<Long>> getReleaseDetailLog(long releaseSchemeId, List<DynamicObject> decomposeAdjusts, String status) {
        HashMap<String, Set<Long>> detailLogMap = new HashMap<String, Set<Long>>(16);
        QFilter releaseSchemeFilter = new QFilter("datareleaselog.releasescheme", "=", (Object)releaseSchemeId);
        QFilter adjustDecomposeFilter = new QFilter("adjustdecompose", "in", decomposeAdjusts.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toSet()));
        QFilter statusFilter = new QFilter("status", "=", (Object)status);
        DynamicObjectCollection detailLogs = QueryServiceHelper.query((String)"eb_datarelease_detail_log", (String)"adjustdecompose,tarmodel,tarbizmodel", (QFilter[])new QFilter[]{releaseSchemeFilter, adjustDecomposeFilter, statusFilter});
        for (DynamicObject detailLog : detailLogs) {
            String key = detailLog.getLong("tarmodel") + "_" + detailLog.getLong("tarbizmodel");
            Set strings = detailLogMap.computeIfAbsent(key, v -> new HashSet(16));
            strings.add(detailLog.getLong("adjustdecompose"));
        }
        return detailLogMap;
    }

    public static Map<Long, DynamicObject> getAllMemberMapping(long modelId) {
        QFilter qFilter = new QFilter("srcmodel", "=", (Object)modelId).and("status", "=", (Object)true);
        DynamicObject[] eb_dim_membermaps = BusinessDataServiceHelper.load((String)"eb_dim_membermap", (String)"id,membermapentity.srcmembernumber,membermapentity.tarmembernumber,state", (QFilter[])qFilter.toArray());
        HashMap<Long, DynamicObject> memberMapping = new HashMap<Long, DynamicObject>(eb_dim_membermaps.length);
        for (DynamicObject eb_dim_membermap : eb_dim_membermaps) {
            memberMapping.put(eb_dim_membermap.getLong("id"), eb_dim_membermap);
        }
        return memberMapping;
    }
}

