/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.dataupload;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.dataupload.ModelUploadContext;
import kd.epm.eb.business.dataupload.entity.DatasetMapperGroup;
import kd.epm.eb.business.dataupload.entity.ModeluploadMapperInfo;
import kd.epm.eb.business.dataupload.entity.ModeluploadMemberMapper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.cache.impl.ViewMember;
import kd.epm.eb.common.elasticsearch.OlapDataAuditEventEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MemberSourceEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.enums.dimensionEnums.ViewMemberSourceEnum;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.olapdao.BGCells;
import kd.epm.eb.common.olapdao.BgmdOlapReader;
import kd.epm.eb.common.olapdao.BgmdShrekDao;
import kd.epm.eb.common.olapdao.OlapContext;
import kd.epm.eb.common.olapdao.OlapWriteOption;
import kd.epm.eb.common.olapdao.SaveDataContext;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.util.ShrekOlapUtils;
import kd.epm.eb.common.utils.Builder;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.threadpool.EBThreadPoolExecutor;
import kd.epm.eb.olap.service.OlapManager;
import kd.epm.eb.olap.service.request.QueryRequest;
import kd.epm.eb.olap.service.request.SaveRequest;
import kd.epm.eb.olap.service.view.ViewMemberManager;
import kd.epm.eb.olap.service.view.bean.DimensionViewMember;
import kd.epm.epbs.business.log.trace.OlapTraceServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.time.DateUtils;

public class ModelUploadService {
    private static final Log log = LogFactory.getLog(ModelUploadService.class);
    public static final EBThreadPoolExecutor pool = new EBThreadPoolExecutor(16, 16, 50L, TimeUnit.SECONDS, new LinkedBlockingQueue());
    private static final int QUERY_COUNT = Integer.parseInt(System.getProperty("eb_modelupload_query_count", "100000"));
    private static final int ORG_SIZE = Integer.parseInt(System.getProperty("eb_modelupload_org_size", "1"));
    private static final int ACTIVE_COUNT = 8;

    public static ModelUploadService getInstance() {
        return InnerClass.instance;
    }

    private ModelUploadService() {
    }

    public boolean checkCover(Long id, Map<String, String> pageParamMap) {
        String tarVersion = pageParamMap.get("tarVersion");
        String org = pageParamMap.get("org");
        String bp = pageParamMap.get("bp");
        DynamicObject modelUpload = BusinessDataServiceHelper.loadSingle((Object)id, (String)"eb_modelupload");
        DynamicObject srcmodel = modelUpload.getDynamicObject("srcmodel");
        DynamicObject srcbiz = modelUpload.getDynamicObject("srcbiz");
        DynamicObject tarbiz = modelUpload.getDynamicObject("tarbiz");
        DynamicObject tarmodel = modelUpload.getDynamicObject("tarmodel");
        long srcModelId = srcmodel.getLong("id");
        IModelCacheHelper srcModelCache = ModelCacheContext.getOrCreate((Long)srcModelId);
        long tarModelId = tarmodel.getLong("id");
        IModelCacheHelper tarModelCache = ModelCacheContext.getOrCreate((Long)tarModelId);
        ModelUploadContext ctx = new ModelUploadContext(srcModelCache, tarModelCache);
        ctx.setSrcbiz(srcbiz);
        ctx.setTarbiz(tarbiz);
        DynamicObjectCollection dimmapentity = modelUpload.getDynamicObjectCollection("dimmapentity");
        ctx.setDimmapentity(dimmapentity);
        this.initMembermapperMap(ctx);
        Map<String, List<Member>> tarDimMemberMap = this.getTarDimMemberMap(ctx);
        Map<String, List<Member>> srcDimMemberMap = this.getSrcDimMemberMap(ctx);
        Map<String, List<Member>> queryDimmemberMap = this.buildTarQueryDimMemberMap(ctx, srcDimMemberMap, tarDimMemberMap);
        List<Object> bpMemberList = tarDimMemberMap.get(SysDimensionEnum.BudgetPeriod.getNumber());
        List<String> bpMemberStrList = Arrays.asList(StringUtils.split((String)bp, (String)","));
        bpMemberList = bpMemberList.stream().filter(e -> bpMemberStrList.contains(e.getNumber())).collect(Collectors.toList());
        queryDimmemberMap.put(SysDimensionEnum.BudgetPeriod.getNumber(), bpMemberList);
        List<Object> verMemberList = tarDimMemberMap.get(SysDimensionEnum.Version.getNumber());
        verMemberList = verMemberList.stream().filter(e -> e.getNumber().equals(tarVersion)).collect(Collectors.toList());
        queryDimmemberMap.put(SysDimensionEnum.Version.getNumber(), verMemberList);
        List<Object> tarOrgMembers = tarDimMemberMap.get(SysDimensionEnum.Entity.getNumber());
        List<String> orgMemberStrList = Arrays.asList(StringUtils.split((String)org, (String)","));
        tarOrgMembers = tarOrgMembers.stream().filter(e -> orgMemberStrList.contains(e.getNumber())).collect(Collectors.toList());
        queryDimmemberMap.put(SysDimensionEnum.Entity.getNumber(), tarOrgMembers);
        List<Member> tarAccMemberList = queryDimmemberMap.get(SysDimensionEnum.Account.getNumber());
        if (CollectionUtils.isEmpty(tarAccMemberList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u4e0b\u65e0\u6709\u6548\u7684\u79d1\u76ee\u6620\u5c04\u3002", (String)"ModelUploadService_0", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        Map<Long, List<Member>> tarAccGroupMap = tarAccMemberList.stream().collect(Collectors.groupingBy(Member::getDatasetId));
        HashMap<String, Set<String>> srcDimMemberNumMap = new HashMap<String, Set<String>>(srcDimMemberMap.size());
        srcDimMemberMap.forEach((dimNum, members) -> srcDimMemberNumMap.put((String)dimNum, members.stream().map(BaseCache::getNumber).collect(Collectors.toSet())));
        for (Map.Entry<Long, List<Member>> datasetEntry : tarAccGroupMap.entrySet()) {
            Long tarDatasetId = datasetEntry.getKey();
            List<Member> tarAccMembers = datasetEntry.getValue();
            List tarDimensions = tarModelCache.getDimensionList(tarDatasetId);
            Boolean queryFlag = Boolean.TRUE;
            HashMap queryMemberMap = Maps.newHashMap();
            for (Dimension tarDim : tarDimensions) {
                DynamicObject dimMapper;
                String tarmembernumber;
                String tarDimNumber = tarDim.getNumber();
                if (SysDimensionEnum.Account.getNumber().equals(tarDimNumber)) {
                    Set tarAccMemberNumber = tarAccMembers.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                    queryMemberMap.put(tarDimNumber, tarAccMemberNumber);
                    continue;
                }
                List<Member> members2 = queryDimmemberMap.get(tarDimNumber);
                Optional<DynamicObject> optDimMapper = dimmapentity.stream().filter(e -> this.getDimNumber(e.getDynamicObject("tardim")).equals(tarDimNumber)).findFirst();
                if (optDimMapper.isPresent() && StringUtils.isNotBlank((CharSequence)(tarmembernumber = this.getMemberNumber((dimMapper = optDimMapper.get()).getDynamicObject("tarmember"))))) {
                    queryMemberMap.put(tarDimNumber, Sets.newHashSet((Object[])new String[]{tarmembernumber}));
                    continue;
                }
                if (CollectionUtils.isEmpty(members2)) {
                    queryFlag = Boolean.FALSE;
                    break;
                }
                queryMemberMap.put(tarDimNumber, members2.stream().map(BaseCache::getNumber).collect(Collectors.toSet()));
            }
            if (!queryFlag.booleanValue() || !(queryFlag = Boolean.valueOf(this.removeTarNoCoverMembers(ctx, srcDimMemberNumMap, queryMemberMap))).booleanValue()) continue;
            log.info("\u8986\u76d6\u6821\u9a8c\u53d1\u8d77olap#reder\u67e5\u8be2\uff1a" + JSON.toJSONString((Object)queryMemberMap));
            BgmdOlapReader reader = OlapManager.getInstance().queryReader(new QueryRequest(tarModelCache.getModelobj().getId(), tarDatasetId, (Map)queryMemberMap));
            Throwable throwable = null;
            try {
                if (!reader.hasNext()) continue;
                boolean bl = Boolean.TRUE;
                return bl;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader == null) continue;
                if (throwable != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                reader.close();
            }
        }
        return Boolean.FALSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void executeUpload(Long id, Map<String, String> pageParamMap, IPageCache pageCache, String schemeNumber) {
        log.info("\u5f00\u59cb\u6267\u884c\u6570\u636e\u4e0a\u4f20");
        Double progress = 5.0;
        String progressKey = "eb_modelupload_" + id + "_";
        if (pageCache != null) {
            progressKey = progressKey + pageCache.getPageId();
            CacheServiceHelper.put((String)progressKey, (Object)String.valueOf(progress.intValue()));
        }
        log.info("\u5904\u7406\u9875\u9762\u53c2\u6570");
        String srcVersion = pageParamMap.get("srcVersion");
        String srcVersionName = pageParamMap.get("srcVersionName");
        String tarVersion = pageParamMap.get("tarVersion");
        String tarVersionName = pageParamMap.get("tarVersionName");
        String org = pageParamMap.get("org");
        String orgName = pageParamMap.get("orgName");
        String bp = pageParamMap.get("bp");
        log.info("\u6821\u9a8c\u91cd\u590d\u6267\u884c");
        this.validRepeatRun(id);
        DynamicObject modelUpload = BusinessDataServiceHelper.loadSingle((Object)id, (String)"eb_modelupload");
        DynamicObject srcmodel = modelUpload.getDynamicObject("srcmodel");
        DynamicObject srcbiz = modelUpload.getDynamicObject("srcbiz");
        DynamicObject tarbiz = modelUpload.getDynamicObject("tarbiz");
        DynamicObject tarmodel = modelUpload.getDynamicObject("tarmodel");
        DynamicObjectCollection dimmapentity = modelUpload.getDynamicObjectCollection("dimmapentity");
        long srcModelId = srcmodel.getLong("id");
        long tarModelId = tarmodel.getLong("id");
        IModelCacheHelper srcModelCache = ModelCacheContext.getOrCreate((Long)srcModelId);
        IModelCacheHelper tarModelCache = ModelCacheContext.getOrCreate((Long)tarModelId);
        ModelUploadContext ctx = new ModelUploadContext(srcModelCache, tarModelCache);
        ctx.setSrcbiz(srcbiz);
        ctx.setTarbiz(tarbiz);
        ctx.setDimmapentity(dimmapentity);
        Set<String> transferDimNumbers = this.queryRecParameter(tarModelId, Long.parseLong(pageParamMap.get("tarVersionId")));
        List<String> transferInfo = this.transferDimMember(transferDimNumbers, ctx);
        ctx.setTarModelCache(ModelCacheContext.getOrCreate((Long)tarModelId));
        int totalCnt = 0;
        int successCnt = 0;
        int failCnt = 0;
        DynamicObject dymLog = this.addLog(id, srcVersionName, tarVersionName, orgName, bp, successCnt, failCnt, transferInfo);
        long start = System.currentTimeMillis();
        boolean failExecute = false;
        try {
            this.initMembermapperMap(ctx);
            Map<String, List<Member>> srcDimMemberMap = this.getSrcDimMemberMap(ctx);
            Map<String, List<Member>> tarDimMemberMap = this.getTarDimMemberMap(ctx);
            Map<Long, DynamicObject> tarDimMemberDynMap = this.getTraMetricMemberDynMap(ctx);
            log.info("\u5f00\u59cb\u5220\u9664\u76ee\u6807\u6570\u636e");
            OlapTraceServiceHelper.setTraceOpInfo((String)schemeNumber);
            OlapContext.setSaveDataContext((SaveDataContext)new SaveDataContext(OlapDataAuditEventEnum.DataUpload));
            this.cleanTargetData(tarVersion, org, bp, srcDimMemberMap, tarDimMemberMap, ctx);
            log.info("\u5220\u9664\u76ee\u6807\u6570\u636e\u5b8c\u6210");
            if (pageCache != null) {
                progress = this.updateProgress(progress + 9.0, progressKey);
            }
            HashMap queryMemberMap = Maps.newHashMap();
            Map<String, List<Member>> queryDimmemberMap = this.buildSrcQueryDimMemberMap(ctx, srcDimMemberMap, tarDimMemberMap);
            log.info("\u9884\u7b97\u671f\u95f4\u5904\u7406");
            List<String> bpMemberStrList = Arrays.asList(StringUtils.split((String)bp, (String)","));
            queryMemberMap.put(SysDimensionEnum.BudgetPeriod.getNumber(), new HashSet<String>(bpMemberStrList));
            log.info("\u7248\u672c\u5904\u7406");
            queryMemberMap.put(SysDimensionEnum.Version.getNumber(), Sets.newHashSet((Object[])new String[]{srcVersion}));
            log.info("\u7ec4\u7ec7\u5904\u7406");
            List<Member> orgMemberList = this.getSrcOrgMemberList(org, ctx, srcDimMemberMap.get(SysDimensionEnum.Entity.getNumber()));
            queryMemberMap.put(SysDimensionEnum.Entity.getNumber(), orgMemberList.stream().map(e -> e.getNumber()).collect(Collectors.toSet()));
            List<Member> srcAccMemberList = queryDimmemberMap.get(SysDimensionEnum.Account.getNumber());
            if (CollectionUtils.isEmpty(srcAccMemberList)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u4e0b\u65e0\u6709\u6548\u7684\u79d1\u76ee\u6620\u5c04\u3002", (String)"ModelUploadService_0", (String)"epm-eb-business", (Object[])new Object[0]));
            }
            Map<String, Member> tarAccMemberMap = this.getTarAccMember(srcAccMemberList, ctx, tarDimMemberMap);
            Map<Long, List<Member>> srcAccGroupMap = srcAccMemberList.stream().collect(Collectors.groupingBy(Member::getDatasetId));
            for (Map.Entry<Long, List<Member>> datasetEntry : srcAccGroupMap.entrySet()) {
                Long srcDatasetId = datasetEntry.getKey();
                List<Member> srcAccMembers = datasetEntry.getValue();
                List<DatasetMapperGroup> dmgList = this.getDatasetMapperGroups(tarAccMemberMap, srcDatasetId, srcAccMembers);
                for (DatasetMapperGroup dmg : dmgList) {
                    List srcDimensions = srcModelCache.getDimensionList(srcDatasetId);
                    Map tarDimensionMap = tarModelCache.getDimensionMap(dmg.getTarDatasetId());
                    HashMap queryInfo = Maps.newHashMapWithExpectedSize((int)10);
                    queryInfo.put(SysDimensionEnum.BudgetPeriod.getNumber(), queryMemberMap.get(SysDimensionEnum.BudgetPeriod.getNumber()));
                    queryInfo.put(SysDimensionEnum.Version.getNumber(), queryMemberMap.get(SysDimensionEnum.Version.getNumber()));
                    queryInfo.put(SysDimensionEnum.Entity.getNumber(), queryMemberMap.get(SysDimensionEnum.Entity.getNumber()));
                    Boolean queryFlag = this.getQueryFlag(dmg, ctx, queryDimmemberMap, srcDatasetId, srcAccMembers, srcDimensions, tarDimensionMap, queryInfo);
                    if (!queryFlag.booleanValue()) continue;
                    Dataset srcDataSet = DatasetServiceHelper.getInstance().getDataSet(srcDatasetId);
                    String[] dimensionNums = srcModelCache.getDimensionNums(srcDataSet.getId());
                    Set entitySet = (Set)queryInfo.get(SysDimensionEnum.Entity.getNumber());
                    List partition = Lists.partition(new ArrayList(entitySet), (int)ORG_SIZE);
                    ArrayList subList = Lists.newArrayListWithExpectedSize((int)ORG_SIZE);
                    for (List sugOrg : partition) {
                        HashMap sub = new HashMap(queryInfo);
                        sub.put(SysDimensionEnum.Entity.getNumber(), new HashSet(sugOrg));
                        subList.add(sub);
                    }
                    for (Map sub : subList) {
                        while (pool.getPoolExecutor().getActiveCount() > 8) {
                            TimeUnit.SECONDS.sleep(1L);
                        }
                        ArrayList cells = Lists.newArrayList();
                        ArrayList futures = Lists.newArrayList();
                        BgmdOlapReader reader = OlapManager.getInstance().queryReader(new QueryRequest(srcModelCache.getModelobj().getId(), srcDataSet.getId(), sub));
                        Object object = null;
                        try {
                            while (reader.hasNext()) {
                                Object[] row = reader.next();
                                if (row[0] == null) continue;
                                BGCell cell = BGCells.of((Object[])row, Arrays.asList(dimensionNums));
                                cells.add(cell);
                                if (++totalCnt % QUERY_COUNT != 0) continue;
                                ArrayList newCells = new ArrayList(cells);
                                String loginIP = RequestContext.getOrCreate().getLoginIP();
                                Future future = pool.submit(() -> {
                                    RequestContext.getOrCreate().setLoginIP(loginIP);
                                    return this.doService(newCells, srcDataSet, dmg.getTarDatasetId(), tarVersion, tarDimMemberMap, queryDimmemberMap, ctx, tarDimMemberDynMap, schemeNumber);
                                });
                                futures.add(future);
                                cells.clear();
                            }
                        }
                        catch (Throwable row) {
                            object = row;
                            throw row;
                        }
                        finally {
                            if (reader != null) {
                                if (object != null) {
                                    try {
                                        reader.close();
                                    }
                                    catch (Throwable row) {
                                        ((Throwable)object).addSuppressed(row);
                                    }
                                } else {
                                    reader.close();
                                }
                            }
                        }
                        if (!cells.isEmpty()) {
                            ArrayList newCells = new ArrayList(cells);
                            String loginIP = RequestContext.getOrCreate().getLoginIP();
                            Future future = pool.submit(() -> {
                                RequestContext.getOrCreate().setLoginIP(loginIP);
                                return this.doService(newCells, srcDataSet, dmg.getTarDatasetId(), tarVersion, tarDimMemberMap, queryDimmemberMap, ctx, tarDimMemberDynMap, schemeNumber);
                            });
                            futures.add(future);
                            cells.clear();
                        }
                        Double step = 100.0 / (double)subList.size();
                        for (Future future : futures) {
                            try {
                                Integer futureResult = (Integer)future.get();
                                if (pageCache != null) {
                                    progress = this.updateProgress(progress + step, progressKey);
                                }
                                successCnt += futureResult.intValue();
                            }
                            catch (Exception e2) {
                                log.error("\u6570\u636e\u4f20\u8f93\u5931\u8d25:" + e2.getMessage(), (Throwable)e2);
                                throw new KDBizException(ResManager.loadResFormat((String)"\u6570\u636e\u4f20\u8f93\u5931\u8d25%1", (String)"ModelUploadService_4", (String)"epm-eb-business", (Object[])new Object[]{e2.getMessage()}));
                            }
                        }
                    }
                }
                continue;
                return;
            }
        }
        catch (Exception e3) {
            failExecute = true;
            log.error("\u6570\u636e\u4e0a\u4f20\u5f02\u5e38:" + ExceptionUtils.getStackTrace((Throwable)e3), (Throwable)e3);
            this.updateFailLog(totalCnt, successCnt, dymLog, e3);
            if (pageCache == null) return;
            progress = 100.0;
            CacheServiceHelper.put((String)progressKey, (Object)String.valueOf(progress.intValue()));
            return;
        }
        finally {
            long end = System.currentTimeMillis();
            log.info("\u67e5\u8be2\u6570\u636e\u603b\u6570\uff1a" + totalCnt + ", \u6210\u529f\u6620\u5c04\u6570\u91cf\uff1a" + successCnt + "\u5931\u8d25\u6570\u91cf\uff1a" + failCnt + "\u4f20\u8f93\u8017\u65f6\uff1a" + (end - start));
            if (!failExecute) {
                this.updateSuccessLog(totalCnt, successCnt, dymLog);
            }
            if (pageCache != null) {
                progress = 100.0;
                CacheServiceHelper.put((String)progressKey, (Object)String.valueOf(progress.intValue()));
            }
        }
    }

    private Map<Long, DynamicObject> getTraMetricMemberDynMap(ModelUploadContext ctx) {
        Set ids = ctx.getTarModelCache().getMembers(null, SysDimensionEnum.Metric.getNumber()).stream().map(x -> x.getId()).collect(Collectors.toSet());
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"epm_metricmembertree"));
        if (dynamicObjects == null) {
            return new HashMap<Long, DynamicObject>(16);
        }
        return Arrays.asList(dynamicObjects).stream().collect(Collectors.toMap(x -> x.getLong("id"), x -> x));
    }

    private Integer doService(List<BGCell> cells, Dataset srcDataSet, Long tarDataSetId, String tarVersion, Map<String, List<Member>> tarDimMemberMap, Map<String, List<Member>> queryDimmemberMap, ModelUploadContext ctx, Map<Long, DynamicObject> tarDimMemberDynMap, String schemeNumber) {
        log.info("doService-size:" + cells.size());
        int successCount = 0;
        List<BGCell> newCells = this.getMapperCell(cells, srcDataSet.getId(), tarDataSetId, tarVersion, ctx, tarDimMemberMap, queryDimmemberMap, tarDimMemberDynMap);
        successCount += newCells.size();
        if (!newCells.isEmpty()) {
            this.saveToOlap(tarDataSetId, newCells, ctx.getTarModelCache(), schemeNumber);
        }
        cells.clear();
        return successCount;
    }

    private void cleanTargetData(String tarVersion, String org, String bp, Map<String, List<Member>> srcDimMemberMap, Map<String, List<Member>> tarDimMemberMap, ModelUploadContext ctx) {
        Map<String, List<Member>> queryDimmemberMap = this.buildTarQueryDimMemberMap(ctx, srcDimMemberMap, tarDimMemberMap);
        List<Object> bpMemberList = tarDimMemberMap.get(SysDimensionEnum.BudgetPeriod.getNumber());
        List<String> bpMemberStrList = Arrays.asList(StringUtils.split((String)bp, (String)","));
        bpMemberList = bpMemberList.stream().filter(e -> bpMemberStrList.contains(e.getNumber())).collect(Collectors.toList());
        queryDimmemberMap.put(SysDimensionEnum.BudgetPeriod.getNumber(), bpMemberList);
        List<Object> verMemberList = tarDimMemberMap.get(SysDimensionEnum.Version.getNumber());
        verMemberList = verMemberList.stream().filter(e -> e.getNumber().equals(tarVersion)).collect(Collectors.toList());
        queryDimmemberMap.put(SysDimensionEnum.Version.getNumber(), verMemberList);
        List<Object> tarOrgMembers = tarDimMemberMap.get(SysDimensionEnum.Entity.getNumber());
        List<String> orgMemberStrList = Arrays.asList(StringUtils.split((String)org, (String)","));
        tarOrgMembers = tarOrgMembers.stream().filter(e -> orgMemberStrList.contains(e.getNumber())).collect(Collectors.toList());
        queryDimmemberMap.put(SysDimensionEnum.Entity.getNumber(), tarOrgMembers);
        List<Member> tarAccMemberList = queryDimmemberMap.get(SysDimensionEnum.Account.getNumber());
        if (CollectionUtils.isEmpty(tarAccMemberList)) {
            return;
        }
        HashMap<String, Set<String>> srcDimMemberNumMap = new HashMap<String, Set<String>>(srcDimMemberMap.size());
        srcDimMemberMap.forEach((dimNum, members) -> srcDimMemberNumMap.put((String)dimNum, members.stream().map(BaseCache::getNumber).collect(Collectors.toSet())));
        Map<Long, List<Member>> tarAccGroupMap = tarAccMemberList.stream().collect(Collectors.groupingBy(Member::getDatasetId));
        for (Map.Entry<Long, List<Member>> datasetEntry : tarAccGroupMap.entrySet()) {
            Long tarDatasetId = datasetEntry.getKey();
            List<Member> tarAccMembers = datasetEntry.getValue();
            List tarDimensions = ctx.getTarModelCache().getDimensionList(tarDatasetId);
            Boolean queryFlag = Boolean.TRUE;
            HashMap<String, Set<String>> deleteRange = new HashMap<String, Set<String>>(16);
            for (Dimension tarDim : tarDimensions) {
                DynamicObject dimMapper;
                String tarmembernumber;
                String tarDimNumber = tarDim.getNumber();
                if (SysDimensionEnum.Account.getNumber().equals(tarDimNumber)) {
                    List tarAccMemberNumber = tarAccMembers.stream().map(BaseCache::getNumber).collect(Collectors.toList());
                    deleteRange.put(tarDimNumber, new HashSet(tarAccMemberNumber));
                    continue;
                }
                List<Member> members2 = queryDimmemberMap.get(tarDimNumber);
                Optional<DynamicObject> optDimMapper = ctx.getDimmapentity().stream().filter(e -> this.getDimNumber(e.getDynamicObject("tardim")).equals(tarDimNumber)).findFirst();
                if (optDimMapper.isPresent() && StringUtils.isNotBlank((CharSequence)(tarmembernumber = this.getMemberNumber((dimMapper = optDimMapper.get()).getDynamicObject("tarmember"))))) {
                    deleteRange.put(tarDimNumber, Sets.newHashSet((Object[])new String[]{tarmembernumber}));
                    continue;
                }
                if (CollectionUtils.isEmpty(members2)) {
                    queryFlag = Boolean.FALSE;
                    break;
                }
                List memberList = members2.stream().map(BaseCache::getNumber).collect(Collectors.toList());
                deleteRange.put(tarDimNumber, new HashSet(memberList));
            }
            if (!queryFlag.booleanValue() || !(queryFlag = Boolean.valueOf(this.removeTarNoCoverMembers(ctx, srcDimMemberNumMap, deleteRange))).booleanValue()) continue;
            log.info("\u6570\u636e\u6e05\u9664olap#reader\u6e05\u6570\uff1a" + JSON.toJSONString(deleteRange));
            Dataset dataSet = DatasetServiceHelper.getInstance().getDataSet(tarDatasetId);
            BgmdShrekDao.getInstance().delete(ctx.getTarModelCache().getModelobj(), ShrekOlapUtils.getCubeNumber((Dataset)dataSet), deleteRange);
        }
    }

    private boolean removeTarNoCoverMembers(ModelUploadContext ctx, Map<String, Set<String>> srcDimMemberNumMap, Map<String, Set<String>> tarDimMemberNumMap) {
        boolean queryFlag = true;
        for (Map.Entry<String, Set<String>> entry : tarDimMemberNumMap.entrySet()) {
            String tarDimNumber = entry.getKey();
            if (!tarDimNumber.equals(SysDimensionEnum.Entity.getNumber())) continue;
            Set<String> tarMemberSet = entry.getValue();
            Set<String> srcMemberSet = srcDimMemberNumMap.getOrDefault(tarDimNumber, Sets.newHashSetWithExpectedSize((int)16));
            Optional<DynamicObject> optDimMapper = ctx.getDimmapentity().stream().filter(e -> this.getDimNumber(e.getDynamicObject("tardim")).equals(tarDimNumber)).findFirst();
            if (optDimMapper.isPresent()) {
                DynamicObject dimMapper = optDimMapper.get();
                boolean mapOnly = dimMapper.getBoolean("maponly");
                DynamicObject memberMap = dimMapper.getDynamicObject("membermap");
                if (memberMap != null) {
                    ModeluploadMapperInfo modeluploadMapperInfo = ctx.getMapperInfoMap().get(memberMap.getLong("id"));
                    if (modeluploadMapperInfo != null) {
                        Set tarMapperMemberSet = modeluploadMapperInfo.getMapperList().stream().map(ModeluploadMemberMapper::getTarmembernumber).collect(Collectors.toSet());
                        if (mapOnly) {
                            tarMemberSet.removeIf(e -> !tarMapperMemberSet.contains(e));
                        } else {
                            Set srcMapperMemberSet = modeluploadMapperInfo.getMapperList().stream().map(ModeluploadMemberMapper::getSrcmembernumber).collect(Collectors.toSet());
                            tarMemberSet.removeIf(e -> !tarMapperMemberSet.contains(e) && !srcMemberSet.contains(e));
                            tarMemberSet.removeIf(srcMapperMemberSet::contains);
                        }
                    }
                } else {
                    tarMemberSet.removeIf(e -> !srcMemberSet.contains(e));
                }
            } else {
                tarMemberSet.removeIf(e -> !srcMemberSet.contains(e));
            }
            if (!CollectionUtils.isEmpty(tarMemberSet)) continue;
            queryFlag = false;
            break;
        }
        return queryFlag;
    }

    private void updateSuccessLog(int totalCnt, int successCnt, DynamicObject dymLog) {
        dymLog.set("status", (Object)1);
        dymLog.set("successcount", (Object)successCnt);
        dymLog.set("failcount", (Object)(totalCnt - successCnt));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dymLog});
    }

    private void updateFailLog(int totalCnt, int successCnt, DynamicObject dymLog, Exception e) {
        dymLog.set("status", (Object)2);
        dymLog.set("successcount", (Object)successCnt);
        dymLog.set("failcount", (Object)(totalCnt - successCnt));
        dymLog.set("failmsg", (Object)e.getMessage());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dymLog});
    }

    private Boolean getQueryFlag(DatasetMapperGroup dmg, ModelUploadContext ctx, Map<String, List<Member>> queryDimmemberMap, Long srcDatasetId, List<Member> srcAccMembers, List<Dimension> srcDimensions, Map<String, Dimension> tarDimensionMap, Map<String, Set<String>> queryMemberMap) {
        Boolean queryFlag = Boolean.TRUE;
        Map srcViewMap = ctx.getSrcModelCache().getViewsByDataSet(dmg.getSrcDatasetId());
        for (Dimension srcDim : srcDimensions) {
            String srcDimNumber = srcDim.getNumber();
            if (StringUtils.equalsAny((CharSequence)srcDimNumber, (CharSequence[])new CharSequence[]{SysDimensionEnum.Entity.getNumber(), SysDimensionEnum.Version.getNumber(), SysDimensionEnum.BudgetPeriod.getNumber()})) continue;
            if (SysDimensionEnum.Account.getNumber().equals(srcDimNumber)) {
                List srcMemberNumbers = srcAccMembers.stream().filter(e -> srcDatasetId.equals(e.getDatasetId())).map(BaseCache::getNumber).collect(Collectors.toList());
                DynamicObject accMapper = ctx.getDimmapentity().stream().filter(e -> this.getDimNumber(e.getDynamicObject("srcdim")).equals(srcDimNumber)).findFirst().get();
                boolean maponly = accMapper.getBoolean("maponly");
                if (accMapper.getDynamicObject("membermap") == null && !maponly) {
                    List tarAccMembers = ctx.getTarModelCache().getMembers(null, SysDimensionEnum.Account.getNumber());
                    Set tarMemNumberSet = tarAccMembers.stream().filter(e -> e.isLeaf() && e.getDatasetId().equals(dmg.getTarDatasetId())).map(e -> e.getNumber()).collect(Collectors.toSet());
                    if (CollectionUtils.isEmpty(srcMemberNumbers = srcMemberNumbers.stream().filter(tarMemNumberSet::contains).collect(Collectors.toList()))) {
                        log.warn("\u6570\u636e\u96c6:[" + srcDatasetId + "]\u5173\u8054\u7684\u7ef4\u5ea6[" + srcDimNumber + "]\u6ca1\u6709\u7ef4\u5ea6\u6210\u5458");
                        queryFlag = Boolean.FALSE;
                        break;
                    }
                }
                Set memberSet = queryMemberMap.computeIfAbsent(srcDimNumber, v -> Sets.newHashSet());
                memberSet.addAll(srcMemberNumbers);
                continue;
            }
            List<Member> members = queryDimmemberMap.get(srcDimNumber);
            if (CollectionUtils.isEmpty(members)) {
                log.warn("\u6570\u636e\u96c6:[" + srcDatasetId + "]\u5173\u8054\u7684\u7ef4\u5ea6[" + srcDimNumber + "]\u6ca1\u6709\u7ef4\u5ea6\u6210\u5458");
                queryFlag = Boolean.FALSE;
                break;
            }
            Optional<DynamicObject> optDimMapper = ctx.getDimmapentity().stream().filter(e -> this.getDimNumber(e.getDynamicObject("srcdim")).equals(srcDimNumber)).findFirst();
            if (!optDimMapper.isPresent()) continue;
            DynamicObject dimMapper = optDimMapper.get();
            String tardimnumber = this.getDimNumber(dimMapper.getDynamicObject("tardim"));
            String srcmembernumber = this.getMemberNumber(dimMapper.getDynamicObject("srcmember"));
            if (StringUtils.isNotBlank((CharSequence)srcmembernumber)) {
                Set memberSet = queryMemberMap.computeIfAbsent(srcDimNumber, v -> Sets.newHashSet());
                memberSet.add(srcmembernumber);
                continue;
            }
            Long srcDefaultViewId = (Long)srcViewMap.get(srcDimNumber);
            String defaultViewRootNumber = ctx.getSrcModelCache().getRootMember(srcDimNumber, srcDefaultViewId).getNumber();
            if (StringUtils.isNotBlank((CharSequence)tardimnumber) && !tarDimensionMap.containsKey(tardimnumber)) {
                Set memberSet = queryMemberMap.computeIfAbsent(srcDimNumber, v -> Sets.newHashSet());
                memberSet.add(defaultViewRootNumber);
                continue;
            }
            Set memberNumbers = members.stream().map(e -> e.getNumber()).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(memberNumbers)) {
                log.warn("\u6570\u636e\u96c6:[" + srcDatasetId + "]\u5173\u8054\u7684\u7ef4\u5ea6[" + srcDimNumber + "]\u6ca1\u6709\u7ef4\u5ea6\u6210\u5458");
                queryFlag = Boolean.FALSE;
                break;
            }
            Set memberSet = queryMemberMap.computeIfAbsent(srcDimNumber, v -> Sets.newHashSet());
            memberSet.addAll(memberNumbers);
        }
        return queryFlag;
    }

    private List<DatasetMapperGroup> getDatasetMapperGroups(Map<String, Member> tarAccMemberMap, Long srcDatasetId, List<Member> srcAccMembers) {
        HashMap srcAccMemberMap = Maps.newHashMapWithExpectedSize((int)20);
        for (Member srcAccMember : srcAccMembers) {
            Member tarAccMember = tarAccMemberMap.get(srcAccMember.getNumber());
            Long tardatasetId = tarAccMember.getDatasetId();
            List accMembers = srcAccMemberMap.computeIfAbsent(tardatasetId, v -> new ArrayList(10));
            accMembers.add(srcAccMember);
        }
        ArrayList<DatasetMapperGroup> dmgList = new ArrayList<DatasetMapperGroup>(10);
        for (Map.Entry entry : srcAccMemberMap.entrySet()) {
            DatasetMapperGroup dmg = new DatasetMapperGroup(srcDatasetId, (List)entry.getValue(), (Long)entry.getKey());
            dmgList.add(dmg);
        }
        return dmgList;
    }

    private DynamicObject addLog(Long id, String srcVersionName, String tarVersionName, String orgName, String bp, int successCnt, int failCnt, List<String> transferInfo) {
        log.info("\u65b0\u589e\u4e0a\u4f20\u65e5\u5fd7");
        DynamicObject dymLog = BusinessDataServiceHelper.newDynamicObject((String)"eb_modelupload_log");
        dymLog.set("modelupload", (Object)id);
        dymLog.set("status", (Object)3);
        dymLog.set("successcount", (Object)successCnt);
        dymLog.set("failcount", (Object)failCnt);
        dymLog.set("createrfield", (Object)UserUtils.getUserId());
        dymLog.set("createdatefield", (Object)new Date());
        dymLog.set("org", (Object)orgName);
        dymLog.set("bp", (Object)bp);
        dymLog.set("srcversion", (Object)srcVersionName);
        dymLog.set("tarversion", (Object)tarVersionName);
        if (!transferInfo.isEmpty()) {
            dymLog.set("transferinfo", (Object)String.join((CharSequence)";", transferInfo));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dymLog});
        return dymLog;
    }

    public void validRepeatRun(Long id) {
        DynamicObject modelUpload;
        long srcmodelId;
        Date limitTime = DateUtils.addMinutes((Date)new Date(), (int)-10);
        String sql = "select fmodelupload,forg from t_eb_modelupload_log where fstatus='3' and fcreatedatefield > ?";
        ArrayList<Long> modeluploadIds = new ArrayList<Long>(16);
        try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"epm"), (String)sql, (Object[])new Object[]{limitTime});){
            while (ds.hasNext()) {
                Row row = ds.next();
                modeluploadIds.add(row.getLong("fmodelupload"));
            }
        }
        if (modeluploadIds.isEmpty()) {
            return;
        }
        DynamicObjectCollection idColl = QueryServiceHelper.query((String)"eb_modelupload", (String)"srcmodel", (QFilter[])new QFilter[]{new QFilter("id", "in", modeluploadIds)});
        Set executeSrcModelIds = idColl.stream().map(e -> e.getLong("srcmodel")).collect(Collectors.toSet());
        if (executeSrcModelIds.contains(srcmodelId = (modelUpload = BusinessDataServiceHelper.loadSingle((Object)id, (String)"eb_modelupload")).getDynamicObject("srcmodel").getLong("id"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6b64\u6e90\u4f53\u7cfb\u6709\u6b63\u5728\u6267\u884c\u4e2d\u7684\u4efb\u52a1\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"ModelUploadService_1", (String)"epm-eb-business", (Object[])new Object[0]));
        }
    }

    private void saveToOlap(Long tarDatasetId, List<BGCell> newCells, IModelCacheHelper tarModelCache, String schemeNumber) {
        OlapTraceServiceHelper.setTraceOpInfo((String)schemeNumber);
        OlapContext.setSaveDataContext((SaveDataContext)new SaveDataContext(OlapDataAuditEventEnum.DataUpload));
        OlapWriteOption olapWriteOption = new OlapWriteOption();
        olapWriteOption.setDataLockThrowErr(true);
        OlapManager.getInstance().saveList(new SaveRequest(tarModelCache.getModelobj().getId(), tarDatasetId, newCells), olapWriteOption);
        newCells.clear();
    }

    private List<BGCell> getMapperCell(List<BGCell> cells, Long srcDatasetId, Long tarDatasetId, String tarVersion, ModelUploadContext ctx, Map<String, List<Member>> tarDimMemberMap, Map<String, List<Member>> queryDimmemberMap, Map<Long, DynamicObject> tarDimMemberDynMap) {
        Map srcDimensionMap = ctx.getSrcModelCache().getDimensionMap(srcDatasetId);
        List tarDimensions = ctx.getTarModelCache().getDimensionList(tarDatasetId);
        Map tarDimensionMap = ctx.getTarModelCache().getDimensionMap(tarDatasetId);
        HashMap<String, Set<String>> tarDimMemberNumMap = new HashMap<String, Set<String>>(tarDimMemberMap.size());
        tarDimMemberMap.forEach((dimNum, memList) -> {
            if (SysDimensionEnum.Account.getNumber().equals(dimNum)) {
                Set tarDimMemberNumSet = memList.stream().filter(e -> tarDatasetId.equals(e.getDatasetId())).map(BaseCache::getNumber).collect(Collectors.toSet());
                tarDimMemberNumMap.put((String)dimNum, tarDimMemberNumSet);
            } else {
                tarDimMemberNumMap.put((String)dimNum, memList.stream().map(BaseCache::getNumber).collect(Collectors.toSet()));
            }
        });
        Map<String, DynamicObject> tarDimEntityMap = ctx.getDimmapentity().stream().collect(Collectors.toMap(e -> {
            DynamicObject tardim = e.getDynamicObject("tardim");
            if (tardim != null) {
                return tardim.getString("number");
            }
            return null;
        }, e -> e, (oldv, newv) -> newv));
        ArrayList<BGCell> newCells = new ArrayList<BGCell>(cells.size());
        for (BGCell cell : cells) {
            Map srcMemberMap = cell.getMemberMap();
            Boolean saveFlag = this.validMember(ctx.getDimmapentity(), queryDimmemberMap, srcDimensionMap, tarDimensionMap, cell, srcMemberMap);
            if (!saveFlag.booleanValue()) continue;
            HashMap tarMemberMap = Maps.newHashMap();
            for (Dimension dimension : tarDimensions) {
                Member member;
                String tarDimNumber = dimension.getNumber();
                if (SysDimensionEnum.Version.getNumber().equals(tarDimNumber)) {
                    tarMemberMap.put(tarDimNumber, tarVersion);
                    continue;
                }
                if (SysDimensionEnum.BudgetPeriod.getNumber().equals(tarDimNumber)) {
                    tarMemberMap.put(tarDimNumber, srcMemberMap.get(tarDimNumber));
                    continue;
                }
                DynamicObject dimMapper = tarDimEntityMap.get(tarDimNumber);
                if (dimMapper == null) {
                    log.error("\u76ee\u6807\u7ef4\u5ea6\u6ca1\u6709\u914d\u7f6e\u7ef4\u5ea6\u6620\u5c04:" + tarDimNumber);
                    throw new KDBizException(ResManager.loadResFormat((String)"\u76ee\u6807\u7ef4\u5ea6\u672a\u914d\u7f6e\u7ef4\u5ea6\u6620\u5c04\u201c%1\u201d\u3002", (String)"ModelUploadService_2", (String)"epm-eb-business", (Object[])new Object[]{tarDimNumber}));
                }
                String srcdimnumber = this.getDimNumber(dimMapper.getDynamicObject("srcdim"));
                if (StringUtils.isNotBlank((CharSequence)srcdimnumber) && !srcDimensionMap.containsKey(srcdimnumber)) {
                    List<Member> members = tarDimMemberMap.get(tarDimNumber);
                    if (CollectionUtils.isNotEmpty(members) && members.stream().anyMatch(e -> dimension.getNoneNumber().equals(e.getNumber()))) {
                        tarMemberMap.put(tarDimNumber, dimension.getNoneNumber());
                        continue;
                    }
                    return Collections.emptyList();
                }
                if (StringUtils.isBlank((CharSequence)srcdimnumber)) {
                    String tarmembernumber = this.getMemberNumber(dimMapper.getDynamicObject("tarmember"));
                    tarMemberMap.put(tarDimNumber, tarmembernumber);
                    continue;
                }
                String srcMemberNumber = (String)srcMemberMap.get(srcdimnumber);
                String memberMapperNumber = this.getMemberMapperTarNumber(ctx, dimMapper, srcMemberNumber);
                if (SysDimensionEnum.Account.getNumber().equals(tarDimNumber) && StringUtils.isNotBlank((CharSequence)memberMapperNumber) && ((member = ctx.getTarModelCache().getMember(SysDimensionEnum.Account.getNumber(), null, memberMapperNumber)) == null || !tarDatasetId.equals(member.getDatasetId()))) {
                    saveFlag = Boolean.FALSE;
                    break;
                }
                if (StringUtils.isNotBlank((CharSequence)memberMapperNumber)) {
                    tarMemberMap.put(tarDimNumber, memberMapperNumber);
                    continue;
                }
                String tarmembernumber = this.getMemberNumber(dimMapper.getDynamicObject("tarmember"));
                if (!StringUtils.isBlank((CharSequence)tarmembernumber)) {
                    tarMemberMap.put(tarDimNumber, tarmembernumber);
                    continue;
                }
                String sameMapperNumber = this.getSameMapperNumber(tarDimNumber, dimMapper, srcMemberNumber, ctx, tarDimMemberNumMap);
                if (StringUtils.isNotBlank((CharSequence)sameMapperNumber)) {
                    tarMemberMap.put(tarDimNumber, sameMapperNumber);
                    continue;
                }
                saveFlag = Boolean.FALSE;
                break;
            }
            if (!saveFlag.booleanValue()) {
                log.info("\u6210\u5458\u6620\u5c04\u4e0d\u4e0a\uff1a" + JSON.toJSONString((Object)cell));
                continue;
            }
            BGCell newCell = new BGCell((Map)tarMemberMap, cell.getValue());
            Boolean checkMetric = Boolean.TRUE;
            for (int i = 0; i < tarDimensions.size(); ++i) {
                DynamicObject metricObj;
                String tarDimNumber = ((Dimension)tarDimensions.get(i)).getNumber();
                if (!SysDimensionEnum.Metric.getNumber().equals(tarDimNumber)) continue;
                String tarMetricNumber = (String)newCell.getMemberMap().get(tarDimNumber);
                String srcMetricNumber = (String)srcMemberMap.get(tarDimNumber);
                Member srcMember = ctx.getSrcModelCache().getMember(SysDimensionEnum.Metric.getNumber(), null, srcMetricNumber);
                Member tarMember = ctx.getTarModelCache().getMember(SysDimensionEnum.Metric.getNumber(), null, tarMetricNumber);
                if (MetricDataTypeEnum.RATE.getIndex().equals(srcMember.getDatatype()) && !MetricDataTypeEnum.RATE.getIndex().equals(tarMember.getDatatype())) {
                    checkMetric = false;
                    log.info("\u6210\u5458\u6620\u5c04\u4e0d\u4e0a\uff1a" + JSON.toJSONString((Object)cell));
                    break;
                }
                if (MetricDataTypeEnum.TEXT.getIndex().equals(srcMember.getDatatype()) && !MetricDataTypeEnum.TEXT.getIndex().equals(tarMember.getDatatype())) {
                    checkMetric = false;
                    log.info("\u6210\u5458\u6620\u5c04\u4e0d\u4e0a\uff1a" + JSON.toJSONString((Object)cell));
                    break;
                }
                if (!MetricDataTypeEnum.ENUM.getIndex().equals(srcMember.getDatatype()) || (metricObj = tarDimMemberDynMap.get(tarMember.getId())) == null) continue;
                DynamicObjectCollection enumentryentity = metricObj.getDynamicObjectCollection("enumentryentity");
                if (CollectionUtils.isEmpty((Collection)enumentryentity)) {
                    checkMetric = false;
                    log.info("\u6210\u5458\u6620\u5c04\u4e0d\u4e0a\uff1a" + JSON.toJSONString((Object)cell));
                    break;
                }
                Set enumnumbers = enumentryentity.stream().map(x -> x.getString("enumname")).collect(Collectors.toSet());
                if (enumnumbers.contains(String.valueOf(cell.getValue()))) continue;
                checkMetric = false;
                log.info("\u6210\u5458\u6620\u5c04\u4e0d\u4e0a\uff1a" + JSON.toJSONString((Object)cell));
                break;
            }
            if (!checkMetric.booleanValue()) continue;
            newCells.add(newCell);
        }
        return newCells;
    }

    private Boolean validMember(DynamicObjectCollection dimmapentity, Map<String, List<Member>> queryDimmemberMap, Map<String, Dimension> srcDimensionMap, Map<String, Dimension> tarDimensionMap, BGCell cell, Map<String, String> srcMemberMap) {
        for (DynamicObject mapEntity : dimmapentity) {
            String srcdimnumber = this.getDimNumber(mapEntity.getDynamicObject("srcdim"));
            String tardimnumber = this.getDimNumber(mapEntity.getDynamicObject("tardim"));
            if (!srcDimensionMap.containsKey(srcdimnumber) || tarDimensionMap.containsKey(tardimnumber) || !StringUtils.isNotBlank((CharSequence)tardimnumber)) continue;
            String srcMemberNumber = srcMemberMap.get(srcdimnumber);
            List<Member> srcMembers = queryDimmemberMap.get(srcdimnumber);
            Member srcMember = srcMembers.stream().filter(e -> e.getNumber().equals(srcMemberNumber)).findFirst().get();
            if (srcMember.getParentId() <= 0L) continue;
            log.info("\u6b64\u6761\u6570\u636e\u4e0d\u662f\u6839\u6210\u5458\uff1a" + JSON.toJSONString((Object)cell));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private String getSameMapperNumber(String tarDimNumber, DynamicObject dimMapper, String srcMemberNumber, ModelUploadContext ctx, Map<String, Set<String>> tarDimMemberNumMap) {
        ModeluploadMapperInfo modeluploadMapperInfo;
        boolean maponly = dimMapper.getBoolean("maponly");
        if (maponly) {
            return "";
        }
        Set<String> tarMemberNumSet = tarDimMemberNumMap.get(tarDimNumber);
        DynamicObject membermap = dimMapper.getDynamicObject("membermap");
        if (membermap != null && (modeluploadMapperInfo = ctx.getMapperInfoMap().get(membermap.getLong("id"))) != null) {
            Set srcMapperMemberSet = modeluploadMapperInfo.getMapperList().stream().map(ModeluploadMemberMapper::getSrcmembernumber).collect(Collectors.toSet());
            Set tarMapperMemberSet = modeluploadMapperInfo.getMapperList().stream().map(ModeluploadMemberMapper::getTarmembernumber).collect(Collectors.toSet());
            log.info("\u8fc7\u6ee4\u524dtarMemberList_size:" + tarMemberNumSet.size());
            tarMemberNumSet = tarMemberNumSet.stream().filter(e -> !srcMapperMemberSet.contains(e) && !tarMapperMemberSet.contains(e)).collect(Collectors.toSet());
            log.info("\u8fc7\u6ee4\u540etarMemberList_size:" + tarMemberNumSet.size());
        }
        if (tarMemberNumSet.contains(srcMemberNumber)) {
            return srcMemberNumber;
        }
        return "";
    }

    private String getMemberMapperTarNumber(ModelUploadContext ctx, DynamicObject dimMapper, String srcMemberNumber) {
        Optional<ModeluploadMemberMapper> optMemberMapper;
        DynamicObject membermap = dimMapper.getDynamicObject("membermap");
        if (membermap == null) {
            return "";
        }
        ModeluploadMapperInfo modeluploadMapperInfo = ctx.getMapperInfoMap().get(membermap.getLong("id"));
        if (modeluploadMapperInfo != null && (optMemberMapper = modeluploadMapperInfo.getMapperList().stream().filter(e -> e.getSrcmembernumber().equals(srcMemberNumber)).findFirst()).isPresent()) {
            return optMemberMapper.get().getTarmembernumber();
        }
        return "";
    }

    private Map<String, Member> getTarAccMember(List<Member> srcAccmembers, ModelUploadContext ctx, Map<String, List<Member>> tarDimMemberMap) {
        Set srcAccNumbers = srcAccmembers.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
        DynamicObject accMapper = ctx.getDimmapentity().stream().filter(e -> SysDimensionEnum.Account.getNumber().equals(e.getDynamicObject("srcdim").getString("number"))).findFirst().get();
        DynamicObject membermap = accMapper.getDynamicObject("membermap");
        Map<Object, Object> tarAccMap = Maps.newHashMapWithExpectedSize((int)30);
        if (membermap != null) {
            ModeluploadMapperInfo modeluploadMapperInfo = ctx.getMapperInfoMap().get(membermap.getLong("id"));
            List<Object> memberMapperList = Collections.emptyList();
            if (modeluploadMapperInfo != null) {
                memberMapperList = modeluploadMapperInfo.getMapperList();
            }
            if (CollectionUtils.isNotEmpty(memberMapperList)) {
                tarAccMap = memberMapperList.stream().filter(e -> srcAccNumbers.contains(e.getSrcmembernumber())).collect(Collectors.toMap(ModeluploadMemberMapper::getSrcmembernumber, ModeluploadMemberMapper::getTarmembernumber, (v1, v2) -> v1));
            }
        }
        for (String srcAccNumber : srcAccNumbers) {
            if (tarAccMap.containsKey(srcAccNumber)) continue;
            tarAccMap.put(srcAccNumber, srcAccNumber);
        }
        List<Member> tarAccMembers = tarDimMemberMap.get(SysDimensionEnum.Account.getNumber());
        HashMap tarAccMemberMap = Maps.newHashMapWithExpectedSize((int)30);
        for (Map.Entry entry : tarAccMap.entrySet()) {
            Member member = tarAccMembers.stream().filter(e -> e.getNumber().equals(entry.getValue())).findFirst().get();
            tarAccMemberMap.put(entry.getKey(), member);
        }
        return tarAccMemberMap;
    }

    private List<Member> getSrcOrgMemberList(String org, ModelUploadContext ctx, List<Member> srcOrgMembers) {
        boolean maponly;
        String[] orgArry = StringUtils.split((String)org, (String)",");
        DynamicObject orgMapper = ctx.getDimmapentity().stream().filter(e -> SysDimensionEnum.Entity.getNumber().equals(e.getDynamicObject("srcdim").getString("number"))).findFirst().get();
        DynamicObject orgMembermap = orgMapper.getDynamicObject("membermap");
        ArrayList<Member> orgMemberList = new ArrayList<Member>(16);
        List<Object> orgTarmemberList = new ArrayList(16);
        if (orgMembermap != null) {
            List<Object> orgMemberMapperList = Collections.emptyList();
            ModeluploadMapperInfo modeluploadMapperInfo = ctx.getMapperInfoMap().get(orgMembermap.getLong("id"));
            if (modeluploadMapperInfo != null) {
                orgMemberMapperList = modeluploadMapperInfo.getMapperList();
            }
            if (CollectionUtils.isNotEmpty(orgMemberMapperList)) {
                orgTarmemberList = orgMemberMapperList.stream().map(ModeluploadMemberMapper::getTarmembernumber).collect(Collectors.toList());
                List srcOrgMemberNumbers = orgMemberMapperList.stream().filter(e -> ArrayUtils.contains((Object[])orgArry, (Object)e.getTarmembernumber())).map(ModeluploadMemberMapper::getSrcmembernumber).collect(Collectors.toList());
                orgMemberList.addAll(srcOrgMembers.stream().filter(e -> srcOrgMemberNumbers.contains(e.getNumber())).collect(Collectors.toList()));
            }
        }
        if (!(maponly = orgMapper.getBoolean("maponly"))) {
            for (String orgNumber : orgArry) {
                Optional<Member> filterMember;
                if (orgTarmemberList.contains(orgNumber) || !(filterMember = srcOrgMembers.stream().filter(e -> e.getNumber().equals(orgNumber)).findFirst()).isPresent()) continue;
                orgMemberList.add(filterMember.get());
            }
        }
        return orgMemberList;
    }

    private Map<String, List<Member>> getSrcDimMemberMap(ModelUploadContext ctx) {
        Long srcbizId = ctx.getSrcbiz().getLong("id");
        List dimensions = DatasetServiceHelper.getInstance().listDimensionBybizmodelId(srcbizId);
        HashMap srcDimMemberMap = Maps.newHashMapWithExpectedSize((int)20);
        IModelCacheHelper srcModelCache = ctx.getSrcModelCache();
        for (kd.epm.eb.common.model.Dimension dim : dimensions) {
            Dimension dimension = srcModelCache.getDimension(dim.getId());
            Map groupViewMap = ctx.getSrcModelCache().getViewGroupViewsByBusModel(Long.valueOf(ctx.getSrcbiz().getLong("id")));
            List viewList = (List)groupViewMap.get(dimension.getNumber());
            List members = Lists.newArrayListWithCapacity((int)10);
            if (CollectionUtils.isEmpty((Collection)viewList)) {
                members = ctx.getSrcModelCache().getMembers(null, dimension.getNumber());
            } else {
                for (Long vid : viewList) {
                    List vMembers = ctx.getSrcModelCache().getMembers(vid, dimension.getNumber());
                    List rawMembers = vMembers.stream().filter(e -> !ViewMemberSourceEnum.INNER_REF.getIndex().equals(e.getSource())).collect(Collectors.toList());
                    if (rawMembers.isEmpty()) continue;
                    members.addAll(rawMembers);
                }
            }
            srcDimMemberMap.put(dimension.getNumber(), new ArrayList(members));
        }
        List datasetIds = BusinessModelServiceHelper.getInstance().queryDataSetIds(srcbizId);
        String accDimNumber = SysDimensionEnum.Account.getNumber();
        List accMembers = srcModelCache.getMembers(null, accDimNumber).stream().filter(e -> datasetIds.contains(e.getDatasetId())).collect(Collectors.toList());
        srcDimMemberMap.put(accDimNumber, accMembers);
        return srcDimMemberMap;
    }

    private Map<String, List<Member>> getTarDimMemberMap(ModelUploadContext ctx) {
        long tarbizId = ctx.getTarbiz().getLong("id");
        List dimensions = DatasetServiceHelper.getInstance().listDimensionBybizmodelId(Long.valueOf(tarbizId));
        HashMap tarDimMemberMap = Maps.newHashMapWithExpectedSize((int)20);
        for (kd.epm.eb.common.model.Dimension dim : dimensions) {
            Dimension dimension = ctx.getTarModelCache().getDimension(dim.getId());
            Map groupViewMap = ctx.getTarModelCache().getViewGroupViewsByBusModel(Long.valueOf(ctx.getTarbiz().getLong("id")));
            List viewList = (List)groupViewMap.get(dimension.getNumber());
            List members = Lists.newArrayListWithCapacity((int)10);
            if (CollectionUtils.isEmpty((Collection)viewList)) {
                members = ctx.getTarModelCache().getMembers(null, dimension.getNumber());
            } else {
                for (Long vid : viewList) {
                    List vMembers = ctx.getTarModelCache().getMembers(vid, dimension.getNumber());
                    List rawMembers = vMembers.stream().filter(e -> !ViewMemberSourceEnum.INNER_REF.getIndex().equals(e.getSource())).collect(Collectors.toList());
                    if (rawMembers.isEmpty()) continue;
                    members.addAll(rawMembers);
                }
            }
            List memberNumberList = members.stream().filter(Member::isLeaf).collect(Collectors.toList());
            tarDimMemberMap.put(dimension.getNumber(), memberNumberList);
        }
        List datasetIds = BusinessModelServiceHelper.getInstance().queryDataSetIds(Long.valueOf(tarbizId));
        String accDimNumber = SysDimensionEnum.Account.getNumber();
        List accMembers = ctx.getTarModelCache().getMembers(null, accDimNumber).stream().filter(e -> datasetIds.contains(e.getDatasetId()) && e.isLeaf()).collect(Collectors.toList());
        tarDimMemberMap.put(accDimNumber, accMembers);
        return tarDimMemberMap;
    }

    private Map<String, List<Member>> buildSrcQueryDimMemberMap(ModelUploadContext ctx, Map<String, List<Member>> srcDimMemberMap, Map<String, List<Member>> tarDimMemberMap) {
        HashMap queryDimmemberMap = Maps.newHashMapWithExpectedSize((int)30);
        for (DynamicObject dimMapper : ctx.getDimmapentity()) {
            boolean maponly;
            String srcdimnumber = this.getDimNumber(dimMapper.getDynamicObject("srcdim"));
            String tardimnumber = this.getDimNumber(dimMapper.getDynamicObject("tardim"));
            if (StringUtils.isBlank((CharSequence)srcdimnumber)) continue;
            List<Member> srcMembers = srcDimMemberMap.get(srcdimnumber);
            if (StringUtils.isBlank((CharSequence)tardimnumber)) {
                String srcmembernumber = this.getMemberNumber(dimMapper.getDynamicObject("srcmember"));
                Member srcMember = srcMembers.stream().filter(e -> e.getNumber().equals(srcmembernumber)).findFirst().get();
                queryDimmemberMap.put(srcdimnumber, Collections.singletonList(srcMember));
                continue;
            }
            List<Member> tarMembers = tarDimMemberMap.get(tardimnumber);
            Map<String, Member> srcMemberMap = srcMembers.stream().collect(Collectors.toMap(BaseCache::getNumber, e -> e, (v1, v2) -> v1));
            Set tarMemberSet = tarMembers.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
            ArrayList<Member> queryMembers = new ArrayList<Member>(16);
            DynamicObject membermap = dimMapper.getDynamicObject("membermap");
            List<Object> memberMapperList = new ArrayList(10);
            if (membermap != null) {
                long membermapId = membermap.getLong("id");
                ModeluploadMapperInfo modeluploadMapperInfo = ctx.getMapperInfoMap().get(membermapId);
                if (modeluploadMapperInfo != null) {
                    memberMapperList = modeluploadMapperInfo.getMapperList();
                }
                if (CollectionUtils.isNotEmpty(memberMapperList)) {
                    if ((memberMapperList = memberMapperList.stream().filter(e -> srcMemberMap.containsKey(e.getSrcmembernumber()) && tarMemberSet.contains(e.getTarmembernumber())).collect(Collectors.toList())).isEmpty()) {
                        log.info(srcdimnumber + "\u7ef4\u5ea6\u6ca1\u6709\u6709\u6548\u7684\u6210\u5458\u6620\u5c04");
                    }
                    List srcMemberNumbers = memberMapperList.stream().map(ModeluploadMemberMapper::getSrcmembernumber).collect(Collectors.toList());
                    queryMembers.addAll(srcMembers.stream().filter(e -> srcMemberNumbers.contains(e.getNumber())).collect(Collectors.toList()));
                }
            }
            if (!(maponly = dimMapper.getBoolean("maponly"))) {
                Set tarMapperMemberSet = memberMapperList.stream().map(ModeluploadMemberMapper::getTarmembernumber).collect(Collectors.toSet());
                Set srcMapperMemberSet = queryMembers.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                for (Member tarMember : tarMembers) {
                    if (srcMapperMemberSet.contains(tarMember.getNumber()) || tarMapperMemberSet.contains(tarMember.getNumber()) || !srcMemberMap.containsKey(tarMember.getNumber())) continue;
                    queryMembers.add(srcMemberMap.get(tarMember.getNumber()));
                }
            }
            queryDimmemberMap.put(srcdimnumber, queryMembers);
        }
        return queryDimmemberMap;
    }

    private Map<String, List<Member>> buildTarQueryDimMemberMap(ModelUploadContext ctx, Map<String, List<Member>> srcDimMemberMap, Map<String, List<Member>> tarDimMemberMap) {
        HashMap queryDimmemberMap = Maps.newHashMapWithExpectedSize((int)30);
        for (DynamicObject dimMapper : ctx.getDimmapentity()) {
            boolean maponly;
            String srcdimnumber = this.getDimNumber(dimMapper.getDynamicObject("srcdim"));
            String tardimnumber = this.getDimNumber(dimMapper.getDynamicObject("tardim"));
            if (StringUtils.isBlank((CharSequence)tardimnumber)) continue;
            List<Member> srcMembers = srcDimMemberMap.get(srcdimnumber);
            List<Member> tarMembers = tarDimMemberMap.get(tardimnumber);
            if (srcMembers == null || tarMembers == null) continue;
            Map<String, Member> srcMemberMap = srcMembers.stream().collect(Collectors.toMap(BaseCache::getNumber, e -> e, (v1, v2) -> v1));
            Set tarMemberSet = tarMembers.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
            ArrayList<Member> queryMembers = new ArrayList<Member>(16);
            if (StringUtils.isBlank((CharSequence)srcdimnumber)) {
                Dimension tarDim = ctx.getTarModelCache().getDimension(tardimnumber);
                Member tarMember = tarMembers.stream().filter(e -> e.getNumber().equals(tarDim.getNoneNumber())).findFirst().get();
                queryDimmemberMap.put(tardimnumber, Collections.singletonList(tarMember));
                continue;
            }
            DynamicObject membermap = dimMapper.getDynamicObject("membermap");
            if (membermap != null) {
                long membermapId = membermap.getLong("id");
                ModeluploadMapperInfo modeluploadMapperInfo = ctx.getMapperInfoMap().get(membermapId);
                if (modeluploadMapperInfo != null) {
                    List memberMapperList = modeluploadMapperInfo.getMapperList().stream().filter(e -> srcMemberMap.containsKey(e.getSrcmembernumber()) && tarMemberSet.contains(e.getTarmembernumber())).collect(Collectors.toList());
                    if (memberMapperList.isEmpty()) {
                        log.info(srcdimnumber + "\u7ef4\u5ea6\u6ca1\u6709\u6709\u6548\u7684\u6210\u5458\u6620\u5c04");
                    }
                    List tarMemberNumbers = memberMapperList.stream().map(ModeluploadMemberMapper::getTarmembernumber).collect(Collectors.toList());
                    queryMembers.addAll(tarMembers.stream().filter(e -> tarMemberNumbers.contains(e.getNumber())).collect(Collectors.toList()));
                }
            }
            if (!(maponly = dimMapper.getBoolean("maponly"))) {
                Set mapSet = queryMembers.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                for (Member tarMember : tarMembers) {
                    if (mapSet.contains(tarMember.getNumber()) || !srcMemberMap.containsKey(tarMember.getNumber())) continue;
                    queryMembers.add(tarMember);
                }
            }
            queryDimmemberMap.put(tardimnumber, queryMembers);
        }
        return queryDimmemberMap;
    }

    private void initMembermapperMap(ModelUploadContext ctx) {
        Map<Object, Object> membermapperMap = Maps.newHashMapWithExpectedSize((int)20);
        Set membermapIds = ctx.getDimmapentity().stream().filter(e -> e.getDynamicObject("membermap") != null).map(e -> e.getDynamicObject("membermap").getLong("id")).collect(Collectors.toSet());
        ArrayList mapperBaseInfos = Lists.newArrayList();
        if (!membermapIds.isEmpty()) {
            String mapSql = "select fid,fsrcdimview,ftardimview from t_eb_dim_membermap where fstatus='1'  and fid in (" + membermapIds.stream().map(Object::toString).collect(Collectors.joining(",")) + ")";
            try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"epm"), (String)mapSql);){
                membermapIds.clear();
                while (ds.hasNext()) {
                    Row row = ds.next();
                    mapperBaseInfos.add(new ModeluploadMapperInfo(row.getLong("fid"), row.getLong("fsrcdimview"), row.getLong("ftardimview")));
                    membermapIds.add(row.getLong("fid"));
                }
            }
            if (membermapIds.isEmpty()) {
                return;
            }
            String sql = "select fid,fentryid,fsrcmembername,fsrcmembernumber,ftarmembername,ftarmembernumber  from t_eb_dim_membermapval where fstate='1' and fid in (" + membermapIds.stream().map(Object::toString).collect(Collectors.joining(",")) + ")";
            try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"epm"), (String)sql);){
                ArrayList<ModeluploadMemberMapper> mapperList = new ArrayList<ModeluploadMemberMapper>(16);
                while (ds.hasNext()) {
                    Row row = ds.next();
                    ModeluploadMemberMapper obj = new ModeluploadMemberMapper();
                    obj.setId(row.getLong("fid"));
                    obj.setEntryId(row.getLong("fentryid"));
                    obj.setSrcmembername(row.getString("fsrcmembername"));
                    obj.setSrcmembernumber(row.getString("fsrcmembernumber"));
                    obj.setTarmembername(row.getString("ftarmembername"));
                    obj.setTarmembernumber(row.getString("ftarmembernumber"));
                    mapperList.add(obj);
                }
                membermapperMap = mapperList.stream().collect(Collectors.groupingBy(ModeluploadMemberMapper::getId));
            }
        }
        HashMap finalMembermapperMap = membermapperMap;
        mapperBaseInfos.forEach(item -> {
            List<ModeluploadMemberMapper> mapperList = (List<ModeluploadMemberMapper>)finalMembermapperMap.get(item.getId());
            if (mapperList == null) {
                mapperList = Collections.emptyList();
            }
            item.setMapperList(mapperList);
        });
        ctx.setMapperInfoList(mapperBaseInfos);
        ctx.setMapperInfoMap(mapperBaseInfos.stream().collect(Collectors.toMap(ModeluploadMapperInfo::getId, e -> e)));
    }

    private String getDimNumber(DynamicObject dimDy) {
        if (dimDy != null) {
            return dimDy.getString("number");
        }
        return "";
    }

    private String getMemberNumber(DynamicObject memberDy) {
        if (memberDy != null) {
            return memberDy.getString("number");
        }
        return "";
    }

    private Double updateProgress(Double progress, String progressKey) {
        if (progress >= 100.0) {
            progress = 99.0;
        }
        CacheServiceHelper.put((String)progressKey, (Object)progress.intValue());
        return progress;
    }

    public List<String> transferDimMember(Set<String> transferDimNumbers, ModelUploadContext ctx) {
        log.info("\u51c6\u5907\u4f20\u8f93\u6210\u5458");
        List transferRows = ctx.getDimmapentity().stream().filter(d -> d.getBoolean("istransfermember") && transferDimNumbers.contains(d.getString("tardim.number"))).collect(Collectors.toList());
        ArrayList<String> successInfo = new ArrayList<String>(10);
        try {
            for (DynamicObject transferRow : transferRows) {
                Dimension srcDimension = ctx.getSrcModelCache().getDimension(transferRow.getString("srcdim.number"));
                Dimension tarDimension = ctx.getTarModelCache().getDimension(transferRow.getString("tardim.number"));
                Map tarDefaultViewMap = ctx.getTarModelCache().getViewsByBusModel(Long.valueOf(ctx.getTarbiz().getLong("id")));
                Long tarDefaultViewId = (Long)tarDefaultViewMap.get(tarDimension.getNumber());
                Map srcGroupViewMap = ctx.getSrcModelCache().getViewGroupViewsByBusModel(Long.valueOf(ctx.getSrcbiz().getLong("id")));
                List srcViewIds = (List)srcGroupViewMap.get(srcDimension.getNumber());
                ArrayList srcLeafMembers = Lists.newArrayListWithCapacity((int)10);
                for (Long srcViewId : srcViewIds) {
                    List vMembers = ctx.getSrcModelCache().getMembers(srcViewId, srcDimension.getNumber());
                    List rawMembers = vMembers.stream().filter(e -> e.isLeaf() && !ViewMemberSourceEnum.INNER_REF.getIndex().equals(e.getSource())).collect(Collectors.toList());
                    srcLeafMembers.addAll(rawMembers);
                }
                List<Dataset> datasets = this.queryRefDataSets(ctx.getTarModelCache().getModelobj().getId(), tarDimension.getId());
                HashSet<String> transferFail = new HashSet<String>(16);
                HashMap<String, DynamicObject> transferMembers = new HashMap<String, DynamicObject>(srcLeafMembers.size());
                String srcDimNumber = srcDimension.getNumber();
                log.info("\u5f00\u59cb\u4f20\u8f93\u7ef4\u5ea6\uff1a" + srcDimNumber);
                TXHandle tx = TX.required((String)("transfer-" + srcDimNumber));
                Throwable throwable = null;
                try {
                    try {
                        for (Member srcLeafMember : srcLeafMembers) {
                            this.prepareTransferMember(ctx, srcDimension, tarDimension, tarDefaultViewId, datasets, transferFail, transferMembers, srcLeafMember);
                        }
                        Map<Long, DynamicObject> tranMemberMap = transferMembers.values().stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
                        Map<Long, List<DynamicObject>> groupByPid = transferMembers.values().stream().collect(Collectors.groupingBy(t -> t.getLong("parent")));
                        HashSet<Long> hasHandle = new HashSet<Long>(16);
                        for (Map.Entry<Long, List<DynamicObject>> entry : groupByPid.entrySet()) {
                            Long pid = entry.getKey();
                            this.buildTree(tarDimension, tranMemberMap, hasHandle, (Collection<DynamicObject>)entry.getValue(), pid, tarDefaultViewId, ctx);
                        }
                        ArrayList vmMembers = Lists.newArrayListWithExpectedSize((int)transferMembers.size());
                        for (DynamicObject dy : transferMembers.values()) {
                            DimensionViewMember vm = (DimensionViewMember)Builder.of(DimensionViewMember::new).with(DimensionViewMember::setId, (Object)dy.getLong("id")).with(DimensionViewMember::setMemberId, (Object)dy.getLong("id")).with(DimensionViewMember::setNumber, (Object)dy.getString("number")).with(DimensionViewMember::setLevel, (Object)dy.getInt("level")).with(DimensionViewMember::setLongNumber, (Object)dy.getString("longnumber")).with(DimensionViewMember::setShowNumber, (Object)dy.getString("number")).with(DimensionViewMember::setName, (Object)dy.getString("name")).with(DimensionViewMember::setParentId, (Object)dy.getLong("parent")).with(DimensionViewMember::setDseq, (Object)dy.getInt("dseq")).build();
                            vmMembers.add(vm);
                        }
                        ViewMemberManager.getInstance().insertViewMemberToRawView2(ctx.getTarModelCache().getModelobj().getId().longValue(), tarDimension.getNumber(), tarDefaultViewId, (List)vmMembers);
                        successInfo.add(ResManager.loadResFormat((String)"\u3010%1\u3011\u4f20\u8f93\u6210\u5458: %2", (String)"ModelUploadService_3", (String)"epm-eb-business", (Object[])new Object[]{srcDimension.getName(), tranMemberMap.size()}));
                    }
                    catch (Exception e2) {
                        log.error(srcDimNumber + "\u4f20\u8f93\u6210\u5458\u5931\u8d25\uff1a" + e2.getMessage(), (Throwable)e2);
                        tx.markRollback();
                        throw new RuntimeException(e2.getMessage(), e2);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (tx == null) continue;
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    tx.close();
                }
            }
        }
        catch (Exception e3) {
            log.error("\u4f20\u8f93\u6210\u5458\u5931\u8d25\uff1a" + e3.getMessage(), (Throwable)e3);
        }
        return successInfo;
    }

    private void buildTree(Dimension tarDimension, Map<Long, DynamicObject> tranMemberMap, Set<Long> hasHandle, Collection<DynamicObject> children, Long pid, Long tarDefaultViewId, ModelUploadContext ctx) {
        if (hasHandle.contains(pid)) {
            DynamicObject parent = tranMemberMap.get(pid);
            parent.set("isleaf", (Object)Character.valueOf('0'));
            int dseq = 1;
            this.handleChildren(hasHandle, children, dseq, parent.getInt("level"), parent.getString("longnumber"));
        } else if (!tranMemberMap.containsKey(pid)) {
            Member parent = ctx.getTarModelCache().getMemberByVid(tarDimension.getNumber(), tarDefaultViewId, pid);
            int dseq = this.getMaxDSeq(pid, "eb_viewmember", tarDefaultViewId);
            this.handleChildren(hasHandle, children, ++dseq, parent.getLevel(), parent.getLongNumber());
        } else {
            DynamicObject parent = tranMemberMap.get(pid);
            this.buildTree(tarDimension, tranMemberMap, hasHandle, Collections.singletonList(parent), parent.getLong("parent"), tarDefaultViewId, ctx);
            parent.set("isleaf", (Object)Character.valueOf('0'));
            int dseq = 1;
            this.handleChildren(hasHandle, children, dseq, parent.getInt("level"), parent.getString("longnumber"));
        }
    }

    public int getMaxDSeq(long parentId, String entityNumber, long viewId) {
        QFBuilder builder = new QFBuilder();
        builder.add("parent", "=", (Object)parentId);
        if ("eb_viewmember".equals(entityNumber) && viewId != 0L) {
            builder.add("view", "=", (Object)viewId);
        }
        int seq = 0;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"getMaxDSeq", (String)entityNumber, (String)"dseq", (QFilter[])builder.toArrays(), (String)"dseq desc", (int)1);){
            if (ds != null && ds.hasNext()) {
                seq = ds.next().getInteger("dseq");
            }
        }
        return seq;
    }

    private void handleChildren(Set<Long> hasHandle, Collection<DynamicObject> children, int dseq, int level, String longnumber) {
        for (DynamicObject object : children) {
            if (hasHandle.contains(object.getLong("id"))) continue;
            object.set("level", (Object)(level + 1));
            object.set("dseq", (Object)dseq);
            object.set("isleaf", (Object)Character.valueOf('1'));
            object.set("longnumber", (Object)(longnumber + "!" + object.getString("number")));
            hasHandle.add(object.getLong("id"));
        }
    }

    private Set<String> queryRecParameter(Long tarModelId, Long versionId) {
        DynamicObjectCollection recdims;
        Date today = TimeServiceHelper.today();
        QFilter qFilter = new QFilter("model", "=", (Object)tarModelId);
        QFilter qFilter1 = new QFilter("startdate", "<=", (Object)today);
        qFilter1.and("enddate", ">", (Object)today);
        QFilter qFilter2 = new QFilter("version", "=", (Object)versionId);
        DynamicObject object = BusinessDataServiceHelper.loadSingle((String)"eb_receiveparameter", (String)"id,recdims,recdims.recdim", (QFilter[])new QFilter[]{qFilter, qFilter1, qFilter2});
        if (object != null && (recdims = object.getDynamicObjectCollection("recdims")) != null) {
            return recdims.stream().map(r -> r.getString("recdim.number")).collect(Collectors.toSet());
        }
        return new HashSet<String>(0);
    }

    private List<Dataset> queryRefDataSets(Long modelId, Long dimensionId) {
        List datasetIds = DatasetServiceHelper.queryDatasetIds((Long)modelId, (Long)dimensionId);
        ArrayList<Dataset> datasets = new ArrayList<Dataset>(datasetIds.size());
        DynamicObjectCollection _datasets = DatasetServiceHelper.loadDatasets((Long[])datasetIds.toArray(new Long[0]));
        if (_datasets != null) {
            _datasets.forEach(d -> datasets.add(Dataset.of((DynamicObject)d)));
        }
        return datasets;
    }

    private boolean hasData(Model model, String dimNumber, List<Dataset> datasets, String memNumber) {
        if (datasets.isEmpty()) {
            return false;
        }
        return !ShrekOlapServiceHelper.getExistDataMember((Model)model, datasets, (String)dimNumber, Collections.singleton(memNumber)).isEmpty();
    }

    private void prepareTransferMember(ModelUploadContext ctx, Dimension srcDimension, Dimension tarDimension, Long tarViewId, List<Dataset> datasets, Set<String> transferFail, Map<String, DynamicObject> transferMembers, Member srcLeafMember) {
        Model tarModel = ctx.getTarModelCache().getModelobj();
        String pNumber = srcLeafMember.getParentNumber();
        String number = srcLeafMember.getNumber();
        if (srcLeafMember.isDisable()) {
            transferFail.add(number);
            return;
        }
        if (this.isTransfered(transferFail, transferMembers, number)) {
            return;
        }
        if (transferFail.contains(pNumber)) {
            transferFail.add(number);
            return;
        }
        String srcRootMember = srcDimension.getNumber();
        if (srcLeafMember instanceof ViewMember) {
            ViewMember srcViewMember = (ViewMember)srcLeafMember;
            Long srcViewId = srcViewMember.getViewId();
            srcRootMember = ctx.getSrcModelCache().getRootMember(srcDimension.getNumber(), srcViewId).getNumber();
        }
        if (pNumber.equals(srcRootMember)) {
            ViewMember tarRootMember = (ViewMember)ctx.getTarModelCache().getRootMember(tarDimension.getNumber(), tarViewId);
            Map tarMemberMap = tarDimension.getAllMemberMap(tarViewId);
            if (!tarMemberMap.containsKey(srcLeafMember.getNumber())) {
                transferMembers.put(srcLeafMember.getNumber(), this.memberToDyObject(srcLeafMember, tarModel.getId(), tarDimension.getId(), tarRootMember.getVid()));
            }
        } else if (transferMembers.containsKey(pNumber)) {
            transferMembers.put(srcLeafMember.getNumber(), this.memberToDyObject(srcLeafMember, tarModel.getId(), tarDimension.getId(), transferMembers.get(pNumber).getLong("id")));
        } else {
            ViewMember parent;
            Map tarMemberMap = tarDimension.getAllMemberMap(tarViewId);
            if (tarMemberMap.containsKey(pNumber)) {
                parent = (ViewMember)tarMemberMap.get(pNumber);
                if (parent.isLeaf() && this.hasData(tarModel, tarDimension.getNumber(), datasets, pNumber)) {
                    transferFail.add(number);
                } else if (!tarMemberMap.containsKey(srcLeafMember.getNumber())) {
                    transferMembers.put(srcLeafMember.getNumber(), this.memberToDyObject(srcLeafMember, tarModel.getId(), tarDimension.getId(), parent.getVid()));
                }
            } else {
                parent = null;
                if (srcLeafMember instanceof ViewMember) {
                    ViewMember srcViewMember = (ViewMember)srcLeafMember;
                    Long srcViewId = srcViewMember.getViewId();
                    parent = ctx.getSrcModelCache().getMember(srcDimension.getNumber(), srcViewId, pNumber);
                }
                if (parent == null) {
                    transferFail.add(pNumber);
                } else {
                    this.prepareTransferMember(ctx, srcDimension, tarDimension, tarViewId, datasets, transferFail, transferMembers, (Member)parent);
                    if (transferMembers.containsKey(pNumber)) {
                        transferMembers.put(srcLeafMember.getNumber(), this.memberToDyObject(srcLeafMember, tarModel.getId(), tarDimension.getId(), transferMembers.get(pNumber).getLong("id")));
                    } else {
                        transferFail.add(number);
                    }
                }
            }
        }
    }

    private boolean isTransfered(Set<String> transferFail, Map<String, DynamicObject> transferMembers, String number) {
        return transferMembers.containsKey(number) || transferFail.contains(number);
    }

    private DynamicObject memberToDyObject(Member member, Long modelId, Long dimensionId, Long pid) {
        DynamicObject dyna = BusinessDataServiceHelper.newDynamicObject((String)"epm_userdefinedmembertree");
        dyna.set("id", (Object)DBServiceHelper.genGlobalLongId());
        dyna.set("status", (Object)"C");
        dyna.set("enable", (Object)"1");
        Date now = TimeServiceHelper.now();
        dyna.set("createtime", (Object)now);
        dyna.set("modifytime", (Object)now);
        Long currUserId = RequestContext.get().getCurrUserId();
        dyna.set("creator", (Object)currUserId);
        dyna.set("modifier", (Object)currUserId);
        dyna.set("model", (Object)modelId);
        dyna.set("dimension", (Object)dimensionId);
        dyna.set("number", (Object)member.getNumber());
        dyna.set("name", (Object)member.getName());
        dyna.set("membersource", (Object)MemberSourceEnum.ADD.getIndex());
        dyna.set("isleaf", (Object)Character.valueOf('1'));
        dyna.set("storagetype", (Object)"2");
        dyna.set("masterid", (Object)dyna.getLong("id"));
        dyna.set("aggoprt", (Object)Character.valueOf('1'));
        dyna.set("dseq", (Object)1);
        dyna.set("level", (Object)member.getLevel());
        dyna.set("parent", (Object)pid);
        dyna.set("datatype", (Object)"0");
        return dyna;
    }

    private static class InnerClass {
        private static ModelUploadService instance = new ModelUploadService();

        private InnerClass() {
        }
    }
}

