/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.db;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import kd.epm.eb.common.pojo.SqlObj;

public abstract class AbstractSqlBuilder {
    private List<String> filterKey = new LinkedList<String>();
    private List<String> filterSign = new LinkedList<String>();
    private List<Object> filterVal = new LinkedList<Object>();
    private String table;

    public AbstractSqlBuilder(String table) {
        this.table = table;
    }

    public void addFilter(String fieldKey, String sign, Object value) {
        if (fieldKey == null || value == null || sign == null) {
            return;
        }
        this.filterKey.add(fieldKey);
        this.filterVal.add(value);
        this.filterSign.add(sign);
    }

    public void addLikeFilter(String fieldKey, String value) {
        this.addFilter(fieldKey, "like", value);
    }

    public void addInFilter(String fieldKey, Object value) {
        this.addFilter(fieldKey, "in", value);
    }

    public void addMoreFilter(String fieldKey, Object value, boolean equals) {
        if (equals) {
            this.addFilter(fieldKey, ">=", value);
        } else {
            this.addFilter(fieldKey, ">", value);
        }
    }

    public void addLessFilter(String fieldKey, Object value, boolean equals) {
        if (equals) {
            this.addFilter(fieldKey, "<=", value);
        } else {
            this.addFilter(fieldKey, "<", value);
        }
    }

    public void addEqualsFilter(String fieldKey, Object value) {
        this.addFilter(fieldKey, "=", value);
    }

    public SqlObj buildSql() {
        StringBuilder sb = new StringBuilder(this.getPreSql());
        int paramCount = this.filterKey.size();
        int valueCount = 0;
        if (paramCount > 0) {
            sb.append(" where ");
            Iterator<String> keyIterator = this.filterKey.iterator();
            Iterator<Object> valIterator = this.filterVal.iterator();
            Iterator<String> signIterator = this.filterSign.iterator();
            while (keyIterator.hasNext() && valIterator.hasNext() && signIterator.hasNext()) {
                --paramCount;
                String sign = signIterator.next();
                Object value = valIterator.next();
                int valSize = value instanceof Collection ? ((Collection)value).size() : (value.getClass().isArray() ? Array.getLength(value) : 1);
                valueCount += valSize;
                if (valSize == 1) {
                    sb.append(keyIterator.next());
                    if ("in".equals(sign)) {
                        sb.append('=');
                    } else {
                        sb.append(' ');
                        sb.append(sign);
                    }
                    sb.append('?');
                } else if (valSize == 0) {
                    sb.append(" '1'='2' ");
                } else {
                    sb.append(keyIterator.next());
                    sb.append(" in");
                    sb.append('(');
                    for (int seq = 0; seq < valSize; ++seq) {
                        sb.append("?,");
                    }
                    sb.setCharAt(sb.length() - 1, ')');
                }
                if (paramCount == 0) continue;
                sb.append(" and ");
            }
        }
        Collection<Object> preParamVal = this.getPreParamVal();
        int paramIndex = 0;
        Object[] paramValues = null;
        if (preParamVal != null) {
            paramValues = new Object[preParamVal.size() + valueCount];
            for (Object val : preParamVal) {
                paramValues[paramIndex++] = val;
            }
        }
        if (valueCount != 0) {
            if (paramValues == null) {
                paramValues = new Object[valueCount];
            }
            for (Object value : this.filterVal) {
                if (value instanceof Collection) {
                    for (Object val : (Collection)value) {
                        paramValues[paramIndex++] = val;
                    }
                    continue;
                }
                if (value.getClass().isArray()) {
                    int valSize = Array.getLength(value);
                    while (--valSize < 0) {
                        paramValues[paramIndex++] = Array.get(value, valSize);
                    }
                    continue;
                }
                paramValues[paramIndex++] = value;
            }
        }
        return new SqlObj(sb.toString(), paramValues);
    }

    public String getTable() {
        return this.table;
    }

    String getPreSql() {
        return " from " + this.getTable();
    }

    Collection<Object> getPreParamVal() {
        return null;
    }
}

