/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.decompose.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.entity.property.CustomPropertyUtils;
import kd.epm.eb.common.enums.AggOprtEnum;
import kd.epm.eb.common.enums.StorageTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MemberSourceEnum;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.MemberServiceHelper;
import kd.epm.eb.common.utils.MetaUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.adjustdecompose.AdjustServiceHelper;
import kd.epm.eb.olap.service.view.ViewMemberManager;
import kd.epm.eb.olap.service.view.context.SaveMemberContext;

public class CusMemberServiceHelper {
    private static final Log log = LogFactory.getLog(CusMemberServiceHelper.class);
    private static final ViewMemberManager vmManager = ViewMemberManager.getInstance();

    public static Member addCosmicMember(Long modelId, Member member, Long viewId) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Dimension dimension = member.getDimension();
        String dimNumber = dimension.getNumber();
        String memNum = member.getNumber();
        Member cusMember = dimension.getMember(viewId, memNum + "._inv");
        if (cusMember != null) {
            return cusMember;
        }
        CusMemberServiceHelper.checkBeforeAddCosmicMember(dimNumber, memNum);
        DynamicObject structOfCusMember = CusMemberServiceHelper.createStructOfCusMember(modelId, member);
        List<DynamicObject> viewCusMembers = CusMemberServiceHelper.createViewCusMember(modelId, viewId, member, structOfCusMember);
        try (TXHandle tx = TX.required((String)"insert adjust invMember");){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{structOfCusMember});
                if (!viewCusMembers.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])viewCusMembers.toArray(new DynamicObject[0]));
                }
                SaveMemberContext ctx = new SaveMemberContext(modelCache, dimNumber, dimension.getMemberModel(), dimension.getMemberTable(), Long.valueOf(0L));
                vmManager.syncOlapData(ctx);
            }
            catch (Throwable e) {
                log.error(ResManager.loadKDString((String)"\u4fdd\u5b58\u5ba1\u6279\u8c03\u6574\u81ea\u5b9a\u4e49\u865a\u62df\u6210\u5458\u5931\u8d25\u3002", (String)"CusMemberServiceHelper_2", (String)"epm-eb-business", (Object[])new Object[0]), e);
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
        return ModelCacheContext.getOrCreate((Long)modelId).getMember(dimNumber, viewId, memNum + "._inv");
    }

    private static List<DynamicObject> createViewCusMember(Long modelId, Long viewId, Member member, DynamicObject structOfCusMember) {
        Dimension dimension = member.getDimension();
        String dimNumber = dimension.getNumber();
        if (View.NoViewDimNums.contains(dimNumber)) {
            return new ArrayList<DynamicObject>(0);
        }
        String cusMemNum = member.getNumber() + "._inv";
        Long userId = UserUtils.getUserId();
        Date now = TimeServiceHelper.now();
        ArrayList<DynamicObject> cusViewMemberDys = new ArrayList<DynamicObject>(10);
        List viewIds = MemberServiceHelper.getViewGroupViewsByViewId((Long)viewId);
        for (Long vId : viewIds) {
            Member viewMem = dimension.getMember(vId, member.getNumber());
            if (viewMem == null) continue;
            DynamicObject viewMemberDy = BusinessDataServiceHelper.loadSingle((String)"eb_viewmember", (QFilter[])new QFilter("view", "=", (Object)vId).and("number", "=", (Object)member.getNumber()).toArray());
            DynamicObject cusViewMember = BusinessDataServiceHelper.loadSingle((String)"eb_viewmember", (QFilter[])new QFilter("view", "=", (Object)vId).and("number", "=", (Object)cusMemNum).toArray());
            if (cusViewMember != null) continue;
            cusViewMember = BusinessDataServiceHelper.newDynamicObject((String)"eb_viewmember");
            cusViewMember.set("number", (Object)cusMemNum);
            cusViewMember.set("shownumber", (Object)cusMemNum);
            cusViewMember.set("name", structOfCusMember.get("name"));
            cusViewMember.set("parent", viewMemberDy.get("id"));
            cusViewMember.set("model", (Object)modelId);
            cusViewMember.set("dimension", (Object)dimension.getId());
            cusViewMember.set("view", (Object)vId);
            cusViewMember.set("membersource", (Object)MemberSourceEnum.COSMIC_INVISIBLE.getIndex());
            cusViewMember.set("isleaf", (Object)"1");
            cusViewMember.set("enable", (Object)"0");
            cusViewMember.set("disable", (Object)"1");
            cusViewMember.set("level", (Object)(viewMemberDy.getInt("level") + 1));
            cusViewMember.set("dseq", (Object)1);
            cusViewMember.set("longnumber", (Object)(viewMemberDy.getString("longnumber") + '!' + cusMemNum));
            cusViewMember.set("memberid", structOfCusMember.get("id"));
            cusViewMember.set("aggoprt", (Object)AggOprtEnum.ADD.getSign());
            cusViewMember.set("modifydate", (Object)now);
            cusViewMember.set("modifier", (Object)userId);
            cusViewMember.set("status", (Object)"C");
            cusViewMemberDys.add(cusViewMember);
        }
        return cusViewMemberDys;
    }

    private static DynamicObject createStructOfCusMember(Long modelId, Member member) {
        DynamicObjectCollection propertyEntry;
        Dimension dimension = member.getDimension();
        String dimNumber = dimension.getNumber();
        String cusMemNum = member.getNumber() + "._inv";
        DynamicObject cusObject = BusinessDataServiceHelper.loadSingle((String)dimension.getMemberModel(), (QFilter[])new QFilter("model", "=", (Object)modelId).and("number", "=", (Object)cusMemNum).toArray());
        if (cusObject != null) {
            return cusObject;
        }
        Long userId = UserUtils.getUserId();
        Date now = TimeServiceHelper.now();
        String cusMemName = member.getName() + "._inv";
        if (cusMemName.length() > 255) {
            cusMemName = cusMemName.substring(0, 255);
        }
        DynamicObject memberDy = BusinessDataServiceHelper.loadSingle((Object)member.getId(), (String)dimension.getMemberModel());
        cusObject = BusinessDataServiceHelper.newDynamicObject((String)dimension.getMemberModel());
        cusObject.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        cusObject.set("number", (Object)cusMemNum);
        cusObject.set("shownumber", (Object)cusMemNum);
        cusObject.set("parent", (Object)member.getId());
        cusObject.set("name", (Object)cusMemName);
        cusObject.set("simplename", memberDy.get("simplename"));
        cusObject.set("status", memberDy.get("status"));
        cusObject.set("creator", (Object)userId);
        cusObject.set("modifier", (Object)userId);
        cusObject.set("createtime", (Object)now);
        cusObject.set("modifytime", (Object)now);
        cusObject.set("aggoprt", (Object)AggOprtEnum.ADD.getSign());
        cusObject.set("storagetype", (Object)StorageTypeEnum.STORAGE.getIndex());
        cusObject.set("model", memberDy.get("model"));
        cusObject.set("dimension", memberDy.get("dimension"));
        cusObject.set("level", (Object)(memberDy.getInt("level") + 1));
        cusObject.set("dseq", (Object)1);
        cusObject.set("longnumber", (Object)(memberDy.getString("longnumber") + '!' + cusMemNum));
        cusObject.set("isleaf", (Object)"1");
        cusObject.set("enable", (Object)"0");
        cusObject.set("disable", (Object)"1");
        cusObject.set("disabledate", (Object)memberDy.getDate("disabledate"));
        cusObject.set("membersource", (Object)MemberSourceEnum.COSMIC_INVISIBLE.getIndex());
        cusObject.set("customvalues", memberDy.get("customvalues"));
        boolean hasProperty = false;
        if (SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
            cusObject.set("dataset", memberDy.get("dataset"));
            cusObject.set("accounttype", memberDy.get("accounttype"));
            cusObject.set("drcrdirect", memberDy.get("drcrdirect"));
            hasProperty = true;
        } else if (SysDimensionEnum.Entity.getNumber().equals(dimNumber)) {
            cusObject.set("currency", memberDy.get("currency"));
            cusObject.set("mergernode", (Object)Character.valueOf('0'));
            cusObject.set("isinnerorg", (Object)Character.valueOf('0'));
            cusObject.set("isouterorg", (Object)Character.valueOf('0'));
            cusObject.set("isexchangerate", (Object)Character.valueOf('0'));
            cusObject.set("executor", (Object)0L);
            cusObject.set("owner", (Object)0L);
            hasProperty = true;
        }
        if (!dimension.isPreset()) {
            cusObject.set("datatype", memberDy.get("datatype"));
            hasProperty = true;
        }
        if (hasProperty && CollectionUtils.isNotEmpty((Collection)(propertyEntry = memberDy.getDynamicObjectCollection("propertyentry")))) {
            DynamicObjectCollection propertyEntryCopy = cusObject.getDynamicObjectCollection("propertyentry");
            for (DynamicObject property : propertyEntry) {
                DynamicObject propertyCopy = new DynamicObject(propertyEntryCopy.getDynamicObjectType());
                propertyCopy.set("seq", property.get("seq"));
                propertyCopy.set("propertyvalue", property.get("propertyvalue"));
                propertyEntryCopy.add((Object)propertyCopy);
            }
        }
        return cusObject;
    }

    private static void checkBeforeAddCosmicMember(String dimNumber, String memNum) {
        if (!MetaUtils.verifyMetaLength((String)SysDimensionEnum.getMemberTreemodelByNumber((String)dimNumber), (String)"number", (String)(memNum + "._inv"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u7f16\u7801\u8fc7\u957f\uff0c\u4e0d\u5141\u8bb8\u5ba1\u6279\u8c03\u6574\u3002", (String)"CusMemberServiceHelper_1", (String)"epm-eb-business", (Object[])new Object[0]));
        }
    }

    public static void delCosmicMember(Long modelId, Member cusMember) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Dimension dimension = cusMember.getDimension();
        String dimNumber = dimension.getNumber();
        try (TXHandle tx = TX.required((String)"delete adjust invMember");){
            try {
                DeleteServiceHelper.delete((String)"eb_viewmember", (QFilter[])new QFilter("memberid", "=", (Object)cusMember.getId()).toArray());
                DeleteServiceHelper.delete((String)dimension.getMemberModel(), (QFilter[])new QFilter("id", "=", (Object)cusMember.getId()).toArray());
                CustomPropertyUtils.deletePropertyByRef(Collections.singleton(cusMember.getId()));
                MemberPropCacheService.updateVersion((Long)modelId, (Long)dimension.getId());
                vmManager.delOlapMember(Collections.singletonList(cusMember.getNumber()), dimNumber, modelCache);
                SaveMemberContext ctx = new SaveMemberContext(modelCache, dimNumber, dimension.getMemberModel(), dimension.getMemberTable(), Long.valueOf(0L));
                vmManager.syncOlapData(ctx);
            }
            catch (Throwable e) {
                log.error(ResManager.loadKDString((String)"\u5220\u9664\u5ba1\u6279\u8c03\u6574\u81ea\u5b9a\u4e49\u865a\u62df\u6210\u5458\u5931\u8d25\u3002", (String)"CusMemberServiceHelper_3", (String)"epm-eb-business", (Object[])new Object[0]), e);
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public static void deleteCosmicMember(Long modelId, Map<String, String> memberMap, Map<String, Long> dimViewMap) {
        CusMemberServiceHelper.deleteCosmicMember(modelId, memberMap, null, dimViewMap);
    }

    public static void deleteCosmicMember(Long modelId, Map<String, String> memberMap, String decDimNumber, Map<String, Long> dimViewMap) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        HashMap<String, String> deleteCosmicMap = new HashMap<String, String>(16);
        if (decDimNumber != null) {
            String memberNumber = memberMap.get(decDimNumber);
            deleteCosmicMap.put(decDimNumber, memberNumber);
        } else {
            deleteCosmicMap.putAll(memberMap);
        }
        for (Map.Entry entry : deleteCosmicMap.entrySet()) {
            String dimNumber = (String)entry.getKey();
            String memberNumber = (String)entry.getValue();
            Long viewId = dimViewMap.get(dimNumber);
            Member cosmicMember = modelCache.getMember(dimNumber, viewId, memberNumber + "._inv");
            if (cosmicMember == null || AdjustServiceHelper.hasDecomposeAdjust((Long)modelId, (String)dimNumber, (String)memberNumber, dimViewMap)) continue;
            CusMemberServiceHelper.delCosmicMember(modelId, cosmicMember);
        }
    }
}

