/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.decompose.service;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.epm.eb.business.approvetype.ApproveUtils;
import kd.epm.eb.business.bizrule.RuleExecutionService;
import kd.epm.eb.business.bizrule.RuleFindService;
import kd.epm.eb.business.decompose.service.CusMemberServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.constant.BgFormConstant;
import kd.epm.eb.common.decompose.DecomposeStatus;
import kd.epm.eb.common.decompose.entity.AdjustDecomposeDetail;
import kd.epm.eb.common.decompose.entity.AdjustDecomposeQueryVO;
import kd.epm.eb.common.decompose.entity.AdjustDecomposeRecord;
import kd.epm.eb.common.decompose.entity.BgNumberCell;
import kd.epm.eb.common.elasticsearch.OlapDataAuditEventEnum;
import kd.epm.eb.common.enums.AggOprtEnum;
import kd.epm.eb.common.enums.AuditTrailUseEnum;
import kd.epm.eb.common.enums.FacTabFieldDefEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.olapdao.OlapContext;
import kd.epm.eb.common.olapdao.OlapWriteOption;
import kd.epm.eb.common.olapdao.SaveDataContext;
import kd.epm.eb.common.reportprocess.entity.domain.ReportProcess;
import kd.epm.eb.common.rule.execute.RuleExecuteTypeEnum;
import kd.epm.eb.common.shrek.controller.ShrekOlapReader;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.thread.EpmThreadPools;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.adjustdecompose.AdjustServiceHelper;
import kd.epm.eb.olap.api.base.IKDValue;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.impl.base.KDValue;
import kd.epm.eb.olap.impl.metadata.KDCell;
import kd.epm.eb.olap.service.AlgoCalcUtils;
import kd.epm.eb.olap.service.OlapManager;
import kd.epm.eb.olap.service.request.Options;
import kd.epm.eb.olap.service.request.SaveRequest;
import kd.epm.epbs.business.log.trace.OlapTraceServiceHelper;

public class DataDecomposeService {
    private static final Log log = LogFactory.getLog(DataDecomposeService.class);

    public static DataDecomposeService getInstance() {
        return InnerClass.instance;
    }

    public void delDetail(long modelId, Long dataSetId, Map<String, String> memberMap) {
        try {
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
            List dimensions = modelCache.getDimensionList(dataSetId);
            Map viewMap = modelCache.getViewsByDataSet(dataSetId);
            HashMap deleteRange = new HashMap(16);
            String metricNumber = "";
            for (Dimension dim : dimensions) {
                String dimNumber = dim.getNumber();
                String memberNumber = AdjustServiceHelper.getMemberNumberWithNone((IModelCacheHelper)modelCache, (Dimension)dim, memberMap, (Map)viewMap);
                Set memberDetailList = modelCache.getMemberIncludeCosmic(dimNumber, (Long)viewMap.get(dimNumber), memberNumber, RangeEnum.ALL_DETAIL.getIndex()).stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                if (!memberDetailList.isEmpty()) {
                    deleteRange.put(dimNumber, memberDetailList);
                }
                if (!SysDimensionEnum.Metric.getNumber().equals(dimNumber)) continue;
                metricNumber = memberNumber;
            }
            ShrekOlapServiceHelper.deleteData((Long)modelId, (Long)dataSetId, deleteRange, (String)metricNumber);
        }
        catch (Exception e) {
            log.error(CommonServiceHelper.getStackTraceStr((Throwable)e));
            throw new KDBizException(e.getMessage());
        }
    }

    public void avgToDetail(long modelId, List<BgNumberCell> numberCellS) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        for (BgNumberCell numberCell : numberCellS) {
            this.avgToDetail(modelCache, numberCell);
        }
    }

    public void adjustBack(Long modelId, Long datasetId, Map<String, String> memberMap, BigDecimal value, String decDimNumber, Map<String, Long> dimViewMap) {
        BgNumberCell bgNumberCell = new BgNumberCell(datasetId, memberMap, BigDecimal.ZERO.subtract(value));
        HashMap<String, Map<String, Long>> cellViewMap = new HashMap<String, Map<String, Long>>(1);
        cellViewMap.put(memberMap.toString(), dimViewMap);
        this.adjustToOlap(modelId, Collections.singletonList(bgNumberCell), true, cellViewMap);
        CusMemberServiceHelper.deleteCosmicMember(modelId, memberMap, decDimNumber, dimViewMap);
    }

    public void adjustToOlap(long modelId, List<BgNumberCell> numberCells, Map<String, Map<String, Long>> cellViewMap) {
        this.adjustToOlap(modelId, numberCells, false, cellViewMap);
    }

    public void adjustToOlap(long modelId, List<BgNumberCell> numberCells, boolean deleteOld, Map<String, Map<String, Long>> cellViewMap) {
        if (numberCells.isEmpty()) {
            return;
        }
        Long datasetId = numberCells.get(0).getDatasetId();
        ArrayList<BGCell> cells = new ArrayList<BGCell>(numberCells.size());
        for (BgNumberCell numberCell : numberCells) {
            BGCell bgCell = new BGCell(numberCell.getMemberMap(), (Object)numberCell.getValue());
            cells.add(bgCell);
        }
        this.adjustToOlap(modelId, datasetId, cells, deleteOld, cellViewMap);
    }

    public void adjustToOlap(long modelId, Long datasetId, List<BGCell> cells, boolean deleteOld, Map<String, Map<String, Long>> cellViewMap) {
        if (cells.isEmpty()) {
            return;
        }
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        ArrayList<BGCell> valueCells = new ArrayList<BGCell>(cells.size());
        ArrayList<BGCell> otherCells = new ArrayList<BGCell>(cells.size());
        Long businessModelId = modelCache.getBusModelByDataSet(datasetId);
        for (BGCell cell : cells) {
            Object value = cell.getValue();
            List dimensionList = modelCache.getDimensionList(datasetId);
            Map memMap = cell.getMemberMap();
            HashMap dimViewMap = cellViewMap.get(memMap.toString()) == null ? Maps.newHashMap() : cellViewMap.get(memMap.toString());
            Object[] members = new Object[dimensionList.size() + 1];
            Member metric = modelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, (String)memMap.get(SysDimensionEnum.Metric.getNumber()));
            boolean isNumberMetric = AdjustServiceHelper.isNumberMetric((String)metric.getDatatype());
            for (int i = 0; i < dimensionList.size(); ++i) {
                Dimension dimension = (Dimension)dimensionList.get(i);
                String memberNumber = AdjustServiceHelper.getMemberNumberWithNone((IModelCacheHelper)modelCache, (Dimension)dimension, (Map)memMap, (Map)dimViewMap);
                members[i + 1] = memberNumber;
                if (metric.isNoLeafStorage()) continue;
                Long dimViewId = (Long)dimViewMap.get(dimension.getNumber());
                Member member = modelCache.getMemberByAnyView(businessModelId, dimension.getNumber(), memberNumber);
                if (member == null || member.isLeaf()) continue;
                Member decomposeAuditTrail = null;
                if (SysDimensionEnum.AuditTrail.getNumber().equals(dimension.getNumber()) && isNumberMetric && metric.hasAgg()) {
                    decomposeAuditTrail = AdjustServiceHelper.getChildDecomposeAuditTrail((IModelCacheHelper)modelCache, (String)memberNumber);
                }
                if (decomposeAuditTrail == null) {
                    Member cosmicMember = CusMemberServiceHelper.addCosmicMember(modelId, member, dimViewId);
                    if (cosmicMember == null) continue;
                    members[i + 1] = cosmicMember.getNumber();
                    continue;
                }
                members[i + 1] = decomposeAuditTrail.getNumber();
            }
            members[0] = value;
            IKDCell ikdCell = KDCell.of((Object[])members, (boolean)true);
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
            if (isNumberMetric) {
                valueCells.add(AlgoCalcUtils.toBGCell((IKDCell)ikdCell, (IModelCacheHelper)modelCacheHelper, (List)dimensionList, (Map)dimViewMap));
                continue;
            }
            otherCells.add(AlgoCalcUtils.toBGCell((IKDCell)ikdCell, (IModelCacheHelper)modelCacheHelper, (List)dimensionList, (Map)dimViewMap));
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        this.saveToOlap(modelCacheHelper, datasetId, valueCells, true);
        this.saveToOlap(modelCacheHelper, datasetId, otherCells, false);
        this.executeRuleForDecomposeAdjust(modelCache, datasetId, valueCells, deleteOld);
    }

    public void rejectAdjust(Set<Long> approveBillIds) {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        Map<Long, ReportProcess> approveRefReportProcessInfo = ApproveUtils.getInstance().getApproveRefReportProcessInfo(approveBillIds);
        long modelId = 0L;
        ArrayList<Map> memberList = new ArrayList<Map>(approveRefReportProcessInfo.size());
        OlapTraceServiceHelper.setTraceOpInfo((String)StringUtils.join((Object[])ApproveUtils.getApproveBillNumber(approveBillIds).toArray(), (String)","));
        OlapContext.setSaveDataContext((SaveDataContext)new SaveDataContext(OlapDataAuditEventEnum.AdjustDecompose));
        HashMap<String, Map<String, Long>> cellViewMap = new HashMap<String, Map<String, Long>>(1);
        for (ReportProcess report : approveRefReportProcessInfo.values()) {
            modelId = report.getModelId();
            Long reportProcessId = report.getId();
            AdjustDecomposeRecord record = new AdjustDecomposeRecord();
            record.setModelId(Long.valueOf(modelId));
            AdjustDecomposeDetail adjustDecomposeDetail = new AdjustDecomposeDetail();
            adjustDecomposeDetail.setStatus(DecomposeStatus.WAIT.getValue());
            adjustDecomposeDetail.setReportProcessId(reportProcessId);
            adjustDecomposeDetail.setApproveBillId(report.getApproveBillId());
            AdjustDecomposeQueryVO queryVO = new AdjustDecomposeQueryVO();
            queryVO.setAdjustDecomposeRecord(record);
            queryVO.setAdjustDecomposeDetail(adjustDecomposeDetail);
            DynamicObjectCollection adjusts = AdjustServiceHelper.queryAdjustDecomposeRecordList((AdjustDecomposeQueryVO)queryVO);
            for (DynamicObject adjust : adjusts) {
                params.add(new Object[]{adjust.getLong("entryid")});
                BigDecimal value = adjust.getBigDecimal("adjusttrial");
                String viewJsonStr = adjust.getString("viewjson");
                Map viewMap = (Map)JSON.parseObject((String)viewJsonStr, HashMap.class);
                String srcdimensionjson = adjust.getString("dimensionjson");
                Map memberMap = (Map)JSON.parseObject((String)srcdimensionjson, HashMap.class);
                long datasetId = adjust.getLong("dataset");
                BgNumberCell bgNumberCell = new BgNumberCell(Long.valueOf(datasetId), memberMap, BigDecimal.ZERO.subtract(value));
                Map dimViewMap = AdjustServiceHelper.getDimViewMap((Map)viewMap);
                cellViewMap.put(memberMap.toString(), dimViewMap);
                this.adjustToOlap(modelId, Collections.singletonList(bgNumberCell), true, cellViewMap);
                memberList.add(memberMap);
            }
        }
        if (!params.isEmpty()) {
            DB.executeBatch((DBRoute)BgFormConstant.DBROUTE, (String)"delete from t_eb_decomposeadjustsub where fentryid = ?", params);
        }
        for (Map memberMap : memberList) {
            Map dimViewMap = (Map)cellViewMap.get(memberMap.toString());
            CusMemberServiceHelper.deleteCosmicMember(modelId, memberMap, dimViewMap);
        }
    }

    public List<IKDCell> avgCells(IModelCacheHelper modelCache, BgNumberCell numberCell) {
        return this.avgCells(modelCache, numberCell, true);
    }

    public List<IKDCell> avgCells(IModelCacheHelper modelCache, BgNumberCell numberCell, boolean includeDisable) {
        Long datasetId = numberCell.getDatasetId();
        Map viewMap = modelCache.getViewsByDataSet(datasetId);
        List detailMemberList = new ArrayList(10);
        List dimensionList = modelCache.getDimensionList(datasetId);
        Map memMap = numberCell.getMemberMap();
        Long businessModelId = modelCache.getBusModelByDataSet(datasetId);
        for (Dimension dim : dimensionList) {
            String memberNumber;
            String dimNumber = dim.getNumber();
            Member member = modelCache.getMemberByAnyView(businessModelId, dimNumber, memberNumber = AdjustServiceHelper.getMemberNumberWithNone((IModelCacheHelper)modelCache, (Dimension)dim, (Map)memMap, (Map)viewMap));
            if (member == null) {
                return new ArrayList<IKDCell>(10);
            }
            ArrayList<String> memberList2 = new ArrayList<String>(10);
            if (SysDimensionEnum.Metric.getNumber().equals(dimNumber)) {
                memberList2.add(member.getNumber());
            } else if (member.isLeaf()) {
                memberList2.add(member.getNumber());
            } else {
                List details = modelCache.getMemberByAnyView(dimNumber, businessModelId, memberNumber, RangeEnum.ALL_DETAIL.getIndex());
                if (SysDimensionEnum.Account.getNumber().endsWith(dimNumber) && (details = details.stream().filter(e -> AggOprtEnum.ADD.getSign().equals(e.getAggType())).collect(Collectors.toList())).isEmpty()) {
                    log.warn("\u6ca1\u6709\u79d1\u76ee\u4e3a\u52a0\u7684\u6210\u5458");
                    return Collections.emptyList();
                }
                memberList2.addAll(details.stream().filter(member1 -> includeDisable || !member1.isDisable()).map(BaseCache::getNumber).collect(Collectors.toList()));
            }
            detailMemberList.add(memberList2);
        }
        detailMemberList = Lists.cartesianProduct(detailMemberList);
        int size = detailMemberList.size();
        log.info("\u660e\u7ec6\u7684\u7b1b\u5361\u5c14\u79efsize:" + size);
        if (size < 1) {
            return Collections.emptyList();
        }
        BigDecimal value = numberCell.getValue();
        String metricNumber = (String)numberCell.getMemberMap().get(SysDimensionEnum.Metric.getNumber());
        Member metricMember = modelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, metricNumber);
        boolean isAggMetric = metricMember.hasAgg();
        BigDecimal avg = !isAggMetric || detailMemberList.size() == 1 ? value : value.divide(new BigDecimal(detailMemberList.size()), 2, 4);
        List<IKDCell> cells = detailMemberList.parallelStream().map(memberList -> {
            String[] memberMeta = memberList.toArray(new String[memberList.size()]);
            return KDCell.of((String[])memberMeta, (BigDecimal)avg);
        }).collect(Collectors.toList());
        if (isAggMetric && cells.size() > 1) {
            IKDCell cell = cells.get(size - 1);
            BigDecimal other = avg.multiply(new BigDecimal(size - 1));
            BigDecimal diff = value.subtract(other);
            cell.setValue((IKDValue)new KDValue(diff));
        }
        return cells;
    }

    public void avgToDetail(IModelCacheHelper modelCache, BgNumberCell numberCell) {
        Long datasetId = numberCell.getDatasetId();
        List dimensions = modelCache.getDimensionList(datasetId);
        List<IKDCell> cells = this.avgCells(modelCache, numberCell);
        ArrayList<BGCell> bgCells = new ArrayList<BGCell>(cells.size());
        Map viewMap = modelCache.getViewsByDataSet(datasetId);
        for (IKDCell kdCell : cells) {
            bgCells.add(AlgoCalcUtils.toBGCell((IKDCell)kdCell, (IModelCacheHelper)modelCache, (List)dimensions, (Map)viewMap));
        }
        this.saveToOlap(modelCache, datasetId, bgCells, false);
    }

    public IKDCell queryCell(Long datasetId, Map<String, String> memberMap, IModelCacheHelper modelCache, Map<String, Long> dimViewMap) {
        List<IKDCell> cells = this.queryCells(datasetId, Collections.singletonList(memberMap), modelCache, dimViewMap);
        if (cells.size() > 0) {
            return cells.get(0);
        }
        return null;
    }

    public Map<String, BigDecimal> queryValues(String dim, Long datasetId, List<Map<String, String>> memberMaps, IModelCacheHelper modelCache, Map<String, Long> dimViewMap) {
        HashMap<String, BigDecimal> memberValueMap = new HashMap<String, BigDecimal>(16);
        List<IKDCell> cells = this.queryCells(datasetId, memberMaps, modelCache, dimViewMap);
        List dimensionList = modelCache.getDimensionList(datasetId);
        Map viewIds = modelCache.getViewsByDataSet(datasetId);
        for (Map<String, String> memberMap : memberMaps) {
            Object[] members = new String[dimensionList.size()];
            for (int i = 0; i < dimensionList.size(); ++i) {
                members[i] = AdjustServiceHelper.getMemberNumberWithNone((IModelCacheHelper)modelCache, (Dimension)((Dimension)dimensionList.get(i)), memberMap, (Map)viewIds);
            }
            for (IKDCell cell : cells) {
                Object[] numbers = cell.getMeta().getNumber();
                if (!Arrays.equals(numbers, members)) continue;
                memberValueMap.put(memberMap.get(dim), cell.getValue().getDecimal());
            }
        }
        return memberValueMap;
    }

    public Map<String, IKDValue> queryValues(Long datasetId, List<Map<String, String>> memberMaps, IModelCacheHelper modelCache, Map<String, Long> dimViewMap) {
        HashMap<String, IKDValue> memberValueMap = new HashMap<String, IKDValue>(16);
        if (memberMaps.isEmpty()) {
            return memberValueMap;
        }
        List<IKDCell> cells = this.queryCells(datasetId, memberMaps, modelCache, dimViewMap);
        List dimensionList = modelCache.getDimensionList(datasetId);
        Map viewIds = modelCache.getViewsByDataSet(datasetId);
        for (Map<String, String> memberMap : memberMaps) {
            Object[] members = new String[dimensionList.size()];
            for (int i = 0; i < dimensionList.size(); ++i) {
                members[i] = AdjustServiceHelper.getMemberNumberWithNone((IModelCacheHelper)modelCache, (Dimension)((Dimension)dimensionList.get(i)), memberMap, (Map)viewIds);
            }
            for (IKDCell cell : cells) {
                Object[] numbers;
                if (cell == null || !Arrays.equals(numbers = cell.getMeta().getNumber(), members)) continue;
                memberValueMap.put(JSON.toJSONString((Object)AdjustServiceHelper.removeCustomDimNoneMember(memberMap, (IModelCacheHelper)modelCache)), cell.getValue());
            }
        }
        return memberValueMap;
    }

    public List<IKDCell> queryCells(Long datasetId, List<Map<String, String>> memberMaps, IModelCacheHelper modelCache, Map<String, Long> dimViewMap) {
        List dimensions = modelCache.getDimensionList(datasetId);
        SelectCommandInfo queryInfo = new SelectCommandInfo();
        for (Dimension dim : dimensions) {
            String dimNumber = dim.getNumber();
            HashSet<String> members = new HashSet<String>(16);
            for (Map<String, String> memberMap : memberMaps) {
                members.add(AdjustServiceHelper.getMemberNumberWithNone((IModelCacheHelper)modelCache, (Dimension)dim, memberMap, dimViewMap));
            }
            queryInfo.addFilter(dimNumber, members.toArray(new String[0]));
        }
        queryInfo.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        Dataset dataSet = DatasetServiceHelper.getInstance().getDataSet(datasetId);
        queryInfo.setDimensions(Arrays.asList(modelCache.getDimensionNums(datasetId)));
        ArrayList<IKDCell> cells = new ArrayList<IKDCell>(10);
        try (ShrekOlapReader reader = ShrekOlapServiceHelper.queryReader((Model)modelCache.getModelobj(), (Dataset)dataSet, (SelectCommandInfo)queryInfo, (LogStats)new LogStats("portionToDetailFromEntityInput"));){
            while (reader.hasNext()) {
                Object[] row = reader.next();
                cells.add(KDCell.of((Object[])row));
            }
        }
        return cells;
    }

    public void saveToOlap(IModelCacheHelper modelCache, Long datasetId, List<BGCell> bgCells, boolean increment) {
        if (bgCells == null || bgCells.isEmpty()) {
            return;
        }
        LogStats stats = new LogStats("budget-shrek-log : ");
        stats.addInfo("begin-saveToOlap");
        stats.addInfo("data_size:" + bgCells.size());
        Map viewMap = modelCache.getViewsByDataSet(datasetId);
        List dimensions = modelCache.getDimensionList(datasetId);
        OlapWriteOption olapWriteOption = new OlapWriteOption();
        olapWriteOption.setIncrement(increment);
        olapWriteOption.setDataLockThrowErr(true);
        OlapManager.getInstance().saveList(new SaveRequest(modelCache.getModelobj().getId(), datasetId, bgCells), olapWriteOption);
    }

    public String[] toMemberArr(Map<String, String> memberMap, List<Dimension> dimensions) {
        String[] memberMeta = new String[dimensions.size()];
        for (int i = 0; i < dimensions.size(); ++i) {
            Dimension dim = dimensions.get(i);
            memberMeta[i] = memberMap.get(dim.getNumber());
        }
        return memberMeta;
    }

    private static boolean checkCellATAdjustMemHasNotRule(Long modelId, Long datasetId, Map<String, String> dimMemData, Map<String, Long> dimMemViewIdMap) {
        Optional<Member> first;
        if (IDUtils.isEmptyLong((Long)modelId).booleanValue()) {
            return false;
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Member atMember = modelCacheHelper.getMember("AuditTrail", null, dimMemData.get("AuditTrail"));
        if (atMember == null) {
            return false;
        }
        if (atMember.isLeaf()) {
            return false;
        }
        List members = modelCacheHelper.getMember("AuditTrail", Long.valueOf(0L), atMember.getNumber(), RangeEnum.ALL_EXCLUDE.getIndex());
        if (CollectionUtils.isNotEmpty((Collection)members) && (first = members.stream().filter(e -> StringUtils.equals((String)e.getAuditTrailUse(), (String)AuditTrailUseEnum.DECOMPOSE.getCode())).findFirst()).isPresent()) {
            Member atAdjustMember = first.get();
            HashMap dimMemDataCopy = Maps.newHashMap();
            dimMemDataCopy.putAll(dimMemData);
            dimMemDataCopy.put("AuditTrail", atAdjustMember.getNumber());
            log.info("checkCellATAdjustMemHasNotRule" + SerializationUtils.toJsonString((Object)dimMemDataCopy));
            return !RuleFindService.getInstance().checkCellDetailHasRule(modelId, datasetId, dimMemDataCopy, dimMemViewIdMap);
        }
        return false;
    }

    private void executeRuleForDecomposeAdjust(IModelCacheHelper modelCache, Long datasetId, List<BGCell> bgCells, boolean deleteOld) {
        Model modelobj = modelCache.getModelobj();
        if (modelobj == null) {
            return;
        }
        List partition = Lists.partition(bgCells, (int)100000);
        String traceId = RequestContext.getOrCreate().getTraceId();
        for (List bgCellList : partition) {
            if (deleteOld) {
                this.adjustExecuteRuleChain(datasetId, modelobj, traceId, bgCellList);
                continue;
            }
            EpmThreadPools.RULE_EXECUTION_POOL.execute(() -> this.adjustExecuteRuleChain(datasetId, modelobj, traceId, bgCellList));
        }
    }

    private void adjustExecuteRuleChain(Long datasetId, Model modelobj, String traceId, List<BGCell> bgCellList) {
        RequestContext.getOrCreate().setTraceId(traceId);
        Options opt = new Options();
        opt.setSkipTrust(Boolean.valueOf(true));
        RuleExecutionService.getInstance().executeRuleChain(null, datasetId, modelobj.getId(), bgCellList, RuleExecuteTypeEnum.DECOMPOSE_ADJUST.getType(), opt);
    }

    public static void checkRules(Long modelId, Long datasetId, Map<String, String> dimenData, Map<String, String> dimViewMap) {
        HashMap<String, Long> dimMemViewIdMap = new HashMap<String, Long>(16);
        for (Map.Entry<String, String> entry : dimViewMap.entrySet()) {
            dimMemViewIdMap.put(entry.getKey(), IDUtils.toLong((Object)entry.getValue()));
        }
        boolean hasRule = RuleFindService.getInstance().checkCellDetailHasRule(modelId, datasetId, dimenData, dimMemViewIdMap);
        log.info("checkCellDetailHasRule:" + hasRule);
        if (hasRule) {
            boolean atAdjustMemHasNotRule = DataDecomposeService.checkCellATAdjustMemHasNotRule(modelId, datasetId, dimenData, dimMemViewIdMap);
            if (atAdjustMemHasNotRule) {
                return;
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u7531\u4e1a\u52a1\u89c4\u5219\u8ba1\u7b97\u5f97\u51fa\uff0c\u4e0d\u5141\u8bb8\u5bf9\u6b64\u6570\u636e\u8fdb\u884c\u76f4\u63a5\u8c03\u6574\u3002", (String)"Fn_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public void deleteAdjustRecordForReportUnaudit(Map<Long, Long> reportModelMap) {
        OlapTraceServiceHelper.setTraceOpInfo((String)StringUtils.join((Object[])reportModelMap.keySet().toArray(), (String)","));
        OlapContext.setSaveDataContext((SaveDataContext)new SaveDataContext(OlapDataAuditEventEnum.AdjustDecompose));
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        HashMap<Long, List> modelMemberMap = new HashMap<Long, List>(16);
        HashMap<String, Map<String, Long>> cellViewMap = new HashMap<String, Map<String, Long>>(1);
        for (Map.Entry<Long, Long> entry : reportModelMap.entrySet()) {
            Long reportProcessId = entry.getKey();
            Long modelId = entry.getValue();
            AdjustDecomposeRecord record = new AdjustDecomposeRecord();
            record.setModelId(modelId);
            AdjustDecomposeDetail adjustDecomposeDetail = new AdjustDecomposeDetail();
            adjustDecomposeDetail.setStatus(DecomposeStatus.WAIT.getValue());
            adjustDecomposeDetail.setReportProcessId(reportProcessId);
            AdjustDecomposeQueryVO queryVO = new AdjustDecomposeQueryVO();
            queryVO.setAdjustDecomposeRecord(record);
            queryVO.setAdjustDecomposeDetail(adjustDecomposeDetail);
            DynamicObjectCollection adjusts = AdjustServiceHelper.queryAdjustDecomposeRecordList((AdjustDecomposeQueryVO)queryVO);
            for (DynamicObject adjust : adjusts) {
                params.add(new Object[]{adjust.getLong("entryid")});
                BigDecimal value = adjust.getBigDecimal("adjusttrial");
                String viewJsonStr = adjust.getString("viewjson");
                Map viewMap = (Map)JSON.parseObject((String)viewJsonStr, HashMap.class);
                String srcdimensionjson = adjust.getString("dimensionjson");
                Map memberMap = (Map)JSON.parseObject((String)srcdimensionjson, HashMap.class);
                long datasetId = adjust.getLong("dataset");
                BgNumberCell bgNumberCell = new BgNumberCell(Long.valueOf(datasetId), memberMap, BigDecimal.ZERO.subtract(value));
                Map dimViewMap = AdjustServiceHelper.getDimViewMap((Map)viewMap);
                cellViewMap.put(memberMap.toString(), dimViewMap);
                this.adjustToOlap(modelId, Collections.singletonList(bgNumberCell), true, cellViewMap);
                List memberList = modelMemberMap.computeIfAbsent(modelId, v -> new ArrayList(16));
                memberList.add(memberMap);
            }
        }
        if (!params.isEmpty()) {
            DB.executeBatch((DBRoute)BgFormConstant.DBROUTE, (String)"delete from t_eb_decomposeadjustsub where fentryid = ?", params);
        }
        for (Map.Entry<Long, Long> entry : modelMemberMap.entrySet()) {
            Long modelId = entry.getKey();
            List memberList = (List)((Object)entry.getValue());
            for (Map memberMap : memberList) {
                Map dimViewMap = (Map)cellViewMap.get(memberMap.toString());
                CusMemberServiceHelper.deleteCosmicMember(modelId, memberMap, dimViewMap);
            }
        }
    }

    private static class InnerClass {
        private static DataDecomposeService instance = new DataDecomposeService();

        private InnerClass() {
        }
    }
}

