/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.decompose.service;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.dataupload.DataReleaseUtils;
import kd.epm.eb.business.decompose.service.CusMemberServiceHelper;
import kd.epm.eb.business.decompose.service.DataDecomposeService;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.constant.BgFormConstant;
import kd.epm.eb.common.decompose.DecDimensionUtil;
import kd.epm.eb.common.decompose.DecomposeStatus;
import kd.epm.eb.common.decompose.DynamicObjectUtil;
import kd.epm.eb.common.decompose.TaskStatus;
import kd.epm.eb.common.decompose.entity.AdjustDecomposeDetail;
import kd.epm.eb.common.decompose.entity.AdjustDecomposeRecord;
import kd.epm.eb.common.decompose.entity.BgNumberCell;
import kd.epm.eb.common.decompose.entity.DecomposeSchemeStatus;
import kd.epm.eb.common.decompose.entity.DecomposeSchemeType;
import kd.epm.eb.common.enums.AdjustDecomposeTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.thread.EpmThreadPools;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.adjustdecompose.AdjustServiceHelper;
import org.apache.commons.collections.CollectionUtils;

public class DecomposeSchemeService {
    private static DecomposeSchemeService instance = new DecomposeSchemeService();
    private static final Log log = LogFactory.getLog(DataDecomposeService.class);
    private static final String FORM_SCHEME = "eb_decompose_scheme";
    private static final String FORM_TASK = "eb_decompose_task";

    public static DecomposeSchemeService getInstance() {
        return instance;
    }

    private DecomposeSchemeService() {
    }

    public DynamicObject[] adjustToDecomposeTask(IModelCacheHelper modelCacheContext, DynamicObjectCollection adjusts, DynamicObject scheme) {
        try {
            HashMap<String, DynamicObject> taskMap = new HashMap<String, DynamicObject>(16);
            ArrayList<Object[]> params = new ArrayList<Object[]>();
            for (DynamicObject adjust : adjusts) {
                String viewjson;
                String srcdimensionjson = adjust.getString("dimensionjson");
                Map srcdimensionMap = (Map)JSON.parseObject((String)srcdimensionjson, HashMap.class);
                List list = DecDimensionUtil.getDecDimensionListFromSrc((IModelCacheHelper)modelCacheContext, (String)(srcdimensionjson = AdjustServiceHelper.toJsonString((Map)srcdimensionMap)), (String)(viewjson = adjust.getString("viewjson")), (DynamicObject)scheme);
                if (list.size() <= 0) continue;
                BigDecimal value = adjust.getBigDecimal("adjusttrial");
                DynamicObject task = (DynamicObject)taskMap.get(srcdimensionjson + viewjson);
                if (task == null) {
                    task = BusinessDataServiceHelper.newDynamicObject((String)FORM_TASK);
                    Long taskId = GlobalIdUtil.genGlobalLongId();
                    task.set("id", (Object)taskId);
                    task.set("scheme", (Object)scheme);
                    task.set("entity", adjust.get("entity"));
                    task.set("value", (Object)value);
                    task.set("hashcode", (Object)srcdimensionMap.hashCode());
                    task.set("srcdimensionjson", (Object)srcdimensionjson);
                    task.set("decdimensionjson", (Object)JSON.toJSONString((Object)list));
                    task.set("viewjson", (Object)viewjson);
                    DynamicObjectUtil.init4Update((DynamicObject)task);
                    task.set("status", (Object)TaskStatus.WAIT.getValue());
                    taskMap.put(srcdimensionjson + viewjson, task);
                } else {
                    task.set("value", (Object)value.add(task.getBigDecimal("value")));
                }
                Object[] param = new Object[]{DecomposeStatus.START.getValue(), task.getLong("id"), adjust.getLong("fentryid")};
                params.add(param);
            }
            Long modelId = modelCacheContext.getModelobj().getId();
            ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(taskMap.size());
            for (DynamicObject task : taskMap.values()) {
                BigDecimal value = task.getBigDecimal("value");
                long taskId = task.getLong("id");
                String srcdimensionjson = task.getString("srcdimensionjson");
                Map memberMap = (Map)JSON.parseObject((String)srcdimensionjson, HashMap.class);
                String viewJson = task.getString("viewjson");
                Map viewMap = (Map)JSON.parseObject((String)viewJson, HashMap.class);
                Map dimViewMap = AdjustServiceHelper.getDimViewMap((Map)viewMap);
                if (BigDecimal.ZERO.compareTo(value) != 0) {
                    saveList.add(task);
                    continue;
                }
                for (Object[] param : params) {
                    if (!param[1].equals(taskId)) continue;
                    param[0] = DecomposeStatus.DONE.getValue();
                    CusMemberServiceHelper.deleteCosmicMember(modelId, memberMap, dimViewMap);
                }
            }
            this.updateAdjust(params);
            return saveList.toArray(new DynamicObject[0]);
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public void updateAdjust(List<Object[]> params) {
        String upDetailSql = "update t_eb_decomposeadjustsub set fstatus=?,fdecomposetask=? where fentryid=?";
        if (params.size() > 0) {
            DB.executeBatch((DBRoute)BgFormConstant.DBROUTE, (String)upDetailSql, params);
        }
    }

    public void saveTaskByScheme(DynamicObject scheme) {
        Long modelId = (Long)scheme.getDynamicObject("model").getPkValue();
        IModelCacheHelper modelCacheContext = ModelCacheContext.getOrCreate((Long)modelId);
        QFilter qFilter = new QFilter("scheme", "=", scheme.getPkValue());
        qFilter.and("status", "in", Arrays.asList(TaskStatus.WAIT.getValue(), TaskStatus.START.getValue()));
        DynamicObject[] tasks = BusinessDataServiceHelper.load((String)FORM_TASK, (String)"status,entity.level,decdimensionjson", (QFilter[])qFilter.toArray(), (String)"entity.level");
        DynamicObjectCollection adjusts = this.getFirstAdjusts(scheme, modelCacheContext);
        DynamicObject[] adjustTasks = this.adjustToDecomposeTask(modelCacheContext, adjusts, scheme);
        if (adjustTasks.length > 0) {
            SaveServiceHelper.save((DynamicObject[])adjustTasks);
        } else if (tasks.length < 1) {
            String message = ResManager.loadKDString((String)"\u65e0\u5f85\u5206\u89e3\u6570\u636e\u3002", (String)"DecomposeSchemePlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            OperationLogUtil.log((String)"bgmd", (String)FORM_SCHEME, null, (String)"execute_scheme", (MultiLangEnumBridge)new MultiLangEnumBridge("\u6267\u884c\u65b9\u6848", "DecomposeSchemeListPlugin_51", "epm-eb-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u7f16\u53f7\uff1a%1$s\uff0c\u6267\u884c\u65b9\u6848\u5931\u8d25\uff0c%2$s\u3002", "DecomposeSchemeListPlugin_58", "epm-eb-formplugin"), (String[])new String[]{scheme.getString("number"), message});
            throw new KDBizException(message);
        }
    }

    public DynamicObjectCollection getAdjusts(DynamicObject scheme, List<Long> entityIds) {
        Map viewsByBusModel;
        Long baseViewId;
        Long modelId = (Long)scheme.getDynamicObject("model").getPkValue();
        Long bizModelId = (Long)scheme.getDynamicObject("bizmodel").getPkValue();
        IModelCacheHelper modelCacheContext = ModelCacheContext.getOrCreate((Long)modelId);
        QFilter qFilter = this.getSchemeBaseQfilter(scheme);
        Long entityviewId = (Long)scheme.getDynamicObject("entityview").getPkValue();
        if (IDUtils.equals((Object)entityviewId, (Object)(baseViewId = (Long)(viewsByBusModel = modelCacheContext.getViewsByBusModel(bizModelId)).get(SysDimensionEnum.Entity.getNumber()))) || IDUtils.isNull((Long)baseViewId)) {
            QFilter qFilter1 = new QFilter("eb_decomposeadjustsub.entityview", "=", (Object)entityviewId).or(new QFilter("eb_decomposeadjustsub.entityview", "=", (Object)0));
            qFilter.and(qFilter1);
        } else {
            qFilter.and(new QFilter("eb_decomposeadjustsub.entityview", "=", (Object)entityviewId));
        }
        qFilter.and(new QFilter("eb_decomposeadjustsub.status", "=", (Object)DecomposeStatus.WAIT.getValue()));
        qFilter.and(new QFilter("eb_decomposeadjustsub.adjusttrial", "!=", (Object)"0"));
        qFilter.and(new QFilter("audittrail", "in", this.getAudittrailIdSet(scheme, modelCacheContext)));
        qFilter.and(new QFilter("budgetperiod", "in", this.getBudgetperiodIdSet(scheme, modelCacheContext)));
        qFilter.and(new QFilter("entity", "in", entityIds));
        String schemeType = scheme.getString("type");
        if (DecomposeSchemeType.ADJUST.getValue().equals(schemeType)) {
            qFilter.and(new QFilter("eb_decomposeadjustsub.type", "in", Arrays.asList(AdjustDecomposeTypeEnum.DECOMPOSE.getNumber(), AdjustDecomposeTypeEnum.ADJUST.getNumber())));
        } else {
            qFilter.and(new QFilter("eb_decomposeadjustsub.type", "=", (Object)AdjustDecomposeTypeEnum.TARGET_DECOMPOSE.getNumber()));
        }
        String selectProperties = "eb_decomposeadjustsub.id as fentryid,entity,entity.level,eb_decomposeadjustsub.entityview as entityview,account,budgetperiod,eb_decomposeadjustsub.adjusttrial as adjusttrial,eb_decomposeadjustsub.type as type,eb_decomposeadjustsub.status as status,eb_decomposeadjustsub.decomposetask as decomposetask,dimensionjson,eb_decomposeadjustsub.viewjson as viewjson";
        return QueryServiceHelper.query((String)"eb_decomposeadjust", (String)selectProperties, (QFilter[])qFilter.toArray());
    }

    private DynamicObjectCollection getFirstAdjusts(DynamicObject scheme, IModelCacheHelper modelCacheContext) {
        Long entityviewId = (Long)scheme.getDynamicObject("entityview").getPkValue();
        Member root = modelCacheContext.getRootMember(SysDimensionEnum.Entity.getNumber(), entityviewId);
        if (root == null) {
            return new DynamicObjectCollection();
        }
        List<Long> entityIds = root.getChildren().stream().map(BaseCache::getId).collect(Collectors.toList());
        return this.getAdjusts(scheme, modelCacheContext, entityIds);
    }

    public DynamicObjectCollection getAdjusts(DynamicObject scheme, IModelCacheHelper modelCacheContext, List<Long> entityIds) {
        if (entityIds.isEmpty()) {
            return new DynamicObjectCollection();
        }
        DynamicObjectCollection adjusts = this.getAdjusts(scheme, entityIds);
        if (adjusts.isEmpty()) {
            QFilter qFilter = new QFilter("scheme", "=", scheme.getPkValue());
            qFilter.and("status", "in", Arrays.asList(TaskStatus.WAIT.getValue(), TaskStatus.START.getValue()));
            qFilter.and(new QFilter("entity", "in", entityIds));
            if (!QueryServiceHelper.exists((String)FORM_TASK, (QFilter[])qFilter.toArray())) {
                return this.getChildAdjusts(scheme, modelCacheContext, entityIds);
            }
        }
        return adjusts;
    }

    private DynamicObjectCollection getChildAdjusts(DynamicObject scheme, IModelCacheHelper modelCacheContext, List<Long> entityIds) {
        ArrayList<Long> ids = new ArrayList<Long>(10);
        Long bizModelId = (Long)scheme.getDynamicObject("bizmodel").getPkValue();
        Long entityviewId = (Long)scheme.getDynamicObject("entityview").getPkValue();
        String dimNumber = SysDimensionEnum.Entity.getNumber();
        for (Long entityId : entityIds) {
            Member entityMember = modelCacheContext.getMember(dimNumber, entityviewId, entityId);
            if (entityMember == null) continue;
            List members = entityMember.getChildren();
            ids.addAll(members.stream().map(BaseCache::getId).collect(Collectors.toList()));
        }
        return this.getAdjusts(scheme, modelCacheContext, ids);
    }

    public DynamicObject loadScheme(Long schemeId) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)schemeId, (String)FORM_SCHEME);
    }

    public Set<Long> getBudgetperiodIdSet(DynamicObject scheme, IModelCacheHelper modelCacheContext) {
        String budgetperiod = scheme.getString("budgetperiod");
        String[] budgetperiods = budgetperiod.split(",");
        HashSet<Long> budgetperiodIdSet = new HashSet<Long>();
        for (String memberId : budgetperiods) {
            Member budgetperiodMember = modelCacheContext.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, Long.valueOf(Long.parseLong(memberId)));
            List budgetperiodMemberList = modelCacheContext.getChildren(budgetperiodMember, true);
            for (Member member : budgetperiodMemberList) {
                budgetperiodIdSet.add(member.getId());
            }
        }
        return budgetperiodIdSet;
    }

    public QFilter getSchemeBaseQfilter(DynamicObject scheme) {
        Long modelId = (Long)scheme.getDynamicObject("model").getPkValue();
        Long bizModelId = (Long)scheme.getDynamicObject("bizmodel").getPkValue();
        Long datatypeId = (Long)scheme.getDynamicObject("datatype").getPkValue();
        Long versionId = (Long)scheme.getDynamicObject("version").getPkValue();
        Long currency = (Long)scheme.getDynamicObject("currency").getPkValue();
        return QFilter.of((String)"model=? and bizmodel=? and datatype=? and version=? and currency=?", (Object[])new Object[]{modelId, bizModelId, datatypeId, versionId, currency});
    }

    public Set<Long> getAudittrailIdSet(DynamicObject scheme, IModelCacheHelper modelCacheContext) {
        Long audittrailId = (Long)scheme.getDynamicObject("audittrail").getPkValue();
        Member audittrailMember = modelCacheContext.getMember(SysDimensionEnum.AuditTrail.getNumber(), null, audittrailId);
        List audittrailMemberList = modelCacheContext.getChildren(audittrailMember, true);
        HashSet<Long> audittrailIdSet = new HashSet<Long>(16);
        for (Member member : audittrailMemberList) {
            audittrailIdSet.add(member.getId());
        }
        return audittrailIdSet;
    }

    public Object getAudittrailTotalIdSet(DynamicObject scheme, IModelCacheHelper modelCacheContext) {
        Long audittrailId = (Long)scheme.getDynamicObject("audittrail").getPkValue();
        Member audittrailMember = modelCacheContext.getMember(SysDimensionEnum.AuditTrail.getNumber(), null, audittrailId);
        List audittrailMemberList = modelCacheContext.getChildren(audittrailMember, true);
        List parents = modelCacheContext.getParents(null, audittrailMember, true);
        HashSet<Long> audittrailIdSet = new HashSet<Long>(16);
        for (Member member : audittrailMemberList) {
            audittrailIdSet.add(member.getId());
        }
        for (Member parent : parents) {
            audittrailIdSet.add(parent.getId());
        }
        return audittrailIdSet;
    }

    public void validHasStartingScheme(DynamicObject scheme) {
        Long modelId = (Long)scheme.getDynamicObject("model").getPkValue();
        IModelCacheHelper modelCacheContext = ModelCacheContext.getOrCreate((Long)modelId);
        Set<Long> set = this.getBudgetperiodTotalIdSet(scheme, modelCacheContext);
        QFilter qFilter = this.getSchemeBaseQfilter(scheme);
        qFilter.and(new QFilter("status", "=", (Object)DecomposeSchemeStatus.START.getNumber()));
        qFilter.and(new QFilter("type", "=", (Object)scheme.getString("type")));
        QFilter audittrail = new QFilter("audittrail", "in", this.getAudittrailTotalIdSet(scheme, modelCacheContext));
        DynamicObjectCollection existSchemes = QueryServiceHelper.query((String)FORM_SCHEME, (String)"id,number,budgetperiod", (QFilter[])new QFilter[]{qFilter, audittrail});
        if (!CollectionUtils.isEmpty((Collection)existSchemes)) {
            for (DynamicObject existScheme : existSchemes) {
                Set<Long> budgetIds = this.getBudgetperiodIdSet(existScheme, modelCacheContext);
                if (Collections.disjoint(set, budgetIds)) continue;
                throw new KDBizException(ResManager.loadResFormat((String)"\u6267\u884c\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u5b58\u5728\u540c\u4e00\u4e1a\u52a1\u6a21\u578b\u7684\u6570\u636e\u7ef4\u5ea6\u8303\u56f4\u6709\u4ea4\u96c6\u7684\u5206\u89e3\u65b9\u6848\uff08%1\uff09\u6b63\u5728\u5206\u89e3\u4e2d\u3002", (String)"DecomposeSchemePlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[]{existScheme.getString("number")}));
            }
        }
    }

    private Set<Long> getBudgetperiodTotalIdSet(DynamicObject scheme, IModelCacheHelper modelCacheContext) {
        String budgetperiod = scheme.getString("budgetperiod");
        String[] split = budgetperiod.split(",");
        HashSet<Long> budgetIds = new HashSet<Long>(16);
        for (String s : split) {
            Member member = modelCacheContext.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, Long.valueOf(s));
            List parents = modelCacheContext.getParents(null, member, true);
            List children = modelCacheContext.getChildren(member, true);
            budgetIds.addAll(parents.stream().map(BaseCache::getId).collect(Collectors.toList()));
            budgetIds.addAll(children.stream().map(BaseCache::getId).collect(Collectors.toList()));
        }
        return budgetIds;
    }

    public List<DynamicObject> getIssueAdjusts(DynamicObject scheme, boolean needQueryNoNeedDecompose) {
        Long modelId = (Long)scheme.getDynamicObject("model").getPkValue();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        QFilter qFilter = this.getSchemeBaseQfilter(scheme);
        Long entityviewId = (Long)scheme.getDynamicObject("entityview").getPkValue();
        qFilter.and(new QFilter("eb_decomposeadjustsub.entityview", "=", (Object)entityviewId));
        qFilter.and(new QFilter("audittrail", "in", this.getAudittrailIdSet(scheme, modelCacheHelper)));
        qFilter.and(new QFilter("budgetperiod", "in", this.getBudgetperiodIdSet(scheme, modelCacheHelper)));
        ArrayList<Integer> statusValue = new ArrayList<Integer>(10);
        statusValue.add(DecomposeStatus.WAIT.getValue());
        statusValue.add(DecomposeStatus.START.getValue());
        if (needQueryNoNeedDecompose) {
            statusValue.add(DecomposeStatus.NOT_NEED_DECOMPOSE.getValue());
        }
        qFilter.and(new QFilter("eb_decomposeadjustsub.status", "in", statusValue));
        qFilter.and(new QFilter("eb_decomposeadjustsub.type", "in", Arrays.asList(AdjustDecomposeTypeEnum.DECOMPOSE.getNumber(), AdjustDecomposeTypeEnum.ADJUST.getNumber())));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"eb_decomposeadjust", (String)"id,model,bizmodel,dataset,dimensionjson ,hashcode,eb_decomposeadjustsub.viewjson as viewjson,eb_decomposeadjustsub.entityview as entityview, eb_decomposeadjustsub.id as entryid,eb_decomposeadjustsub.pendingtrial as pendingtrial,eb_decomposeadjustsub.adjusttrial as adjusttrial,eb_decomposeadjustsub.fixtrial as fixtrial,eb_decomposeadjustsub.status as status,eb_decomposeadjustsub.adjustexplain as adjustexplain,eb_decomposeadjustsub.attachmentfield as attachmentfield,eb_decomposeadjustsub.modifyoperator as modifyoperator,eb_decomposeadjustsub.modifytime as modifytime,eb_decomposeadjustsub.type as type", (QFilter[])qFilter.toArray());
        return dynamicObjects.stream().filter(e -> {
            Member member;
            String srcdimensionjson = e.getString("dimensionjson");
            Map srcdimensionMap = (Map)JSON.parseObject((String)srcdimensionjson, HashMap.class);
            int status = e.getInt("status");
            return status != DecomposeStatus.NOT_NEED_DECOMPOSE.getValue() || (member = modelCacheHelper.getMember(SysDimensionEnum.Metric.getNumber(), null, (String)srcdimensionMap.get(SysDimensionEnum.Metric.getNumber()))) != null && member.hasAgg() && AdjustServiceHelper.isNumberMetric((String)member.getDatatype());
        }).collect(Collectors.toList());
    }

    public boolean buildChildAdjust(DynamicObject releaseScheme, List<DynamicObject> decomposeAdjusts, Map<Long, DynamicObject> allDataMapping, Map<Long, DynamicObject> memberMapping, DynamicObject scheme) {
        DynamicObjectCollection targetmodelentity = releaseScheme.getDynamicObjectCollection("targetmodelentity");
        if (CollectionUtils.isEmpty((Collection)targetmodelentity)) {
            return false;
        }
        HashMap<Long, List> dataCell = new HashMap<Long, List>(16);
        DynamicObject mainLog = BusinessDataServiceHelper.newDynamicObject((String)"eb_datarelease_log");
        long mainLogId = GlobalIdUtil.genGlobalLongId();
        mainLog.set("id", (Object)mainLogId);
        DynamicObjectCollection entryentity = mainLog.getDynamicObjectCollection("entryentity");
        boolean allSuccess = true;
        Map<String, Set<Long>> detailLogMap = DataReleaseUtils.getReleaseDetailLog(releaseScheme.getLong("id"), decomposeAdjusts, "1");
        ArrayList<DynamicObject> detailObj = new ArrayList<DynamicObject>(10);
        HashSet<String> hasSendMsg = new HashSet<String>(16);
        HashMap<String, Map<String, Long>> cellViewMap = new HashMap<String, Map<String, Long>>(16);
        for (DynamicObject dynamicObject : targetmodelentity) {
            int sourceCount = 0;
            int failedCount = 0;
            int successCount = 0;
            DynamicObject mainLogInfo = entryentity.addNew();
            long tarModel = dynamicObject.getLong("tarmodel.id");
            long tarBizModel = dynamicObject.getLong("tarbizmodel.id");
            mainLogInfo.set("tarmodel", (Object)tarModel);
            mainLogInfo.set("tarbizmodel", (Object)tarBizModel);
            Set<Long> longs = detailLogMap.get(tarModel + "_" + tarBizModel);
            for (DynamicObject decomposeAdjust : decomposeAdjusts) {
                long adjustDecomposeId = decomposeAdjust.getLong("id");
                if (CollectionUtils.isNotEmpty(longs) && longs.contains(adjustDecomposeId)) {
                    entryentity.remove((Object)mainLogInfo);
                    continue;
                }
                long srcModelId = decomposeAdjust.getLong("model");
                IModelCacheHelper srcModelCache = ModelCacheContext.getOrCreate((Long)srcModelId);
                String dimensionJson = decomposeAdjust.getString("dimensionjson");
                Map srcDimensionMap = (Map)JSON.parseObject((String)dimensionJson, HashMap.class);
                boolean needSendMsg = true;
                String msgreceivers = dynamicObject.getString("msgreceivers");
                DynamicObject detailLog = null;
                AdjustDecomposeRecord record = DataReleaseUtils.buildAdjustDecomposeRecord(srcModelCache, allDataMapping, memberMapping, srcDimensionMap, dynamicObject, decomposeAdjust);
                if (record != null && IDUtils.isNotNull((Long)record.getModelId())) {
                    AdjustServiceHelper.saveAdjustDecomposeRecord((List)Lists.newArrayList((Object[])new AdjustDecomposeRecord[]{record}));
                    List bgNumberCells = dataCell.computeIfAbsent(record.getModelId(), v -> new ArrayList(10));
                    BigDecimal value = BigDecimal.ZERO;
                    List details = record.getDetails();
                    if (CollectionUtils.isNotEmpty((Collection)details)) {
                        AdjustDecomposeDetail adjustDecomposeDetail = (AdjustDecomposeDetail)details.get(0);
                        cellViewMap.put(record.getMemberMap().toString(), AdjustServiceHelper.getDimViewMap((Map)adjustDecomposeDetail.getViewMap()));
                        Object adjustTrial = adjustDecomposeDetail.getAdjustTrial();
                        if (adjustTrial instanceof BigDecimal) {
                            value = value.add((BigDecimal)adjustTrial);
                        }
                    }
                    detailLog = BusinessDataServiceHelper.newDynamicObject((String)"eb_datarelease_detail_log");
                    detailLog.set("datareleaselog", (Object)mainLogId);
                    detailLog.set("tarmodel", (Object)tarModel);
                    detailLog.set("tarbizmodel", (Object)tarBizModel);
                    detailLog.set("adjusttrial", (Object)value);
                    detailLog.set("adjustdecompose", (Object)adjustDecomposeId);
                    detailLog.set("status", (Object)"1");
                    detailLog.set("metric", (Object)srcModelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, (String)srcDimensionMap.get(SysDimensionEnum.Metric.getNumber())).getId());
                    BgNumberCell bgNumberCell = new BgNumberCell(record.getDataSetId(), record.getMemberMap(), value);
                    bgNumberCells.add(bgNumberCell);
                    dataCell.put(record.getModelId(), bgNumberCells);
                    ++sourceCount;
                    ++successCount;
                } else if (record == null) {
                    ++sourceCount;
                    ++failedCount;
                    allSuccess = false;
                    needSendMsg = false;
                    detailLog = BusinessDataServiceHelper.newDynamicObject((String)"eb_datarelease_detail_log");
                    detailLog.set("datareleaselog", (Object)mainLogId);
                    detailLog.set("tarmodel", (Object)tarModel);
                    detailLog.set("tarbizmodel", (Object)tarBizModel);
                    detailLog.set("adjusttrial", (Object)decomposeAdjust.getBigDecimal("adjusttrial"));
                    detailLog.set("adjustdecompose", (Object)adjustDecomposeId);
                    detailLog.set("status", (Object)"2");
                    detailLog.set("metric", (Object)srcModelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, (String)srcDimensionMap.get(SysDimensionEnum.Metric.getNumber())).getId());
                }
                if (detailLog != null) {
                    detailObj.add(detailLog);
                }
                if (!needSendMsg || !hasSendMsg.add(srcModelId + "_" + tarModel)) continue;
                EpmThreadPools.CommPools.execute(() -> DataReleaseUtils.sendMessage(msgreceivers, releaseScheme.getString("srcmodel.name"), dynamicObject.getString("tarmodel.name")));
            }
            mainLogInfo.set("sourcecount", (Object)sourceCount);
            mainLogInfo.set("successcount", (Object)successCount);
            mainLogInfo.set("failedcount", (Object)failedCount);
        }
        for (Map.Entry entry : dataCell.entrySet()) {
            List value = (List)entry.getValue();
            Long key = (Long)entry.getKey();
            DataDecomposeService.getInstance().adjustToOlap(key, value, cellViewMap);
        }
        if (allSuccess) {
            mainLog.set("status", (Object)"1");
        } else {
            mainLog.set("status", (Object)"2");
        }
        mainLog.set("decomposescheme", (Object)scheme.getLong("id"));
        mainLog.set("releasescheme", (Object)releaseScheme.getLong("id"));
        mainLog.set("creater", (Object)UserUtils.getUserId());
        if (CollectionUtils.isNotEmpty((Collection)entryentity)) {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mainLog});
        }
        SaveServiceHelper.save((DynamicObject[])detailObj.toArray(new DynamicObject[0]));
        return allSuccess;
    }
}

