/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.decompose.service;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.EntryGrid;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.decompose.service.DataDecomposeService;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.decompose.DecDimensionUtil;
import kd.epm.eb.common.decompose.TaskStatus;
import kd.epm.eb.common.decompose.entity.DecDimension;
import kd.epm.eb.common.decompose.entity.DecomposeSchemeStatus;
import kd.epm.eb.common.decompose.entity.DecomposeSchemeType;
import kd.epm.eb.common.enums.AggOprtEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.adjustdecompose.AdjustServiceHelper;
import kd.epm.eb.common.utils.fileImport.FileImportUtils;
import kd.epm.eb.common.utils.fileImport.entity.Header;
import kd.epm.eb.common.utils.fileImport.entity.ImportEntity;
import kd.epm.eb.olap.api.metadata.IKDCell;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class DecomposeTaskService {
    private static DecomposeTaskService instance = new DecomposeTaskService();
    private static final String SPLIT = ".";
    private DataDecomposeService dataDecomposeService = DataDecomposeService.getInstance();

    public static DecomposeTaskService getInstance() {
        return instance;
    }

    private DecomposeTaskService() {
    }

    public DynamicObject queryTaskById(long taskId) {
        QFilter qFilter = new QFilter("id", "=", (Object)taskId);
        String selectProperties = "id,status,modifier,creater,modifydate,createdate,srcdimensionjson,decdimensionjson,value,entity.name, adjust,viewjson";
        return BusinessDataServiceHelper.loadSingle((String)"eb_decompose_task", (String)selectProperties, (QFilter[])qFilter.toArray());
    }

    public DynamicObject[] queryTaskByIds(List<Long> taskIds) {
        QFilter qFilter = new QFilter("id", "in", taskIds);
        String selectProperties = "id,status,modifier,creater,modifydate,createdate,srcdimensionjson,decdimensionjson,value,entity.name, adjust";
        return BusinessDataServiceHelper.load((String)"eb_decompose_task", (String)selectProperties, (QFilter[])qFilter.toArray());
    }

    public DynamicObjectCollection queryDecLogsByPid(long pid) {
        QFilter qFilter = new QFilter("pid", "=", (Object)pid);
        String selectProperties = "id,task,pid,parent,value,srcdimensionjson,status,issueflag,dimension,pendingtrial,change";
        return QueryServiceHelper.query((String)"eb_decompose_log", (String)selectProperties, (QFilter[])qFilter.toArray());
    }

    public DynamicObjectCollection queryDecLogsByPids(Set<Long> pids) {
        if (pids.isEmpty()) {
            return new DynamicObjectCollection();
        }
        QFilter qFilter = new QFilter("pid", "in", pids);
        String selectProperties = "id,task,pid";
        return QueryServiceHelper.query((String)"eb_decompose_log", (String)selectProperties, (QFilter[])qFilter.toArray());
    }

    public DynamicObject[] queryDecLogsByParent(long parent) {
        QFilter qFilter = new QFilter("parent", "=", (Object)parent);
        String selectProperties = "id,task,pid,parent,value,srcdimensionjson,decdimensionjson,status,issueflag,dimension,pendingtrial,change";
        return BusinessDataServiceHelper.load((String)"eb_decompose_log", (String)selectProperties, (QFilter[])qFilter.toArray());
    }

    public DynamicObject[] queryDecLogsByIds(Set<Long> idList) {
        QFilter qFilter = new QFilter("id", "in", idList);
        String selectProperties = "id,task,pid,parent,value,srcdimensionjson,decdimensionjson, status, issueflag,dimension,pendingtrial,change";
        return BusinessDataServiceHelper.load((String)"eb_decompose_log", (String)selectProperties, (QFilter[])qFilter.toArray());
    }

    public DynamicObject[] queryDecLogsByTaskAndDim(long taskId, DecDimension previousDecDimen) {
        String previousDimNumber = "0";
        if (previousDecDimen != null) {
            previousDimNumber = previousDecDimen.getDimNumber();
        }
        QFilter qFilter = new QFilter("dimension", "=", (Object)previousDimNumber);
        qFilter.and(new QFilter("task", "=", (Object)taskId));
        qFilter.and(new QFilter("value", "!=", (Object)BigDecimal.ZERO));
        qFilter.and(new QFilter("issueflag", "=", (Object)"1"));
        String selectProperties = "id,task,pid,parent,value,target,srcdimensionjson,status,dimension,pendingtrial,change";
        return BusinessDataServiceHelper.load((String)"eb_decompose_log", (String)selectProperties, (QFilter[])qFilter.toArray());
    }

    public DynamicObject[] queryTaskBySchemeId(long schemeId) {
        QFilter qFilter = new QFilter("scheme", "=", (Object)schemeId);
        return BusinessDataServiceHelper.load((String)"eb_decompose_task", (String)"id,status,modifier,modifydate", (QFilter[])qFilter.toArray());
    }

    public boolean existsTaskByStatus(long schemeId, List<Integer> statusList) {
        QFilter qFilter = new QFilter("scheme", "=", (Object)schemeId);
        qFilter.and(new QFilter("status", "in", statusList));
        return QueryServiceHelper.exists((String)"eb_decompose_task", (QFilter[])qFilter.toArray());
    }

    public void updateSchemeStatus(long schemeId, DecomposeSchemeStatus effStatus) {
        QFilter qFilter = new QFilter("id", "=", (Object)schemeId);
        DynamicObject scheme = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_decompose_scheme", (String)"id,status", (QFilter[])qFilter.toArray());
        if (scheme != null) {
            scheme.set("status", (Object)effStatus.getNumber());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{scheme});
        }
    }

    public BigDecimal getValueFromOlap(Map<String, String> memberMap, IModelCacheHelper modelCacheContext, Map<String, Long> dimViewMap) {
        try {
            IKDCell ikdCell = this.dataDecomposeService.queryCell(DecDimensionUtil.getDatasetId((IModelCacheHelper)modelCacheContext, memberMap), memberMap, modelCacheContext, dimViewMap);
            if (ikdCell != null) {
                return ikdCell.getValue().getDecimal();
            }
            return BigDecimal.ZERO;
        }
        catch (KDBizException e) {
            return BigDecimal.ZERO;
        }
    }

    public Map<String, String> stringtoMap(String str) {
        return (Map)JSON.parseObject((String)str, HashMap.class);
    }

    public String getDimNameByDimNumber(IModelCacheHelper modelCacheContext, String dimNumber) {
        Dimension dimension = modelCacheContext.getDimension(dimNumber);
        return dimension == null ? "" : dimension.getName();
    }

    public String getMemberName(Member member) {
        return member == null ? "" : member.getName();
    }

    private long getMemberId(Member member) {
        return member == null ? 0L : member.getId();
    }

    public String getMemberNameFromJson(IModelCacheHelper modelCacheContext, Map<String, String> srcdimensionMap, String dimenNumber) {
        Member member = this.getMemberFromJson(modelCacheContext, srcdimensionMap, dimenNumber, 0L);
        return this.getMemberName(member);
    }

    public Long getMemberIdFromJson(IModelCacheHelper modelCacheContext, Map<String, String> srcdimensionMap, String dimenNumber) {
        Member member = this.getMemberFromJson(modelCacheContext, srcdimensionMap, dimenNumber, 0L);
        return this.getMemberId(member);
    }

    public Member getMemberFromJson(IModelCacheHelper modelCacheContext, Map<String, String> srcdimensionMap, String dimenNumber, Long viewId) {
        String memberNumber = srcdimensionMap.get(dimenNumber);
        return modelCacheContext.getMember(dimenNumber, viewId, memberNumber);
    }

    public String getDecdimensionStr(IModelCacheHelper modelCacheContext, List<DecDimension> decDimensions) {
        StringBuilder decdimensionStr = new StringBuilder();
        for (int i = 0; i < decDimensions.size(); ++i) {
            DecDimension decDimension = decDimensions.get(i);
            String dimNumber = decDimension.getDimNumber();
            String dimName = this.getDimNameByDimNumber(modelCacheContext, dimNumber);
            decdimensionStr.append(dimName);
            if (i == decDimensions.size() - 1) continue;
            decdimensionStr.append("\uff0c");
        }
        return decdimensionStr.toString();
    }

    public String getAggType(String srcdimensionjson, String dimNumber, IModelCacheHelper modelCacheContext, Long dimViewId) {
        Map<String, String> memberMap = this.stringtoMap(srcdimensionjson);
        String memberNumber = memberMap.get(dimNumber);
        Member member = modelCacheContext.getMember(dimNumber, dimViewId, memberNumber);
        return member.getAggType();
    }

    private String selectColor(String statusStr) {
        String color = TaskStatus.WAIT.getText().equals(statusStr) ? "#666666" : (TaskStatus.START.getText().equals(statusStr) ? "#55A0F5" : (TaskStatus.DONE.getText().equals(statusStr) ? "#26B175" : "#666666"));
        return color;
    }

    public void setEntryGridColor(DynamicObjectCollection dynamicObjects, EntryGrid entryGrid, String fieldKey) {
        ArrayList<kd.bos.entity.report.CellStyle> cellStyles = new ArrayList<kd.bos.entity.report.CellStyle>(dynamicObjects.size());
        for (int i = 0; i < dynamicObjects.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(i);
            kd.bos.entity.report.CellStyle cellStyle = new kd.bos.entity.report.CellStyle();
            String status = dynamicObject.getString(fieldKey);
            String color = this.selectColor(status);
            cellStyle.setForeColor(color);
            cellStyle.setRow(i);
            cellStyle.setFieldKey(fieldKey);
            cellStyles.add(cellStyle);
        }
        entryGrid.setCellStyle(cellStyles);
    }

    public boolean metricIsCurrencyOrUnCurrencyAndHasAgg(Member metricMember) {
        return AdjustServiceHelper.ALLOW_ADJUST_METRIC_TYPE.contains(metricMember.getDatatype()) && metricMember.hasAgg();
    }

    public Map<String, String> getLastMember(Map<String, String> lastMemberMap) {
        if (!CollectionUtils.isEmpty(lastMemberMap)) {
            HashMap<String, String> hashMap = new HashMap<String, String>(lastMemberMap);
            String budgetPeriod = (String)hashMap.get(SysDimensionEnum.BudgetPeriod.getNumber());
            if (StringUtils.isNotEmpty((String)budgetPeriod)) {
                String lastBudgetPeriod = this.getLastBudgetPeriod(budgetPeriod);
                hashMap.put(SysDimensionEnum.BudgetPeriod.getNumber(), lastBudgetPeriod);
            }
            hashMap.put(SysDimensionEnum.DataType.getNumber(), "Actual");
            hashMap.put(SysDimensionEnum.Version.getNumber(), "ACTUAL");
            hashMap.put(SysDimensionEnum.ChangeType.getNumber(), "EBChanges");
            return hashMap;
        }
        return new HashMap<String, String>(16);
    }

    public String getLastBudgetPeriod(String budgetPeriod) {
        String[] split = budgetPeriod.split("FY");
        StringBuilder lastBudgetPeriod = new StringBuilder("FY");
        String fy = split[1];
        if (fy.contains(SPLIT)) {
            String[] split1 = fy.split("\\.");
            String yearStr = split1[0];
            int year = Integer.parseInt(yearStr);
            lastBudgetPeriod.append(--year).append(SPLIT).append(split1[1]);
        } else {
            int year = Integer.parseInt(fy);
            lastBudgetPeriod.append(--year);
        }
        return lastBudgetPeriod.toString();
    }

    public BigDecimal getNewAmountByAggoprt(String tabAggoprt, BigDecimal newData, BigDecimal value) {
        if (StringUtils.isEmpty((String)tabAggoprt)) {
            return newData;
        }
        BigDecimal bigDecimal = BigDecimal.ZERO;
        Optional<AggOprtEnum> aggOprtEnumOptional = Arrays.stream(AggOprtEnum.values()).filter(aggOprtEnum -> aggOprtEnum.getSign().equals(tabAggoprt)).findFirst();
        if (aggOprtEnumOptional.isPresent()) {
            AggOprtEnum aggOprtEnum2 = aggOprtEnumOptional.get();
            switch (aggOprtEnum2) {
                case ADD: {
                    bigDecimal = newData.add(value);
                    break;
                }
                case SUBSTRACT: {
                    bigDecimal = newData.subtract(value);
                    break;
                }
                case MULTI: {
                    bigDecimal = newData.multiply(value);
                    break;
                }
                case DIVIDE: {
                    bigDecimal = newData.divide(value, 6, RoundingMode.HALF_UP);
                    break;
                }
                case SKIP: {
                    bigDecimal = newData;
                    break;
                }
            }
        }
        return bigDecimal;
    }

    public ImportEntity prepareTemplateData(IModelCacheHelper modelCache, String schemeType, List<DecDimension> dimensionList, String dimNumber, String agent) {
        ImportEntity importData = new ImportEntity();
        importData.setSheetName("sheet0");
        LinkedHashMap<String, Header> headerMap = new LinkedHashMap<String, Header>(16);
        String noEditTip = ResManager.loadKDString((String)"\u52ff\u6539", (String)"DecomposeTaskPlugin_38", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        String nokyNumberTip = ResManager.loadKDString((String)"\u53ea\u80fd\u586b\u6570\u5b57", (String)"DecomposeTaskPlugin_48", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        headerMap.put("grandParentNumber", new Header(ResManager.loadKDString((String)"\u4e0a\u4e0a\u7ea7\u5185\u7801", (String)"DecomposeTaskPlugin_39", (String)"epm-eb-formplugin", (Object[])new Object[0]), noEditTip));
        headerMap.put("parentNumber", new Header(ResManager.loadKDString((String)"\u4e0a\u7ea7\u5185\u7801", (String)"DecomposeTaskPlugin_40", (String)"epm-eb-formplugin", (Object[])new Object[0]), noEditTip));
        headerMap.put("number", new Header(ResManager.loadKDString((String)"\u5185\u7801", (String)"DecomposeTaskPlugin_41", (String)"epm-eb-formplugin", (Object[])new Object[0]), noEditTip));
        for (DecDimension decDimension : dimensionList) {
            if (!StringUtils.equals((String)decDimension.getDimNumber(), (String)dimNumber)) continue;
            String name = modelCache.getDimension(dimNumber).getName();
            importData.setSheetTitle(ResManager.loadResFormat((String)"\u5206\u89e3\u7ef4\u5ea6\uff1a%1", (String)"DecomposeTaskPlugin_37", (String)"epm-eb-formplugin", (Object[])new Object[]{name}));
            headerMap.put(dimNumber, new Header(name, noEditTip));
            break;
        }
        for (DecDimension decDimension : dimensionList) {
            if (StringUtils.equals((String)decDimension.getDimNumber(), (String)dimNumber)) continue;
            headerMap.put(decDimension.getDimNumber(), new Header(modelCache.getDimension(decDimension.getDimNumber()).getName(), noEditTip));
        }
        if (DecomposeSchemeType.ADJUST.getValue().equals(schemeType)) {
            headerMap.put("pendingtrial", new Header(ResManager.loadKDString((String)"\u5206\u89e3\u524d\u503c", (String)"DecomposeTaskPlugin_42", (String)"epm-eb-formplugin", (Object[])new Object[0]), noEditTip));
            headerMap.put("value", new Header(ResManager.loadKDString((String)"\u5206\u89e3\u76ee\u6807\u503c", (String)"DecomposeTaskPlugin_43", (String)"epm-eb-formplugin", (Object[])new Object[0]), noEditTip));
            headerMap.put("change", new Header(ResManager.loadKDString((String)"\u5206\u89e3\u503c", (String)"DecomposeTaskPlugin_31", (String)"epm-eb-formplugin", (Object[])new Object[0]), nokyNumberTip));
            headerMap.put("result", new Header(ResManager.loadKDString((String)"\u5206\u89e3\u7ed3\u679c\u503c", (String)"DecomposeTaskPlugin_44", (String)"epm-eb-formplugin", (Object[])new Object[0]), nokyNumberTip));
        } else if (DecomposeSchemeType.TARGET.getValue().equals(schemeType)) {
            headerMap.put("value", new Header(ResManager.loadKDString((String)"\u5206\u89e3\u76ee\u6807\u503c", (String)"DecomposeTaskPlugin_43", (String)"epm-eb-formplugin", (Object[])new Object[0]), noEditTip));
            headerMap.put("change", new Header(ResManager.loadKDString((String)"\u5206\u89e3\u503c", (String)"DecomposeTaskPlugin_31", (String)"epm-eb-formplugin", (Object[])new Object[0]), nokyNumberTip));
            headerMap.put("ratio", new Header(ResManager.loadKDString((String)"\u5206\u89e3\u6bd4\u4f8b", (String)"DecomposeTaskPlugin_46", (String)"epm-eb-formplugin", (Object[])new Object[0]), nokyNumberTip));
        }
        headerMap.put("pid", new Header("pid", ""));
        headerMap.put("id", new Header("id", ""));
        importData.setSheetHeaderMap(headerMap);
        importData.setSheetNotes(ResManager.loadKDString((String)"\u8bf7\u5c06\u9f20\u6807\u79fb\u5230\u6807\u9898\u884c\uff0c\u67e5\u770b\u5b57\u6bb5\u8981\u6c42\u3002", (String)"DecomposeTaskPlugin_47", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        return importData;
    }

    public String exportData(ImportEntity importEntity, List<Map<String, Object>> dataList) {
        Map sheetHeaderMap = importEntity.getSheetHeaderMap();
        FileImportUtils fileImportUtils = FileImportUtils.getInstance((ImportEntity)importEntity);
        Workbook xssfWorkbook = fileImportUtils.createImportTemplate();
        Sheet sheet = xssfWorkbook.getSheetAt(0);
        sheet.protectSheet("decompose");
        int rowNum = 3;
        for (Map<String, Object> data : dataList) {
            Row row = fileImportUtils.getRow(sheet, rowNum++);
            int columnIndex = 0;
            for (Map.Entry headerEntry : sheetHeaderMap.entrySet()) {
                Object value;
                Cell cell = fileImportUtils.getCell(row, columnIndex++);
                if (((String)headerEntry.getKey()).equals("change") || ((String)headerEntry.getKey()).equals("ratio") || ((String)headerEntry.getKey()).equals("result")) {
                    CellStyle style = xssfWorkbook.createCellStyle();
                    style.setLocked(false);
                    cell.setCellStyle(style);
                }
                if ((value = data.get(headerEntry.getKey())) == null) continue;
                fileImportUtils.setCellObjValue(cell, value);
            }
        }
        sheet.setColumnHidden(sheetHeaderMap.size() - 2, true);
        sheet.setColumnHidden(sheetHeaderMap.size() - 1, true);
        return fileImportUtils.saveFileAsUrl(xssfWorkbook, ResManager.loadKDString((String)"\u76ee\u6807\u5206\u89e3", (String)"DecomposeTaskPlugin_52", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }
}

