/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.easupgrade;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.easupgrade.EASBudgetUpgradeImpl;
import kd.epm.eb.business.easupgrade.enums.Status;
import kd.epm.eb.business.easupgrade.enums.UpgradeStatus;
import kd.epm.eb.business.easupgrade.face.IEASSchema;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeContext;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeParam;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeResult;
import kd.epm.eb.business.easupgrade.face.IRunData;
import kd.epm.eb.business.easupgrade.impl.EASUpgradeResult;
import kd.epm.eb.business.easupgrade.impl.context.EASUpgradeContext;
import kd.epm.eb.business.easupgrade.impl.dao.EASDim;
import kd.epm.eb.business.easupgrade.impl.dao.EASMember;
import kd.epm.eb.business.easupgrade.impl.dao.EasDimUpgradeLog;
import kd.epm.eb.business.easupgrade.impl.dao.EasMemberUpgradeLog;
import kd.epm.eb.business.easupgrade.impl.dao.EasUpgradeLog;
import kd.epm.eb.business.easupgrade.impl.dao.NewMember;
import kd.epm.eb.business.easupgrade.impl.upgrade.EasUpgradeLogService;
import kd.epm.eb.business.easupgrade.impl.upgrade.EasUpgradeService;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEASBudgetUpgradeImpl {
    public static final Log log = LogFactory.getLog(EASBudgetUpgradeImpl.class);
    private IEASUpgradeParam param;
    private final List<IEASUpgradeResult> results = Collections.synchronizedList(new ArrayList());
    private IEASUpgradeContext context = null;

    protected AbstractEASBudgetUpgradeImpl() {
    }

    protected void setParam(IEASUpgradeParam param) {
        this.param = param;
    }

    protected IEASUpgradeParam getParam() {
        return this.param;
    }

    protected List<IEASUpgradeResult> getResults() {
        return this.results;
    }

    protected IEASUpgradeContext getContext() {
        if (this.context == null) {
            this.context = this.fromParam(this.getParam());
        }
        return this.context;
    }

    protected IEASUpgradeContext fromParam(@NotNull IEASUpgradeParam param) {
        return EASUpgradeContext.of(param);
    }

    protected boolean checkUpgradeParam(@NotNull IEASUpgradeParam param) {
        this.setParam(param);
        if (this.getParam() == null) {
            throw new KDBizException(ResManager.loadKDString((String)"EAS\u6570\u636e\u5347\u7ea7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractEASBudgetUpgradeImpl_0", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        if (!this.getParam().isUpgradeBaseData() && !this.getParam().isUpgradeData()) {
            throw new KDBizException(ResManager.loadKDString((String)"EAS\u6570\u636e\u5347\u7ea7\u53c2\u6570\u4e0d\u6b63\u786e\uff08\u6ca1\u6709\u6570\u636e\u5347\u7ea7\u8bbe\u7f6e\uff09\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractEASBudgetUpgradeImpl_1", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        IEASSchema easSchema = this.getParam().getEASSchema();
        if (StringUtils.isEmpty((String)easSchema.getSchemaId())) {
            throw new KDBizException(ResManager.loadKDString((String)"EAS\u6570\u636e\u5347\u7ea7\u53c2\u6570\u4e0d\u6b63\u786e\uff08\u6ca1\u6709\u6307\u5b9a\u5347\u7ea7\u7684EAS\u9884\u7b97\u65b9\u6848\uff09\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractEASBudgetUpgradeImpl_2", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        return true;
    }

    protected void saveRunResult() {
        boolean checker;
        block10: {
            checker = true;
            try {
                if (!this.getParam().isUpgradeBaseData()) break block10;
                checker = this.saveUpgradeBaseLog();
            }
            catch (Exception ex) {
                try {
                    checker = false;
                    log.error("saveRunResult-error:", (Throwable)ex);
                }
                catch (Throwable throwable) {
                    EasUpgradeService easUpgradeService = EasUpgradeService.getInstance();
                    if (this.getParam().isUpgradeBaseData()) {
                        easUpgradeService.upEasModelMemberUpgrade(this.param.getUpgradeModelId(), checker ? UpgradeStatus.SUCCEED : UpgradeStatus.FAILED, this.getContext().getRunData().getModelId());
                    } else {
                        checker = EASUpgradeResult.isSuccess(this.getResults());
                        easUpgradeService.upEasModelDataUpgradeStatus(this.param.getUpgradeModelId(), checker ? UpgradeStatus.SUCCEED : UpgradeStatus.FAILED);
                    }
                    throw throwable;
                }
                EasUpgradeService easUpgradeService = EasUpgradeService.getInstance();
                if (this.getParam().isUpgradeBaseData()) {
                    easUpgradeService.upEasModelMemberUpgrade(this.param.getUpgradeModelId(), checker ? UpgradeStatus.SUCCEED : UpgradeStatus.FAILED, this.getContext().getRunData().getModelId());
                } else {
                    checker = EASUpgradeResult.isSuccess(this.getResults());
                    easUpgradeService.upEasModelDataUpgradeStatus(this.param.getUpgradeModelId(), checker ? UpgradeStatus.SUCCEED : UpgradeStatus.FAILED);
                }
            }
        }
        EasUpgradeService easUpgradeService = EasUpgradeService.getInstance();
        if (this.getParam().isUpgradeBaseData()) {
            easUpgradeService.upEasModelMemberUpgrade(this.param.getUpgradeModelId(), checker ? UpgradeStatus.SUCCEED : UpgradeStatus.FAILED, this.getContext().getRunData().getModelId());
        } else {
            checker = EASUpgradeResult.isSuccess(this.getResults());
            easUpgradeService.upEasModelDataUpgradeStatus(this.param.getUpgradeModelId(), checker ? UpgradeStatus.SUCCEED : UpgradeStatus.FAILED);
        }
    }

    private boolean saveUpgradeBaseLog() {
        EasDimUpgradeLog dimLog;
        String dimKey;
        IRunData runData = this.getContext().getRunData();
        EasUpgradeLog modelLog = new EasUpgradeLog();
        modelLog.setUpgradeModelId(this.getParam().getUpgradeModelId());
        modelLog.setCreater(this.getContext().getRunData().getUserId());
        modelLog.setModelId(this.getContext().getRunData().getModelId());
        boolean checker = EASUpgradeResult.isSuccess(this.getResults());
        modelLog.setStatus(checker ? Status.SUCCEED.getVal() : Status.FAILED.getVal());
        LinkedHashMap dimLogMap = Maps.newLinkedHashMap();
        LinkedHashMap memberMsgMap = Maps.newLinkedHashMap();
        for (IEASUpgradeResult result : this.getResults()) {
            if (result.isUpgradeData()) continue;
            if (StringUtils.isNotEmpty((String)result.getMemberNumber())) {
                memberMsgMap.put(result.getMemberNumber(), result.getAllInfo());
                continue;
            }
            if (StringUtils.isNotEmpty((String)result.getNewDimNumber()) || IDUtils.isNotNull((Long)result.getNewDimId())) {
                dimKey = StringUtils.isEmpty((String)result.getViewNumber()) ? result.getNewDimNumber() : result.getNewDimNumber() + '!' + result.getViewNumber();
                dimLog = dimLogMap.computeIfAbsent(dimKey, f -> {
                    EasDimUpgradeLog _dimLog = new EasDimUpgradeLog();
                    _dimLog.setStatus(Status.SUCCEED.getVal());
                    if (StringUtils.isNotEmpty((String)result.getOldDimId())) {
                        if (_dimLog.getEasDim() == null) {
                            _dimLog.setEasDim(new EASDim());
                        }
                        _dimLog.getEasDim().setId(result.getOldDimId());
                    }
                    if (StringUtils.isNotEmpty((String)result.getOldDimNumber())) {
                        if (_dimLog.getEasDim() == null) {
                            _dimLog.setEasDim(new EASDim());
                        }
                        _dimLog.getEasDim().setNumber(result.getOldDimNumber());
                    }
                    _dimLog.setDimension(new Dimension());
                    _dimLog.getDimension().setId(result.getNewDimId());
                    _dimLog.getDimension().setNumber(result.getNewDimNumber());
                    if (IDUtils.isNotNull((Long)result.getViewId())) {
                        View view = new View();
                        view.setId(result.getViewId());
                        _dimLog.setView(view);
                        _dimLog.getView().setNumber(result.getViewNumber());
                        _dimLog.getView().setName(result.getViewName());
                        _dimLog.setEasunionid(result.getUnionId());
                    }
                    return _dimLog;
                });
                String dimInfo = result.getAllInfo();
                if (StringUtils.isNotEmpty((String)dimInfo)) {
                    if (StringUtils.isEmpty((String)dimLog.getDimLogInfo())) {
                        dimLog.setDimLogInfo(dimInfo);
                    } else {
                        dimLog.setDimLogInfo(dimLog.getDimLogInfo() + "\r\n" + dimInfo);
                    }
                }
                dimLog.setStatus(Status.SUCCEED.getVal().equals(dimLog.getStatus()) && result.isSuccess() ? Status.SUCCEED.getVal() : Status.FAILED.getVal());
                continue;
            }
            String modelInfo = result.getAllInfo();
            if (!StringUtils.isNotEmpty((String)modelInfo)) continue;
            if (StringUtils.isEmpty((String)modelLog.getInfo())) {
                modelLog.setInfo(modelInfo);
                continue;
            }
            modelLog.setInfo(modelLog.getInfo() + "\r\n" + modelInfo);
        }
        EasUpgradeLogService service = EasUpgradeLogService.getInstance();
        service.add(modelLog);
        service.addDimLogs(this.getParam().getUpgradeModelId(), new ArrayList<EasDimUpgradeLog>(dimLogMap.values()));
        LinkedList memberLogs = Lists.newLinkedList();
        for (Map.Entry entry : dimLogMap.entrySet()) {
            dimKey = (String)entry.getKey();
            dimLog = (EasDimUpgradeLog)entry.getValue();
            Map<String, NewMember> membersMap = runData.getNumberMappingMap().get(dimKey);
            if (membersMap == null && dimLog.getView() != null) {
                membersMap = runData.getNumberMappingMap().get(dimLog.getView().getNumber());
            }
            if (membersMap == null) continue;
            memberLogs.clear();
            for (Map.Entry<String, NewMember> _member : membersMap.entrySet()) {
                NewMember newMember = _member.getValue();
                EasMemberUpgradeLog memberLog = new EasMemberUpgradeLog();
                memberLog.setEasunionid(dimLog.getEasunionid());
                memberLog.setEasMember(EASMember.of(newMember));
                memberLog.getEasMember().setNumber(_member.getKey());
                memberLog.setMember(new Member());
                memberLog.getMember().setId(newMember.getId());
                memberLog.getMember().setNumber(newMember.getNumber());
                memberLog.getMember().setName(newMember.getName());
                if (memberMsgMap.containsKey(memberLog.getMember().getNumber())) {
                    memberLog.setMemLogInfo((String)memberMsgMap.get(memberLog.getMember().getNumber()));
                }
                memberLogs.add(memberLog);
                if (newMember.getChildren() == null) continue;
                for (NewMember _child : newMember.getChildren().values()) {
                    memberLog = new EasMemberUpgradeLog();
                    memberLog.setEasMember(EASMember.of(_child));
                    memberLog.getEasMember().setNumber(_child.getOldNumber());
                    memberLog.setMember(new Member());
                    memberLog.getMember().setId(_child.getId());
                    memberLog.getMember().setNumber(_child.getNumber());
                    memberLog.getMember().setName(_child.getName());
                    if (memberMsgMap.containsKey(memberLog.getMember().getNumber())) {
                        memberLog.setMemLogInfo((String)memberMsgMap.get(memberLog.getMember().getNumber()));
                    }
                    memberLogs.add(memberLog);
                }
            }
            if (dimLog.getView() != null) {
                service.addMemberLogs(this.getParam().getUpgradeModelId(), dimLog.getEasDim().getNumber(), dimLog.getView().getNumber(), memberLogs);
                continue;
            }
            service.addMemberLogs(this.getParam().getUpgradeModelId(), dimLog.getEasDim().getNumber(), null, memberLogs);
        }
        return checker;
    }
}

