/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.easupgrade;

import java.util.List;
import kd.bos.exception.KDBizException;
import kd.epm.eb.business.easupgrade.AbstractEASBudgetUpgradeImpl;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeParam;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeResult;
import kd.epm.eb.business.easupgrade.impl.EASUpgradeResult;
import kd.epm.eb.business.easupgrade.impl.checker.EASCheckerImpl;
import kd.epm.eb.business.easupgrade.impl.upgrade.EASDataUpgradeImpl;
import org.jetbrains.annotations.NotNull;

public class EASBudgetUpgradeImpl
extends AbstractEASBudgetUpgradeImpl {
    public static EASBudgetUpgradeImpl getInstance() {
        return new EASBudgetUpgradeImpl();
    }

    public List<IEASUpgradeResult> upgrade(@NotNull IEASUpgradeParam param) {
        this.checkUpgradeParam(param);
        if (this.checkRunUpgrade()) {
            throw new KDBizException("");
        }
        try {
            if (this.runChecker()) {
                this.upgradeEasData();
            }
        }
        catch (Exception ex) {
            log.error("eas-upgrade-error:", (Throwable)ex);
            this.getResults().add(EASUpgradeResult.error("upgrade", ex));
        }
        finally {
            this.saveRunResult();
        }
        return this.getResults();
    }

    protected synchronized boolean checkRunUpgrade() {
        return false;
    }

    protected boolean runChecker() {
        this.getResults().addAll(EASCheckerImpl.get(this.getParam(), this.getContext()).check());
        boolean checker = true;
        for (IEASUpgradeResult result : this.getResults()) {
            checker = checker && result.isSuccess();
        }
        return checker;
    }

    private void upgradeEasData() {
        EASDataUpgradeImpl impl = EASDataUpgradeImpl.get(this.getParam(), this.getContext());
        impl.beforeUpgrade();
        impl.upgrade();
        this.getResults().addAll(impl.getResults());
    }
}

