/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.easupgrade.face;

import java.util.HashSet;
import java.util.List;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeParam;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeResult;
import kd.epm.eb.business.easupgrade.impl.EASUpgradeResult;
import kd.epm.eb.common.utils.SqlBatchUtils;
import kd.epm.eb.common.utils.StringUtils;
import org.jetbrains.annotations.NotNull;

public interface IChecker {
    default public boolean existTables(@NotNull IEASUpgradeParam param, List<IEASUpgradeResult> results, String oldDimNumber, String newDimNumber, String category, String ... tables) {
        if (category == null || tables == null || tables.length == 0) {
            return false;
        }
        boolean exist = true;
        HashSet<String> checkTables = new HashSet<String>(tables.length);
        for (String _table : tables) {
            String syncTable = param.getSyncTableName(_table);
            if (SqlBatchUtils.hasTable((String)syncTable)) continue;
            checkTables.add(syncTable);
            exist = false;
        }
        if (!checkTables.isEmpty()) {
            String msg = ResManager.loadResFormat((String)"EAS\u540c\u6b65\u6570\u636e\u8868\uff08%1\uff09\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractEASUpgrade_0", (String)"epm-eb-business", (Object[])new Object[]{StringUtils.join(checkTables, (char)',')});
            results.add(EASUpgradeResult.error(category, msg, null, oldDimNumber, null, newDimNumber));
        }
        return exist;
    }

    default public boolean canDealCustomPeriod(@NotNull Row row) {
        return row.getBoolean("ftenday") == false && row.getBoolean("fyearweek") == false && row.getBoolean("fmothweek") == false && row.getBoolean("fday") == false;
    }
}

