/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.easupgrade.impl;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.easupgrade.face.IEASSchema;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeParam;
import kd.epm.eb.business.easupgrade.impl.dao.EASSchema;
import kd.epm.eb.business.easupgrade.utils.EASDimUpgradeUtils;
import kd.epm.eb.common.enums.ApplicationTypeEnum;

public class EASUpgradeParam
implements IEASUpgradeParam {
    private Long upGradeSourceId;
    private String dataCenter;
    private Map<String, String> tableMap = new HashMap<String, String>(16);
    private boolean upgradeBaseData = true;
    private boolean upgradeData = true;
    private IEASSchema easSchema = null;
    private ApplicationTypeEnum type = null;
    private Long epmDataSourceId = 0L;
    private Long upgradeModelId = 0L;
    private boolean syncData = true;

    @Override
    public void setUpgradeSourceId(Long upGradeSourceId) {
        this.upGradeSourceId = upGradeSourceId;
        this.setTableMap();
    }

    @Override
    public Long getUpgradeSourceId() {
        return this.upGradeSourceId;
    }

    @Override
    public String getDataCenter() {
        return this.dataCenter;
    }

    @Override
    public Map<String, String> getTableMap() {
        return this.tableMap;
    }

    @Override
    public void setTableMap() {
        DynamicObject srcDataSource = BusinessDataServiceHelper.loadSingle((Object)this.upGradeSourceId, (String)"isc_data_source");
        long dblinkId = srcDataSource.getLong("dblink_id");
        DynamicObject dblink = BusinessDataServiceHelper.loadSingle((Object)dblinkId, (String)"isc_database_link");
        this.dataCenter = dblink != null ? dblink.getString("data_center") : "";
        QFilter qFilter = new QFilter("easdbsource", "=", (Object)this.upGradeSourceId);
        qFilter.and(new QFilter("easdbcenter", "=", (Object)this.dataCenter));
        DynamicObjectCollection easTables = QueryServiceHelper.query((String)"eb_eas_table", (String)"srctable,tartable", (QFilter[])qFilter.toArray());
        for (DynamicObject easTable : easTables) {
            this.tableMap.put(easTable.getString("srctable"), easTable.getString("tartable"));
        }
    }

    public void setTableMap(Map<String, String> tableMap) {
        this.tableMap = tableMap;
    }

    @Override
    public String getSyncTableName(String tableName) {
        return EASDimUpgradeUtils.getSyncTable(this, tableName, true);
    }

    @Override
    public void setUpgradeBaseData(boolean upgradeBaseData) {
        this.upgradeBaseData = upgradeBaseData;
    }

    @Override
    public boolean isUpgradeBaseData() {
        return this.upgradeBaseData;
    }

    @Override
    public void setUpgradeData(boolean upgradeData) {
        this.upgradeData = upgradeData;
    }

    @Override
    public boolean isUpgradeData() {
        return this.upgradeData;
    }

    @Override
    public IEASSchema getEASSchema() {
        if (this.easSchema == null) {
            this.easSchema = new EASSchema();
        }
        return this.easSchema;
    }

    @Override
    public void setApplication(ApplicationTypeEnum type) {
        this.type = type;
    }

    @Override
    public ApplicationTypeEnum getApplication() {
        return this.type;
    }

    @Override
    public void setEpmDataSourceId(Long epmDataSourceId) {
        this.epmDataSourceId = epmDataSourceId;
    }

    @Override
    public Long getEpmDataSourceId() {
        return this.epmDataSourceId;
    }

    @Override
    public void setUpgradeModelId(Long upgradeModelId) {
        this.upgradeModelId = upgradeModelId;
    }

    @Override
    public Long getUpgradeModelId() {
        return this.upgradeModelId;
    }

    @Override
    public boolean isSyncData() {
        return this.syncData;
    }

    @Override
    public void setSyncData(boolean syncData) {
        this.syncData = syncData;
    }
}

