/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.easupgrade.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeResult;
import kd.epm.eb.business.easupgrade.impl.dao.EasDataUpgradeDetail;
import kd.epm.eb.business.easupgrade.impl.dao.EasDataUpgradeLog;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.StringUtils;
import org.jetbrains.annotations.NotNull;

public class EASUpgradeResult
implements IEASUpgradeResult {
    private boolean isUpgradeData = false;
    private EasDataUpgradeLog easDataUpgradeLog;
    private EasDataUpgradeDetail easDataUpgradeDetail;
    private String oldDimId = null;
    private String oldDimNumber = null;
    private Long newDimId = null;
    private String newDimNumber = null;
    private Long viewId = null;
    private String viewNumber = null;
    private String viewName = null;
    private String unionId = null;
    private String memberNumber = null;
    private final Map<String, List<String>> run = new ConcurrentHashMap<String, List<String>>();
    private final Map<String, List<String>> warring = new ConcurrentHashMap<String, List<String>>();
    private final Map<String, List<String>> errors = new ConcurrentHashMap<String, List<String>>();

    public static IEASUpgradeResult get() {
        return new EASUpgradeResult();
    }

    @Override
    public void setUpgradeData(boolean upgradeData) {
        this.isUpgradeData = upgradeData;
    }

    @Override
    public boolean isUpgradeData() {
        return this.isUpgradeData;
    }

    @Override
    public EasDataUpgradeLog getEasDataUpgradeLog() {
        return this.easDataUpgradeLog;
    }

    @Override
    public void setEasDataUpgradeLog(EasDataUpgradeLog easDataUpgradeLog) {
        this.easDataUpgradeLog = easDataUpgradeLog;
    }

    @Override
    public EasDataUpgradeDetail getEasDataUpgradeDetail() {
        return this.easDataUpgradeDetail;
    }

    @Override
    public void setEasDataUpgradeDetail(EasDataUpgradeDetail easDataUpgradeDetail) {
        this.easDataUpgradeDetail = easDataUpgradeDetail;
    }

    @Override
    public void setOldDimId(String oldDimId) {
        this.oldDimId = oldDimId;
    }

    @Override
    public String getOldDimId() {
        return this.oldDimId;
    }

    @Override
    public void setOldDimNumber(String oldDimNumber) {
        this.oldDimNumber = oldDimNumber;
    }

    @Override
    public String getOldDimNumber() {
        return this.oldDimNumber;
    }

    @Override
    public void setNewDimId(Long newDimId) {
        this.newDimId = newDimId;
    }

    @Override
    public Long getNewDimId() {
        return this.newDimId;
    }

    @Override
    public void setNewDimNumber(String newDimNumber) {
        this.newDimNumber = newDimNumber;
    }

    @Override
    public String getNewDimNumber() {
        return this.newDimNumber;
    }

    @Override
    public void setViewId(Long viewId) {
        this.viewId = viewId;
    }

    @Override
    public Long getViewId() {
        return this.viewId;
    }

    @Override
    public void setViewNumber(String viewNumber) {
        this.viewNumber = viewNumber;
    }

    @Override
    public String getViewNumber() {
        return this.viewNumber;
    }

    @Override
    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    @Override
    public String getViewName() {
        return this.viewName;
    }

    @Override
    public void setUnionId(String unionId) {
        this.unionId = unionId;
    }

    @Override
    public String getUnionId() {
        return this.unionId;
    }

    @Override
    public void setMemberNumber(String memberNumber) {
        this.memberNumber = memberNumber;
    }

    @Override
    public String getMemberNumber() {
        return this.memberNumber;
    }

    public static String getDimensionNumber(String category) {
        if (category == null) {
            return null;
        }
        String dimNumber = null;
        switch (category) {
            case "checker-entity": 
            case "upgrade-entity": 
            case "checker-consolidation": 
            case "upgrade-consolidation": {
                dimNumber = SysDimensionEnum.Entity.getNumber();
                break;
            }
            case "checker-account": 
            case "upgrade-account": {
                dimNumber = SysDimensionEnum.Account.getNumber();
                break;
            }
            case "checker-period": 
            case "upgrade-period": {
                dimNumber = SysDimensionEnum.BudgetPeriod.getNumber();
                break;
            }
            case "checker-scenario": 
            case "upgrade-scenario": {
                dimNumber = SysDimensionEnum.DataType.getNumber();
                break;
            }
            case "checker-version": 
            case "upgrade-version": {
                dimNumber = SysDimensionEnum.Version.getNumber();
                break;
            }
            case "checker-currency": 
            case "upgrade-currency": {
                dimNumber = SysDimensionEnum.Currency.getNumber();
                break;
            }
            case "checker-element": 
            case "upgrade-element": {
                dimNumber = SysDimensionEnum.Metric.getNumber();
            }
        }
        return dimNumber;
    }

    public static String getOldDimensionNumber(String category) {
        if (category == null) {
            return null;
        }
        String dimNumber = null;
        switch (category) {
            case "checker-entity": 
            case "upgrade-entity": {
                dimNumber = "BG_Organization";
                break;
            }
            case "checker-consolidation": 
            case "upgrade-consolidation": {
                dimNumber = "BG_Consolidation";
                break;
            }
            case "checker-account": 
            case "upgrade-account": {
                dimNumber = "BG_Account";
                break;
            }
            case "checker-period": 
            case "upgrade-period": {
                dimNumber = "BG_Period";
                break;
            }
            case "checker-scenario": 
            case "upgrade-scenario": {
                dimNumber = "BG_Scenario";
                break;
            }
            case "checker-version": 
            case "upgrade-version": {
                dimNumber = "BG_Version";
                break;
            }
            case "checker-currency": 
            case "upgrade-currency": {
                dimNumber = "BG_Currency";
                break;
            }
            case "checker-element": 
            case "upgrade-element": {
                dimNumber = "BG_Element";
            }
        }
        return dimNumber;
    }

    public static IEASUpgradeResult error(@NotNull String category, @NotNull String errorInfo) {
        IEASUpgradeResult result = EASUpgradeResult.error(category, errorInfo, null, null, null, null);
        result.setNewDimNumber(EASUpgradeResult.getDimensionNumber(category));
        result.setOldDimNumber(EASUpgradeResult.getOldDimensionNumber(category));
        return result;
    }

    public static IEASUpgradeResult error(@NotNull String category, @NotNull Throwable ex) {
        return EASUpgradeResult.error(category, ex, null, null, null, null);
    }

    public static IEASUpgradeResult error(@NotNull String category, @NotNull String errorInfo, String oldDimId, String oldDimNumber, Long newDimId, String newDimNumber) {
        IEASUpgradeResult result = EASUpgradeResult.get();
        result.setOldDimId(oldDimId);
        result.setOldDimNumber(oldDimNumber);
        result.setNewDimId(newDimId);
        result.setNewDimNumber(newDimNumber);
        result.addErrorInfo(category, errorInfo);
        return result;
    }

    public static IEASUpgradeResult error(@NotNull String category, @NotNull Throwable ex, String oldDimId, String oldDimNumber, Long newDimId, String newDimNumber) {
        IEASUpgradeResult result = EASUpgradeResult.get();
        result.setOldDimId(oldDimId);
        result.setOldDimNumber(oldDimNumber);
        result.setNewDimId(newDimId);
        result.setNewDimNumber(newDimNumber);
        result.addErrorInfo(category, CommonServiceHelper.getStackTraceStr((Throwable)ex));
        return result;
    }

    public static IEASUpgradeResult run(@NotNull String category, @NotNull String runInfo) {
        IEASUpgradeResult result = EASUpgradeResult.run(category, runInfo, null, null, null, null);
        result.setNewDimNumber(EASUpgradeResult.getDimensionNumber(category));
        result.setOldDimNumber(EASUpgradeResult.getOldDimensionNumber(category));
        return result;
    }

    public static IEASUpgradeResult run(@NotNull String category, @NotNull String warringInfo, String oldDimId, String oldDimNumber, Long newDimId, String newDimNumber) {
        IEASUpgradeResult result = EASUpgradeResult.get();
        result.setOldDimId(oldDimId);
        result.setOldDimNumber(oldDimNumber);
        result.setNewDimId(newDimId);
        result.setNewDimNumber(newDimNumber);
        result.addRunInfo(category, warringInfo);
        return result;
    }

    public static IEASUpgradeResult warring(@NotNull String category, @NotNull String warringInfo) {
        IEASUpgradeResult result = EASUpgradeResult.warring(category, warringInfo, null, null, null, null);
        result.setNewDimNumber(EASUpgradeResult.getDimensionNumber(category));
        result.setOldDimNumber(EASUpgradeResult.getOldDimensionNumber(category));
        return result;
    }

    public static IEASUpgradeResult warring(@NotNull String category, @NotNull String warringInfo, String oldDimId, String oldDimNumber, Long newDimId, String newDimNumber) {
        IEASUpgradeResult result = EASUpgradeResult.get();
        result.setOldDimId(oldDimId);
        result.setOldDimNumber(oldDimNumber);
        result.setNewDimId(newDimId);
        result.setNewDimNumber(newDimNumber);
        result.addWarring(category, warringInfo);
        return result;
    }

    @Override
    public boolean isSuccess() {
        return this.getErrors().isEmpty();
    }

    @Override
    public Map<String, List<String>> getRun() {
        return this.run;
    }

    @Override
    public void addRunInfo(String category, String runInfo) {
        if (StringUtils.isNotEmpty((String)category) && StringUtils.isNotEmpty((String)runInfo)) {
            List msg = this.getRun().computeIfAbsent(category, f -> Collections.synchronizedList(new LinkedList()));
            msg.add(runInfo);
        }
    }

    @Override
    public String getRunInfo() {
        return this.getInfo(this.getRun());
    }

    @Override
    public String getAllInfo() {
        String runInfo;
        String warringInfo;
        StringBuilder msg = new StringBuilder();
        String errorInfo = this.getErrorsInfo();
        if (StringUtils.isNotEmpty((String)errorInfo)) {
            msg.append(ResManager.loadResFormat((String)"\u9519\u8bef:%1", (String)"AbstractEASBudgetUpgradeImpl_3", (String)"epm-eb-business", (Object[])new Object[]{errorInfo}));
        }
        if (StringUtils.isNotEmpty((String)(warringInfo = this.getWarringInfo()))) {
            msg.append(ResManager.loadResFormat((String)"\u8b66\u544a:%1", (String)"AbstractEASBudgetUpgradeImpl_4", (String)"epm-eb-business", (Object[])new Object[]{warringInfo}));
        }
        if (StringUtils.isNotEmpty((String)(runInfo = this.getRunInfo()))) {
            msg.append(ResManager.loadResFormat((String)"\u63d0\u793a:%1", (String)"AbstractEASBudgetUpgradeImpl_5", (String)"epm-eb-business", (Object[])new Object[]{runInfo}));
        }
        return msg.toString();
    }

    private String getInfo(Map<String, List<String>> infoMap) {
        StringBuilder msg = new StringBuilder();
        for (Map.Entry<String, List<String>> entry : infoMap.entrySet()) {
            for (String _info : entry.getValue()) {
                msg.append(_info).append("\r\n");
            }
        }
        return msg.toString();
    }

    @Override
    public Map<String, List<String>> getWarring() {
        return this.warring;
    }

    @Override
    public void addWarring(String category, String warringInfo) {
        if (StringUtils.isNotEmpty((String)category) && StringUtils.isNotEmpty((String)warringInfo)) {
            List msg = this.getWarring().computeIfAbsent(category, f -> Collections.synchronizedList(new LinkedList()));
            msg.add(warringInfo);
        }
    }

    @Override
    public String getWarringInfo() {
        return this.getInfo(this.getWarring());
    }

    @Override
    public Map<String, List<String>> getErrors() {
        return this.errors;
    }

    @Override
    public void addErrorInfo(String category, String errorInfo) {
        if (StringUtils.isNotEmpty((String)category) && StringUtils.isNotEmpty((String)errorInfo)) {
            List msg = this.getErrors().computeIfAbsent(category, f -> Collections.synchronizedList(new LinkedList()));
            msg.add(errorInfo);
        }
    }

    @Override
    public void addErrorInfo(String category, Throwable ex) {
        if (StringUtils.isNotEmpty((String)category) && ex != null) {
            this.addErrorInfo(category, CommonServiceHelper.getStackTraceStr((Throwable)ex));
        }
    }

    @Override
    public String getErrorsInfo() {
        return this.getInfo(this.getErrors());
    }

    @Override
    public void merge(IEASUpgradeResult result) {
        if (result == null) {
            return;
        }
        this.merge(result.getRun(), this.getRun());
        this.merge(result.getWarring(), this.getWarring());
        this.merge(result.getErrors(), this.getErrors());
    }

    private void merge(Map<String, List<String>> source, Map<String, List<String>> target) {
        if (source == null || source.isEmpty() || target == null) {
            return;
        }
        for (Map.Entry<String, List<String>> entry : source.entrySet()) {
            List msg = target.computeIfAbsent(entry.getKey(), f -> new ArrayList(((List)entry.getValue()).size()));
            msg.addAll((Collection)entry.getValue());
        }
    }

    public static boolean isSuccess(List<IEASUpgradeResult> results) {
        if (results == null) {
            return true;
        }
        boolean checker = true;
        for (IEASUpgradeResult result : results) {
            checker = checker && result.isSuccess();
        }
        return checker;
    }

    public static String getErrorsInfo(List<IEASUpgradeResult> results) {
        if (results == null) {
            return "";
        }
        StringBuilder msg = new StringBuilder();
        for (IEASUpgradeResult result : results) {
            msg.append(result.getErrorsInfo()).append(',');
        }
        if (msg.length() > 0) {
            msg.setLength(msg.length() - 1);
        }
        return msg.toString();
    }
}

