/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.easupgrade.impl.checker;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeContext;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeParam;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeResult;
import kd.epm.eb.business.easupgrade.face.IRunChecker;
import kd.epm.eb.business.easupgrade.impl.checker.EASCheckerImpl;
import kd.epm.eb.business.easupgrade.impl.checker.items.EASAccountChecker;
import kd.epm.eb.business.easupgrade.impl.checker.items.EASCslChecker;
import kd.epm.eb.business.easupgrade.impl.checker.items.EASCurrencyChecker;
import kd.epm.eb.business.easupgrade.impl.checker.items.EASCusMemberChecker;
import kd.epm.eb.business.easupgrade.impl.checker.items.EASElementChecker;
import kd.epm.eb.business.easupgrade.impl.checker.items.EASEntityChecker;
import kd.epm.eb.business.easupgrade.impl.checker.items.EASPeriodChecker;
import kd.epm.eb.business.easupgrade.impl.checker.items.EASPropertyChecker;
import kd.epm.eb.business.easupgrade.impl.checker.items.EASScenarioChecker;
import kd.epm.eb.business.easupgrade.impl.checker.items.EASSchemaChecker;
import kd.epm.eb.business.easupgrade.impl.checker.items.EASSysVersionChecker;
import kd.epm.eb.business.easupgrade.impl.checker.items.EASTableChecker;
import kd.epm.eb.business.easupgrade.impl.checker.items.EASVersionChecker;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEASCheckerImpl {
    protected static final Log log = LogFactory.getLog(EASCheckerImpl.class);
    private final IEASUpgradeParam param;
    private final IEASUpgradeContext context;
    private final List<IEASUpgradeResult> results = Collections.synchronizedList(new ArrayList());
    private final List<IRunChecker> relies = new ArrayList<IRunChecker>(32);
    private final List<IRunChecker> checkers = new ArrayList<IRunChecker>(32);

    protected IEASUpgradeParam getParam() {
        return this.param;
    }

    protected IEASUpgradeContext getContext() {
        return this.context;
    }

    protected List<IEASUpgradeResult> getResults() {
        return this.results;
    }

    protected final List<IRunChecker> getRelies() {
        return this.relies;
    }

    protected final List<IRunChecker> getCheckers() {
        return this.checkers;
    }

    public AbstractEASCheckerImpl(@NotNull IEASUpgradeParam param, @NotNull IEASUpgradeContext context) {
        this.param = param;
        this.context = context;
        this.getRelies().add(EASTableChecker.get(param, context));
        this.getRelies().add(EASSysVersionChecker.get(param, context));
        this.getRelies().add(EASSchemaChecker.get(param, context));
        this.getCheckers().add(EASEntityChecker.get(param, context));
        this.getCheckers().add(EASAccountChecker.get(param, context));
        this.getCheckers().add(EASPeriodChecker.get(param, context));
        this.getCheckers().add(EASScenarioChecker.get(param, context));
        this.getCheckers().add(EASVersionChecker.get(param, context));
        this.getCheckers().add(EASCurrencyChecker.get(param, context));
        this.getCheckers().add(EASElementChecker.get(param, context));
        this.getCheckers().add(EASCusMemberChecker.get(param, context));
        this.getCheckers().add(EASCslChecker.get(param, context));
        this.getCheckers().add(EASPropertyChecker.get(param, context));
    }
}

