/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.easupgrade.impl.checker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import kd.bos.context.RequestContext;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeContext;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeParam;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeResult;
import kd.epm.eb.business.easupgrade.face.IRunChecker;
import kd.epm.eb.business.easupgrade.impl.checker.AbstractEASCheckerImpl;
import kd.epm.eb.business.easupgrade.utils.EASUpgradeUtils;
import kd.epm.eb.common.thread.EpmThreadPools;
import kd.epm.eb.common.utils.LogStats;
import org.jetbrains.annotations.NotNull;

public class EASCheckerImpl
extends AbstractEASCheckerImpl {
    public static EASCheckerImpl get(@NotNull IEASUpgradeParam param, @NotNull IEASUpgradeContext context) {
        return new EASCheckerImpl(param, context);
    }

    public EASCheckerImpl(@NotNull IEASUpgradeParam param, @NotNull IEASUpgradeContext context) {
        super(param, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IEASUpgradeResult> check() {
        LogStats stats = new LogStats("budget-update-log : ");
        stats.addInfo("begin-checker.");
        ArrayList<Future> futures = new ArrayList<Future>(this.getCheckers().size());
        try {
            for (IRunChecker checker : this.getRelies()) {
                this.getResults().addAll(checker.check());
            }
            RequestContext _context = RequestContext.getOrCreate();
            CountDownLatch cdl = new CountDownLatch(this.getCheckers().size());
            for (IRunChecker checker : this.getCheckers()) {
                checker.setCountDownLatch(cdl);
                Future _result = EpmThreadPools.CommPools.submit((Callable)checker, _context);
                if (_result == null) continue;
                futures.add(_result);
            }
            try {
                cdl.await();
            }
            catch (InterruptedException ex) {
                log.error("eas-checker-error:", (Throwable)ex);
                EASUpgradeUtils.dealException("checker", (Exception)ex, this.getResults());
            }
            for (Future future : futures) {
                this.getResults().addAll((Collection)future.get());
            }
        }
        catch (Exception ex) {
            log.error("eas-checker-error:", (Throwable)ex);
            EASUpgradeUtils.dealException("checker", ex, this.getResults());
        }
        finally {
            stats.addInfo("end-checker.");
            log.info(stats.toString());
        }
        return this.getResults();
    }
}

