/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.easupgrade.impl.checker.items;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeContext;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeParam;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeResult;
import kd.epm.eb.business.easupgrade.face.IRunChecker;
import kd.epm.eb.business.easupgrade.utils.EASUpgradeUtils;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractChecker
implements IRunChecker {
    protected static final Log log = LogFactory.getLog(AbstractChecker.class);
    private final IEASUpgradeParam param;
    private final IEASUpgradeContext context;
    private final List<IEASUpgradeResult> results = new ArrayList<IEASUpgradeResult>();
    private CountDownLatch cdl = null;
    private boolean checked = false;

    protected IEASUpgradeParam getParam() {
        return this.param;
    }

    protected IEASUpgradeContext getContext() {
        return this.context;
    }

    protected List<IEASUpgradeResult> getResults() {
        return this.results;
    }

    @Override
    public void setCountDownLatch(CountDownLatch cdl) {
        this.cdl = cdl;
    }

    @Override
    public CountDownLatch getCountDownLatch() {
        return this.cdl;
    }

    protected void setChecked(boolean checked) {
        this.checked = checked;
    }

    protected boolean isChecked() {
        return this.checked;
    }

    protected AbstractChecker(@NotNull IEASUpgradeParam param, @NotNull IEASUpgradeContext context) {
        this.param = param;
        this.context = context;
    }

    protected abstract String getCategoryInfo();

    public Object call() throws Exception {
        try {
            this.check();
        }
        catch (Exception ex) {
            log.error("eas-checker-error:", (Throwable)ex);
            EASUpgradeUtils.dealException("checker", ex, this.getResults());
        }
        finally {
            if (this.getCountDownLatch() != null) {
                this.getCountDownLatch().countDown();
            }
        }
        return this.getResults();
    }
}

