/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.easupgrade.impl.checker.items;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.epm.eb.business.easupgrade.face.IEASSchema;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeContext;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeParam;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeResult;
import kd.epm.eb.business.easupgrade.face.IRunChecker;
import kd.epm.eb.business.easupgrade.impl.EASUpgradeResult;
import kd.epm.eb.business.easupgrade.impl.checker.items.AbstractChecker;
import kd.epm.eb.business.easupgrade.impl.dao.EASMember;
import kd.epm.eb.business.easupgrade.utils.EASDimUpgradeUtils;
import kd.epm.eb.business.easupgrade.utils.EASUpgradeCheckUtils;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.StringUtils;
import org.jetbrains.annotations.NotNull;

public class EASAccountChecker
extends AbstractChecker {
    public static IRunChecker get(@NotNull IEASUpgradeParam param, @NotNull IEASUpgradeContext context) {
        return new EASAccountChecker(param, context);
    }

    protected EASAccountChecker(@NotNull IEASUpgradeParam param, @NotNull IEASUpgradeContext context) {
        super(param, context);
    }

    @Override
    protected String getCategoryInfo() {
        return "checker-account";
    }

    @Override
    public List<IEASUpgradeResult> check() {
        String[] checkTables = new String[]{"T_MBG_BGACCOUNT", "T_MBG_BGACCOUNTVIEW"};
        if (!this.existTables(this.getParam(), this.getResults(), "BG_Account", SysDimensionEnum.Account.getNumber(), this.getCategoryInfo(), checkTables)) {
            return this.getResults();
        }
        IEASSchema easSchema = this.getContext().getEASSchema();
        EASMember accountView = null;
        List<EASMember> easMembers = EASDimUpgradeUtils.getDimRefMember(this.getParam(), easSchema.getSchemaId(), "BG_Account");
        if (!easMembers.isEmpty()) {
            accountView = easMembers.get(0);
        }
        if (accountView == null) {
            String msg = ResManager.loadKDString((String)"EAS\u79d1\u76ee\u7ef4\u5ea6\u6ca1\u6709\u5173\u8054\u7684\u89c6\u56fe\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EASAccountChecker_0", (String)"epm-eb-business", (Object[])new Object[0]);
            this.getResults().add(EASUpgradeResult.error(this.getCategoryInfo(), msg, null, "BG_Account", null, SysDimensionEnum.Account.getNumber()));
            return this.getResults();
        }
        List<String> checkNumbers = EASUpgradeCheckUtils.queryNoExistParent(this.getParam(), "T_MBG_BGACCOUNT", "fbgaccountviewid", accountView.memberId);
        if (!checkNumbers.isEmpty()) {
            String numbers = StringUtils.join(checkNumbers, (String)",");
            String msg = ResManager.loadResFormat((String)"\u79d1\u76ee\u89c6\u56fe\u4e0b\u5b58\u5728\u6ca1\u6709\u4e0a\u7ea7\u6210\u5458\u7684\u7ef4\u5ea6\u6210\u5458\u6570\u636e\uff08%1\uff09\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EASAccountChecker_1", (String)"epm-eb-business", (Object[])new Object[]{numbers});
            this.getResults().add(EASUpgradeResult.error(this.getCategoryInfo(), msg, null, "BG_Account", null, SysDimensionEnum.Account.getNumber()));
        }
        return this.getResults();
    }
}

