/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.easupgrade.impl.checker.items;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.epm.eb.business.easupgrade.face.IEASSchema;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeContext;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeParam;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeResult;
import kd.epm.eb.business.easupgrade.face.IRunChecker;
import kd.epm.eb.business.easupgrade.impl.EASUpgradeResult;
import kd.epm.eb.business.easupgrade.impl.checker.items.AbstractChecker;
import kd.epm.eb.business.easupgrade.impl.dao.EASMember;
import kd.epm.eb.business.easupgrade.utils.EASDimUpgradeUtils;
import kd.epm.eb.common.constant.BgBaseConstant;
import org.jetbrains.annotations.NotNull;

public class EASCusMemberChecker
extends AbstractChecker {
    public static IRunChecker get(@NotNull IEASUpgradeParam param, @NotNull IEASUpgradeContext context) {
        return new EASCusMemberChecker(param, context);
    }

    protected EASCusMemberChecker(@NotNull IEASUpgradeParam param, @NotNull IEASUpgradeContext context) {
        super(param, context);
    }

    @Override
    protected String getCategoryInfo() {
        return "checker-cus";
    }

    @Override
    public List<IEASUpgradeResult> check() {
        String[] checkTables = new String[]{"T_MBG_MBGMEMBER", "T_MBG_MBGVIEW"};
        if (!this.existTables(this.getParam(), this.getResults(), null, null, this.getCategoryInfo(), checkTables)) {
            return this.getResults();
        }
        IEASSchema easSchema = this.getContext().getEASSchema();
        List<EASMember> easCusViews = EASDimUpgradeUtils.getCusDimRefMember(this.getParam(), easSchema.getSchemaId());
        if (!easCusViews.isEmpty()) {
            LinkedHashSet existViewIds = Sets.newLinkedHashSetWithExpectedSize((int)easCusViews.size());
            Set cusViewIds = easCusViews.stream().map(EASMember::getMemberId).collect(Collectors.toSet());
            String syncCusViewTable = this.getParam().getSyncTableName("T_MBG_MBGVIEW");
            SqlBuilder sql = new SqlBuilder();
            sql.append("select fid from " + syncCusViewTable + " where ", new Object[0]).appendIn("fid", cusViewIds.toArray());
            DataSet ds = DB.queryDataSet((String)"queryEASCusView", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);
            Object object = null;
            try {
                if (ds != null) {
                    for (Row row : ds) {
                        existViewIds.add(row.getString("fid"));
                    }
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (object != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
            for (EASMember view : easCusViews) {
                if (existViewIds.contains(view.getMemberId())) continue;
                String msg = ResManager.loadResFormat((String)"EAS\u5b58\u5728\u81ea\u5b9a\u4e49\u7ef4\u5ea6(%1)\u7684\u89c6\u56fe\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EASCusMemberChecker_0", (String)"epm-eb-business", (Object[])new Object[]{view.number});
                this.getResults().add(EASUpgradeResult.error(this.getCategoryInfo(), msg, null, view.number, null, view.number));
            }
        }
        return this.getResults();
    }
}

