/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.easupgrade.impl.checker.items;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.epm.eb.business.easupgrade.face.IEASSchema;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeContext;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeParam;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeResult;
import kd.epm.eb.business.easupgrade.face.IRunChecker;
import kd.epm.eb.business.easupgrade.impl.EASUpgradeResult;
import kd.epm.eb.business.easupgrade.impl.checker.items.AbstractChecker;
import kd.epm.eb.business.easupgrade.impl.dao.EASMember;
import kd.epm.eb.business.easupgrade.utils.EASDimUpgradeUtils;
import kd.epm.eb.business.easupgrade.utils.EASUpgradeCheckUtils;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.StringUtils;
import org.jetbrains.annotations.NotNull;

public class EASEntityChecker
extends AbstractChecker {
    public static IRunChecker get(@NotNull IEASUpgradeParam param, @NotNull IEASUpgradeContext context) {
        return new EASEntityChecker(param, context);
    }

    protected EASEntityChecker(@NotNull IEASUpgradeParam param, @NotNull IEASUpgradeContext context) {
        super(param, context);
    }

    @Override
    protected String getCategoryInfo() {
        return "checker-entity";
    }

    @Override
    public List<IEASUpgradeResult> check() {
        String[] checkTables = new String[]{"T_MBG_BGORGUNIT", "T_MBG_BGORGVIEW"};
        if (!this.existTables(this.getParam(), this.getResults(), "BG_Organization", SysDimensionEnum.Entity.getNumber(), this.getCategoryInfo(), checkTables)) {
            return this.getResults();
        }
        IEASSchema easSchema = this.getContext().getEASSchema();
        EASMember editView = null;
        List<EASMember> easMembers = EASDimUpgradeUtils.getDimRefMember(this.getParam(), easSchema.getSchemaId(), "BG_Organization");
        for (EASMember easMember : easMembers) {
            if (2 != easMember.type) continue;
            editView = easMember;
        }
        if (editView == null && !easMembers.isEmpty()) {
            editView = easMembers.get(0);
        }
        if (editView == null) {
            String msg = ResManager.loadKDString((String)"EAS\u7ec4\u7ec7\u7ef4\u5ea6\u6ca1\u6709\u5173\u8054\u7684\u7f16\u5236\u89c6\u56fe\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EASEntityChecker_0", (String)"epm-eb-business", (Object[])new Object[0]);
            this.getResults().add(EASUpgradeResult.error(this.getCategoryInfo(), msg, null, "BG_Organization", null, SysDimensionEnum.Entity.getNumber()));
            return this.getResults();
        }
        List<String> checkNumbers = EASUpgradeCheckUtils.queryNoExistParent(this.getParam(), "T_MBG_BGORGUNIT", "fviewid", editView.memberId);
        if (!checkNumbers.isEmpty()) {
            String numbers = StringUtils.join(checkNumbers, (String)",");
            String msg = ResManager.loadResFormat((String)"\u7ec4\u7ec7\u7f16\u5236\u89c6\u56fe\u4e0b\u5b58\u5728\u6ca1\u6709\u4e0a\u7ea7\u6210\u5458\u7684\u7ef4\u5ea6\u6210\u5458\u6570\u636e\uff08%1\uff09\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EASEntityChecker_1", (String)"epm-eb-business", (Object[])new Object[]{numbers});
            this.getResults().add(EASUpgradeResult.error(this.getCategoryInfo(), msg, null, "BG_Organization", null, SysDimensionEnum.Entity.getNumber()));
        }
        return this.getResults();
    }
}

