/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.easupgrade.impl.checker.items;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeContext;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeParam;
import kd.epm.eb.business.easupgrade.face.IEASUpgradeResult;
import kd.epm.eb.business.easupgrade.face.IRunChecker;
import kd.epm.eb.business.easupgrade.impl.EASUpgradeResult;
import kd.epm.eb.business.easupgrade.impl.checker.items.AbstractChecker;
import kd.epm.eb.business.easupgrade.impl.dao.EASDim;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.StringUtils;
import org.jetbrains.annotations.NotNull;

public class EASPropertyChecker
extends AbstractChecker {
    private static final String[] checkTables = new String[]{"T_MBG_BGPROPERTYSORT", "T_MBG_BGPROPERTY", "T_MBG_PROPERTYREFSOURCE"};

    public static IRunChecker get(@NotNull IEASUpgradeParam param, @NotNull IEASUpgradeContext context) {
        return new EASPropertyChecker(param, context);
    }

    protected EASPropertyChecker(@NotNull IEASUpgradeParam param, @NotNull IEASUpgradeContext context) {
        super(param, context);
    }

    @Override
    protected String getCategoryInfo() {
        return "checker-property";
    }

    @Override
    public List<IEASUpgradeResult> check() {
        if (!this.existTables(this.getParam(), this.getResults(), null, null, this.getCategoryInfo(), checkTables)) {
            return this.getResults();
        }
        HashMap<String, String> propertyNumbers = new HashMap<String, String>();
        String syncPropertyTable = this.getParam().getSyncTableName("T_MBG_BGPROPERTYSORT");
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fmbgdimid, fnumber, fsourcetype, count(fid) from " + syncPropertyTable + " group by fmbgdimid, fnumber, fsourcetype having count(fid) > 1", new Object[0]);
        try (DataSet ds = DB.queryDataSet((String)"checkProperty", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                for (Row row : ds) {
                    String easDimId = row.getString("fmbgdimid");
                    if (StringUtils.isNotEmpty((String)easDimId)) {
                        propertyNumbers.put(row.getString("fmbgdimid"), row.getString("fnumber"));
                        continue;
                    }
                    propertyNumbers.put(row.getString("fsourcetype"), row.getString("fnumber"));
                }
            }
        }
        if (CollectionUtils.isNotEmpty(propertyNumbers)) {
            String msg;
            EASDim easDim;
            String syncDimTable = this.getParam().getSyncTableName("T_MBG_MBGDIM");
            HashMap easDimMap = Maps.newHashMapWithExpectedSize((int)propertyNumbers.size());
            sql = new SqlBuilder();
            sql.append("select fid, fnumber, fsrcnumber, freffield, fname_l1, fname_l2, fname_l3, fdescription_l1, fdescription_l2, fdescription_l3 from " + syncDimTable + " where ", new Object[0]).appendIn("fid", (Object[])propertyNumbers.keySet().toArray(new String[0]));
            DataSet ds = DB.queryDataSet((String)"queryEASDIM", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);
            Object object = null;
            try {
                if (ds != null) {
                    for (Row row : ds) {
                        easDim = EASDim.of(row);
                        easDimMap.put(easDim.getId(), easDim);
                    }
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (object != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
            ArrayList<String> msgs = new ArrayList<String>();
            for (Map.Entry entry : propertyNumbers.entrySet()) {
                easDim = (EASDim)easDimMap.get(entry.getKey());
                if (easDim != null) {
                    msg = ResManager.loadResFormat((String)"\u7ef4\u5ea6(%1)\u4e0b\u7f16\u7801(%2)", (String)"EASPropertyChecker_0", (String)"epm-eb-business", (Object[])new Object[]{easDim.getNumber() + '-' + easDim.getName(), entry.getValue()});
                    msgs.add(msg);
                    continue;
                }
                if ("33F82845".equals(entry.getKey())) {
                    msg = ResManager.loadResFormat((String)"\u7ef4\u5ea6(%1)\u4e0b\u7f16\u7801(%2)", (String)"EASPropertyChecker_0", (String)"epm-eb-business", (Object[])new Object[]{"BG_Organization", entry.getValue()});
                    msgs.add(msg);
                    continue;
                }
                if (!"E68E9293".equals(entry.getKey())) continue;
                msg = ResManager.loadResFormat((String)"\u7ef4\u5ea6(%1)\u4e0b\u7f16\u7801(%2)", (String)"EASPropertyChecker_0", (String)"epm-eb-business", (Object[])new Object[]{"BG_Account", entry.getValue()});
                msgs.add(msg);
            }
            msg = StringUtils.join(msgs, (char)',');
            this.getResults().add(EASUpgradeResult.error(this.getCategoryInfo(), ResManager.loadResFormat((String)"EAS\u81ea\u5b9a\u4e49\u5c5e\u6027\u5206\u7c7b\u4e0b\u5b58\u5728(%1)\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EASPropertyChecker_1", (String)"epm-eb-business", (Object[])new Object[]{msg})));
        }
        return this.getResults();
    }
}

